package jp.co.headwaters.webappos.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ForeignKeyCache {

	private static final ForeignKeyCache instance = new ForeignKeyCache();

	private Map<String, List<String>> importMap = new HashMap<String, List<String>>();
	private Map<String, List<String>> exportMap = new HashMap<String, List<String>>();

	private ForeignKeyCache() {
		// nothing
	}

	public static ForeignKeyCache getInstance() {
		return instance;
	}

	public Map<String, List<String>> getImportMap() {
		return importMap;
	}

	public void setImportMap(Map<String, List<String>> importMap) {
		this.importMap = importMap;
	}

	public Map<String, List<String>> getExportMap() {
		return exportMap;
	}

	public void setExportMap(Map<String, List<String>> exportMap) {
		this.exportMap = exportMap;
	}

	public void addImportTable(String fktable, String pktable) {
		if (!importMap.containsKey(fktable)) {
			importMap.put(fktable, new ArrayList<String>());
		}
		importMap.get(fktable).add(pktable);
	}

	public void addExportTable(String pktable, String fktable) {
		if (!exportMap.containsKey(pktable)) {
			exportMap.put(pktable, new ArrayList<String>());
		}
		exportMap.get(pktable).add(fktable);
	}

	public List<String> getImportList(String fktable) {
		if (!importMap.containsKey(fktable)) {
			return null;
		}
		return importMap.get(fktable);
	}

	public List<String> getExportList(String pktable) {
		if (!exportMap.containsKey(pktable)) {
			return null;
		}
		return exportMap.get(pktable);
	}
}
