package jp.co.headwaters.webappos.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.co.headwaters.webappos.dao.DaoUtil;
import jp.co.headwaters.webappos.dao.bean.SchemaColumn;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.session.SqlSession;

public class SchemaColumnCache {

	private static final Log logger = LogFactory.getLog(SchemaColumnCache.class);

	private static final SchemaColumnCache instance = new SchemaColumnCache();

	private Map<String, SchemaColumn> schemaColumnMap;

	private SchemaColumnCache() {
	}

	public static SchemaColumnCache getInstance() {
		return instance;
	}

	public void refresh() {
		SqlSession session = DaoUtil.getSqlSessionFactory().openSession();
		List<SchemaColumn> schemaColumn = null;
		try {
			schemaColumn = session.selectList("schema_column.selectAll");
		} finally {
			session.close();
		}

		schemaColumnMap = new HashMap<String, SchemaColumn>();
		for (SchemaColumn col : schemaColumn) {
			if (schemaColumnMap.containsKey((col.getColumnName()))) {
				// TODO:ワーニング出す
			}
			schemaColumnMap.put(col.getColumnName(), col);
			logger.debug("col:" + col.getColumnName() + "  type:" + col.getDataType() + "  null:" + col.isNullable());
		}
	}

	public SchemaColumn getSchemaColumn(String colName) {
		return schemaColumnMap.get(colName);
	}
}
