package jp.co.headwaters.webappos.common.enumation;

/**
 * サーバ機能名を表す列挙子
 */
public enum FunctionEnum {

	/** CRUD機能 */
	FUNCTION_CRUD("func_crud"),
	/** メール送信機能 */
	FUNCTION_SENDMAIL("func_sendmail"),
	/** ファイルアップロード機能 */
	FUNCTION_UPLOAD("func_upload"),
	/** ファイルダウンロード機能 */
	FUNCTION_DOWNLOAD("func_download");

	private String funcName;

	private FunctionEnum(final String funcName) {
		this.funcName = funcName;
	}

	public static FunctionEnum getFunction(final String funcName) {
		for (FunctionEnum e : FunctionEnum.values()) {
			if (funcName.equals(e.getFunctionName())) {
				return e;
			}
		}
		throw new IllegalArgumentException(funcName);
	}

	public String getFunctionName() {
		return this.funcName;
	}

}
