package jp.co.headwaters.webappos.dao;

import java.io.IOException;

import jp.co.headwaters.webappos.common.AppConstants;

import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;

public class DaoUtil {
	private SqlSessionFactory sessionFactory;
	private static DaoUtil inst = new DaoUtil();

	private DaoUtil() {
		sessionFactory = createSqlSessionFactory();
	}

	public static SqlSessionFactory getSqlSessionFactory() {
		return inst.sessionFactory;
	}

	private SqlSessionFactory createSqlSessionFactory() {
		SqlSessionFactory ssf = null;

		try {
			ssf = new SqlSessionFactoryBuilder().build(Resources.getResourceAsStream(AppConstants.MYBATIS_CONFIG_FILE_NAME));
		} catch (IOException e) {
			e.printStackTrace();
		}

		return ssf;
	}
}