package jp.co.headwaters.webappos.controller.utils;

import java.io.IOException;

import jp.co.headwaters.webappos.controller.ControllerConstants;

import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;

public class DaoUtils {
	private SqlSessionFactory sessionFactory;
	private static DaoUtils inst = new DaoUtils();

	private DaoUtils() {
		this.sessionFactory = createSqlSessionFactory();
	}

	public static SqlSessionFactory getSqlSessionFactory() {
		return inst.sessionFactory;
	}

	private static SqlSessionFactory createSqlSessionFactory() {
		SqlSessionFactory ssf = null;

		try {
			ssf = new SqlSessionFactoryBuilder().build(Resources.getResourceAsStream(ControllerConstants.MYBATIS_CONFIG_FILE_NAME));
		} catch (IOException e) {
			e.printStackTrace();
		}

		return ssf;
	}
}