package jp.co.headwaters.webappos.generator.utils;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.mybatis.generator.config.JDBCConnectionConfiguration;
import org.mybatis.generator.internal.db.ConnectionFactory;

public class DataBaseUtils {

	public static Connection getConnection(JDBCConnectionConfiguration config) throws SQLException {
		Connection connection = ConnectionFactory.getInstance().getConnection(config);
		return connection;
	}

	public static void closeConnection(Connection connection) {
		if (connection != null) {
			try {
				connection.close();
			} catch (SQLException e) {
				// ignore
			}
		}
	}

	public static void closeResultSet(ResultSet rs) {
		if (rs != null) {
			try {
				rs.close();
			} catch (SQLException e) {
				// ignore
			}
		}
	}
}
