﻿/*
  ==============================================================================

   Copyright 2005-11 by Satoshi Fujiwara.

   async can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   async is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with async; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ==============================================================================
*/

#include "StdAfx.h"
#if _DEBUG
#define _CRTDBG_MAP_ALLOC
#include <crtdbg.h>
#define new new(_NORMAL_BLOCK, __FILE__, __LINE__)
#endif
#include "sf_memory.h"
#include "audio_base.h"
#include "wasapi.h"
#include "application.h"
using namespace boost;
using namespace std;
namespace sf {
  const int wasapi_device_manager::sample_rates[NUM_SAMPLE_RATE] = {8000,11025,16000,22050,24000,32000,44100,48000,88200,96000,176400,192000};
  const bits_pair wasapi_device_manager::sample_bits[NUM_SAMPLE_BITS] = {{8,8},{16,16},{24,24},{32,24},{32,32},{32,WAVE_FORMAT_IEEE_FLOAT}};

  void make_wave_format(WAVEFORMATEXTENSIBLE& format,int sample_rate,int channels,bits_pair b,uint32_t type,const GUID&  sub_type)
  {
    ZeroMemory(&format,sizeof(WAVEFORMATEXTENSIBLE));
    format.Format.wFormatTag = type;
    format.Format.cbSize = sizeof(WAVEFORMATEXTENSIBLE) - sizeof(WAVEFORMATEX);
    format.SubFormat = sub_type;
    format.Format.nSamplesPerSec = sample_rate;
    format.Format.nChannels = channels;
    format.Format.wBitsPerSample = b.bits_per_sample;
    format.Format.nBlockAlign = (format.Format.wBitsPerSample / 8) * format.Format.nChannels;
    format.Format.nAvgBytesPerSec = format.Format.nSamplesPerSec  * format.Format.nBlockAlign;
    format.Samples.wValidBitsPerSample = b.valid_bits_per_sample;

    format.dwChannelMask = SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT;
  };

  void make_wave_format(WAVEFORMATEX& format,int sample_rate,int channels,int bits,uint32_t type)
  {
    ZeroMemory(&format,sizeof(WAVEFORMATEX));
    format.wFormatTag = type;
    format.nSamplesPerSec = sample_rate;
    format.nChannels = channels;
    format.wBitsPerSample = bits;
    format.nBlockAlign = (format.wBitsPerSample / 8) * format.nChannels;
    format.nAvgBytesPerSec = format.nSamplesPerSec  * format.nBlockAlign;
  };

  struct prop_variant 
  {
    prop_variant()
    {
      PropVariantInit(&value_);
    }

    ~prop_variant()
    {
      PropVariantClear(&value_);
    }

    PROPVARIANT* get(){ return &value_;};

    PROPVARIANT* operator &(){return get();}

    operator PROPVARIANT*() {return get();}

  private:
    PROPVARIANT value_;
  };

wasapi_device_manager::wasapi_device_manager() 
  : output_device_index_(0),input_device_index_(0)
{
  wstring p = application::instance()->base_directory() + L"\\wasapi_device_manager.config.xml";
  filesystem3::wpath config_path(p);

  std::wstring output_id;
  std::wstring input_id;

  if(filesystem3::exists(config_path))
  {
    try {
      filesystem3::wifstream f(config_path);
      archive::xml_wiarchive ar(f);
      ar & boost::serialization::make_nvp("output_device_id",output_id);
      ar & boost::serialization::make_nvp("input_device_id" ,input_id);
    } catch(...)
    {
      output_id = input_id = L"";
      filesystem3::remove(config_path);
    }
  }

  // IMMDeviceEnumeratorの取得
  THROW_IF_ERR(
    CoCreateInstance(
    __uuidof(MMDeviceEnumerator), NULL, CLSCTX_INPROC_SERVER,
    IID_PPV_ARGS(&device_enumerator_)));

  // 出力エンドポイントの取得
  output_device_index_ = get_device_infos(eRender,output_device_infos_,output_id);

  // 出力エンドポイントの能力を調査する
  for(int d = 0;d < output_device_infos_.size();++d)
  {
    IAudioClientPtr c;
    // オーディオクライアントを取得
    THROW_IF_ERR(
      output_device_infos_[d].device_ptr
      ->Activate(__uuidof(IAudioClient), CLSCTX_INPROC_SERVER,
      NULL, reinterpret_cast<void **>(&c))
      );          

    c->GetDevicePeriod(&(output_device_infos_[d].latency_default),&(output_device_infos_[d].latency_minimum));
    if(output_device_infos_[d].params.latency == 0 
      || output_device_infos_[d].params.latency < output_device_infos_[d].latency_minimum )
    {
      output_device_infos_[d].params.latency = output_device_infos_[d].latency_default;
    }

#ifdef _DEBUG
    wdout << output_device_infos_[d].device_friendly_name << endl;
    wdout << wformat(L"latency default:%d min:%d") % output_device_infos_[d].latency_default % output_device_infos_[d].latency_minimum << endl;
#endif
    for(int bits = 0;bits < NUM_SAMPLE_BITS;++bits)
    {
      for(int channel = 1;channel < 3;++channel)
      {
        for(int rate = 0;rate < NUM_SAMPLE_RATE;++rate)
        {
          sf::co_task_memory<WAVEFORMATEXTENSIBLE>  a,a1;
          WAVEFORMATEXTENSIBLE f;

//            make_wave_fomat(f,sample_rates[rate],channel,sample_bits[bits]);
          if(sample_bits[bits].valid_bits_per_sample == WAVE_FORMAT_IEEE_FLOAT)
          {
            bits_pair b ={sample_bits[bits].bits_per_sample,sample_bits[bits].bits_per_sample};
            make_wave_format(f,sample_rates[rate],channel,b,WAVE_FORMAT_EXTENSIBLE,KSDATAFORMAT_SUBTYPE_IEEE_FLOAT);
          } else {
            make_wave_format(f,sample_rates[rate],channel,sample_bits[bits],WAVE_FORMAT_EXTENSIBLE,KSDATAFORMAT_SUBTYPE_PCM);
          }

          // 排他モード
          HRESULT hr = c->IsFormatSupported(
            AUDCLNT_SHAREMODE_EXCLUSIVE,reinterpret_cast<WAVEFORMATEX*>(&f),reinterpret_cast<WAVEFORMATEX**>(&a));
          if(hr == S_OK){
            output_device_infos_[d].support_formats[AUDCLNT_SHAREMODE_EXCLUSIVE][ sample_bits[bits].bits_per_sample ][sample_bits[bits].valid_bits_per_sample][channel][sample_rates[rate]] = 0;
#ifdef _DEBUG
            wdout << wformat(L"|exc  |bits:%02d|vbits:%02d|channel:%02d|rate:%06d|%s|") % sample_bits[bits].bits_per_sample % sample_bits[bits].valid_bits_per_sample % channel % sample_rates[rate] % (hr == S_OK?L"OK":L"NG") << endl;
#endif            }

          // make_wave_format(f,sample_rates[rate],channel,sample_bits[bits],WAVE_FORMAT_EXTENSIBLE);
          // 共有モード
          hr = c->IsFormatSupported(AUDCLNT_SHAREMODE_SHARED,reinterpret_cast<WAVEFORMATEX*>(&f),reinterpret_cast<WAVEFORMATEX**>(&a1));
          if(hr == S_OK){
            output_device_infos_[d]
              .support_formats
                [AUDCLNT_SHAREMODE_SHARED]
                [ sample_bits[bits].bits_per_sample ]
                [sample_bits[bits].valid_bits_per_sample]
                [channel][sample_rates[rate]] 
                = 0;
#ifdef _DEBUG
            wdout << wformat(L"|share|bits:%02d|vbits:%02d|channel:%02d|rate:%06d|%s|")
              % sample_bits[bits].bits_per_sample 
              % sample_bits[bits].valid_bits_per_sample 
              % channel % sample_rates[rate] 
              % (hr == S_OK?L"OK":L"NG") << endl;

#endif
          }
        }
      }
    }
#ifdef _DEBUG
    wdout << "-------------------------------" << std::endl;
#endif
    }
    safe_release(c);
  }

  // 入力エンドポイントの取得
  input_device_index_ = get_device_infos(eCapture,input_device_infos_,input_id);
  // 出力エンドポイントの能力を調査する
  for(int d = 0;d < input_device_infos_.size();++d)
  {
    IAudioClientPtr c;
    // オーディオクライアントを取得
    THROW_IF_ERR(
      input_device_infos_[d].device_ptr
      ->Activate(__uuidof(IAudioClient), CLSCTX_INPROC_SERVER,
      NULL, reinterpret_cast<void **>(&c))
      );          

    c->GetDevicePeriod(&(input_device_infos_[d].latency_default),&(input_device_infos_[d].latency_minimum));
    if(input_device_infos_[d].params.latency == 0 || input_device_infos_[d].params.latency < input_device_infos_[d].latency_minimum ){
      input_device_infos_[d].params.latency = input_device_infos_[d].latency_default;
    }

#ifdef _DEBUG
    wdout << input_device_infos_[d].device_friendly_name << endl;
    wdout << wformat(L"latency default:%d min:%d") % input_device_infos_[d].latency_default % input_device_infos_[d].latency_minimum << endl;
#endif
    for(int bits = 0;bits < NUM_SAMPLE_BITS;++bits)
    {
      for(int channel = 1;channel < 3;++channel)
      {
        for(int rate = 0;rate < NUM_SAMPLE_RATE;++rate)
        {
          sf::co_task_memory<WAVEFORMATEXTENSIBLE>  a,a1;
          WAVEFORMATEXTENSIBLE f;

          // make_wave_fomat(f,sample_rates[rate],channel,sample_bits[bits]);
          if(sample_bits[bits].valid_bits_per_sample == WAVE_FORMAT_IEEE_FLOAT)
          {
            bits_pair b ={sample_bits[bits].bits_per_sample,sample_bits[bits].bits_per_sample};
            make_wave_format(f,sample_rates[rate],channel,b,WAVE_FORMAT_EXTENSIBLE,KSDATAFORMAT_SUBTYPE_IEEE_FLOAT);
          } else {
            make_wave_format(f,sample_rates[rate],channel,sample_bits[bits],WAVE_FORMAT_EXTENSIBLE,KSDATAFORMAT_SUBTYPE_PCM);
          }

          // 排他モード
          HRESULT hr = c->IsFormatSupported(
            AUDCLNT_SHAREMODE_EXCLUSIVE,reinterpret_cast<WAVEFORMATEX*>(&f),reinterpret_cast<WAVEFORMATEX**>(&a));
          if(hr == S_OK){
            input_device_infos_[d]
            .support_formats
              [AUDCLNT_SHAREMODE_EXCLUSIVE]
              [ sample_bits[bits].bits_per_sample ]
              [sample_bits[bits].valid_bits_per_sample]
              [channel]
              [sample_rates[rate]] = 0;
#ifdef _DEBUG
            wdout << wformat(L"|exc  |bits:%02d|vbits:%02d|channel:%02d|rate:%06d|%s|") 
              % sample_bits[bits].bits_per_sample 
              % sample_bits[bits].valid_bits_per_sample 
              % channel % sample_rates[rate] 
              % (hr == S_OK?L"OK":L"NG") << endl;
#endif            }

            // make_wave_format(f,sample_rates[rate],channel,sample_bits[bits],WAVE_FORMAT_EXTENSIBLE);
            // 共有モード
            hr = c->IsFormatSupported(AUDCLNT_SHAREMODE_SHARED,reinterpret_cast<WAVEFORMATEX*>(&f),reinterpret_cast<WAVEFORMATEX**>(&a1));
            if(hr == S_OK){
              input_device_infos_[d].
                support_formats
                [AUDCLNT_SHAREMODE_SHARED]
                [sample_bits[bits].bits_per_sample ]
                [sample_bits[bits].valid_bits_per_sample]
                [channel]
                [sample_rates[rate]] = 0;
#ifdef _DEBUG
              wdout << wformat(L"|share|bits:%02d|vbits:%02d|channel:%02d|rate:%06d|%s|") 
                % sample_bits[bits].bits_per_sample 
                % sample_bits[bits].valid_bits_per_sample 
                % channel 
                % sample_rates[rate] 
                % (hr == S_OK?L"OK":L"NG") << endl;

#endif
            }
          }
        }
      }
#ifdef _DEBUG
    wdout << "-------------------------------" << std::endl;
#endif
    }
    safe_release(c);
  }
}//

  int wasapi_device_manager::get_device_infos(EDataFlow data_flow, std::vector<device_info>& infos,const std::wstring& idd)
  {
    // コレクションを取得
    IMMDeviceCollectionPtr collection;
    device_enumerator_->EnumAudioEndpoints(data_flow,DEVICE_STATE_ACTIVE ,&collection);
    uint32_t count;
    wstring idd_w(idd);
    // デフォルトデバイスの情報
    IMMDevicePtr default_device;
    int default_index = 0;
    device_enumerator_->GetDefaultAudioEndpoint(data_flow,eMultimedia,&default_device);
    co_task_memory<WCHAR> iddw;
    default_device->GetId(&iddw);
    wstring id_default(iddw.get());

    if(idd_w.empty() || id_default.size() != idd_w.size())
    {
      idd_w.assign(iddw.get());
    }

    // 各デバイスの情報を収集する
    collection->GetCount(&count);
    bool found = false;
    for(int i = 0;i < count ;++i)
    {
      IMMDevicePtr d;
      IPropertyStorePtr p;
      co_task_memory<WCHAR> id;
      collection->Item(i,&d);
      d->GetId(&id);
      d->OpenPropertyStore(STGM_READ,&p);
      prop_variant difn,ddd,dfn;
      THROW_IF_ERR(p->GetValue(PKEY_DeviceInterface_FriendlyName, &difn));
      THROW_IF_ERR(p->GetValue(PKEY_Device_DeviceDesc, &ddd));
      THROW_IF_ERR(p->GetValue(PKEY_Device_FriendlyName, &difn));
      infos.push_back(device_info(std::wstring(id.get()),std::wstring(difn.get()->pwszVal),std::wstring(ddd.get()->pwszVal),std::wstring(difn.get()->pwszVal),d));

      if(infos[i].id == idd_w)
      {
        default_index = i;
        infos[i].is_selected = true;
        found = true;
      }

#ifdef _DEBUG
      wdout << L"--------------------------------------------" << std::endl;
      wdout << infos[i].device_description << std::endl;
      wdout << infos[i].device_friendly_name << std::endl;
      wdout << infos[i].device_interface_friendly_name << std::endl;
      wdout << infos[i].is_selected << std::endl;
      wdout << infos[i].id << std::endl;
#endif
      safe_release(p);
      safe_release(d);
    }

    if(!found)
    {
      for(int i = 0;i < infos.size();++i)
      {
        if(infos[i].id == id_default)
        {
          default_index = i;
          infos[i].is_selected = true;
        }


      }
    }
    return default_index;
  }

  wasapi_device_manager::~wasapi_device_manager()
  {
    //for(int i = 0; i < 
    //safe_release(device_collection_);
    //safe_release(device_collection_);
    safe_release(device_enumerator_);

    // 設定の保存
    try{
      wstring p = application::instance()->base_directory() + L"\\wasapi_device_manager.config.xml";
      filesystem3::wpath config_path(p);
      filesystem3::wofstream f(config_path,std::ios_base::out | std::ios_base::trunc);
      archive::xml_woarchive ar(f);
      ar & boost::serialization::make_nvp("output_device_id",current_output_device().id);
      ar & boost::serialization::make_nvp("input_device_id" ,current_input_device().id);
    }catch(...) {

    }
  }

  wasapi_device_manager::device_info::device_info(std::wstring& i,std::wstring& difn,std::wstring& dd,std::wstring& dfn,IMMDevicePtr p)
    : id(i),device_interface_friendly_name(difn),device_description(dd),device_friendly_name(dfn),is_selected(false)
  {
    device_ptr = p;
    filesystem3::wpath config_path(application::instance()->base_directory() + L"\\" + id + L".xml");
    if(filesystem3::exists(config_path))
    {
      try{
        filesystem3::wifstream ifile(config_path);
        boost::archive::xml_wiarchive ar(ifile);
        ar >> BOOST_SERIALIZATION_NVP(params);
      } catch (...) 
      {
        // ファイル読み込みに問題がある場合はファイルを消す。
        filesystem3::remove(config_path);
      }
    }
#ifdef _DEBUG
    wdout << L"================================================" << std::endl;
    wdout << id << L"\n" << device_interface_friendly_name << std::endl;
    wdout << params.latency << std::endl;
    wdout << L"================================================" << std::endl;
#endif

  }

  wasapi_device_manager::device_info::~device_info()
  {
    try {
      filesystem3::wpath config_path(application::instance()->base_directory() + L"\\"+  id + L".xml");
      filesystem3::wofstream ofile(config_path,std::ios_base::out | ios_base::trunc);
      archive::xml_woarchive ar(ofile);
      ar << BOOST_SERIALIZATION_NVP(params);
    } catch(...)
    {

    }
  }


}