unit BottleChainListFrame;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, 
  Dialogs, BottleChainEvent, BottleChainRule, StdCtrls, CheckLst,
  BottleChainRuleEditor;

type
  TfrmBottleChainList = class(TFrame)
    lstRules: TCheckListBox;
    btnDelete: TButton;
    btnAdd: TButton;
    btnDown: TButton;
    btnUp: TButton;
    btnEdit: TButton;
    btnDuplicate: TButton;
    procedure lstRulesMeasureItem(Control: TWinControl; Index: Integer;
      var Height: Integer);
    procedure lstRulesDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure lstRulesClickCheck(Sender: TObject);
    procedure EditRule(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
    procedure btnUpClick(Sender: TObject);
    procedure btnDownClick(Sender: TObject);
    procedure btnDuplicateClick(Sender: TObject);
  private
    function ExecuteEditRule(Rule: TBottleChainRule): boolean;
    procedure UpdateCheckBox;
    procedure UpdateHeight;
  public
    procedure UpdateDisplay;
  end;

implementation

{$R *.dfm}

procedure TfrmBottleChainList.lstRulesMeasureItem(Control: TWinControl; Index: Integer;
  var Height: Integer);
var Str: String;
    ARect: TRect;
begin
  ARect := lstRules.ItemRect(Index);
  ARect.Left := ARect.Left + 2;
  ARect.Right := ARect.Right - 2;

  Str := BottleChainRuleList[Index].StringExpression;
  //
  lstRules.Canvas.Font.Style := lstRules.Canvas.Font.Style + [fsBold];
  DrawText(lstRules.Canvas.Handle, PChar(Str), -1,
    ARect, DT_NOPREFIX or DT_EDITCONTROL or DT_CALCRECT or DT_WORDBREAK);
  Height := ARect.Bottom - ARect.Top;
  //

  ARect.Left := ARect.Left + 5;
  lstRules.Canvas.Font.Style := lstRules.Canvas.Font.Style - [fsBold];
  Str := BottleChainRuleList[Index].Title;
  DrawText(lstRules.Canvas.Handle, PChar(Str), -1,
    ARect, DT_NOPREFIX or DT_EDITCONTROL or DT_CALCRECT or DT_WORDBREAK);
  Height := Height + ARect.Bottom - ARect.Top;
  Height := Height + 4;
end;

procedure TfrmBottleChainList.lstRulesDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var Str: String;
    y: integer;
begin
  lstRules.Canvas.FillRect(Rect);

  // eLXg`̈̃}[W
  Rect.Left := Rect.Left + 2;
  Rect.Top := Rect.Top + 2;
  Rect.Right := Rect.Right - 2;
  Rect.Bottom := Rect.Bottom - 2;

  lstRules.Canvas.Font.Style := lstRules.Canvas.Font.Style + [fsBold];
  Str := BottleChainRuleList[Index].Title;
  y := DrawText(lstRules.Canvas.Handle, PChar(Str), -1, Rect, DT_NOPREFIX or DT_WORDBREAK);
  lstRules.Canvas.Font.Style := lstRules.Canvas.Font.Style - [fsBold];
  Str := BottleChainRuleList[Index].StringExpression;
  Rect.Top := Rect.Top + y;
  Rect.Left := Rect.Left + 5;
  DrawText(lstRules.Canvas.Handle, PChar(Str), -1, Rect, DT_NOPREFIX or DT_WORDBREAK);
end;

procedure TfrmBottleChainList.UpdateDisplay;
var i: integer;
    sel: TBottleChainRule;
begin
  i := lstRules.ItemIndex;
  if i >= 0 then begin
    if i <= BottleChainRuleList.Count-1 then
      sel := BottleChainRuleList[i]
    else if BottleChainRuleList.Count > 0 then
      sel := BottleChainRuleList[BottleChainRuleList.Count-1]
    else
      sel := nil;
  end else sel := nil;

  lstRules.Items.BeginUpdate;
  lstRules.Items.Clear;
  for i := 0 to BottleChainRuleList.Count-1 do begin
    lstRules.Items.Add(BottleChainRuleList.Rules[i].StringExpression);
    lstRules.Checked[i] := BottleChainRuleList[i].Enabled;
  end;
  lstRules.Items.EndUpdate;
  lstRules.ItemIndex := BottleChainRuleList.List.IndexOf(sel);
end;

procedure TfrmBottleChainList.lstRulesClickCheck(Sender: TObject);
var i: integer;
begin
  for i := 0 to BottleChainRuleList.Count-1 do begin
    BottleChainRuleList[i].Enabled := lstRules.Checked[i];
  end;
end;

procedure TfrmBottleChainList.EditRule(Sender: TObject);
var
  Edit: TBottleChainRule;
begin
  if lstRules.ItemIndex <> -1 then
  begin
    Edit := TBottleChainRule.Create(nil);
    try
      Edit.Assign(BottleChainRuleList[lstRules.ItemIndex]);
      if ExecuteEditRule(Edit) then
        BottleChainRuleList[lstRules.ItemIndex].Assign(Edit);
    finally
      Edit.Free;
    end;
    UpdateHeight;
  end;
end;

procedure TfrmBottleChainList.btnAddClick(Sender: TObject);
var
  New: TBottleChainRule;
begin
  New := TBottleChainRule.Create(BottleChainRuleList);
  try
    New.Enabled := true;
    if ExecuteEditRule(New) then
    begin
      New.RuleList := BottleChainRuleList; // Xgɒǉ
      UpdateDisplay;
    end
    else
      New.Free;
  except
    New.Free;
  end;
end;

procedure TfrmBottleChainList.btnDeleteClick(Sender: TObject);
var
  Del: TBottleChainRule;
  Index: integer;
begin
  Index := lstRules.ItemIndex;
  if Index < 0 then
    Exit;
  Del := BottleChainRuleList[Index];
  Del.Free;
  lstRules.Items.Delete(Index);
end;

procedure TfrmBottleChainList.btnUpClick(Sender: TObject);
var i: integer;
begin
  i := lstRules.ItemIndex;
  if i > 0 then begin
    BottleChainRuleList.List.Move(i, i - 1);
    lstRules.Items.Move(i, i-1);
    lstRules.ItemIndex := i - 1;
    UpdateHeight;
  end;
end;

procedure TfrmBottleChainList.btnDownClick(Sender: TObject);
var i: integer;
begin
  i := lstRules.ItemIndex;
  if (i >= 0) and (i < lstRules.Items.Count-1) then begin
    BottleChainRuleList.List.Move(i, i + 1);
    lstRules.Items.Move(i, i+1);
    lstRules.ItemIndex := i + 1;
    UpdateHeight;
  end;
end;

function TfrmBottleChainList.ExecuteEditRule(Rule: TBottleChainRule): boolean;
var MyfrmBottleChainRuleEditor: TfrmBottleChainRuleEditor;
begin
  Application.CreateForm(TfrmBottleChainRuleEditor, MyfrmBottleChainRuleEditor);
  with MyfrmBottleChainRuleEditor do begin
    try
      Result := Execute(Rule);
    finally
      Release;
    end;
  end;
end;

procedure TfrmBottleChainList.btnDuplicateClick(Sender: TObject);
var
  New: TBottleChainRule;
begin
  if lstRules.ItemIndex <> -1 then
  begin
    New := TBottleChainRule.Create(BottleChainRuleList);
    New.Assign(BottleChainRuleList.Rules[lstRules.ItemIndex]);
    New.RuleList := BottleChainRuleList; // Ń[Xgɂ͒ǉ
    lstRules.Items.Insert(lstRules.ItemIndex + 1, New.StringExpression);
    UpdateCheckBox;
    UpdateHeight;
  end;
end;

procedure TfrmBottleChainList.UpdateCheckBox;
var
  i: integer;
begin
  for i := 0 to BottleChainRuleList.Count-1 do
    lstRules.Checked[i] := BottleChainRuleList[i].Enabled;
end;

procedure TfrmBottleChainList.UpdateHeight;
begin
  with lstRules do
  begin
    Style := lbOwnerDrawFixed;
    Style := lbOwnerDrawVariable;
  end;
end;

end.
