unit EditorTalkShow;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, TalkShowFrame, BottleDef, SsParser;

type
  TfrmEditorTalkShow = class(TForm)
    TalkShowFrame: TfrmTalkShow;
    SsParser: TSsParser;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  frmEditorTalkShow: TfrmEditorTalkShow;

implementation

{$R *.dfm}

uses MainForm;

procedure TfrmEditorTalkShow.FormCreate(Sender: TObject);
begin
  with SsParser do
  begin
    MetaPattern.Assign(frmSender.SsParser.MetaPattern);
    TagPattern.Assign(frmSender.SsParser.TagPattern);
  end;
  TalkShowFrame.SsParser := SsParser;
  self.Left := Pref.EditorPreviewWindowPosition.Left;
  self.Top  := Pref.EditorPreviewWindowPosition.Top;
  self.Width := Pref.EditorPreviewWindowPosition.Right - self.Left;
  self.Height := Pref.EditorPreviewWindowPosition.Bottom - self.Top;
end;

procedure TfrmEditorTalkShow.FormDestroy(Sender: TObject);
var ARect: TRect;
begin
  with ARect do
  begin
    Left   := self.Left;
    Top    := self.Top;
    Right  := self.Width + self.Left;
    Bottom := self.Height + self.Top;
  end;
  Pref.EditorPreviewWindowPosition := ARect;
end;

procedure TfrmEditorTalkShow.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Pref.ShowEditorPreviewWindow := False;

  //ꉞIɁuBvwĂiftHgŉBj
  Action := caHide;
end;

initialization

frmEditorTalkShow := nil;

end.
