unit HeadValue;

(*
Content-type: text/html
Content-length: 1024

̂悤ȕ͂K؂ɕĈ₷邽߂̃NXB
 *)

interface
uses Classes, SysUtils;

type
  EHeadValueError = class(Exception);

  THeadValue = class(TPersistent)
  private
    FStrList: TStringList;
    function GetCount: integer;
    function GetData(Key: String): String;
    function GetValueAt(Index: integer): String;
    function GetKeyAt(Index: integer): String;
    function GetIntData(Key: String): integer;
    procedure SetData(Key: String; const Value: String);
    procedure SetValueAt(Index: integer; const Value: String);
  public
    constructor Create(const Str: String); overload;
    constructor Create; overload;
    destructor Destroy; override;
    procedure Initialize(const Str: String);
    function ToStr: String;
    property Count: integer read GetCount;
    property KeyAt[Index: integer]: String read GetKeyAt;
    property ValueAt[Index: integer]: String read GetValueAt write SetValueAt;
    property Data[Key: String]: String read GetData write SetData; default;
    property IntData[Key: String]: integer read GetIntData;
    procedure Assign(Source: TPersistent); override;
  end;

implementation

{ THeadValue }

constructor THeadValue.Create(const Str: String);
begin
  Create;
  Initialize(Str);
end;

procedure THeadValue.Assign(Source: TPersistent);
begin
  if Source is THeadValue then
    FStrList.Assign((Source as THeadValue).FStrList)
  else
    inherited;
end;

constructor THeadValue.Create;
begin
  FStrList := TStringList.Create;
end;

destructor THeadValue.Destroy;
begin
  inherited;
  FStrList.Free;
end;

function THeadValue.GetCount: integer;
begin
  Result := FStrList.Count div 2;
end;

function THeadValue.GetData(Key: String): String;
var i: integer;
begin
  Result := '';
  for i := 0 to Count-1 do
    if KeyAt[i] = Key then begin
      Result := ValueAt[i];
      Exit;
    end;
end;

function THeadValue.GetIntData(Key: String): integer;
begin
  Result := StrToIntDef(GetData(Key), -1);
end;

function THeadValue.GetKeyAt(Index: integer): String;
begin
  Result := FStrList[Index * 2];
end;

function THeadValue.GetValueAt(Index: integer): String;
begin
  Result := FStrList[Index * 2 +1];
end;

procedure THeadValue.Initialize(const Str: String);
var Tmp: TStringList;
    i, j: integer;
    Key, Value, S: String;
begin
  Tmp := nil;
  FStrList.Clear;
  try
    Tmp := TStringList.Create;
    Tmp.Text := Str;
    for i := 0 to Tmp.Count-1 do begin
      S := Tmp[i];
      Key := ''; Value := '';
      j := Pos(':', S);
      if j > 0 then begin
        Key := Copy(S, 1, j-1);
        if Length(S) > j then Inc(j);
        while j <= Length(S) do
        begin
          if (S[j] in [' ']) then
            Inc(j)
          else
            Break;
        end;
        Value := Copy(S, j, High(integer));
      end;
      if Key <> '' then begin // Value͋ł悢
        FStrList.Add(Key);
        FStrList.Add(Value);
      end;
    end;
  finally
    Tmp.Free;
  end;
end;

function THeadValue.ToStr: String;
var i, max: integer;
begin
  max := FStrList.Count div 2 - 1;
  Result := '';
  for i := 0 to max do begin
    Result := Result + Format('%s: %s', [FStrList[i*2], FStrList[i*2+1]]);
    if i <> max then Result := Result + #13#10;
  end;
end;

procedure THeadValue.SetData(Key: String; const Value: String);
var i: integer;
begin
  for i := 0 to Count-1 do
    if KeyAt[i] = Key then begin
      ValueAt[i] := Value;
      Exit;
    end;
  // ǉ
  FStrList.Add(Key);
  FStrList.Add(Value);
end;

procedure THeadValue.SetValueAt(Index: integer; const Value: String);
begin
  FStrList[Index * 2 +1] := Value;
end;

end.
