unit HtmlOutputConfig;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Logs, StrUtils;

type
  TfrmHTMLOutputConfig = class(TForm)
    rgpUseColor: TRadioGroup;
    rgpOutputRange: TRadioGroup;
    rgpImageType: TRadioGroup;
    btnOK: TButton;
    edtFileName: TEdit;
    btnBrowseFileName: TButton;
    lblFileName: TLabel;
    edtImageDir: TEdit;
    btnBrowseImageDir: TButton;
    lblImageDir: TLabel;
    btnCancel: TButton;
    SaveDialog: TSaveDialog;
    procedure btnCancelClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure btnBrowseFileNameClick(Sender: TObject);
  private
    FImageType: THTMLOutputImageType;
    FRange: THTMLOutputRange;
    FUseColor: THTMLOutputUseColor;
    FImageDir: String;
    FFileName: String;
    procedure SetImageType(const Value: THTMLOutputImageType);
    procedure SetRange(const Value: THTMLOutputRange);
    procedure SetUseColor(const Value: THTMLOutputUseColor);
    procedure SetFileName(const Value: String);
    procedure SetImageDir(const Value: String);
    { Private 錾 }
  public
    { Public 錾 }
    property UseColor: THTMLOutputUseColor read FUseColor write SetUseColor;
    property ImageType: THTMLOutputImageType read FImageType write SetImageType;
    property Range: THTMLOutputRange read FRange write SetRange;
    property FileName: String read FFileName write SetFileName;
    property ImageDir: String read FImageDir write SetImageDir;
    function Execute: boolean;
  end;

var
  frmHTMLOutputConfig: TfrmHTMLOutputConfig;

implementation

{$R *.dfm}

procedure TfrmHTMLOutputConfig.btnCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TfrmHTMLOutputConfig.btnOKClick(Sender: TObject);
begin
  if RightStr(edtImageDir.Text, 1) = PathDelim then
    edtImageDir.Text := LeftStr(edtImageDir.Text, Length(edtImageDir.Text)-1);
  if not ForceDirectories(edtImageDir.Text) then
    if rgpImageType.ItemIndex > 0 then
    begin
      ShowMessage('摜fBNg쐬ł܂');
      Exit;
    end;
  ModalResult := mrOk;
end;

procedure TfrmHTMLOutputConfig.btnBrowseFileNameClick(Sender: TObject);
begin
  if SaveDialog.Execute then
  begin
    edtFileName.Text := SaveDialog.FileName;
    if edtImageDir.Text = '' then
      edtImageDir.Text := ChangeFileExt(SaveDialog.FileName, '.files');
  end;
end;

function TfrmHTMLOutputConfig.Execute: boolean;
begin
  rgpUseColor.ItemIndex := Ord(UseColor);
  rgpImageType.ItemIndex := Ord(ImageType);
  rgpOutputRange.ItemIndex := Ord(Range);
  edtFileName.Text := FileName;
  edtImageDir.Text := ImageDir;
  Result := Self.ShowModal = mrOk;
  if Result then
  begin
    UseColor := THTMLOutputUseColor(rgpUseColor.ItemIndex);
    ImageType := THTMLOutputImageType(rgpImageType.ItemIndex);
    Range := THTMLOutputRange(rgpOutputRange.ItemIndex);
    FileName := edtFileName.Text;
    ImageDir := edtImageDir.Text;
  end;
end;

procedure TfrmHTMLOutputConfig.SetImageType(
  const Value: THTMLOutputImageType);
begin
  FImageType := Value;
end;

procedure TfrmHTMLOutputConfig.SetRange(const Value: THTMLOutputRange);
begin
  FRange := Value;
end;

procedure TfrmHTMLOutputConfig.SetUseColor(
  const Value: THTMLOutputUseColor);
begin
  FUseColor := Value;
end;

procedure TfrmHTMLOutputConfig.SetFileName(const Value: String);
begin
  FFileName := Value;
end;

procedure TfrmHTMLOutputConfig.SetImageDir(const Value: String);
begin
  FImageDir := Value;
end;

end.
