unit LogDownload;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, Spin, BottleDef, DateUtils;

type
  TfrmLogDownload = class(TForm)
    btnOk: TButton;
    btnCancel: TButton;
    grpDate: TGroupBox;
    dtFrom: TDateTimePicker;
    Label1: TLabel;
    dtTo: TDateTimePicker;
    Label2: TLabel;
    GroupBox1: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    spnMinVote: TSpinEdit;
    spnMinAgree: TSpinEdit;
    cbxChannel: TComboBox;
    Label6: TLabel;
    Label7: TLabel;
    spnRecentCount: TSpinEdit;
    Label8: TLabel;
    rbRecent: TRadioButton;
    rbRange: TRadioButton;
    cbxUnit: TComboBox;
    procedure btnCancelClick(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
    procedure spnRecentCountChange(Sender: TObject);
    procedure cbxUnitChange(Sender: TObject);
    procedure dtFromChange(Sender: TObject);
    procedure dtToChange(Sender: TObject);
    procedure spnEdtEnterKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    procedure SetChannel(const Value: String);
    procedure SetDateHi(const Value: TDateTime);
    procedure SetDateLo(const Value: TDateTime);
    procedure SetMinAgree(const Value: integer);
    procedure SetMinVote(const Value: integer);
    function GetChannel: String;
    function GetDateHi: TDateTime;
    function GetDateLo: TDateTime;
    function GetMinAgree: integer;
    function GetMinVote: integer;
    function GetIsRange: boolean;
    procedure SetIsRange(const Value: boolean);
    function GetRecentCount: integer;
    { Private 錾 }
  public
    { Public 錾 }
    function Execute: boolean;
    property MinVote: integer read GetMinVote write SetMinVote;
    property MinAgree: integer read GetMinAgree write SetMinAgree;
    property Channel: String read GetChannel write SetChannel;
    property DateLo: TDateTime read GetDateLo write SetDateLo;
    property DateHi: TDateTime read GetDateHi write SetDateHi;
    property IsRange: boolean read GetIsRange write SetIsRange;
    property RecentCount: integer read GetRecentCount;
  end;

var
  frmLogDownload: TfrmLogDownload;

implementation

{$R *.dfm}

procedure TfrmLogDownload.btnCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TfrmLogDownload.btnOkClick(Sender: TObject);
begin
  if CompareDate(dtFrom.DateTime, dtTo.DateTime) = 1 then
    ShowMessage('Jn͏IOɂĂ')
  else
    ModalResult := mrOk;
end;

function TfrmLogDownload.Execute: boolean;
var i: integer;
begin
  cbxChannel.Items.Clear;
  for i := 0 to ChannelList.Count - 1 do begin
    cbxChannel.Items.Add(ChannelList.ChannelItem[i].Name);
  end;
  cbxChannel.Text := '';

  spnRecentCount.Value := 1;
  cbxUnit.ItemIndex := 1;
  dtFrom.Date := Date;
  dtTo.Date := Date;
  rbRecent.Checked := true;

  spnMinVote.Value := 0;
  spnMinAgree.Value := 0;
  ShowModal;
  Result := ModalResult = mrOk;
end;

function TfrmLogDownload.GetChannel: String;
begin
  Result := cbxChannel.Text;
end;

function TfrmLogDownload.GetDateHi: TDateTime;
begin
  Result := dtTo.DateTime;
end;

function TfrmLogDownload.GetDateLo: TDateTime;
begin
  Result := dtFrom.DateTime;
end;

function TfrmLogDownload.GetMinAgree: integer;
begin
  Result := spnMinAgree.Value;
end;

function TfrmLogDownload.GetMinVote: integer;
begin
  Result := spnMinVote.Value;
end;

procedure TfrmLogDownload.SetChannel(const Value: String);
begin
  cbxChannel.Text := Value;
end;

procedure TfrmLogDownload.SetDateHi(const Value: TDateTime);
begin
  dtTo.DateTime := Value;
end;

procedure TfrmLogDownload.SetDateLo(const Value: TDateTime);
begin
  dtFrom.DateTime := Value;
end;

procedure TfrmLogDownload.SetMinAgree(const Value: integer);
begin
  spnMinAgree.Value := Value;
end;

procedure TfrmLogDownload.SetMinVote(const Value: integer);
begin
  spnMinVote.Value := Value;
end;

procedure TfrmLogDownload.spnRecentCountChange(Sender: TObject);
begin
  rbRecent.Checked := true;
end;

procedure TfrmLogDownload.cbxUnitChange(Sender: TObject);
begin
  rbRecent.Checked := true;
end;

procedure TfrmLogDownload.dtFromChange(Sender: TObject);
begin
  rbRange.Checked := true;
end;

procedure TfrmLogDownload.dtToChange(Sender: TObject);
begin
  rbRange.Checked := true;
end;

function TfrmLogDownload.GetIsRange: boolean;
begin
  Result := rbRange.Checked;
end;

procedure TfrmLogDownload.SetIsRange(const Value: boolean);
begin
  if Value then rbRange.Checked := true else rbRecent.Checked := true;
end;

function TfrmLogDownload.GetRecentCount: integer;
var u: integer;
begin
  case cbxUnit.ItemIndex of
    0: u := 1;
    1: u := 60;
    2: u := 60 * 24;
    else u := 1;
  end;
  Result := spnRecentCount.Value * u;
end;
   
{SpinEditŃG^[L[ꂽƂ
 OK{^}
 
procedure TfrmLogDownload.spnEdtEnterKeyDown(Sender: TObject;
var Key: Word; Shift: TShiftState);
begin
  if Key = VK_RETURN then
  begin
      ModalResult := mrOk;
  end
end;

end.
