unit LogForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ToolWin, StdCtrls, SsParser, BottleDef, Menus,
  Clipbrd, Logs, ShellAPI, Commctrl, DirectSstp, Contnrs, StrUtils,
  TalkShowFrame, SppList, HtmlOutputConfig, HtmlOutputProgress,
  SearchLog, IniFiles, BRegExp, RegexUtils, ExtCtrls;

type
  // O̕ۑ@
  TSaveLogType = (stLog, stLogWithChannels, stText, stXML);

  // Xgr[̃XN[
  TLVScrollDir = (lvScrollUp, lvScrollDown);

  TfrmLog = class(TForm)
    ToolBar: TToolBar;
    tbtnClear: TToolButton;
    pnlUpper: TPanel;
    SsParser: TSsParser;
    StatusBar: TStatusBar;
    tbtnSaveLog: TToolButton;
    PopupMenuPreview: TPopupMenu;
    mnPopCopy: TMenuItem;
    tbtnVoteMessage: TToolButton;
    PopupMenuListView: TPopupMenu;
    mnPopUpVoteMessage: TMenuItem;
    SaveDialog: TSaveDialog;
    pnlPanel: TPanel;
    Splitter: TSplitter;
    mnPopUpCopyScript: TMenuItem;
    PopupMenuSaveLog: TPopupMenu;
    mnSaveLog: TMenuItem;
    mnSaveLogChannel: TMenuItem;
    mnSaveLogScript: TMenuItem;
    mnSaveLogXML: TMenuItem;
    ToolButton1: TToolButton;
    mnJumpURL: TMenuItem;
    mnPopUpAgreeMessage: TMenuItem;
    tbtnAgreeMessage: TToolButton;
    ToolButton2: TToolButton;
    tbtnPreviewStyle: TToolButton;
    PopupMenuPreviewStyle: TPopupMenu;
    mnPreviewStyleConversation: TMenuItem;
    mnPreviewStyleScript: TMenuItem;
    mnPreviewStyleScriptWithLineBreak: TMenuItem;
    Panel1: TPanel;
    tabBottleLog: TTabControl;
    tbtnDownloadLog: TToolButton;
    PopupMenuTab: TPopupMenu;
    mnCloseTab: TMenuItem;
    tbtnFindBottle: TToolButton;
    tbtnOpenLog: TToolButton;
    OpenDialog: TOpenDialog;
    tbtnInsertCue: TToolButton;
    mnInsertCue: TMenuItem;
    PopupMenuListPreviewStyle: TPopupMenu;
    mnListPreviewStyleNormal: TMenuItem;
    mnListPreviewStyleTagStripped: TMenuItem;
    tbtnListPreviewStyle: TToolButton;
    mnListPreviewStyleNoColor: TMenuItem;
    SsParserForTalkShow: TSsParser;
    mnPreviewStyleConversationImage: TMenuItem;
    pnlPreviewArea: TPanel;
    TalkShowFrame: TfrmTalkShow;
    edtScript: TRichEdit;
    tbtnSendEditor: TToolButton;
    mnSendEditor: TMenuItem;
    timScrollTimer: TTimer;
    mnChangeTabName: TMenuItem;
    lvwLog: TListBox;
    N1: TMenuItem;
    N2: TMenuItem;
    mnDeleteLogItem: TMenuItem;
    mnTabSaveXMLLog: TMenuItem;
    mnSaveHTML: TMenuItem;
    mnPopupCopyGhost: TMenuItem;
    Header: THeaderControl;
    procedure tbtnClearClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure lvwLogDblClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure lvwLogClick(Sender: TObject);
    procedure mnSaveLogClick(Sender: TObject);
    procedure mnPopUpCopyScriptClick(Sender: TObject);
    procedure mnSaveLogChannelClick(Sender: TObject);
    procedure mnSaveLogScriptClick(Sender: TObject);
    procedure mnSaveLogXMLClick(Sender: TObject);
    procedure PopupMenuListViewPopup(Sender: TObject);
    procedure PopupMenuPreviewStylePopup(Sender: TObject);
    procedure mnPreviewStyleClick(Sender: TObject);
    procedure tbtnPreviewStyleClick(Sender: TObject);
    procedure tabBottleLogChange(Sender: TObject);
    procedure tabBottleLogChanging(Sender: TObject;
      var AllowChange: Boolean);
    procedure tabBottleLogContextPopup(Sender: TObject; MousePos: TPoint;
      var Handled: Boolean);
    procedure mnCloseTabClick(Sender: TObject);
    procedure tbtnFindBottleClick(Sender: TObject);
    procedure tbtnOpenLogClick(Sender: TObject);
    procedure tabBottleLogMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure tabBottleLogDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure tabBottleLogDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure tabBottleLogEndDrag(Sender, Target: TObject; X, Y: Integer);
    procedure mnListPreviewStyleClick(Sender: TObject);
    procedure tbtnListPreviewStyleClick(Sender: TObject);
    procedure PopupMenuListPreviewStylePopup(Sender: TObject);
    procedure lvwLogDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure lvwLogDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure timScrollTimerTimer(Sender: TObject);
    procedure mnChangeTabNameClick(Sender: TObject);
    procedure lvwLogStartDrag(Sender: TObject;
      var DragObject: TDragObject);
    procedure lvwLogEndDrag(Sender, Target: TObject; X, Y: Integer);
    procedure mnTabSaveXMLLogClick(Sender: TObject);
    procedure mnSaveHTMLClick(Sender: TObject);
    procedure mnPopupCopyGhostClick(Sender: TObject);
    procedure lvwLogDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure lvwLogData(Control: TWinControl; Index: Integer;
      var Data: String);
    procedure HeaderSectionClick(HeaderControl: THeaderControl;
      Section: THeaderSection);
    procedure HeaderSectionTrack(HeaderControl: THeaderControl;
      Section: THeaderSection; Width: Integer; State: TSectionTrackState);
    procedure lvwLogMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private 錾 }
    FLastScript: String; //XNvgĕ`}p
    FBottleLogList: TObjectList;
    //
    FDragTabIndex: integer; //^uhbOhbv֘A
    FDragTabDest: integer;  //hbvʒu(Eɂ^ũCfbNX)
    //
    // Xgr[hbOhbv֘A
    FLVScrollDir: TLVScrollDir; // XN[
    FLVDragDest: integer;    //hbvʒu(ɂACeIndex)
    // Xg{bNX̃L[CxgtbNp
    FLVWndMethod: TWndMethod;
    //
    procedure UpdateScript(const Script: String);
    procedure UpdateScriptConversationColor(const Script: String);
    procedure UpdateScriptScript(const Script: String);
    procedure mnURLClick(Sender: TObject);
    function ExtractURLs(Script: String; Urls: TStrings; Labels: TStrings): Boolean;
    function GetDefaultFileName(const Name: String; const Ext: String): String;
    function BottleLogTitled(const LogName: String): TBottleLogList;
    procedure DrawSingleLineScript(LogItem: TLogItem; Rect: TRect;
      State: TOwnerDrawState);
    procedure PreviewStyleChange;
    procedure DrawListViewDragBorder(const Rect: TRect);
    procedure DoSaveLogXML(Log: TBottleLogList);
    procedure DoCloseTab(const Index: integer);
    function DoSearchLog(Condition: TSearchCond): TBottleLogList;
    procedure SearchLogIndivisual(Condition: TSearchCond;
      LogList, Result: TBottleLogList; UntilIndex: integer = -1);
    procedure DrawListSection(const SectionIndex, Top: Integer;
      const Text: string; const LeftMargin: Integer = 0);
    procedure lvwLogWindowProc(var Msg: TMessage);
  protected
    procedure CreateParams(var Params: TCreateParams); override;
  public
    { Public 錾 }
    function SelectedBottleLog: TBottleLogList;
    property BottleLogList: TObjectList read FBottleLogList;
    procedure AddCurrentScriptLog(const LogName, Script, Channel, MID, Ghost: String);
    procedure AddCurrentSystemLog(const LogName, MessageString: String);
    procedure VoteLog(const MID: String; const Vote: integer);
    procedure AgreeLog(const MID: String; const Agree: integer);
    procedure SetBottleState(const MID: String; State: TLogState);
    procedure AllBottleOpened;
    procedure LogLoaded(Sender: TObject);
    procedure LogLoadFailure(Sender: TObject; const Message: String);
    procedure LogLoadWork(Sender: TObject);
    procedure HTMLOutputWork(Sender: TObject; const Count: integer;
      var Canceled: boolean);
    procedure UpdateTab;
    procedure UpdateWindow;
    procedure SelAndFocusMessage(const MID: String);
    procedure CheckBottleURL(Bottle: TLogItem);
  end;

  TBottleLogDragObject = class(TDragControlObjectEx)
  private
    FBottleLogList: TBottleLogList;
    FLogItem: TLogItem;
    procedure SetBottleLogList(const Value: TBottleLogList);
    procedure SetLogItem(const Value: TLogItem);
  protected
    function GetDragImages: TDragImageList; override;
  public
    property BottleLogList: TBottleLogList read FBottleLogList write SetBottleLogList;
    property LogItem: TLogItem read FLogItem write SetLogItem;
  end;

var
  frmLog: TfrmLog;

const
  IconBottle    = 17;
  IconOpened    = 30;
  IconPlaying   = 31;
  IconSystemLog = 26;
  IconURL       = 43;
  SubTime       = 0;
  SubChannel    = 1;
  SubGhost      = 2;
  SubVotes      = 3;
  SubAgrees     = 4;
  SubScript     = 5;

implementation

uses MainForm;

{$R *.DFM}

{ TfrmLog }

procedure TfrmLog.AddCurrentScriptLog(const LogName, Script, Channel, MID, Ghost: String);
var Sel: integer;
begin
  BottleLogTitled(LogName).AddScriptLog(Script, Channel, MID, Ghost);
  if SelectedBottleLog <> BottleLogTitled(LogName) then Exit;
  if lvwLog.Itemindex <> -1 then
    Sel := lvwLog.ItemIndex
  else
    Sel := -1;
  lvwLog.Count := SelectedBottleLog.Count;
  UpdateWindow;
  if Sel >= 0 then begin
    lvwLog.ItemIndex := Sel + 1;
  end;
  if not lvwLog.Focused then
    PostMessage(lvwLog.Handle,WM_VSCROLL,SB_TOP,0);
end;

procedure TfrmLog.AddCurrentSystemLog(const LogName, MessageString: String);
var Sel: integer;
begin
  BottleLogTitled(LogName).AddSystemLog(MessageString);
  if SelectedBottleLog <> BottleLogTitled(LogName) then Exit;
  if lvwLog.ItemIndex <> -1 then
    Sel := lvwLog.ItemIndex
  else
    Sel := -1;
  lvwLog.Count := SelectedBottleLog.Count;
  UpdateWindow;
  if Sel >= 0 then begin
    lvwLog.ItemIndex := Sel + 1;
    //lvwLog.SetFocus;
  end;
  if not lvwLog.Focused then
    PostMessage(lvwLog.Handle,WM_VSCROLL,SB_TOP,0);
end;



procedure TfrmLog.tbtnClearClick(Sender: TObject);
begin
  if SelectedBottleLog = nil then Exit;
  DoCloseTab(tabBottleLog.TabIndex);
end;

procedure TfrmLog.FormCreate(Sender: TObject);
var i: integer;
begin
  FLVWndMethod := lvwLog.WindowProc;
  lvwLog.WindowProc := lvwLogWindowProc;

  FLVDragDest := -1; // Xgr[̃hbOł͂Ȃ
  FBottleLogList := TObjectList.Create;

  SsParser.TagPattern.Assign(frmSender.SsParser.TagPattern);
  SsParser.MetaPattern.Assign(frmSender.SsParser.MetaPattern);

  with Pref.LogWindowPosition do begin
    Self.Left   := Left;
    Self.Top    := Top;
    Self.Width  := Right - Left + 1;
    Self.Height := Bottom - Top + 1;
  end;
  lvwLog.DoubleBuffered := true;
  pnlPreviewArea.Height := Pref.LogWindowDividerPos;

  i := 0;
  while Token(Pref.LogWindowColumnWidth, ',', i) <> '' do begin
    Header.Sections[i].Width := StrToIntDef(Token(Pref.LogWindowColumnWidth, ',', i), 100);
    Inc(i);
  end;

  SsParserForTalkShow.TagPattern.Assign(SsParser.TagPattern);
  SsParserForTalkShow.MetaPattern.Assign(SsParser.MetaPattern);
  SsParserForTalkShow.EscapeInvalidMeta := false;
  SsParserForTalkShow.LeaveEscape := false;
  TalkShowFrame.SsParser := self.SsParserForTalkShow;

  TalkShowFrame.SetPreviewFont(edtScript.Font);
  TalkShowFrame.PrevControl := lvwLog;

  lvwLog.DoubleBuffered := true;

  PreviewStyleChange;
  UpdateWindow; // Reset window color and enabled status of some buttons
end;

procedure TfrmLog.FormDestroy(Sender: TObject);
var i: integer;
    WidthStr: String;
begin
  WidthStr := '';
  for i := 0 to Header.Sections.Count-1 do begin
    if i > 0 then WidthStr := WidthStr + ',';
    WidthStr := WidthStr + IntToStr(Header.Sections[i].Width);
  end;
  Pref.LogWindowColumnWidth := WidthStr;

  with Pref.LogWindowPosition do begin
    Left   := Self.Left;
    Top    := Self.Top;
    Right  := Self.Left + Self.Width - 1;
    Bottom := Self.Top + Self.Height - 1;
  end;
  Pref.LogWindowDividerPos := pnlPreviewArea.Height;

  FreeAndNil(FBottleLogList);

  lvwLog.WindowProc := FLVWndMethod;
end;

procedure TfrmLog.lvwLogDblClick(Sender: TObject);
var Script, ErrorMes: String;
    Log, CueItem: TLogItem;
    Res: integer;
begin
  if lvwLog.ItemIndex = -1 then
    Exit;
  Log := SelectedBottleLog.Bottles[lvwLog.ItemIndex];
  if Log = nil then Exit;
  if Log.LogType <> ltBottle then
    Exit;
  Script := frmSender.ScriptTransForSSTP(Log.Script, ErrorMes);
  if ErrorMes <> '' then
  begin
    Res := MessageDlg('̂XNvgłBĐł܂B'#13#10+
        ErrorMes + #13#10 +
        'IɍĐ܂?'#13#10,
        mtWarning, mbOkCancel, 0
      );
    if Res = mrCancel then
      Exit;
  end;

  CueItem := TLogItem.Create(Log);
  try
    CueItem.Script := Script;
    frmSender.BottleSstp.Unshift(CueItem);
  except
    CueItem.Free;
  end;
end;

procedure TfrmLog.UpdateScriptConversationColor(const Script: String);
var i: integer;
    scr: String;
    UnyuTalking, Talked, InSynchronized: boolean;
begin
  scr := Script;
  frmSender.DoTrans(scr, [toConvertURL]);
  SsParser.LeaveEscape := false;
  SsParser.InputString := scr;
  UnyuTalking := false;
  Talked := false; //'\h\u\h\u'̂悤ȃXNvgŋ󂫍sȂ߂̑[u
  InSynchronized := false;
  edtScript.Text := '';
  edtScript.Color := Pref.BgColor;
  for i := 0 to SsParser.Count-1 do begin
    if (SsParser[i] = '\_s') and not InSynchronized then begin
      InSynchronized := true;
      if Talked then begin
        edtScript.SelText := #13#10;
        Talked := false;
      end;
    end else if (SsParser[i] = '\_s') and InSynchronized then begin
      InSynchronized := false;
      if Talked then begin
        edtScript.SelText := #13#10;
        Talked := false;
      end;
    end;
    if (SsParser[i] = '\u') and not UnyuTalking then begin
      UnyuTalking := true;
      if Talked then begin
        edtScript.SelText := #13#10;
        Talked := false;
      end;
    end;
    if (SsParser[i] = '\h') and UnyuTalking then begin
      UnyuTalking := false;
      if Talked then begin
        edtScript.SelText := #13#10;
        Talked := false;
      end;
    end;
    if SsParser.MarkUpType[i] = mtStr then begin
      if InSynchronized then
        edtScript.SelAttributes.Color := Pref.TalkColorS
      else if UnyuTalking then
        edtScript.SelAttributes.Color := Pref.TalkColorU
      else
        edtScript.SelAttributes.Color := Pref.TalkColorH;
      edtScript.SelText := SsParser[i];
      Talked := true;
    end;
    if SsParser.MarkUpType[i] = mtMeta then begin
      edtScript.SelAttributes.Color := Pref.MetaWordColor;
      edtScript.SelText := SsParser[i];
      Talked := true;
    end;
  end;
end;

procedure TfrmLog.CreateParams(var Params: TCreateParams);
begin
  inherited;
  Params.ExStyle := Params.ExStyle or WS_EX_APPWINDOW;
end;

procedure TfrmLog.lvwLogClick(Sender: TObject);
var Script, Text: String;
    Log: TLogItem;
    Selected, IsNormalBottle: boolean;
begin
  Selected := false;
  IsNormalBottle := false;
  if SelectedBottleLog <> nil then begin
    Script := '';
    if lvwLog.ItemIndex <> -1 then begin
      Selected := true;
      StatusBar.Panels[0].Text := Format('%d/%d', [lvwLog.ItemIndex+1,
        SelectedBottleLog.Count]);
      Log := SelectedBottleLog.Bottles[lvwLog.ItemIndex];
      if (Log.LogType = ltBottle) and not frmSender.Connecting then begin
        IsNormalBottle := true;
        Script := Log.Script;
        Text := Format('%doCg/%db - _uNbNōĐ',
          [Length(Log.Script), frmSender.SsPlayTime.PlayTime(Log.Script) div 1000]);
        StatusBar.Panels[1].Text := Text;
        if Pref.LogWindowPreviewStyle = psImageConversation then
          TalkShowFrame.View(Log)
        else
          UpdateScript(Script);
      end else begin
        StatusBar.Panels[1].Text := '';
        UpdateScript(''); // Ovr[NA
      end;
    end else begin
      StatusBar.Panels[0].Text := IntToStr(SelectedBottleLog.Count) + '';
      StatusBar.Panels[1].Text := '';
      UpdateScript(Script); // Ovr[NA
    end;
    tbtnSaveLog.Enabled := lvwLog.Items.Count > 0;
  end else begin
    StatusBar.Panels[0].Text := '';
    UpdateScript(''); // Ovr[NA
  end;
  frmSender.actVoteMessage.Enabled := Selected and IsNormalBottle;
  frmSender.actAgreeMessage.Enabled := Selected and IsNormalBottle;
  frmSender.actSendToEditor.Enabled := Selected and IsNormalBottle;
  frmSender.actInsertCue.Enabled := Selected;
  frmSender.actDeleteLogItem.Enabled := Selected;
  mnPopUpCopyScript.Enabled := Selected and IsNormalBottle;
  mnPopupCopyGhost.Enabled := Selected and IsNormalBottle;
end;

procedure TfrmLog.mnPopUpCopyScriptClick(Sender: TObject);
var
  Log: TLogItem;
  Clip: TClipBoard;
begin
  Log := SelectedBottleLog.Bottles[frmLog.lvwLog.ItemIndex];
  if Log = nil then Exit;
  Clip := ClipBoard();
  Clip.SetTextBuf(PChar(Log.Script));
end;

procedure TfrmLog.SetBottleState(const MID: String; State: TLogState);
var i: integer;
    Bottle: TLogItem;
begin
  for i := 0 to FBottleLogList.Count-1 do begin
    Bottle := (FBottleLogList[i] as TBottleLogList).Bottle(MID);
    if Bottle <> nil then begin
      Bottle.State := State;
      // lvwLog.OnChange := nil;
      lvwLog.Invalidate;
      // lvwLog.OnChange := lvwLogChange;
    end;
  end;
end;

procedure TfrmLog.mnSaveLogClick(Sender: TObject);
begin
  if SelectedBottleLog = nil then Exit;
  SaveDialog.FileName := GetDefaultFileName(SelectedBottleLog.Title, '.log');
  SaveDialog.InitialDir := ExtractFileDir(Application.ExeName);
  SaveDialog.DefaultExt := 'log';
  SaveDialog.FilterIndex := 1;
  if SaveDialog.Execute then
    SelectedBottleLog.SaveToSstpLog(SaveDialog.FileName, false);
end;

procedure TfrmLog.mnSaveLogChannelClick(Sender: TObject);
begin
  if SelectedBottleLog = nil then Exit;
  SaveDialog.FileName := GetDefaultFileName(SelectedBottleLog.Title, '.log');
  SaveDialog.InitialDir := ExtractFileDir(Application.ExeName);
  SaveDialog.DefaultExt := 'log';
  SaveDialog.FilterIndex := 1;
  if SaveDialog.Execute then
    SelectedBottleLog.SaveToSstpLog(SaveDialog.FileName, true);
end;

procedure TfrmLog.mnSaveLogScriptClick(Sender: TObject);
begin
  if SelectedBottleLog = nil then Exit;
  SaveDialog.FileName := GetDefaultFileName(SelectedBottleLog.Title, '.txt');
  SaveDialog.InitialDir := ExtractFileDir(Application.ExeName);
  SaveDialog.DefaultExt := 'txt';
  SaveDialog.FilterIndex := 2;
  if SaveDialog.Execute then
    SelectedBottleLog.SaveToText(SaveDialog.FileName);
end;

procedure TfrmLog.mnSaveLogXMLClick(Sender: TObject);
begin
  if SelectedBottleLog = nil then Exit;
  DoSaveLogXML(SelectedBottleLog);
end;

procedure TfrmLog.UpdateWindow;
var
  EnabledFlag: boolean;
  Index: Integer;
begin
  lvwLog.Color := Pref.BgColor;
  lvwLog.Font.Color := Pref.TextColor;
  if SelectedBottleLog <> nil then begin
    Caption := 'O - ' + SelectedBottleLog.Title;
    StatusBar.Panels[0].Text := IntToStr(SelectedBottleLog.Count) + '';
    Index := lvwLog.ItemIndex;
    lvwLog.Count := SelectedBottleLog.Count;
  end else begin
    Caption := 'O';
    StatusBar.Panels[0].Text := '';
    StatusBar.Panels[1].Text := '';
    lvwLog.Count := 0;
  end;

  EnabledFlag := SelectedBottleLog <> nil;
  tbtnClear.Enabled := EnabledFlag;
  tbtnSaveLog.Enabled := EnabledFlag;
  tbtnFindBottle.Enabled := EnabledFlag;

  lvwLog.Invalidate;
end;

procedure TfrmLog.PopupMenuListViewPopup(Sender: TObject);
var Log: TLogItem;
    Child: TMenuItem;
    Urls: TStringList;
    Labels: TStringList;
    ProcessedUrl: String;
    ProcessedLabel: String;
    i: Integer;
begin
  for i := mnJumpURL.Count-1 downto 0 do begin
    mnJumpURL.Items[i].Free;
  end;
  mnJumpURL.Enabled := false;
  if lvwLog.ItemIndex = -1 then
    Exit;
  Log := SelectedBottleLog.Bottles[lvwLog.ItemIndex];
  if Log = nil then
    Exit;
  Urls := TStringList.Create;
  Labels := TStringList.Create;
  try
    ExtractURLs(Log.Script, Urls, Labels);
    for i := 0 to Urls.Count-1 do begin
      Child := TMenuItem.Create(Self);
      with Child do begin
        ProcessedUrl := StringReplace(Urls[i], '&', '&&', [rfReplaceAll]);
        ProcessedLabel := StringReplace(Labels[i], '&', '&&', [rfReplaceAll]);
        if Length(ProcessedLabel) > 0 then begin
          Caption := Format('[%s] %s (&%d)', [ProcessedLabel, ProcessedUrl, i+1]);
        end else begin
          Caption := Format('%s (&%d)', [ProcessedUrl, i+1]);
        end;
        Tag := i;
        OnClick := mnURLClick;
        AutoHotkeys := maManual;
        mnJumpURL.Add(Child);
      end;
    end;
    mnJumpURL.Enabled := Urls.Count > 0;
  finally
    Urls.Free;
    Labels.Free;
  end;
end;

procedure TfrmLog.mnURLClick(Sender: TObject);
var LogItem: TLogItem;
    URL: string;
    Urls: TStringList;

begin
  if (lvwLog.ItemIndex < 0) or (SelectedBottleLog = nil) then Exit;
  LogItem := SelectedBottleLog[lvwLog.ItemIndex] as TLogItem;
  Urls := TStringList.Create;
  try
    ExtractURLs(LogItem.Script, Urls, nil);
    URL := Urls[(Sender as TMenuItem).Tag];
    OpenBrowser(URL);
  finally
    Urls.Free;
  end;
end;

function TfrmLog.ExtractURLs(Script: String; Urls: TStrings; Labels: TStrings): Boolean;
var i, u, j, count: integer;
    s: String;
begin
  count := 0;
  SsParser.InputString := Script;
  SsParser.LeaveEscape := true;
  for i := 0 to SsParser.Count-1 do begin
    if (SsParser.Match(SsParser[i], '\URL%b') > 0)
    and (SsParser.MarkUpType[i] = mtTag) then
    begin
      for u := 7 downto 1 do begin
        if (SsParser.Match(SsParser[i],
            '\URL%b'+StringReplace(StringOfChar('-', u*2),
            '-', '%b', [rfReplaceAll]))) > 0 then begin
          for j := 1 to u do begin
            s := SsParser.GetParam(SsParser[i], j*2);
            //httpsȂǂǉ鎞΍cc://΂Ԃv
            if Pos('://', s) > 0 then begin
              if Urls <> nil then Urls.Add(s);
              count := count + 1;
            end;
            if Labels <> nil then begin
              s := SsParser.GetParam(SsParser[i], j*2+1);
              Labels.Add(s);
            end;
          end;
          Break;
        end;
      end;
      if SsParser.Match(SsParser[i], '\URL%b%b') = 0 then begin
        //ȈՌ`\URL^Oϊ
        s := SsParser.GetParam(SsParser[i], 1);
        //httpsȂǂǉ鎞΍cc://΂Ԃv
        if Pos('://', s) > 0 then begin
          if Urls <> nil then Urls.Add(s);
          count := count + 1;
        end
      end;
    end;
  end;

  //x̐URL̐ɂ킹 - 肵ȂĂ悤
  if Urls <> nil then begin
    if Labels <> nil then begin
      while Urls.Count > Labels.Count do Labels.Add('');
    end;
  end;
  Result := count > 0;
end;

procedure TfrmLog.SelAndFocusMessage(const MID: String);
var i: integer;
    Log: TLogItem;
begin
  for i := 0 to SelectedBottleLog.Count-1 do begin
    Log := SelectedBottleLog.Items[i] as TLogItem;
    if Log.MID = MID then begin
      lvwLog.ItemIndex := i;
      lvwLog.SetFocus;
    end;
  end;
end;

procedure TfrmLog.UpdateScript(const Script: String);
begin
  if Script <> FLastScript then begin
    if Pref.LogWindowPreviewStyle = psConversation then begin
      UpdateScriptConversationColor(Script);
    end else begin
      UpdateScriptScript(Script);
    end;
    SendMessage(edtScript.Handle, EM_LINESCROLL, Low(integer), Low(integer)); //XN[߂
    FLastScript := Script;
  end;
end;

procedure TfrmLog.PopupMenuPreviewStylePopup(Sender: TObject);
var i: integer;
begin
  with PopupMenuPreviewStyle do
    for i := 0 to Items.Count-1 do
      Items[i].Checked := Items[i].Tag = Ord(Pref.LogWindowPreviewStyle)
end;

procedure TfrmLog.mnPreviewStyleClick(Sender: TObject);
var i: integer;
begin
  with PopupMenuPreviewStyle do
    for i := 0 to Items.Count-1 do
      Items[i].Checked := (Sender as TMenuItem).Tag = Items[i].Tag;
  Pref.LogWindowPreviewStyle := TLogWindowPreviewStyle((Sender as TMenuItem).Tag);
  PreviewStyleChange;
  FLastScript := '';
  lvwLogClick(self);
end;

procedure TfrmLog.UpdateScriptScript(const Script: String);
var
  UnyuTalking, InSynchronized: boolean;
  i: integer;
begin
  edtScript.Color := Pref.BgColor;
  SsParser.LeaveEscape := true;
  SsParser.InputString := Script;
  edtScript.Text := '';
  edtScript.SelAttributes.Color := clWindowText;
  UnyuTalking := false;
  InSynchronized := false;
  for i := 0 to SsParser.Count-1 do begin
    case SsParser.MarkUpType[i] of
      mtStr: begin
        if InSynchronized then
          edtScript.SelAttributes.Color := Pref.TalkColorS
        else if UnyuTalking then
          edtScript.SelAttributes.Color := Pref.TalkColorU
        else
          edtScript.SelAttributes.Color := Pref.TalkColorH;
      end;
      mtTag: begin
        edtScript.SelAttributes.Color := Pref.MarkUpColor;
        if SsParser[i] = '\h' then
          UnyuTalking := false
        else if SsParser[i] = '\u' then
          UnyuTalking := true
        else if SsParser[i] = '\_s' then
          InSynchronized := not InSynchronized;
      end;
      mtMeta:   edtScript.SelAttributes.Color := Pref.MetaWordColor;
      mtTagErr: edtScript.SelAttributes.Color := Pref.MarkErrorColor;
    end;
    edtScript.SelText := SsParser[i];
    if (SsParser[i] = '\n') and (Pref.LogWindowPreviewStyle = psScriptWithLineBreak) then
      edtScript.SelText := #13#10;
  end;
end;

procedure TfrmLog.tbtnPreviewStyleClick(Sender: TObject);
var sel: integer;
begin
  sel := Ord(Pref.LogWindowPreviewStyle);
  sel := sel + 1;
  if sel > Ord(High(TLogWindowPreviewStyle)) then sel := 0;
  Pref.LogWindowPreviewStyle := TLogWindowPreviewStyle(sel);
  FLastScript := '';
  PreviewStyleChange;
  lvwLogClick(self);
end;

function TfrmLog.SelectedBottleLog: TBottleLogList;
begin
  if tabBottleLog.TabIndex >= 0 then
    Result := FBottleLogList.Items[tabBottleLog.TabIndex] as TBottleLogList
  else
    Result := nil;
end;

procedure TfrmLog.tabBottleLogChange(Sender: TObject);
begin
  // StatusBař\ListView.Items.CountXV
  UpdateWindow;
  // ACȇIԂ𕜋A
  with SelectedBottleLog do
    if (SelectedIndex >= 0) and (Count > SelectedIndex) then
    begin
      lvwLog.ItemIndex := SelectedIndex;
    end;
end;

procedure TfrmLog.LogLoaded(Sender: TObject);
begin
  if SelectedBottleLog = Sender then begin
    UpdateWindow;
  end;
end;

procedure TfrmLog.UpdateTab;
var i, cur: integer;
begin
  cur := tabBottleLog.tabIndex;
  tabBottleLog.Tabs.Clear;
  for i := 0 to FBottleLogList.Count - 1 do begin
    tabBottleLog.Tabs.Add((FBottleLogList[i] as TBottleLogList).Title);
  end;
  if FBottleLogList.Count > 0 then begin
    if cur < FBottleLogList.Count then
      tabBottleLog.TabIndex := cur
    else
      tabBottleLog.TabIndex := FBottleLogList.Count-1;
  end;
end;

procedure TfrmLog.LogLoadFailure(Sender: TObject; const Message: String);
begin
  Beep;
  ShowMessage(Message);
  if Sender = SelectedBottleLog then UpdateWindow;
end;

procedure TfrmLog.AgreeLog(const MID: String; const Agree: integer);
var i: integer;
    flag: boolean;
begin
  flag := false;
  for i := 0 to FBottleLogList.Count - 1 do begin
    if (FBottleLogList[i] as TBottleLogList).Bottle(MID) <> nil then begin
      (FBottleLogList[i] as TBottleLogList).Bottle(MID).Agrees := Agree;
      flag := true;
    end;
  end;
  if flag then lvwLog.Invalidate;
end;

procedure TfrmLog.VoteLog(const MID: String; const Vote: integer);
var i: integer;
    flag: boolean;
begin
  flag := false;
  for i := 0 to FBottleLogList.Count - 1 do begin
    if (FBottleLogList[i] as TBottleLogList).Bottle(MID) <> nil then begin
      (FBottleLogList[i] as TBottleLogList).Bottle(MID).Votes := Vote;
      flag := true;
    end;
  end;
  if flag then lvwLog.Invalidate;
end;

procedure TfrmLog.tabBottleLogChanging(Sender: TObject;
  var AllowChange: Boolean);
begin
  // ݑIĂ郍ȎIԂۑ
  if SelectedBottleLog = nil then
    Exit;
  SelectedBottleLog.SelectedIndex := lvwLog.ItemIndex
end;

procedure TfrmLog.tabBottleLogContextPopup(Sender: TObject;
  MousePos: TPoint; var Handled: Boolean);
begin
  with tabBottleLog do begin
    Tag := IndexOfTabAt(MousePos.X, MousePos.Y);
    if Tag < 0 then Handled := true;
  end;
end;

procedure TfrmLog.mnCloseTabClick(Sender: TObject);
begin
  DoCloseTab(tabBottleLog.Tag);
end;

procedure TfrmLog.tbtnFindBottleClick(Sender: TObject);
var ResultLog: TBottleLogList;
    Cond: TSearchCond;
    i: integer;
    CList, GList: THashedStringList;
begin
  Application.CreateForm(TfrmSearchLog, frmSearchLog);
  Cond := TSearchCond.Create(nil);
  try
    try
      with frmSearchLog do
      begin
        // ݃OɂS[Xgƃ`l̃Xg擾
        // d??
        CList := THashedStringList.Create;
        GList := THashedStringList.Create;
        try
          for i := 0 to BottleLogList.Count-1 do
          begin
            with BottleLogList[i] as TBottleLogList do
            begin
              ExtractUniqueChannels(CList);
              ExtractUniqueGhosts(GList);
            end;
          end;
          CList.Sort;
          GList.Sort;
          ChannelList := CList;
          GhostList   := GList;
        finally
          CList.Free;
          GList.Free;
        end;
        if not Execute then
          Exit
        else
          Cond.Assign(Condition);
      end;
    finally
      frmSearchLog.Release;
    end;
    // s
    ResultLog := DoSearchLog(Cond);
    // V^u쐬ĉʍXV
    BottleLogList.Add(ResultLog);
    UpdateTab;
    tabBottleLog.TabIndex := BottleLogList.Count-1;
    UpdateWindow;
  finally
    Cond.Free;
  end;
end;

procedure TfrmLog.tbtnOpenLogClick(Sender: TObject);
var BottleLog: TBottleLogList;
    i, Index: integer;
begin
  Index := -1;
  if OpenDialog.Execute then begin
    for i := 0 to OpenDialog.Files.Count-1 do begin
      BottleLog := TBottleLogList.Create(ExtractFileName(OpenDialog.Files[i]));
      try
        with BottleLog do
        begin
          OnLoaded := LogLoaded;
          OnLoadFailure := LogLoadFailure;
          OnLoadWork := LogLoadWork;
          BottleLog.LoadFromXMLFile(OpenDialog.Files[i]);
        end;
        Index := BottleLogList.Add(BottleLog); // ŌɊJÖʒuL
      except
        BottleLog.Free;
      end;
    end;
    UpdateTab;
    if Index >= 0 then tabBottleLog.TabIndex := Index;
    UpdateWindow;
  end;
end;

function TfrmLog.GetDefaultFileName(const Name, Ext: String): String;
begin
  Result := StringReplace(Name, '/', '', [rfReplaceAll]);
  Result := StringReplace(Result, ' ', '', [rfReplaceAll]);
  Result := SafeFileName(Result);
  Result := ChangeFileExt(Result, Ext);
end;

function TfrmLog.BottleLogTitled(const LogName: String): TBottleLogList;
var i: integer;
begin
  for i := 0 to FBottleLogList.Count-1 do begin
    if (FBottleLogList[i] as TBottleLogList).Title = LogName then begin
      Result := (FBottleLogList[i] as TBottleLogList);
      Exit;
    end;
  end;
  // Ȃꍇ
  Result := TBottleLogList.Create(LogName); // V
  FBottleLogList.Add(Result);
  UpdateTab;
  if FBottleLogList.Count = 1 then tabBottleLog.TabIndex := 0;
end;

procedure TfrmLog.AllBottleOpened;
var i, j: integer;
    Log: TBottleLogList;
begin
  for i := 0 to FBottleLogList.Count-1 do begin
    Log  := FBottleLogList[i] as TBottleLogList;
    for j := 0 to Log.Count-1 do begin
      Log.Bottles[j].State := lsOpened;
    end;
  end;
end;

procedure TfrmLog.tabBottleLogMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var Index: integer;
begin
  if Button = mbMiddle then
  begin
    //{^NbNŃ^u폜
    DoCloseTab(tabBottleLog.IndexOfTabAt(X, Y));
  end else
  begin
    with tabBottleLog do begin
      Index := IndexOfTabAt(X, Y);
      if Index = -1 then Exit; //^uȂ̂ŃhbOłȂ
      if Button = mbLeft then begin
        FDragTabIndex := Index; //hbO^ũCfbNXۑ
        BeginDrag(False);
        FDragTabDest := -1;     //hbOg`tONÂ
      end;
    end;
  end;
end;

procedure TfrmLog.tabBottleLogDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
var TargetRect: TRect;
    OldDest, Index: integer;
    dummy: boolean;
begin
  // ^ũhbO(^ȕԓւ)܂́A
  // OACẽhbO(Oʂ̃^uɈړ)
  // ̃hbO󂯕t
  Accept := false;
  if Source = tabBottleLog then
  begin
    // ^ȕԓւ̏ꍇ
    Accept := true;
    with tabBottleLog do begin
      OldDest := FDragTabDest;
      FDragTabDest := IndexOfTabAt(X, Y);
      if FDragTabDest = -1 then begin
        Accept := false; //̏ꍇ̓hbvF߂Ȃ
        Exit;
      end;
      with Canvas do begin
        Pen.Mode := pmNot;
        Pen.Width := 3;
      end;
      if (OldDest <> FDragTabDest) and (OldDest >= 0) then begin
        //ȑO̘g
        TargetRect := TabRect(OldDest);
        with Canvas do begin
          Brush.Style := bsClear;
          Rectangle(TargetRect.Left, TargetRect.Top,
                    TargetRect.Right, TargetRect.Bottom);
        end;
      end;
      if (OldDest <> FDragTabDest) then begin
        //Vg`
        TargetRect := TabRect(FDragTabDest);
        with Canvas do begin
          Brush.Style := bsClear;
          Rectangle(TargetRect.Left, TargetRect.Top,
                    TargetRect.Right, TargetRect.Bottom);
        end;
      end;
    end;
  end else if Source is TBottleLogDragObject then
  begin
    // Oڂ̃hbO(Oʂ̃^uɈړ)̏ꍇ
    Index := tabBottleLog.IndexOfTabAt(X, Y);
    if tabBottleLog.TabIndex <> Index then
    begin
      FLVDragDest := -1; // g͂܂\Ȃ͂
      // ^uؑւ
      tabBottleLogChanging(Self, dummy);
      tabBottleLog.TabIndex := Index;
      UpdateWindow;
    end;
  end;
end;

procedure TfrmLog.tabBottleLogDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var DestIndex: integer;
begin
  with tabBottleLog do begin
    DestIndex := IndexOfTabAt(X, Y);
    Tabs.Move(FDragTabIndex, DestIndex);
    FBottleLogList.Move(FDragTabIndex, DestIndex);
  end;
end;

procedure TfrmLog.tabBottleLogEndDrag(Sender, Target: TObject; X,
  Y: Integer);
begin
  //IɃ^uĕ`悳Bg΍
  tabBottleLog.Tabs.BeginUpdate;
  tabBottleLog.Tabs.EndUpdate;
end;

procedure TfrmLog.LogLoadWork(Sender: TObject);
begin
  if Sender = SelectedBottleLog then
  begin
    lvwLog.Invalidate;
    lvwLog.Count := SelectedBottleLog.Count;
  end;
end;

procedure TfrmLog.DrawSingleLineScript(LogItem: TLogItem;
  Rect: TRect; State: TOwnerDrawState);
var
  i, x, w: integer;
  UnyuTalking, Synchronized, Spaced: boolean;
  Mark: TSsMarkUpType;
  Script: String;
  Ico: TIcon;
  procedure ScopeChange;
  begin
    if (not Spaced) and (Pref.LogListPreviewStyle = psTagStripped) then
    begin
      Inc(x, 7);
      Spaced := true;
    end;
  end;
begin
  Script := LogItem.Script;
  x := 3;

  if LogItem.HasURL = huYes then
  begin
    Ico := TIcon.Create;
    try
      frmSender.imgIcon.GetIcon(IconURL, Ico);
      lvwLog.Canvas.Draw(Rect.Left + x, Rect.Top, Ico);
      Inc(x, 20);
    finally
      Ico.Free;
    end;
  end;

  if Pref.LogListPreviewStyle = psNoColor then
  begin
    Inc(Rect.Left, x);
    Inc(Rect.Top, 2);
    Dec(Rect.Right, 2);
    DrawTextEx(lvwLog.Canvas.Handle, PChar(Script), -1, Rect,
      DT_SINGLELINE or DT_END_ELLIPSIS or DT_NOPREFIX, nil);
    Exit;
  end;

  SsParser.LeaveEscape := Pref.LogListPreviewStyle = psNormal;
  SsParser.InputString := Script;

  UnyuTalking := false;
  Synchronized := false;
  Spaced := true; // ^Oȗ\ɕsKvɃXR[vϊ̃Xy[X󂯂Ȃ
                  // ߂̃tO
  for i := 0 to SsParser.Count - 1 do begin
    if SsParser[i] = '\h' then
    begin
      UnyuTalking := false;
      ScopeChange;
    end else if SsParser[i] = '\u' then
    begin
      UnyuTalking := true;
      ScopeChange;
    end else if SsParser[i] = '\_s' then
    begin
      Synchronized := not Synchronized;
      ScopeChange;
    end else if (Pos('\n', SsParser[i]) = 1) or (SsParser[i] = '\c') then
    begin
      ScopeChange;
    end;
    Mark := SsParser.MarkUpType[i];
    case Mark of
      mtMeta:
        begin
          lvwLog.Canvas.Font.Color := Pref.MetaWordColor;
          Spaced := false;
        end;
      mtTag:
        if Pref.LogListPreviewStyle = psNormal then
          lvwLog.Canvas.Font.Color := Pref.MarkUpColor
        else
        begin
          Continue;
        end;
      mtTagErr:
        lvwLog.Canvas.Font.Color := Pref.MarkErrorColor;
      else begin
        Spaced := false;
        if Synchronized then
          lvwLog.Canvas.Font.Color := Pref.TalkColorS
        else if UnyuTalking then
          lvwLog.Canvas.Font.Color := Pref.TalkColorU
        else
          lvwLog.Canvas.Font.Color := Pref.TalkColorH;
      end;
    end;
    if odSelected in State then
    begin
      if odFocused in State then
        lvwLog.Canvas.Font.Color := clHighlightText
      else
        lvwLog.Canvas.Font.Color := clWindowText;
    end;
    w := lvwLog.Canvas.TextWidth(SsParser[i]);
    lvwLog.Canvas.TextRect(Rect, Rect.Left + x, Rect.Top + 2, SsParser[i]);
    x := x + w;
    if Rect.Right - Rect.Left < x then
      Break;
  end;
end;

procedure TfrmLog.mnListPreviewStyleClick(Sender: TObject);
var i: integer;
begin
  with PopupMenuListPreviewStyle do
    for i := 0 to Items.Count-1 do
      Items[i].Checked := (Sender as TMenuItem).Tag = Items[i].Tag;
  Pref.LogListPreviewStyle := TLogListPreviewStyle((Sender as TMenuItem).Tag);
  lvwLog.Invalidate;
end;

procedure TfrmLog.tbtnListPreviewStyleClick(Sender: TObject);
var sel: integer;
begin
  sel := Ord(Pref.LogListPreviewStyle);
  sel := sel + 1;
  if sel > Ord(High(TLogListPreviewStyle)) then sel := 0;
  Pref.LogListPreviewStyle := TLogListPreviewStyle(sel);
  lvwLog.Invalidate;
end;

procedure TfrmLog.PopupMenuListPreviewStylePopup(Sender: TObject);
var i: integer;
begin
  with PopupMenuListPreviewStyle do
    for i := 0 to Items.Count-1 do
      Items[i].Checked := Items[i].Tag = Ord(Pref.LogListPreviewStyle)
end;

procedure TfrmLog.PreviewStyleChange;
begin
  if Pref.LogWindowPreviewStyle = psImageConversation then
  begin
    if Spps.Count = 0 then
      ShowMessage('T[tBXvr[pvOC݂܂B');
    edtScript.Visible := false;
    TalkShowFrame.Visible := true;
  end else
  begin
    edtScript.Visible := true;
    TalkShowFrame.Visible := false;
  end;
end;

procedure TfrmLog.lvwLogDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
var
  OldDest, Target: Integer;
  Rec: TRect; // _~[B
begin
  Accept := False;
  
  if not Pref.LogItemDragDrop then
    Exit;
  // Ƃ肠󂯕t\̂TBottleLogDragObject
  if not (Source is TBottleLogDragObject) then
    Exit;
  // ڂꍇ̂
  if (Source as TBottleLogDragObject).LogItem = nil then
    Exit; 

  Target := lvwLog.ItemAtPos(Point(X, Y), true);

  // ȑOɕ`悳Ăg̃CfbNX
  OldDest := FLVDragDest;

  // hbvʒu Item ΃hbv
  if Target <> -1 then
  begin
    Accept := true;
    FLVDragDest := Target;
  end else
  begin
    Accept := true;
    FLVDragDest := -1;
  end;

  // ȑO̘g폜
  if (OldDest > -1) and (FLVDragDest <> OldDest) then
  begin
    Rec := lvwLog.ItemRect(OldDest);
    DrawListViewDragBorder(Rec);
  end;
  // hbO̘g`
  if (Target <> -1) and (FLVDragDest <> OldDest) then
  begin
    Rec := lvwLog.ItemRect(Target);
    DrawListViewDragBorder(Rec);
  end;

  // XN[֌W
  if lvwLog.Count > 0 then
  begin
    if Y < 10 then
    begin
      FLVScrollDir := lvScrollDown;
      if not timScrollTimer.Enabled then
        timScrollTimer.Enabled := true;
    end else if (lvwLog.Height - Y) < 10 then
    begin
      FLVScrollDir := lvScrollUp;
      if not timScrollTimer.Enabled then
        timScrollTimer.Enabled := true;
    end
    else
      timScrollTimer.Enabled := false;
  end else
    timScrollTimer.Enabled := false;
end;

procedure TfrmLog.lvwLogDragDrop(Sender, Source: TObject; X, Y: Integer);
var
  TargetItem: integer;
  Src: TBottleLogDragObject;
  SrcLog: TObject;
begin
  timScrollTimer.Enabled := false;

  if not Pref.LogItemDragDrop then
    Exit;
  if not (Source is TBottleLogDragObject) then
    Exit;
  Src := Source as TBottleLogDragObject;
  if Src.LogItem = nil then
    Exit;

  TargetItem := lvwLog.ItemAtPos(Point(X, Y), true);

  // hbvʒu Item ړ
  if (GetAsyncKeyState(VK_CONTROL) and $8000) > 0 then
  begin // Rs[ړ̏ꍇ
    SrcLog := TLogItem.Create(Src.LogItem);
  end else // ړꍇ
  begin
    SrcLog := Src.BottleLogList.Extract(Src.LogItem);
  end;
  if TargetItem >= 0 then
  begin
    // łɑ݂ACȅɃhbvꍇ
    SelectedBottleLog.Insert(TargetItem, SrcLog);
  end else
  begin
    // ListView̗]Ƀhbvꍇ(InsertłȂ)
    TargetItem := SelectedBottleLog.Add(SrcLog);
  end;
  UpdateWindow;
  lvwLog.ItemIndex := TargetItem;
end;

procedure TfrmLog.timScrollTimerTimer(Sender: TObject);
var
  ScrollHeight: Integer;
begin
  // XN[ʂ߂
  ScrollHeight := lvwLog.ItemHeight;

  {TODO: XN[}
  case FLVScrollDir of
    lvScrollUp:
      PostMessage(lvwLog.Handle, WM_VSCROLL, SB_LINEDOWN, 0);
    lvSCrollDown:
      PostMessage(lvwLog.Handle, WM_VSCROLL, SB_LINEUP, 0);
  end;
  lvwLog.Invalidate;  // ŐV̏Ԃɍĕ`悷
  lvwLog.Update;
end;

procedure TfrmLog.mnChangeTabNameClick(Sender: TObject);
var Name: String;
begin
  Name := (FBottleLogList[tabBottleLog.Tag] as TBottleLogList).Title;
  InputQuery('O̕ύX', 'V^u̖O', Name);
  (FBottleLogList[tabBottleLog.Tag] as TBottleLogList).Title := Name;
  UpdateTab;
end;

procedure TfrmLog.lvwLogStartDrag(Sender: TObject;
  var DragObject: TDragObject);
var Drag: TBottleLogDragObject;
begin
  // TDragObject璼ڌp̂(C[WĂȂ)g
  // hbOC[W̕`͗}łB
  Drag := TBottleLogDragObject.Create(lvwLog);
  Drag.BottleLogList := SelectedBottleLog;
  if lvwLog.ItemIndex <> -1 then
    Drag.LogItem := SelectedBottleLog.Bottles[lvwLog.ItemIndex]
  else
    Drag.LogItem := nil;
  DragObject := Drag;
end;

procedure TfrmLog.lvwLogEndDrag(Sender, Target: TObject; X, Y: Integer);
begin
  // gpɋIɍĕ`悳
  timScrollTimer.Enabled := false;
  FLVDragDest := -1;
  lvwLog.Invalidate;
end;

procedure TfrmLog.DrawListViewDragBorder(const Rect: TRect);
var Rec: TRect;
begin
  Rec := Rect;
  InflateRect(Rec, -1, -1);
  with lvwLog.Canvas do
  begin
    Pen.Mode := pmNot;
    Pen.Width := 3;
    Brush.Style := bsClear;
    Refresh; // Kv
    Rectangle(Rec);
  end;
end;

procedure TfrmLog.DoSaveLogXML(Log: TBottleLogList);
begin
  SaveDialog.FileName := GetDefaultFileName(Log.Title, '.xml');
  SaveDialog.InitialDir := ExtractFileDir(Application.ExeName);
  SaveDialog.DefaultExt := 'xml';
  SaveDialog.FilterIndex := 3;
  if SaveDialog.Execute then
    Log.SaveToXmlFile(SaveDialog.FileName);
end;

procedure TfrmLog.DoCloseTab(const Index: integer);
var
  Confirm: String;
  PrevSelection: TBottleLogList; // Ƃ^uȂ悤ɂ鏈p
  i: integer;
begin
  if Pref.ConfirmOnTabClose then
  begin
    Confirm := Format('^u"%s"܂?', [(FBottleLogList[Index] as TBottleLogList).Title]);
    if MessageDlg(Confirm, mtConfirmation, mbOkCancel, 0) = mrCancel then
      Exit;
  end;
  PrevSelection := SelectedBottleLog;
  FBottleLogList.Delete(Index);
  UpdateTab;
  // ^uh~
  for i := 0 to FBottleLogList.Count-1 do
    if FBottleLogList[i] = PrevSelection then
      tabBottleLog.TabIndex := i;
  UpdateWindow;
end;

procedure TfrmLog.HTMLOutputWork(Sender: TObject; const Count: integer;
  var Canceled: boolean);
begin
  frmHTMLOutputProgress.ProgressBar.Position := Count;
  Application.ProcessMessages;
  if frmHTMLOutputProgress.Canceled then
    Canceled := true;
end;

function TfrmLog.DoSearchLog(Condition: TSearchCond): TBottleLogList;
var i, UntilIndex: integer;
begin
  Result := TBottleLogList.Create('');
  if Condition.SearchLogRange in [srSelectedLogList, srAboveSelectedLog] then
  begin
    if SelectedBottleLog = nil then
    begin
      ShowMessage('Ώۂ܂');
      Result.Free;
      Result := nil;
      Exit;
    end else
    begin
      if Condition.SearchLogRange = srSelectedLogList then
        UntilIndex := -1
      else
        UntilIndex := lvwLog.ItemIndex;
      SearchLogIndivisual(Condition, SelectedBottleLog, Result, UntilIndex);
    end;
  end else if Condition.SearchLogRange = srAllLogLists then
  begin
    for i := 0 to BottleLogList.Count-1 do
    begin
      SearchLogIndivisual(Condition, BottleLogList[i] as TBottleLogList,
        Result);
    end;
  end;

  if Result.Count = 0 then
    Result.AddSystemLog('܂łB');
end;

procedure TfrmLog.SearchLogIndivisual(Condition: TSearchCond; LogList,
  Result: TBottleLogList; UntilIndex: integer = -1);
var
  i, Max: integer;
  Bottle, New: TLogItem;
  Ok: boolean;
begin
  // 1̃O^uɑ΂ČBUntilIndexŔ͈͎w(ȗ̃^uS)
  if UntilIndex >= 0 then
    Max := UntilIndex
  else
    Max := LogList.Count-1;
  for i := 0 to Max do
  begin
    // 
    Bottle := LogList.Bottles[i];
    if Bottle.LogType <> ltBottle then
      Continue;
    Ok := true;
    // XNvgp^[ŉ
    if Condition.ScriptPattern <> '' then
    begin
      if Condition.ScriptRegExp then
      begin
        try
          if not RegExp.Match(Condition.ScriptPattern, Bottle.Script) then
            Ok := false;
        except
          on EBRegExpError do
            Ok := false; //ȐK\R
        end;
      end else
      begin
        if not AnsiContainsText(Bottle.Script, Condition.ScriptPattern) then
          Ok := false;
      end;
    end;
    // `lAS[XgA[
    if Condition.Channel <> '' then
      if not AnsiContainsText(Bottle.Channel, Condition.Channel) then
        Ok := false;
    if Condition.Ghost <> '' then
      if not AnsiContainsText(Bottle.Ghost, Condition.Ghost) then
        Ok := false;
    if Condition.MinVote > Bottle.Votes then
      Ok := false;
    if Condition.MinAgree > Bottle.Agrees then
      Ok := false;
    // Ɉv̂ʃXgɒǉ
    if Ok then
    begin
      New := TLogItem.Create(Bottle); // Rs[RXgN^
      New.State := lsOpened;
      Result.Add(New);
    end;
  end;
end;

procedure TfrmLog.CheckBottleURL(Bottle: TLogItem);
begin
  if Bottle.HasURL = huUndefined then
  begin
    try
      //nil,nilnĂTRUE/FALSEURL邩ǂƕԂ
      if ExtractURLs(Bottle.Script, nil, nil) then
        Bottle.HasURL := huYes
      else
        Bottle.HasURL := huNo;
    finally
    end;
  end;
end;

procedure TfrmLog.DrawListSection(const SectionIndex, Top: Integer;
  const Text: string; const LeftMargin: Integer = 0);
var
  Sec: THeaderSection;
  Ex: Integer;
  Rec: TRect;
const
  MinimumTextWidth = 16; //苷Ȃ炻`悵Ȃ
begin
  Sec := Header.Sections[SectionIndex];

  Rec.Left   := Sec.Left + 2 + LeftMargin;
  Rec.Right  := Sec.Right - 2;
  if Rec.Right - Rec.Left < MinimumTextWidth then
    Exit;
  Rec.Top    := Top + 2;
  Rec.Bottom := Top + lvwLog.ItemHeight;

  Ex := DT_NOPREFIX or DT_SINGLELINE or DT_END_ELLIPSIS;
  if Sec.Alignment = taRightJustify then
    Ex := (Ex or DT_RIGHT) and not (DT_END_ELLIPSIS);
  DrawTextEx(lvwLog.Canvas.Handle, PChar(Text), -1, Rec, Ex, nil);
end;

{ TBottleLogDragObject }

function TBottleLogDragObject.GetDragImages: TDragImageList;
begin
  // r[ȃhbOC[W\Ȃ悤ɂ
  Result := nil;
end;

procedure TBottleLogDragObject.SetBottleLogList(
  const Value: TBottleLogList);
begin
  FBottleLogList := Value;
end;

procedure TBottleLogDragObject.SetLogItem(const Value: TLogItem);
begin
  FLogItem := Value;
end;

procedure TfrmLog.mnTabSaveXMLLogClick(Sender: TObject);
begin
  DoSaveLogXML(FBottleLogList[tabBottleLog.Tag] as TBottleLogList);
end;

procedure TfrmLog.mnSaveHTMLClick(Sender: TObject);
var
  LogList, SB: TBottleLogList;
  i: integer;
  Options: THTMLOutputOptions;
begin
  SB := SelectedBottleLog;
  if SB = nil then
    Exit;
  if SB.Count = 0 then
    Exit;
  Application.CreateForm(TfrmHTMLOutputConfig, frmHTMLOutputConfig);
  with frmHTMLOutputConfig do
    try
      // Show HTML save option dialog
      if not Execute then
        Exit;
      LogList := TBottleLogList.Create('');
      try
        case Range of
          orAll:
            for i := SB.Count-1 downto 0 do
              if SB.Bottles[i].LogType = ltBottle then
                LogList.Add(TLogItem.Create(SB.Bottles[i]));
          orSelected:
            if SB.Bottles[lvwLog.ItemIndex].LogType = ltBottle then
              LogList.Add(TLogItem.Create(SB.Bottles[lvwLog.ItemIndex]))
            else
              ShowMessage('̃bZ[W͕ۑł܂');
          orUpward:
            for i := lvwLog.ItemIndex downto 0 do
              if SB.Bottles[i].LogType = ltBottle then
                LogList.Add(TLogItem.Create(SB.Bottles[i]));
        end;
        Options.ImageDir := ImageDir;
        Options.UseColor := UseColor;
        Options.ImageType := ImageType;
        Application.CreateForm(TfrmHTMLOutputProgress, frmHTMLOutputProgress);
        try
          frmHTMLOutputProgress.Show;
          LogList.OnHTMLOutputWork := HTMLOutputWork;
          LogList.SaveToHTML(FileName, Options, SsParser);
        finally
          frmHTMLOutputProgress.Release;
        end;
      finally
        LogList.Free;
      end;
    finally
      Release;
    end;
end;

procedure TfrmLog.mnPopupCopyGhostClick(Sender: TObject);
var
  Log: TLogItem;
  Clip: TClipBoard;
begin
  Log := SelectedBottleLog.Bottles[frmLog.lvwLog.ItemIndex];
  if Log = nil then Exit;
  Clip := ClipBoard();
  Clip.SetTextBuf(PChar(Log.Ghost));
end;

procedure TfrmLog.lvwLogDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var
  DestRect: TRect;
  Ico: TIcon;
  Bottle: TLogItem;
begin
  Bottle := SelectedBottleLog.Bottles[Index];
  CheckBottleURL(Bottle);

  DestRect := lvwLog.ItemRect(Index);

  // wi̐F͑IԁEIANeBuԁEʏԂ3ʂ
  lvwLog.Canvas.Brush.Style := bsSolid;
  if odSelected in State then
  begin
    if odFocused in State then
      lvwLog.Canvas.Brush.Color := clHighlight
    else
      lvwLog.Canvas.Brush.Color := clBtnFace;
  end else
  begin
    lvwLog.Canvas.Brush.Color := Pref.BgColor;
  end;
  lvwLog.Canvas.FillRect(DestRect);
  lvwLog.Canvas.Brush.Style := bsClear;

  // hbOȂg`悷
  if FLVDragDest = Index then
  begin
    DrawListViewDragBorder(DestRect);
  end;

  if odSelected in State then
  begin
    if odFocused in State then
      lvwLog.Canvas.Font.Color := clHighlightText
    else
      lvwLog.Canvas.Font.Color := clWindowText;
  end else
  lvwLog.Canvas.Font.Color := Pref.TextColor;

  //lvwLog.Canvas.TextOut(DestRect.Left, DestRect.Top, Bottle.Script);
  // t
  DrawListSection(SubTime, DestRect.Top,
    FormatDateTime('yy/mm/dd hh:nn:ss', Bottle.LogTime), 16);
  // t{gACR
  Ico := TIcon.Create;
  try
    if Bottle.LogType = ltSystemLog then
      frmSender.imgIcon.GetIcon(IconSystemLog, Ico)
    else
      case Bottle.State of
        lsUnopened:
          frmSender.imgIcon.GetIcon(IconBottle, Ico);
        lsOpened:
          frmSender.imgIcon.GetIcon(IconOpened, Ico);
        lsPlaying:
          frmSender.imgIcon.GetIcon(IconPlaying, Ico);
      end;
    lvwLog.Canvas.Draw(2, DestRect.Top, Ico);
  finally
    Ico.Free;
  end;

  // `l
  DrawListSection(SubChannel, DestRect.Top, Bottle.Channel);
  // S[Xg
  DrawListSection(SubGhost, DestRect.Top, Bottle.Ghost);
  // [E
  if Bottle.Votes <> 0 then
    DrawListSection(SubVotes, DestRect.Top, IntToStr(Bottle.Votes))
  else
    DrawListSection(SubVotes, DestRect.Top, '');

  if Bottle.Agrees <> 0 then
    DrawListSection(SubAgrees, DestRect.Top, IntToStr(Bottle.Agrees))
  else
    DrawListSection(SubVotes, DestRect.Top, '');
  
  // XNvg
  DestRect.Left := Header.Sections[SubScript].Left;
  DrawSingleLineScript(Bottle, DestRect, State);
end;

procedure TfrmLog.lvwLogData(Control: TWinControl; Index: Integer;
  var Data: String);
begin
  Data := '';
end;

procedure TfrmLog.HeaderSectionClick(HeaderControl: THeaderControl;
  Section: THeaderSection);
var SortType: TBottleLogSortType;
    SelectedMID: String;
begin
  if SelectedBottleLog = nil then
    Exit;
  if lvwLog.ItemIndex <> -1 then
    SelectedMID := SelectedBottleLog.Bottles[lvwLog.ItemIndex].MID
  else
    SelectedMID := '';

  case Section.Index of
    SubTime:    SortType := stLogTime;
    SubChannel: SortType := stChannel;
    SubGhost:   SortType := stGhost;
    SubVotes:   SortType := stVote;
    SubAgrees:  SortType := stAgree;
    SubScript:  SortType := stScript;
  else
    SortType := stLogTime;
  end;

  SelectedBottleLog.SortBottles(SortType);
  lvwLog.Invalidate;
  if Length(SelectedMID) > 0 then
    SelAndFocusMessage(SelectedMID);
end;

procedure TfrmLog.HeaderSectionTrack(HeaderControl: THeaderControl;
  Section: THeaderSection; Width: Integer; State: TSectionTrackState);
begin
  lvwLog.Invalidate;
end;

procedure TfrmLog.lvwLogMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  Index: Integer;
begin
  if Button = mbRight then
  begin
    Index := lvwLog.ItemAtPos(Point(X, Y), true);
    if Index > -1 then
    begin
      lvwLog.ItemIndex := Index;
      lvwLogClick(Self);
    end;
  end;
end;

procedure TfrmLog.lvwLogWindowProc(var Msg: TMessage);
begin
  if Msg.Msg = WM_CHAR then begin
    if Msg.WParam = 13 then begin
      lvwLogDblClick(lvwLog);
      Msg.Result := 0;
    end;
    Exit;
  end;

  FLVWndMethod(Msg);
end;

end.
