unit MainForm;

{
AvP[ṼCtH[B
MEME{gz֌Ŵ낢ȏsB
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, ComCtrls, BRegExp, BottleDef, BottleSstp,
  DirectSstp, IdBaseComponent, IdComponent, IdTCPConnection, IdTCPClient,
  IdSLPP20, SsParser, ImgList, AppEvnts, TaskTray, StdActns,
  ActnList, MPlayer, MenuBar, ToolWin, SsPlayTime, heClasses, heFountain,
  SakuraScriptFountain, HEditor,
  IniFiles, ShellAPI, Contnrs,
  ConstEditor, Buttons, Clipbrd, HeadValue, Logs, MultipleChoiceEditor,
  IdException, HttpThread, IdHTTP, LogDownload,
  ScriptConsts, DateUtils, BottleChainRule, BottleChainEvent,
  SakuraSeekerInstance, HTSearch,
  SppList, SurfacePreview, XDOM_2_3_J3,
  RegexUtils, StrReplace, StrReplaceDialog, ReplacePresetEditor, ExtCtrls;

type
  TSurfacePreviewType = (spHint, spEditor);

  TfrmSender = class(TForm)
    MainMenu: TMainMenu;
    mnFile: TMenuItem;
    mnExit: TMenuItem;
    mnRegister: TMenuItem;
    mnStart: TMenuItem;
    mnScript: TMenuItem;
    StatusBar: TStatusBar;
    mnHelp: TMenuItem;
    mnAbout: TMenuItem;
    mnEditConst: TMenuItem;
    ActionList: TActionList;
    mnPopUp: TPopupMenu;
    mnPopPaste: TMenuItem;
    mnPopCut: TMenuItem;
    mnPopCopy: TMenuItem;
    mnPopSelectAll: TMenuItem;
    N6: TMenuItem;
    mnPopConst: TMenuItem;
    mnEdit: TMenuItem;
    mnPaste: TMenuItem;
    mnCopy: TMenuItem;
    mnCut: TMenuItem;
    mnSelectAll: TMenuItem;
    TaskTray: TTaskTray;
    ApplicationEvents: TApplicationEvents;
    mnPopUpTaskTray: TPopupMenu;
    mnTaskStart: TMenuItem;
    mnTaskEnd: TMenuItem;
    mnTaskRestore: TMenuItem;
    mnTaskNewMessage: TMenuItem;
    actStart: TAction;
    actStop: TAction;
    N8: TMenuItem;
    mnTaskExit: TMenuItem;
    actSend: TAction;
    actConfirm: TAction;
    actClear: TAction;
    mnSend: TMenuItem;
    mnConfirm: TMenuItem;
    mnClear: TMenuItem;
    imgIcon: TImageList;
    mnPopupConst: TPopupMenu;
    actEditConst: TAction;
    mnView: TMenuItem;
    mnShowToolBar: TMenuItem;
    mnShowConstBar: TMenuItem;
    ConstBarMenu: TMainMenu;
    ToolBar: TToolBar;
    tbtnClear: TToolButton;
    tbtnConfirm: TToolButton;
    tbtnSend: TToolButton;
    tbtnSeparator: TToolButton;
    tbtnStart: TToolButton;
    tbtnSeparator2: TToolButton;
    tbtnInsertConst: TToolButton;
    ConstMenuBar: TMenuBar;
    mnGoToHP: TMenuItem;
    LabelTimer: TTimer;
    mnCopyAll: TMenuItem;
    actCopyAll: TAction;
    actCopyAllNoReturn: TAction;
    mnCopyAllNoReturn: TMenuItem;
    mnPopCopyAll: TMenuItem;
    mnPopCopyAllNoReturn: TMenuItem;
    actSetting: TAction;
    tbtnSetting: TToolButton;
    mnStayOnTop: TMenuItem;
    mnSetting: TMenuItem;
    actExitClient: TAction;
    SsParser: TSsParser;
    tbtnEditConst: TToolButton;
    actClearBottles: TAction;
    mnClearBottles: TMenuItem;
    MediaPlayer: TMediaPlayer;
    mnGetNewId: TMenuItem;
    actNextChannel: TAction;
    actPrevChannel: TAction;
    N2: TMenuItem;
    mnNextChannel: TMenuItem;
    mnPrevChannel: TMenuItem;
    actShowLog: TAction;
    N3: TMenuItem;
    tbtnShowLog: TToolButton;
    tbtnSleep: TToolButton;
    actSleep: TAction;
    N1: TMenuItem;
    mnSleep: TMenuItem;
    mnTaskSleep: TMenuItem;
    pnlEditor: TPanel;
    tabChannel: TTabControl;
    pnlPanel: TPanel;
    lblMessage: TLabel;
    cbxTargetGhost: TComboBox;
    actVoteMessage: TAction;
    mnPopUpChannelTab: TPopupMenu;
    mnLeaveThisChannel: TMenuItem;
    N4: TMenuItem;
    mnGotoVote: TMenuItem;
    mnGoToHelp: TMenuItem;
    btnSend: TButton;
    btnConfirm: TButton;
    btnClear: TButton;
    mnExitAllChannels: TMenuItem;
    actAgreeMessage: TAction;
    IdSLPP20: TIdSLPP20;
    btnIfGhost: TButton;
    actPrevGhost: TAction;
    actNextGhost: TAction;
    mnPrevGhost: TMenuItem;
    mnNextGhost: TMenuItem;
    actResetGhost: TAction;
    mnResetGhost: TMenuItem;
    timDisconnectCheckTimer: TTimer;
    DirectSstp: TDirectSstp;
    actDownloadLog: TAction;
    actFMOExplorer: TAction;
    tbtnFMOExplorer: TToolButton;
    mnFMOExplorer: TMenuItem;
    mnLine: TMenuItem;
    actInsertCue: TAction;
    SakuraScriptFountain: TSakuraScriptFountain;
    memScript: TEditor;
    actCopy: TAction;
    actPaste: TAction;
    actCut: TAction;
    actSelectAll: TAction;
    actRecallScriptBuffer: TAction;
    N5: TMenuItem;
    mnRecallScriptBuffer: TMenuItem;
    tbtnEditorPreview: TToolButton;
    actEditorPreview: TAction;
    mnEditorPreview: TMenuItem;
    actResetPlugins: TAction;
    N7: TMenuItem;
    mnResetPlugins: TMenuItem;
    actReplace: TAction;
    N10: TMenuItem;
    mnReplace: TMenuItem;
    actSendToEditor: TAction;
    actSendToLogWindow: TAction;
    mnSendLogWindow: TMenuItem;
    actDeleteLogItem: TAction;
    actAbout: TAction;
    actEditCopy: TEditCopy;
    tbtnSendToLogWindow: TToolButton;
    SsPlayTime: TSsPlayTime;
    actUndo: TAction;
    actRedo: TAction;
    mnUndo: TMenuItem;
    mnRedo: TMenuItem;
    N9: TMenuItem;
    mnPresetReplaceRoot: TMenuItem;
    procedure actConfirmExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure actSendExecute(Sender: TObject);
    procedure HTTPSuccess(Sender: TObject);
    procedure HTTPFailure(Sender: TObject);
    procedure actStartClick(Sender: TObject);
    procedure actStopExecute(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure actAboutClick(Sender: TObject);
    procedure actExitClientExecute(Sender: TObject);
    procedure actClearExecute(Sender: TObject);
    procedure memScriptChange(Sender: TObject);
    procedure mnStayOnTopClick(Sender: TObject);
    procedure actEditConstExecute(Sender: TObject);
    procedure mnTaskBarClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ApplicationEventsMinimize(Sender: TObject);
    procedure ApplicationEventsRestore(Sender: TObject);
    procedure mnTaskRestoreClick(Sender: TObject);
    procedure TaskTrayDblClick(Seft: TObject; Button: TMouseButton);
    procedure FormActivate(Sender: TObject);
    procedure mnTaskNewMessageClick(Sender: TObject);
    procedure ApplicationEventsHint(Sender: TObject);
    procedure memScriptKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure mnShowToolBarClick(Sender: TObject);
    procedure mnShowConstBarClick(Sender: TObject);
    procedure mnGoToHPClick(Sender: TObject);
    procedure LabelTimerTimer(Sender: TObject);
    procedure actCopyAllExecute(Sender: TObject);
    procedure actCopyAllNoReturnExecute(Sender: TObject);
    procedure Slpp20SlppEvent(Sender: TObject; EventType: TIdSlppEventType;
      const Param: String);
    procedure actSettingExecute(Sender: TObject);
    procedure memScriptKeyPress(Sender: TObject; var Key: Char);
    procedure Slpp20Disconnect(Sender: TObject);
    procedure actClearBottlesExecute(Sender: TObject);
    procedure SakuraSeekerDetectResultChanged(Sender: TObject);
    procedure mnGetNewIdClick(Sender: TObject);
    procedure tabChannelChange(Sender: TObject);
    procedure actPrevChannelExecute(Sender: TObject);
    procedure actNextChannelExecute(Sender: TObject);
    procedure cbxTargetGhostDropDown(Sender: TObject);
    procedure actShowLogExecute(Sender: TObject);
    procedure actSleepExecute(Sender: TObject);
    procedure actVoteMessageExecute(Sender: TObject);
    procedure tabChannelContextPopup(Sender: TObject; MousePos: TPoint;
      var Handled: Boolean);
    procedure mnLeaveThisChannelClick(Sender: TObject);
    procedure mnGotoVoteClick(Sender: TObject);
    procedure tabChannelMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure mnGoToHelpClick(Sender: TObject);
    procedure tabChannelMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure tabChannelDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure tabChannelDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure tabChannelEndDrag(Sender, Target: TObject; X, Y: Integer);
    procedure cbxTargetGhostDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure actAgreeMessageExecute(Sender: TObject);
    procedure actPrevGhostExecute(Sender: TObject);
    procedure actNextGhostExecute(Sender: TObject);
    procedure actResetGhostExecute(Sender: TObject);
    procedure timDisconnectCheckTimerTimer(Sender: TObject);
    procedure actDownloadLogExecute(Sender: TObject);
    procedure cbxTargetGhostChange(Sender: TObject);
    procedure actFMOExplorerExecute(Sender: TObject);
    procedure actInsertCueExecute(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure actCopyExecute(Sender: TObject);
    procedure actPasteExecute(Sender: TObject);
    procedure actCutExecute(Sender: TObject);
    procedure actSelectAllExecute(Sender: TObject);
    procedure memScriptMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure actRecallScriptBufferExecute(Sender: TObject);
    procedure actEditorPreviewExecute(Sender: TObject);
    procedure actResetPluginsExecute(Sender: TObject);
    procedure IdSLPP20Connect(Sender: TObject);
    procedure actReplaceExecute(Sender: TObject);
    procedure actSendToEditorExecute(Sender: TObject);
    procedure actSendToLogWindowExecute(Sender: TObject);
    procedure memScriptDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure memScriptDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure actDeleteLogItemExecute(Sender: TObject);
    procedure memScriptSelectionChange(Sender: TObject; Selected: Boolean);
    procedure actUndoExecute(Sender: TObject);
    procedure actRedoExecute(Sender: TObject);
    procedure IdSLPP20ConnectFailed(Sender: TObject);
  private
    FSleeping: boolean;  // zX[vǂ
    FStatusText: String;
    FConnecting: boolean;
    FAdded: boolean;
    FBooted: boolean; //NʐMp
    FEndSession: Boolean; // WindowsImtrueɂȂ
    FOriginalCaption: String;
    FAutoAddAfterGetChannel: boolean; //`l擾Ƀ_CAOȂ
                                      //`lɎQ邩ǂ
    FConstDir: String;
    FSppDir: String;
    //
    FNowChannel: String; //ݑIĂ`l
    JoinChannelsBackup: TStringList; //ꎞgp
    //
    FScriptModified: boolean; // XNvgύXĂ邩ǂB
                              // [JmFptOBTRichEdit.Modified
                              //ʂ̗prŎgĂ̂ŎgȂ
    //
    FDragTabIndex: integer; //^uhbOhbv֘A
    FDragTabDest: integer;  //hbvʒu(Eɂ^ũCfbNX)
    //
    FBottleSstp: TBottleSstp; // đvO
    //
    FHttp: THTTPDownloadThread; //HTTP_E[hXbh(CX^X1̂)
    FBeginConnectFailCount: integer; //xڑs烊gC~
    //
    FVisiblePreviewGhost: String;
    FVisiblePreviewSurface: integer; //T[tBXvr[ŌĂ
    FVisibleMenuItem: TMenuItem; //NbNꂽj[ACeB
                                 //T[tBXvr[j[̉
                                 //BȂ悤ɕ\Ă̂LĂ
    //
    FTargetGhostExpand: boolean; //S[XgI{bNXA
                                 //ꎞIɑS\Ă邩ǂ̃tO
    //
    FScriptBuffer: TObjectList;  //XNvgNAobt@
    //
    FWM_TaskBarCreated: WORD; // ^XNo[o^pEBhEbZ[WID
    //
    procedure SetStatusText(const Value: String);
    procedure SetSleeping(const Value: boolean);
    procedure YenETrans;
    procedure SetConnecting(const Value: boolean);
    procedure SetAdded(const Value: boolean);
    procedure mnConstClick(Sender: TObject);
    procedure mnConstGroupClick(Sender: TObject);
    procedure mnPresetReplaceClick(Sender: TObject);
    property Added: boolean read FAdded write SetAdded;
    property Sleeping: boolean read FSleeping write SetSleeping;
    property StatusText: String read FStatusText write SetStatusText;
    function GetScriptText: String;
    procedure ChangeTaskIcon;
    procedure ShowHintLabel(const Mes: String; Col: TColor = clBlue);
    procedure UpdateLayout;
    procedure DispatchBottle(EventType: TIdSlppEventType; Dat: THeadValue);
    //`l֌W
    procedure UpdateChannelInfo(Dat: THeadValue);
    procedure UpdateJoinChannelList(Dat: THeadValue);
    procedure NoLuidError;
    procedure UpdateIfGhostBox;
    function BuildMenuConditionCheck(const IfGhost, Ghost: String): boolean;
    procedure BuildMenu(Root: TMenuItem; Simple: boolean);
    procedure BuildReplaceMenu(Root: TMenuItem);
    procedure PlaySound(const FileName: String);
    //TBottleSstp֌WCxgnh
    procedure BottleSstpResendCountChange(Sender: TObject);
    procedure BottleSstpResendTrying(Sender: TObject; MID: String);
    procedure BottleSstpResendEnd(Sender: TObject; MID: String);
    function IsSurfaceTag(const Script: String; var ID: integer): boolean;
    procedure DoSurfacePreview(Surface: integer; const Kind:
      TSurfacePreviewType);
    function GetSurfacePreviewPositionHint(w, h: integer): TPoint;
    function GetSurfacePreviewPositionScriptPoint(w, h: integer): TPoint;
    procedure EditorPreview;
    // ^O̕ϊ
    function TagReplace(Script: String;
      Before, After: array of String): String; overload;
    function TagReplace(Script: String;
      Before, After: TStrings): String; overload;
    // T[tBXϊ
    function ReplaceSurface(Script: String; Params: TCollection): String;
    procedure ClearEditor;
    procedure CopyFromLogToEditor(Log: TLogItem);
    //
    procedure AppendTextLog(const FileName, Line: String);
    procedure AppendXMLLog(const FileName: String; Args: THeadValue);
  protected
    procedure WndProc(var Message: TMessage); override;
    procedure WMQueryEndSession(var msg: TWMQueryEndSession);
      message WM_QUERYENDSESSION;
  public
    function DoTrans(var Script: String;
      Options: TScriptTransOptions): String; overload;
    function DoTrans(var Script: String;
      Options: TScriptTransOptions; out FoundURL: boolean): String; overload;
    function ScriptTransForSSTP(const Script: String;
      out Error: String): String; overload;
    procedure BeginConnect;
    procedure RetryBeginConnect;
    procedure EndConnect;
    procedure ConstructMenu(Simple: boolean);
    property Connecting: boolean read FConnecting write SetConnecting;
    property BottleSstp: TBottleSstp read FBottleSstp;
    function GhostNameToSetName(const Ghost: String): String;
    procedure PostCommand(const Command: array of String); overload;
    procedure PostCommand(Command: TStrings); overload;
    procedure PostSetChannel(Channels: TStrings);
    procedure SaveChainRuleList;
  end;


var
  frmSender: TfrmSender;

const
  PanelConnecting = 0;  //uڑv\p
  PanelBytes      = 1;  //oCg
  PanelCount      = 2;  //Local ProxyA݁҂
  PanelMembers    = 3;  //l
  PanelStatus     = 4;  //SSTP BottleT[oɓo^Ă܂cȂ

  IconConnected    = 17;
  IconDisconnected = 18;
  IconSleep        = 19;
  IconSleepDisconnected = 20;

  WarningColor = clRed;

  SendButtonLongHint = 'BottlȇM';

function Token(const Str: String; const Delimiter: char;
  const Index: integer): String;

function StringReplaceEx(const Before: String; List: THeadValue): String;
procedure OpenBrowser(const Url: String);

implementation

uses SendConfirm, SettingForm, ChannelListForm, LogForm,
  MessageBox, FMOExplorer, EditorTalkShow;

{$R *.DFM}

// PɃoCgPʂŕĂ郆[eBeB֐
function Token(const Str: String; const Delimiter: char;
  const Index: integer): String;
var i, c, len: integer;
begin
  i := 1;
  c := 0;
  len := length(Str);
  Result := '';
  while i <= len do begin
    if (Str[i] = Delimiter) and (StrByteType(PChar(Str), i) <> mbTrailByte) then begin
      Inc(c);
      if c > Index then Break;
    end else if c = Index then Result := Result + Str[i];
    Inc(i);
  end;
end;

// uEUURLJ
procedure OpenBrowser(const Url: String);
begin
  if Pref.BrowserExeName='' then
    begin
      ShellExecute(HWND(nil), 'open', PChar(Url), nil, nil, SW_SHOW);
    end else
    begin
      ShellExecute(HWND(nil), 'open', PChar(Pref.BrowserExeName), PChar(Url), nil, SW_SHOW);
    end;
end;

// u郆[eBeB֐
function StringReplaceEx(const Before: String; List: THeadValue): String;
var
  i, MinPos, MinKey, p: integer;
  Work: String;
begin
  Work := Before;
  Result := '';
  MinKey := -1;
  while Work <> '' do
  begin
    MinPos := -1;
    for i := 0 to List.Count-1 do
    begin
      p := Pos(List.KeyAt[i], Work);
      if (p > 0) and ((p < MinPos) or (MinPos < 0)) then
      begin
        MinPos := p;
        MinKey := i;
      end;
    end;
    if MinPos < 0 then
    begin
      Result := Result + Work;
      Break;
    end else
    begin
      Result := Result + Copy(Work, 1, MinPos-1) + List.ValueAt[MinKey];
      Delete(Work, 1, (MinPos - 1) + Length(List.KeyAt[MinKey]));
    end;
  end;
end;


{TfrmSender}

procedure TfrmSender.actConfirmExecute(Sender: TObject);
var
  AScript, Err, AGhost: String;
  Item: TLogItem;
  Choice: integer;
begin
  // Partial Confirmation
  if memScript.SelText <> '' then
  begin
    Choice := 0;
    if not Pref.AutoPartialConfirm then
      if not MultipleChoiceEdit('mF', ['I𕔕̂', 'XNvgS'], Choice) then
        Exit;
    if Choice = 0 then
    begin
      AScript := memScript.SelText;
      AScript := StringReplace(Pref.PartialConfirmFormat, '|', AScript, []);
    end else
      AScript := GetScriptText;
  end else
    AScript := GetScriptText;
  AScript := StringReplace(AScript, #13#10, '', [rfReplaceAll]);

  if Length(AScript) = 0 then Exit;
  YenETrans;
  AScript := ScriptTransForSSTP(AScript, Err);
  if Err <> '' then
  begin
    ShowMessage(Err);
    Exit;
  end;

  if cbxTargetGhost.ItemIndex > 0 then
    AGhost := cbxTargetGhost.Text
  else if FNowChannel <> '' then
    AGhost := ChannelList.Channel[FNowChannel].Ghost
  else
    AGhost := '';

  if Pref.IgnoreTimeCritical then
    AScript := TagReplace(AScript, ['\t'], ['']);

  Item := TLogItem.Create;
  try
    with Item do
    begin
      LogType := ltBottle;
      Script := AScript;
      Channel := 'ymFz';
      Ghost := AGhost;
    end;
    BottleSstp.Unshift(Item);
  except
    Item.Free;
  end;

  FScriptModified := false;
end;

procedure TfrmSender.FormCreate(Sender: TObject);
var Str: TStringList;
begin
  FScriptBuffer := TObjectList.Create(true);

  SakuraSeeker.OnDetectResultChanged := SakuraSeekerDetectResultChanged;
  FConstDir := ExtractFileDir(Application.ExeName)+'\consts';
  ScriptConstList.LoadFromDir(FConstDir);
  FSppDir := ExtractFileDir(Application.ExeName)+'\spp';
  Spps.LoadFromDirectory(FSppDir);
  ConstructMenu(false);
  BuildReplaceMenu(mnPresetReplaceRoot);

  Str := TStringList.Create;
  try
    try
      Str.LoadFromFile(ExtractFilePath(Application.ExeName)+'rule.txt');
      BottleChainRuleList := StringToComponent(Str.Text) as TBottleChainRuleList;
    except
      try
        Str.LoadFromFile(ExtractFilePath(Application.ExeName)+'defrule.txt');
        BottleChainRuleList := StringToComponent(Str.Text) as TBottleChainRuleList;
      except
        ShowMessage('defrule.txtǂݍݒɒvIG[܂Bdefrule.txtăCXg[ĂB');
        Application.Terminate;
        Application.ProcessMessages;
        Exit;
      end;
    end;
  finally
    Str.Free;
  end;

  FOriginalCaption := Self.Caption;

  UpdateLayout;
  mnShowToolBar.Checked := Pref.ShowToolBar;
  mnShowConstBar.Checked := Pref.ShowConstBar;
  if Pref.StayOnTop then begin
    FormStyle := fsStayOnTop;
    mnStayOnTop.Checked := true;
  end else begin
    FormStyle := fsNormal;
    mnStayOnTop.Checked := false;
  end;

  // URLWvqgƂĐݒ
  mnGoToHP.Hint := Pref.HomePage;
  mnGotoVote.Hint := Pref.VotePage;
  mnGotoHelp.Hint := Pref.HelpPage;

  mnGetNewId.Enabled := (Pref.LUID = '');

  // XNvg̓p^[ǂݍ
  try
    SsParser.TagPattern.LoadFromFile(ExtractFilePath(Application.Exename) + 'tagpat.txt');
    SsParser.MetaPattern.LoadFromFile(ExtractFilePath(Application.ExeName) + 'metapat.txt');
  except
    ShowMessage('tagpat.txt, metapat.txt܂B');
    Application.Terminate;
  end;

  // ĐԐR|[lgɃp[^w
  SsPlayTime.PlayTimeParams := Pref.PlayTimeParams;

  // CEBhËʒuƃTCY𕜋A
  with Pref.SenderWindowPosition do begin
    Self.Left   := Left;
    Self.Top    := Top;
    Self.Width  := Right - Left + 1;
    Self.Height := Bottom - Top + 1;
  end;

  // ^XNo[̍ċN(ExplorerƂ)o
  FWM_TaskBarCreated := RegisterWindowMessage('TaskBarCreated');

  // XNvg̏
  actClearExecute(Sender);
  // ^XNgCɃACRǉ
  ChangeTaskIcon;
  // `lQ֌W̃^ȕȂ(`lsQŏ)
  UpdateJoinChannelList(nil);

  // SSTPđIuWFNg
  FBottleSstp := TBottleSstp.Create(false);
  with FBottleSstp do begin
    OnResendCountChange := BottleSstpResendCountChange;
    OnResendTrying := BottleSstpResendTrying;
    OnResendEnd := BottleSstpResendEnd;
  end;
end;

procedure TfrmSender.FormDestroy(Sender: TObject);
begin
  if FScriptBuffer <> nil then
    FScriptBuffer.Free;

  if FBottleSstp <> nil then begin
    FBottleSstp.Terminate;
    FBottleSstp.Free;
  end;

  with Pref.SenderWindowPosition do begin
    Left   := Self.Left;
    Top    := Self.Top;
    Right  := Self.Left + Self.Width - 1;
    Bottom := Self.Top + Self.Height - 1;
  end;

  if JoinChannelsBackup <> nil then JoinChannelsBackup.Free;

  ScriptConstList.Save;

  SaveChainRuleList;
  BottleChainRuleList.Free;

end;


procedure TfrmSender.SetConnecting(const Value: boolean);
begin
  FConnecting := Value;
  if Value then begin
    StatusBar.Panels[PanelConnecting].Text := 'ʐM';
    actStart.Enabled := false;
    actStop.Enabled := false;
    actSend.Enabled := false;
    actVoteMessage.Enabled := false;
    actAgreeMessage.Enabled := false;
    mnGetNewId.Enabled := false;
    Screen.Cursor := crAppStart;
  end else begin
    StatusBar.Panels[PanelConnecting].Text := '';
    actStart.Enabled := true;
    actStop.Enabled := true;
    actSend.Enabled := true;
    frmLog.lvwLogClick(Self);
    mnGetNewId.Enabled := Pref.LUID = '';
    Screen.Cursor := crDefault;
  end;
end;

// bZ[WM
procedure TfrmSender.actSendExecute(Sender: TObject);
var Talk, Ghost: String;
    Command: TStringList;
    Err: String;
    F: TextFile;
begin
  if Length(GetScriptText) = 0 then begin
    ShowMessage('XNvgłB');
    Exit;
  end;

  if Pref.LUID = '' then begin
    NoLuidError;
    Exit;
  end;
  if tabChannel.TabIndex < 0 then begin
    ShowMessage('`lɎQĂ܂B'#13#10+
      'j[u`lQvsĂB');
    Exit;
  end;
  if ChannelList.Channel[FNowChannel].NoPost then begin
    Beep;
    ShowMessage(FNowChannel + ' ͎Mpł');
    Exit;
  end;

  YenETrans;
  Talk := StringReplace(GetScriptText, #13#10, '', [rfReplaceAll]);
  Err := DoTrans(Talk, [toWarnMessySurface, toWarnCheck]);
  if Err <> '' then begin
    MessageDlg(Err, mtWarning, [mbOk], 0);
    Exit;
  end;

  if Pref.NeedConfirmBeforeSend and FScriptModified then
  begin
    MessageDlg('MOɃ[JmFĂB', mtError, [mbOk], 0);
    Exit;
  end;

  if Length(Talk) < Pref.MinScriptLength then
  begin
    MessageDlg('ŏMoCgȉłB', mtError, [mbOk], 0);
    Exit;
  end;

  if not Pref.NoConfirm then begin
    if not SendConfirmDialog(FNowChannel, cbxTargetGhost.Text) then Exit;
  end;

  Ghost := '';
  if cbxTargetGhost.ItemIndex > 0 then Ghost := cbxTargetGhost.Text;
  Command := TStringList.Create;
  try
    with Command do begin
      Add('Command: sendBroadcast');
      Add('Channel: ' + FNowChannel);
      Add('LUID: ' + Pref.LUID);
      Add('Agent: ' + VersionString);
      if Ghost <> '' then Add('Ghost: ' + Ghost);
      Add('Talk: ' + Talk);
    end;
    PostCommand(Command);
  finally
    Command.Free;
  end;

  //MOۑ
  AssignFile(F, ExtractFilePath(Application.ExeName) + SentLogFile);
  if FileExists(ExtractFilePath(Application.ExeName) + SentLogFile) then
    Append(F)
  else
    Rewrite(F);
  WriteLn(F, Format('%s,%s,%s,%s', [FNowChannel, Ghost, FormatDateTime('yy/mm/dd hh:nn:ss', Now), Talk]));
  Flush(F);
  CloseFile(F);
end;

procedure TfrmSender.BeginConnect;
begin
  if Pref.LUID = '' then begin
    NoLuidError;
    Exit;
  end;
  IdSlpp20.LUID := Pref.LUID;
  self.Cursor := crHourGlass;
  if IdSlpp20.Connected then IdSlpp20.Disconnect;
  if Pref.UseHttpProxy then begin
    IdSlpp20.Host := Pref.ProxyAddress;
    IdSlpp20.Port := Pref.ProxyPort;
    IdSlpp20.ProxyMode := true;
    if Pref.ProxyNeedAuthentication then begin
      IdSlpp20.ProxyUser := Pref.ProxyUser;
      IdSlpp20.ProxyPass := Pref.ProxyPass;
    end else begin
      IdSlpp20.ProxyUser := '';
      IdSlpp20.ProxyPass := '';
    end;
  end else begin
    IdSlpp20.Host := Pref.BottleServer;
    IdSlpp20.Port := Pref.BottleServerPort;
    IdSlpp20.ProxyMode := false;
  end;
  IdSlpp20.ConnectServer;
  self.Cursor := crDefault;
end;

procedure TfrmSender.EndConnect;
begin
  IdSlpp20.OnDisconnect := nil;
  IdSlpp20.Disconnect;
end;

procedure TfrmSender.SetAdded(const Value: boolean);
begin
  if FAdded = Value then Exit;
  FAdded := Value;
  if Value then begin
    StatusText := 'SSTP Bottle T[oɐڑĂ܂';
    ChangeTaskIcon;
  end else begin
    StatusText := 'T[oƂ̐ڑ؂Ă܂!';
    ChangeTaskIcon;
    ShowHintLabel('SSTP BottleT[oؒf܂!', WarningColor);
  end;
end;

procedure TfrmSender.HTTPSuccess(Sender: TObject);
var Str, ResStr, Command: String;
    HeadValue: THeadValue;
    i: integer;
    SetChannel: TStringList;
begin
  Connecting := false;
  Str := (Sender as THttpDownloadThread).RecvString;
  HeadValue := nil;
  try
    try
      HeadValue := THeadValue.Create(Str);
    except
      Beep;
      frmMessageBox.ShowMessage('SSTP BottleT[o͂łȂG[Ԃ܂B');
      Exit;
    end;
    Command := HeadValue['Command'];
    ResStr  := HeadValue['Result'];
    if ResStr = 'Err' then begin
      if HeadValue['ExtraMessage'] <> '' then begin
        Beep;
        frmMessageBox.ShowMessage('SSTP BottleT[õG[Ԃ܂:'#13#10 +
                     HeadValue['ExtraMessage']);
      end else begin
        Beep;
        frmMessageBox.ShowMessage('SSTP BottleT[o炩̃G[Ԃ܂B'#13#10 + 'iR}hu' + Command + 'vj');
      end;
    end;
    if (Command = 'sendBroadcast') and (ResStr = 'OK') then begin
      ShowHintLabel(HeadValue['Channel'] + '  ' + HeadValue['SentNum'] +
                    'lɑM܂');
      //S[XgftHgɖ߂
      if Pref.ResetIfGhostAfterSend then begin
        actResetGhostExecute(Self);
      end;
      //XNvgNA
      if Pref.ClearAfterSend then begin
        actClear.Execute;
      end;
    end else if (Command = 'sendBroadcast') and (ResStr <> 'OK') then begin
      ShowHintLabel('bZ[W𑗐Mł܂ł', WarningColor);
    end;
    if (Command = 'getNewId') then begin
      if ResStr = 'OK' then begin
        Pref.LUID := HeadValue['NewID'];
        ShowHintLabel('LUID擾B');
        frmMessageBox.ShowMessage('N̂߁A' +
          'SSTP BottleT[oڑpID(LUID)VK擾܂B'#13#10 +
          'LUID: ' + Pref.LUID +  #13#10 +
          'ݒt@C폜邱ƂŁALUID͎RɎ擾ł܂A' +
          'LUID̎gpтɉēT邩܂̂ŁA' +
          'o邾̂gĂBڍׂ̓wvB');
        mnGetNewId.Enabled := false;
        BeginConnect;
      end else begin
        ShowHintLabel('LUID擾Ɏs܂');
      end;
    end;
    if (Command = 'voteMessage') then begin
      if ResStr = 'OK' then begin
        ShowHintLabel('bZ[Wɓ[/ӂ܂B[: ' + HeadValue['Votes']);
      end;
    end;
    if (Command = 'getChannels') and (ResStr = 'OK') then begin
      UpdateChannelInfo(HeadValue);
      SetChannel := nil;
      try
        if FAutoAddAfterGetChannel then begin
          SetChannel := TStringList.Create;
          if JoinChannelsBackup <> nil then begin
            //U`lQɐȂŌɎQĂ`l
            SetChannel.Assign(JoinChannelsBackup);
          end else begin
            //SɏN̏ꍇ̓vt@Xo^擾
            for i := 0 to Pref.AutoJoinChannels.Count-1 do begin
              if ChannelList.Channel[Pref.AutoJoinChannels[i]] <> nil then
                SetChannel.Add(Pref.AutoJoinChannels[i]);
            end;
          end;
        end else begin
          Application.CreateForm(TfrmChannelList, frmChannelList);
          try
            if frmChannelList.Execute(ChannelList, JoinChannels) then begin
              SetChannel := TStringList.Create;
              SetChannel.Assign(frmChannelList.JoinList);
            end;
          finally
            frmChannelList.Release;
          end;
        end;
        if SetChannel <> nil then PostSetChannel(SetChannel);
      finally
        if SetChannel <> nil then FreeAndNil(SetChannel);
      end;
    end;
    if (Command = 'setChannels') then begin
      if ResStr <> 'OK' then begin
        Beep;
        frmMessageBox.ShowMessage('`lݒɎs܂Bxo^ȂĂ');
        ShowHintLabel('`lݒɎs܂', WarningColor);
      end;
    end;
    if HeadValue['ExtraTip'] <> '' then ShowHintLabel(HeadValue['ExtraTip']);
  finally
    HeadValue.Free;
  end;
end;

procedure TfrmSender.actStartClick(Sender: TObject);
begin
  if Pref.LUID = '' then begin
    NoLuidError;
    Exit;
  end;
  if not IdSlpp20.Connected then begin
    FBeginConnectFailCount := 0; // ĐڑJE^Zbg
    BeginConnect;
  end;
  if Added then begin
    FAutoAddAfterGetChannel := false;
    PostCommand(['Command: getChannels']);
  end;
end;

procedure TfrmSender.actStopExecute(Sender: TObject);
begin
  // Đڑs
  FBeginConnectFailCount := 0; // ĐڑJE^Zbg
  RetryBeginConnect;
end;

procedure TfrmSender.FormShow(Sender: TObject);
begin
  if FBooted or Application.Terminated then Exit;
  //LUID擾ĂΑo^BłȂLUID擾B
  if Pref.LUID <> '' then BeginConnect
  else mnGetNewIdClick(Self);

  FAutoAddAfterGetChannel := Pref.AutoStart;
  FBooted := true;

  frmLog.Show;
  frmSurfacePreview.Show;
  Self.Show;

  //GfB^vr[O\ԂȂ炱ŕ\
  if Pref.ShowEditorPreviewWindow then actEditorPreviewExecute(Sender);

  SakuraSeeker.BeginDetect;
  SakuraSeekerDetectResultChanged(self);
  if (SakuraSeeker.Count = 0) and not Pref.NoWarnOfEmptyFMO then
    frmMessageBox.ShowMessage('S[Xg(SSTPT[o)1NĂ܂B'#13#10 +
      'SSTP Bottle𗘗p邽߂ɂ́AS[Xg𓯎ɋNĂB'#13#10 +
      'ڍׂ̓wvB');
end;

procedure TfrmSender.actAboutClick(Sender: TObject);
var
  Str: String;
begin
  Str := VersionString + #13#10 + BottleDisclaimer + #13#10#13#10;
  Str := Str + Format('Compiler Version: %f', [CompilerVersion]) + #13#10;
  Str := Str + 'Indy Version: ' + IdSLPP20.Version;
  frmMessageBox.ShowMessage(Str);
end;

procedure TfrmSender.actExitClientExecute(Sender: TObject);
begin
  Close;
end;

procedure TfrmSender.actClearExecute(Sender: TObject);
var
  Script, Default: String;
begin
  Script := StringReplace(GetScriptText, #13#10, '', [rfReplaceAll]);
  Default := StringReplace(Pref.DefaultScript, '|', '', [rfReplaceAll]);
  Default := StringReplace(Default, #13#10, '', [rfReplaceAll]);

  if (Pref.AutoClip) and (Length(GetScriptText) > 0) and (Script <> Default) then
    actSendToLogWindow.Execute
  else
    ClearEditor;
end;

procedure TfrmSender.memScriptChange(Sender: TObject);
var
  Script: String;
  Text: String;
begin
  Script := StringReplace(GetScriptText, #13#10, '', [rfReplaceAll]);
  Text := Format('%doCg/%db', [Length(Script), SsPlayTime.PlayTime(Script) div 1000]);
  StatusBar.Panels[PanelBytes].Text := Text;
  FScriptModified := true;
  EditorPreview;
end;

procedure TfrmSender.mnStayOnTopClick(Sender: TObject);
begin
  Pref.StayOnTop := not Pref.StayOnTop;
  mnStayOnTop.Checked := Pref.StayOnTop;
  if Pref.StayOnTop then begin
    FormStyle := fsStayOnTop;
  end else begin
    FormStyle := fsNormal;
  end;
  Show;
end;

function TfrmSender.GetScriptText: String;
begin
  Result := memScript.Lines.Text;
end;

procedure TfrmSender.mnConstClick(Sender: TObject);
var i: integer;
begin
  i := (Sender as TMenuItem).Tag;
  memScript.SelText := ScriptConstList.GetConstByID(i).ConstText;
end;

procedure TfrmSender.actEditConstExecute(Sender: TObject);
begin
  ScriptConstList.LoadFromDir(FConstDir);
  try
    Application.CreateForm(TfrmConstEditor, frmConstEditor);
    frmConstEditor.Execute;
    ScriptConstList.Save;
  finally
    frmConstEditor.Release;
  end;
  ConstructMenu(false);
end;

procedure TfrmSender.mnTaskBarClick(Sender: TObject);
begin
  Application.Minimize;
  WindowState := wsNormal;
end;

procedure TfrmSender.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  EndConnect;
  TaskTray.Registered := false;
end;

procedure TfrmSender.ApplicationEventsMinimize(Sender: TObject);
begin
  Visible := false;
  Application.ShowMainForm := false;
  ShowWindow(Application.Handle, SW_HIDE);
end;

procedure TfrmSender.ApplicationEventsRestore(Sender: TObject);
begin
  Application.ShowMainForm := true;
  Visible := true;
end;

procedure TfrmSender.mnTaskRestoreClick(Sender: TObject);
begin
  Application.Restore;
end;

procedure TfrmSender.TaskTrayDblClick(Seft: TObject; Button: TMouseButton);
begin
  Application.Restore;
end;

procedure TfrmSender.FormActivate(Sender: TObject);
begin
  memScript.SetFocus;
end;

procedure TfrmSender.mnTaskNewMessageClick(Sender: TObject);
begin
  Application.Restore;
  actClearExecute(Sender);
end;

procedure TfrmSender.ChangeTaskIcon;
var Ico: TIcon;
    IcoNum: integer;
begin
  if Added then begin
    if Sleeping then IcoNum := IconSleep else IcoNum := IconConnected;
  end else begin
    if Sleeping then IcoNum := IconSleepDisconnected
    else IcoNum := IconDisconnected;
  end;
  try
    Ico := TIcon.Create;
    try
      imgIcon.GetIcon(IcoNum, Ico);
      TaskTray.Icon := Ico;
      TaskTray.Registered := true;
    finally
      Ico.Free;
    end;
  except
    ; // PCׂ̕4bȓɃ^XNgCo^łA
      // VFnOĂƔfėOB
      // ̏ꍇ̓G[𖳎
  end;
end;

procedure TfrmSender.SetStatusText(const Value: String);
begin
  FStatusText := Value;
  StatusBar.Panels[PanelStatus].Text := Value;
end;

procedure TfrmSender.ApplicationEventsHint(Sender: TObject);
var id: integer;
begin
  if Length(Application.Hint) > 0 then
  begin
    StatusBar.Panels[PanelStatus].Text := GetLongHint(Application.Hint);
    Application.HintColor := clInfoBk;
    if (Application.Hint = SendButtonLongHint)
    and (FNowChannel <> '') then
    begin
      //M{^̏ꍇ͑Uo
      Application.HintColor := clYellow;
      Application.ActivateHint(Mouse.CursorPos);
    end;
    if IsSurfaceTag(Application.Hint, id) and Pref.SurfacePreviewOnHint then
    begin
      // T[tBXvr[
      DoSurfacePreview(id, spHint);
    end;
  end else
  begin
    StatusBar.Panels[PanelStatus].Text := FStatusText;
    frmSurfacePreview.HideAway;
  end;
end;

procedure TfrmSender.ConstructMenu(Simple: boolean);
begin
  BuildMenu(mnPopConst, Simple);
  BuildMenu(mnPopUpConst.Items, Simple);
  BuildMenu(ConstBarMenu.Items, Simple);

  {$IFDEF CONDITIONALEXPRESSIONS}
    {$IF Declared(CompilerVersion)}
      {$IF CompilerVersion < 15.0} // Delphi6ȉȂ
        // j[x
        // Ȃ2ڈȍ~̕\Ȃ̏C
        // ported from YasagureClient
        ConstMenuBar.AutoSize := false;
        ConstMenuBar.Menu := nil;
      {$IFEND}
    {$IFEND}
  {$ENDIF}
  
  ConstMenuBar.Menu := ConstBarMenu;
  ConstMenuBar.Width := 1000;
  ConstMenuBar.AutoSize := true;
end;

procedure TfrmSender.memScriptKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var Pos: TPoint;
    Func: TReturnKeyFunction;
begin
  if (Key = VK_RETURN) then begin
    if (ssShift in Shift) then
      Func := Pref.WhenShiftReturn
    else if (ssCtrl in Shift) then
      Func := Pref.WhenCtrlReturn
    else
      Func := Pref.WhenReturn;
    case Func of
      kfConstText: begin
        with tbtnInsertConst do
          Pos := tbtnInsertConst.ClientToScreen(Point(0, Height));
        mnPopUpConst.Popup(Pos.X, Pos.Y);
      end;
      kfYenN: begin
        memScript.SelText := '\n';
        Key := 0;
      end;
      kfYenNReturn: begin
        memScript.SelText := '\n'#13#10;
      end;
      kfReturn: begin
        memScript.SelText := #13#10
      end;
    end;
  end;
end;

procedure TfrmSender.mnShowToolBarClick(Sender: TObject);
begin
  mnShowToolBar.Checked := not mnShowToolBar.Checked;
  Pref.ShowToolBar := mnShowToolBar.Checked;
  UpdateLayout;
end;

procedure TfrmSender.mnShowConstBarClick(Sender: TObject);
begin
  mnShowConstBar.Checked := not mnShowConstBar.Checked;
  Pref.ShowConstBar := mnShowConstBar.Checked;
  UpdateLayout;
end;

procedure TfrmSender.UpdateLayout;
begin
  with SakuraScriptFountain do begin
    TagColor.Color := Pref.MarkUpColor;
    TagErrorColor.Color := Pref.MarkErrorColor;
    Scope0Color.Color := Pref.TalkColorH;
    Scope1Color.Color := Pref.TalkColorU;
    SynchronizedColor.Color := Pref.TalkColorS;
  end;
  memScript.Ruler.Visible := Pref.ShowRuler;
  memScript.Ruler.Color := Pref.TextColor;
  memScript.Color := Pref.BgColor;

  ToolBar.Visible := Pref.ShowToolBar;
  ConstMenuBar.Visible := Pref.ShowConstBar;
  ToolBar.Top := 0;
  //
  with tabChannel do begin
    TabPosition := Pref.TabPosition;
    case Pref.TabPosition of
      tpTop:    Align  := alTop;
      tpBottom: Align := alBottom;
    end;
    TabWidth := Pref.TabWidth;
  end;
end;

function TfrmSender.DoTrans(var Script: String;
  Options: TScriptTransOptions; out FoundURL: boolean): String;
var UrlCancel, Mark: String;
    Url, UrlName: array[0..6] of String;
    i, j, u, UrlCount: integer;
    LastSurfaceH, LastSurfaceU: integer;
    UnyuTalking: boolean;
    QuickSection, Synchronize: boolean;
    Warnings: TStringList;
begin
  UrlCount := 0;
  LastSurfaceH := 0;
  LastSurfaceU := 10;
  UnyuTalking := false;
  QuickSection := false;
  Synchronize := false;
  SsParser.LeaveEscape := true;
  SsParser.EscapeInvalidMeta := false;
  SsParser.InputString := Script;
  Script := '';
  Warnings := TStringList.Create;
  try
    for i := 0 to SsParser.Count-1 do begin
      if SsParser[i] = '\t' then begin
        if not(toIgnoreTimeCritical in Options) then
          Script := Script + '\t';
      end else if SsParser[i] = '\e' then begin
        Continue;
      end else if (SsParser.Match(SsParser[i], '\URL%b') > 0) then begin
        if toConvertURL in Options then begin
          UrlCount := 0; //OURL^Ỏe𖳎B
          for u := 7 downto 1 do begin
            if (SsParser.Match(SsParser[i],
                '\URL%b'+StringReplace(StringOfChar('-', u*2),
                '-', '%b', [rfReplaceAll]))) > 0 then begin
              for j := 1 to u do begin
                Url[UrlCount] := SsParser.GetParam(SsParser[i], UrlCount*2+2);
                UrlName[UrlCount] := SsParser.GetParam(SsParser[i], UrlCount*2+3);
                if UrlName[UrlCount] = '' then UrlName[UrlCount] := Url[UrlCount];
                //httpsȂǂǉ鎞΍cc://΂Ԃv
                if Pos('://', Url[UrlCount]) > 0 then Inc(UrlCount);
              end;
            end;
            if UrlCount > 0 then UrlCancel := SsParser.GetParam(SsParser[i], 1);
            if UrlCancel = '' then UrlCancel := 'sȂ@@@@';
          end;
          if SsParser.Match(SsParser[i], '\URL%b%b') = 0 then begin //ȈՔURLϊ
            //ȈՌ`\URL^Oϊ
            Url[0] := SsParser.GetParam(SsParser[i], 1);
            UrlName[0] := 's@@@@@@';
            UrlCancel  := 'sȂ@@@@';
            //httpsȂǂǉ鎞΍cc://΂Ԃv
            if Pos('://', Url[0]) > 0 then begin
              UrlCount := 1;
              if not QuickSection then
                Script := Script + '\_q' + Url[0] + '\_q'
              else
                Script := Script + Url[0];
            end;
          end;
        end else Script := Script + SsParser[i];
      end else begin
        Mark := SsParser[i];
        if Mark = '\h' then begin
          UnyuTalking := false;
          if toHUTagTo01Tag in Options then Mark := '\0';
          if Synchronize and Pref.WarnScopeChangeInSynchronize then
            Warnings.Add('VNiCYhZNV\h܂B');
        end else if Mark = '\u' then begin
          UnyuTalking := true;
          if toHUTagTo01Tag in Options then Mark := '\1';
          if Synchronize and Pref.WarnScopeChangeInSynchronize then
            Warnings.Add('VNiCYhZNV\u܂B');
        end else if Mark = '\_q' then begin
          QuickSection := not QuickSection;
        end else if Mark = '\_s' then begin
          Synchronize := not Synchronize;
        end else if SsParser.Match(Mark, '\s%b') > 0 then begin
          if UnyuTalking then begin
            LastSurfaceU := StrToIntDef(SsParser.GetParam(Mark, 1),
                                        LastSurfaceU);
          end else begin
            LastSurfaceH := StrToIntDef(SsParser.GetParam(Mark, 1),
                                        LastSurfaceH);
          end;
        end else if SsParser.Match(Mark, '\s%d') > 0 then begin
          if UnyuTalking then begin
            LastSurfaceU := StrToIntDef(Mark[3], LastSurfaceU);
          end else begin
            LastSurfaceH := StrToIntDef(Mark[3], LastSurfaceH);
          end;
        end;
        Script := Script + Mark;
      end;
    end;
    if UrlCount > 0 then begin
      FoundUrl := true;
      Script := Script + '\h\n';
      if not (toNoChoice in Options) then begin
        for i := 0 to UrlCount-1 do begin
          Script := Script + Format('\q%d[%s][%s]',
                      [i, SsParser.EscapeParam(Url[i]), UrlName[i]]);
        end;
        Script := Script + Format('\q%d[#cancel][%s]', [UrlCount, UrlCancel]);
        //Script := Script + '\z'; //ŐVphaseł͍폜
      end else begin
        Script := Script + '\h';
        for i := 0 to UrlCount-1 do begin
          Script := Script + Format('\n{%s}(%s)', [UrlName[i], Url[i]]);
        end;
        Script := Script + Format('\n{%s}', [UrlCancel]);
      end;
    end else
      FoundUrl := false;
    //XNvg̍ŌɃEFCg}
    if toWaitScriptEnd in Options then begin
      i := Pref.WaitScriptEnd;
      while i > 0 do begin
        if i > 9 then begin
          Script := Script + '\w9';
          Dec(i, 9);
        end else begin
          Script := Script + '\w' + IntToStr(i);
          i := 0;
        end;
      end;
    end;

    Script := Script + '\e';
    RegExp.Subst('s/\r\n//gk', Script);

    //^O`FbN֘A
    for i := 0 to SsParser.Count-1 do begin
      if SsParser.MarkUpType[i] = mtTagErr then begin
        Result := '"' + SsParser[i] + '"'#13#10 +
                  '́ASSTP BottleŔF߂ȂAFłȂ^OłB';
        Exit;
      end else if SsParser.MarkUpType[i] = mtStr then begin
        if Pos(#9,SsParser[i]) > 0 then begin
          Result := '^úASSTP BottleŎgpł܂B';
          Exit;
        end;
      end;
    end;
    if (SsParser[0] <> '\t') and Pref.WarnYenTNotExist then begin
      Warnings.Add('XNvg\tn܂Ă܂B');
    end;

    //`FbN
    if (Warnings.Count > 0) and (toWarnCheck in Options) then begin
      if MessageDlg(Warnings.Text + #13#10 + 'M܂?', mtWarning,
                    mbOkCancel, 0) = mrCancel then
        Result := Warnings.Text;
    end;
  finally
    Warnings.Free;
  end;
end;

function TfrmSender.DoTrans(var Script: String;
  Options: TScriptTransOptions): String;
var dum: boolean;
begin
  Result := DoTrans(Script, Options, dum);
end;

procedure TfrmSender.mnGoToHPClick(Sender: TObject);
begin
  OpenBrowser(Pref.HomePage);
end;

procedure TfrmSender.ShowHintLabel(const Mes: String; Col: TColor);
begin
  lblMessage.Caption := Mes;
  lblMessage.Font.Color := Col;
  lblMessage.Visible := true;
  LabelTimer.Enabled := false;
  LabelTimer.Enabled := true;
end;

procedure TfrmSender.LabelTimerTimer(Sender: TObject);
begin
  LabelTimer.Enabled := false;
  lblmessage.Visible := false;
end;

procedure TfrmSender.actCopyAllExecute(Sender: TObject);
var Str: String;
    Clip: TClipBoard;
begin
  Str := memScript.Lines.Text;
  Clip := ClipBoard();
  Clip.SetTextBuf(PChar(Str));
end;

procedure TfrmSender.actCopyAllNoReturnExecute(Sender: TObject);
var Str: String;
    Clip: TClipBoard;
begin
  Str := memScript.Lines.Text;
  RegExp.Subst('s/\r\n//gk', Str);
  Clip := ClipBoard();
  Clip.SetTextBuf(PChar(Str));
end;

procedure TfrmSender.Slpp20SlppEvent(Sender: TObject; EventType: TIdSlppEventType;
  const Param: String);
var HeadValue: THeadValue;
begin
  HeadValue := THeadValue.Create(Param);
  try
    case EventType of
      etScript, etForceBroadcast, etUnicast: begin
        //bZ[WM
        DispatchBottle(EventType, HeadValue);
      end;

      etMemberCount: begin
        //QҐ
        StatusBar.Panels[PanelMembers].Text := HeadValue['Num'] + 'l'
      end;

      etChannelCount: begin
        //`lʎQҐ
        try
          if HeadValue['Channel'] <> '' then begin
            if ChannelList.Channel[HeadValue['Channel']] <> nil then begin
              ChannelList.Channel[HeadValue['Channel']].Members := StrToInt(HeadValue['Num']);
            end;
          end;
        except
        end;
      end;

      etConnectOk: begin
        ShowHintLabel('SSTP BottleT[oƒʐMmB');
        Added := true;
        FBeginConnectFailCount := 0;
        //`lo^
        if not Connecting then
          PostCommand(['Command: getChannels']);
        try
          SakuraSeeker.BeginDetect;
        except
          on E: Exception do ShowHintLabel(E.Message,WarningColor);
        end;
      end;

      etChannelList: begin
        UpdateJoinChannelList(HeadValue);
        // ŌɎQĂ`lL^
        if JoinChannelsBackup = nil then JoinChannelsBackup := TStringList.Create;
        JoinChannelsBackup.Assign(JoinChannels);
      end;

      etCloseChannel: begin
        //`lp~
        if HeadValue['Channel'] <> '' then begin
          with JoinChannels do
            if IndexOf(HeadValue['Channel']) >= 0 then
              Delete(IndexOf(HeadValue['Channel']));
          with tabChannel do begin
            if Tabs.IndexOf(HeadValue['Channel']) >= 0 then
              Tabs.Delete(Tabs.IndexOf(HeadValue['Channel']));
            if Tabs.Count > 0 then TabIndex := 0 else TabIndex := -1;
            tabChannelChange(self);
          end;
          ShowHintLabel(HeadValue['Channel'] + '`l͔p~܂',
                        WarningColor);
          frmLog.AddCurrentSystemLog('SYSTEM', HeadValue['Channel'] + '`l͔p~܂');
          frmMessageBox.ShowMessage(HeadValue['Channel'] + '`l͔p~܂');
        end;
      end;

      etForceBroadcastInformation: begin
        //[^Ӂ^̑u[hLXg
        if HeadValue['MID'] <> '' then begin
          try //NumlłȂƂ΍
            if HeadValue['Type'] = 'Vote' then begin
              frmLog.VoteLog(HeadValue['MID'], StrToIntDef(HeadValue['Num'], 0));
            end else if HeadValue['Type'] = 'Agree' then begin
              frmLog.AgreeLog(HeadValue['MID'], StrToIntDef(HeadValue['Num'], 0));
            end;
          except
          end;
        end;
      end;
    end;
  finally
    HeadValue.Free;
  end;
end;

procedure TfrmSender.BottleSstpResendCountChange(Sender: TObject);
begin
  StatusBar.Panels[PanelCount].Text := IntToStr(FBottleSstp.CueCount) + '';
  try
    TaskTray.TipString := 'SSTP Bottle Client (' +
                          IntToStr(FBottleSstp.CueCount) + ')';
  except
    ; // ^XNgCo^s𖳎
  end;
  actClearBottles.Enabled := (FBottleSstp.CueCount > 0);
end;

procedure TfrmSender.actSettingExecute(Sender: TObject);
begin
  Application.CreateForm(TfrmSetting, frmSetting);
  try
    frmSetting.Execute;
    Pref.SaveSettings;
    SaveChainRuleList;
  finally
    frmSetting.Release;
    frmSetting := nil;
  end;
  //
  BuildReplaceMenu(mnPresetReplaceRoot);
  UpdateLayout;
  tabChannel.Repaint;
  frmLog.UpdateWindow;
end;

procedure TfrmSender.memScriptKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key = #13) or (Key = #10) then Key := Char(0);
end;

procedure TfrmSender.Slpp20Disconnect(Sender: TObject);
begin
  Added := false;
  UpdateJoinChannelList(nil);
  frmLog.AddCurrentSystemLog('SYSTEM', 'T[oؒf܂');
  if not Application.Terminated then RetryBeginConnect;
end;

procedure TfrmSender.SetSleeping(const Value: boolean);
begin
  FSleeping := Value;
  FBottleSstp.ResendSleep := Value;
  ChangeTaskIcon;
end;

procedure TfrmSender.actClearBottlesExecute(Sender: TObject);
var Re: integer;
begin
  Re := MessageDlg(Format('z%dBottleSNA܂', [FBottleSstp.CueCount]),
                   mtWarning, mbOkCancel, 0);
  if Re = mrOk then begin
    FBottleSstp.Clear;
    frmLog.AllBottleOpened;
    frmLog.UpdateWindow;
  end;
end;

procedure TfrmSender.SakuraSeekerDetectResultChanged(Sender: TObject);
begin
  UpdateIfGhostBox; // hbv_E̒g
end;

procedure TfrmSender.UpdateChannelInfo(Dat: THeadValue);
var i: integer;
    Ch: TChannelListItem;
begin
  ChannelList.Clear;
  for i := 1 to Dat.IntData['Count'] do begin
    Ch := TChannelListItem.Create;
    Ch.Name    := Dat[Format('CH%d_name', [i])];
    Ch.Ghost   := Dat[Format('CH%d_ghost', [i])];
    Ch.Info    := Dat[Format('CH%d_info', [i])];
    Ch.NoPost  := Dat[Format('CH%d_nopost', [i])] = '1';
    Ch.Members := Dat.IntData[Format('CH%d_count', [i])];
    Ch.WarnPost:= Dat[Format('CH%d_warnpost', [i])] = '1';
    ChannelList.Add(Ch);
  end;
  UpdateLayout;
end;

procedure TfrmSender.mnGetNewIdClick(Sender: TObject);
begin
  PostCommand(['Command: getNewId', 'Agent: ' + VersionString]);
end;

procedure TfrmSender.NoLuidError;
begin
  Beep;
  ShowMessage('SSTP Bottle ID̎擾܂Ă܂B'#13#10+
              'wvj[[LUID擾]ID擾ĂB'#13#10+
              '̑ClientN1񂾂KvłB');
end;

procedure TfrmSender.tabChannelChange(Sender: TObject);
begin
  if tabChannel.TabIndex >= 0 then begin
    FNowChannel := tabChannel.Tabs[tabChannel.TabIndex];
    actSend.Hint := Format('u%svɑM|%s', [FNowChannel, SendButtonLongHint]);
  end else begin
    FNowChannel := '';
    actSend.Hint := '';
  end;
  tabChannel.Repaint; //ꂪȂƐFςȂƂ
  ConstructMenu(true);
end;

procedure TfrmSender.actPrevChannelExecute(Sender: TObject);
begin
  with tabChannel do begin
    if Tabs.Count = 0 then Exit;
    if TabIndex=0 then TabIndex := Tabs.Count-1
    else TabIndex := TabIndex-1;
  end;
  tabChannelChange(Self);
end;

procedure TfrmSender.actNextChannelExecute(Sender: TObject);
begin
  with tabChannel do begin
    if Tabs.Count = 0 then Exit;
    if TabIndex=Tabs.Count-1 then TabIndex := 0
    else TabIndex := TabIndex+1;
  end;
  tabChannelChange(Self);
end;

procedure TfrmSender.UpdateJoinChannelList(Dat: THeadValue);
var i: integer;
    nodat: boolean;
begin
  nodat := Dat = nil; //nilȂ`lS
  if nodat then Dat := THeadValue.Create('');
  JoinChannels.Clear;
  for i := 0 to Dat.Count-1 do
    if Dat.KeyAt[i] = 'Entry' then begin
      if RegExp.Match('m/^(.+?) \((\d+?)\)$/', Dat.ValueAt[i]) then
        JoinChannels.Add(RegExp[1]);
    end;
  with tabChannel do begin
    OnChange := nil;
    JoinChannels.Sort;
    Tabs.BeginUpdate;
    Tabs.Clear;
    for i := 0 to JoinChannels.Count-1 do begin
      //Mp`l͕\Ȃ
      if ChannelList.Channel[JoinChannels[i]] <> nil then
        if not ChannelList.Channel[JoinChannels[i]].NoPost then
          Tabs.Add(JoinChannels[i]);
    end;
    Tabs.EndUpdate;
    // `lɎQĂꍇ
    // IĂ`lςȂ悤ɂ(^uȂ)
    TabIndex := 0;
    for i := 0 to Tabs.Count-1 do
      if Tabs[i] = FNowChannel then TabIndex := i;
    if Tabs.Count > 0 then begin
      FNowChannel := Tabs[TabIndex];
      actSend.Hint := Format('u%svɑM|%s', [FNowChannel, SendButtonLongHint]);
    end else begin
      FNowChannel := '';
      actSend.Hint := Format('M|%s', [SendButtonLongHint]);
    end;
    Visible := Tabs.Count > 0;
    if Tabs.Count > 1 then begin
      actNextChannel.Enabled := true;
      actPrevChannel.Enabled := true;
    end else begin
      actNextChannel.Enabled := false;
      actPrevChannel.Enabled := false;
    end;
    OnChange := tabChannelChange;
  end;
  if nodat then Dat.Free;
  if JoinChannels.Count = 0 then begin
    Self.Caption := FOriginalCaption + ' - `lɎQĂ܂';
    actSend.Enabled := false;
  end else begin
    Self.Caption := FOriginalCaption;
    actSend.Enabled := true;
  end;
end;

procedure TfrmSender.cbxTargetGhostDropDown(Sender: TObject);
begin
  SakuraSeeker.BeginDetect;
  UpdateIfGhostBox;
end;

procedure TfrmSender.actShowLogExecute(Sender: TObject);
begin
  frmLog.Show;
  if frmLog.WindowState = wsMinimized then frmLog.WindowState := wsNormal;
end;

procedure TfrmSender.actSleepExecute(Sender: TObject);
begin
  if actSleep.Checked then begin
    actSleep.Checked := false;
    ShowHintLabel('X[v܂');
  end else begin
    actSleep.Checked := true;
    ShowHintLabel('X[vݒ肵܂');
  end;
  Sleeping := actSleep.Checked;
  ChangeTaskIcon;
end;


procedure TfrmSender.DispatchBottle(EventType: TIdSlppEventType;
  Dat: THeadValue);
var Opt: TSstpSendOptions;
    Event: TBottleChainBottleEvent;
    Script, Sender, Ghost, Channel, ErrorMes: String;
    BreakFlag, NoDispatch: boolean;
    Sound, LogName: String;
    i, j, k, SkipCount: integer;
    Rule: TBottleChainRule;
    Action: TBottleChainAction;
    LogNameList: TStringList;
    CueItem: TLogItem;
    ReplaceHash: THeadValue; 
begin
  Channel := Dat['Channel'];

  Opt := [];
  if Pref.NoTranslate then Opt := Opt + [soNoTranslate];
  if Pref.NoDescript  then Opt := Opt + [soNoDescript];
  case EventType of
    etScript: Sender := Channel;
    etForceBroadcast: Sender := 'ym点z';
    etUnicast: Sender := Dat['SenderUID'];
  end;

  //ڕWS[Xg(I[o[ChȑO)
  if Dat['IfGhost'] <> '' then begin
    Ghost := Dat['IfGhost'];
  end else begin
    if ChannelList.Channel[Channel] <> nil then
      Ghost := ChannelList.Channel[Channel].Ghost;
  end;
  Dat['TargetGhost'] := Ghost;

  // ^
  ReplaceHash := THeadValue.Create;
  ReplaceHash['%channel%'] := SafeFileName(Dat['Channel']);
  ReplaceHash['%ghost%'] := SafeFileName(Dat['IfGhost']);
  ReplaceHash['%date%'] := FormatDateTime('yy-mm-dd', Now());
  ReplaceHash['%year%'] := FormatDateTime('yyyy', Now());
  ReplaceHash['%yy%'] := FormatDateTime('yy', Now());
  ReplaceHash['%month%'] := FormatDateTime('mm', Now());
  ReplaceHash['%day%'] := FormatDateTime('dd', Now());
  ReplaceHash['%hour%'] := FormatDateTime('hh', Now());
  ReplaceHash['%minute%'] := FormatDateTime('nn', Now());

  Event := TBottleChainBottleEvent.Create;
  try
    Event.Data := Dat;
    if EventType = etScript then Event.LogType := ltBottle
    else Event.LogType := ltSystemLog;

    //XNvgϊ
    Script := ScriptTransForSSTP(Dat['Script'], ErrorMes);
    if ErrorMes <> '' then begin
      frmLog.AddCurrentSystemLog('SYSTEM', '̂\̂XNvg͂߁A'+
                    'z܂ł@c '+Dat['Script']);
      Exit;
    end;

    BreakFlag := false;
    NoDispatch := false;
    Sound := '';
    LogNameList := TStringList.Create;
    SkipCount := 0;
    try
      for i := 0 to BottleChainRuleList.Count-1 do begin
        if SkipCount > 0 then begin
          Dec(SkipCount);
          Continue;
        end;
        Rule := BottleChainRuleList[i];
        if not Rule.Enabled then Continue;
        if not Rule.Check(Event) then Continue;
        for j := 0 to Rule.Actions.Count-1 do begin
          Action := (Rule.Actions[j] as TBottleChainAction);
          if Action is TBottleChainAbortRuleAction then
            BreakFlag := true;
          if Action is TBottleChainSkipRuleAction then
            SkipCount := (Action as TBottleChainSkipRuleAction).SkipCount;
          if (Action is TBottleChainSoundAction) and (Sound = '') then
          begin
            Sound := (Action as TBottleChainSoundAction).SoundFile;
            Sound := StringReplaceEx(Sound, ReplaceHash);
          end;
          if Action is TBottleChainNoDispatchAction then
            NoDispatch := true;
          if Action is TBottleChainLogAction then
          begin
            for k := 0 to (Action as TBottleChainLogAction).LogNames.Count-1 do begin
              LogName := (Action as TBottleChainLogAction).LogNames[k];
              LogName := StringReplaceEx(LogName, ReplaceHash);
              LogNameList.Add(LogName);
            end;
          end;
          if Action is TBottleChainOverrideGhostAction then
          begin
            Dat['TargetGhost'] := (Action as TBottleChainOverrideGhostAction).TargetGhost;
          end;
          if Action is TBottleChainQuitAction then
            Application.Terminate;
          if Action is TBottleChainSaveTextLogAction then
            AppendTextLog(StringReplaceEx((Action as TBottleChainSaveTextLogAction).FileName, ReplaceHash),
              Format('%s,%s,%s,%s', [Dat['Channel'], Dat['IfGhost'],
                FormatDateTime('yy/mm/dd hh:nn:ss', Now), Dat['Script']]));
          if Action is TBottleChainSaveXMLLogAction then
            AppendXMLLog(StringReplaceEx((Action as TBottleChainSaveXMLLogAction).FileName, ReplaceHash),
              Dat);
          if Action is TBottleChainSurfaceReplaceAction then
            Script := ReplaceSurface(Script, (Action as TBottleChainSurfaceReplaceAction).Params);
        end;
        if BreakFlag then Break;
      end;

      if Dat['Script'] <> '' then begin
        for i := 0 to LogNameList.Count-1 do
          frmLog.AddCurrentScriptLog(LogNameList[i], Dat['Script'], Sender, Dat['MID'], Dat['IfGhost']);
        if NoDispatch then begin
          frmLog.SetBottleState(Dat['MID'], lsOpened);
        end else begin
          Ghost := Dat['TargetGhost']; // I[o[ChĂ\
          CueItem := TLogItem.Create(ltBottle, Dat['MID'], Dat['Channel'],
            Script, Ghost, Now());
          try
            FBottleSstp.Push(CueItem);
          except
            CueItem.Free;
          end;
        end;
      end;

      if Dat['DialogMessage'] <> '' then begin
        Beep;
        frmMessageBox.ShowMessage(
          DateTimeToStr(Now) + #13#10 +
          'SSTP BottleT[o炨m点'#13#10+Dat['DialogMessage']);
        for i := 0 to LogNameList.Count-1 do
          frmLog.AddCurrentSystemLog(LogNameList[i], Dat['DialogMessage']);
      end;

      //̍Đ
      if (Sound <> '') then PlaySound(Sound);
    finally
      LogNameList.Free;
    end;
  finally
    Event.Free;
    ReplaceHash.Free;
  end;
end;

procedure TfrmSender.YenETrans;
var St, Le, i: integer;
    Orig, Text: String;
begin
  St := memScript.SelStart;
  Le := memScript.SelLength;
  Orig := GetScriptText;
  RegExp.Subst('s/(\r\n)+$//kg', Orig);

  with SsParser do begin
    LeaveEscape := true;
    EscapeInvalidMeta := false;
    InputString := Orig;
  end;
  for i := 0 to SsParser.Count-1 do begin
    if SsParser[i] <> '\e' then Text := Text + SsParser[i];
  end;

  Text := Text + '\e';

  if Orig <> Text then memScript.Lines.Text := Text;
  SsParser.InputString := Text;

  RegExp.Subst('s/\r\n//kg', Text);
  memScript.SetFocus;
  memScript.SelStart := St;
  memScript.SelLength := Le;
end;

procedure TfrmSender.PostCommand(const Command: array of String);
var PostStr: TStringList;
    i: integer;
begin
  PostStr := nil;
  try
    PostStr := TStringList.Create;
    for i := Low(Command) to High(Command) do begin
      PostStr.Add(Command[i]);
    end;
    PostCommand(PostStr);
  finally
    PostStr.Free;
  end;
end;

procedure TfrmSender.PostCommand(Command: TStrings);
var PostStr: String;
begin
  Connecting := true;
  PostStr := Command.Text;
  PostStr := ParamsEncode(PostStr);
  try
    FHttp := THTTPDownloadThread.Create(Pref.BottleServer, Pref.CgiName, PostStr);
    if Pref.UseHttpProxy then begin
      FHttp.ProxyServer := Pref.ProxyAddress;
      FHttp.ProxyPort   := Pref.ProxyPort;
      if Pref.ProxyNeedAuthentication then begin
        FHttp.ProxyUser := Pref.ProxyUser;
        FHttp.ProxyPass := Pref.ProxyPass;
      end;
    end;
    FHttp.OnSuccess := HttpSuccess;
    FHttp.OnConnectionFailed := HttpFailure;
    FHttp.FreeOnTerminate := true; // ɎFreeĂ
    FHTTP.Resume;
  except
    on EHeapException do begin
      Connecting := false;
      FHttp.Free;
    end;
  end;
end;

procedure TfrmSender.actVoteMessageExecute(Sender: TObject);
var Log: TLogItem;
begin
  if frmLog.lvwLog.ItemIndex < 0 then Exit;
  Log := frmLog.SelectedBottleLog[frmLog.lvwLog.ItemIndex] as TLogItem;
  if Log = nil then Exit;
  if Log.LogType <> ltBottle then Exit;
  PostCommand([
    'Command: voteMessage',
    'VoteType: Vote',
    'LUID: ' + Pref.LUID,
    'MID: ' + Log.MID
  ]);
end;


procedure TfrmSender.actAgreeMessageExecute(Sender: TObject);
var Log: TLogItem;
begin
  if frmLog.lvwLog.ItemIndex < 0 then Exit;
  Log := frmLog.SelectedBottleLog[frmLog.lvwLog.ItemIndex] as TLogItem;
  if Log = nil then Exit;
  if Log.LogType <> ltBottle then Exit;
  PostCommand([
    'Command: voteMessage',
    'VoteType: Agree',
    'LUID: ' + Pref.LUID,
    'MID: ' + Log.MID
  ]);
end;


function TfrmSender.GhostNameToSetName(const Ghost: String): String;
begin
  if SakuraSeeker.ProcessByName[Ghost] <> nil then
    Result := SakuraSeeker.ProcessByName[Ghost].SetName
  else
    Result := '';
end;

procedure TfrmSender.tabChannelContextPopup(Sender: TObject;
  MousePos: TPoint; var Handled: Boolean);
var Ch: String;
begin
  with tabChannel do begin
    Tag := IndexOfTabAt(MousePos.X, MousePos.Y);
    if Tag < 0 then Handled := true;
    Ch := Tabs[Tag];
  end;
end;

procedure TfrmSender.PostSetChannel(Channels: TStrings);
var PostStr: TStringList;
    i: integer;
begin
  PostStr := TStringList.Create;
  try
    with PostStr do begin
      Add('Command: setChannels');
      Add('Agent: ' + VersionString);
      Add('LUID: ' + Pref.LUID);
      if Channels <> nil then
        for i := 0 to Channels.Count-1 do begin
          Add(Format('Ch%d: %s'#13#10, [i+1, Channels[i]]));
        end;
    end;
    PostCommand(PostStr);
  finally
    PostStr.Free;
  end;
end;

procedure TfrmSender.mnLeaveThisChannelClick(Sender: TObject);
var Ch: String;
    Chs: TStringList;
begin
  // w肵`l甲
  with tabChannel do
    Ch := Tabs[Tag]; // `l
  Chs := TStringList.Create;

  // ݎQ̃`lA`l
  // OXgŁAVɃ`lQR}h𑗂
  try
    Chs.Assign(JoinChannels);
    while Chs.IndexOf(Ch) >= 0 do
      Chs.Delete(Chs.IndexOf(Ch));
    PostSetChannel(Chs);
  finally
    Chs.Free;
  end;
end;

procedure TfrmSender.mnGotoVoteClick(Sender: TObject);
begin
  OpenBrowser(Pref.VotePage);
end;

procedure TfrmSender.tabChannelMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var Index: integer;
    Ch: String;
begin
  with tabChannel do begin
    Index := IndexOfTabAt(X, Y);
    Ch := Tabs[Index];
    Hint := Ch + ': ' + IntToStr(ChannelList.Channel[Ch].Members) + 'l';
  end;
end;

procedure TfrmSender.mnGoToHelpClick(Sender: TObject);
begin
  OpenBrowser(Pref.HelpPage);
end;

procedure TfrmSender.tabChannelMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var Index: integer;
begin
  with tabChannel do begin
    Index := IndexOfTabAt(X, Y);
    if Index = -1 then Exit; //^uȂ̂ŃhbOłȂ
    if Button = mbLeft then begin
      FDragTabIndex := Index; //hbO^ũCfbNXۑ
      BeginDrag(False);
      FDragTabDest := -1;     //hbOg`tONÂ
    end;
  end;
end;

procedure TfrmSender.tabChannelDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
var TargetRect: TRect;
    OldDest: integer;
begin
  Accept := Source = tabChannel;
  if not Accept then Exit;
  with tabChannel do begin
    OldDest := FDragTabDest;
    FDragTabDest := IndexOfTabAt(X, Y);
    if FDragTabDest = -1 then begin
      Accept := false; //̏ꍇ̓hbvF߂Ȃ
      Exit;
    end;
    with Canvas do begin
      Pen.Mode := pmNot;
      Pen.Width := 3;
    end;
    if (OldDest <> FDragTabDest) and (OldDest >= 0) then begin
      //ȑO̘g
      TargetRect := TabRect(OldDest);
      with Canvas do begin
        Brush.Style := bsClear;
        Rectangle(TargetRect.Left, TargetRect.Top,
                  TargetRect.Right, TargetRect.Bottom);
      end;
    end;
    if (OldDest <> FDragTabDest) then begin
      //Vg`
      TargetRect := TabRect(FDragTabDest);
      with Canvas do begin
        Brush.Style := bsClear;
        Rectangle(TargetRect.Left, TargetRect.Top,
                  TargetRect.Right, TargetRect.Bottom);
      end;
    end;
  end;
end;

procedure TfrmSender.tabChannelDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var DestIndex: integer;
begin
  with tabChannel do begin
    DestIndex := IndexOfTabAt(X, Y);
    Tabs.Move(FDragTabIndex, DestIndex);
  end;
end;

procedure TfrmSender.tabChannelEndDrag(Sender, Target: TObject; X,
  Y: Integer);
begin
  //IɃ^uĕ`悳Bg΍
  tabChannel.Tabs.BeginUpdate;
  tabChannel.Tabs.EndUpdate;
end;

procedure TfrmSender.cbxTargetGhostDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var AlignRight: boolean;
    w: integer;
begin
  //S[XgI{bNX̃I[i[h[
  with cbxTargetGhost do begin
    AlignRight := false;
    if Pref.HideGhosts and not FTargetGhostExpand and
       (Index = Items.Count-1) and (Index > 0) then
    begin
      // uׂĕ\v
      Canvas.Font.Color := clWindowText;
      Canvas.Font.Style := [];
      AlignRight := true;
    end else if (Index > 0) then
    begin
      // S[XgI
      if SakuraSeeker.ProcessByName[Items[Index]] = nil then
        Canvas.Font.Color := clRed // ݂ȂS[Xg
      else
        Canvas.Font.Color := clBlue; // ݂S[Xg
      Canvas.Font.Style := [fsBold];
    end else
    begin
      Canvas.Font.Color := clWindowText;
      Canvas.Font.Style := [];
    end;
    if odSelected in State then
      Canvas.Font.Color := clHighlightText;
    // `
    if AlignRight then
    begin
      w := Canvas.TextWidth(cbxTargetGhost.Items[Index]);
      Canvas.TextRect(Rect, Rect.Right - w, Rect.Top,
        cbxTargetGhost.Items[Index]);
    end else
      Canvas.TextRect(Rect, Rect.Left, Rect.Top,
        cbxTargetGhost.Items[Index]);
  end;
end;

procedure TfrmSender.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  if (not Pref.ConfirmOnExit) or FEndSession then
    Exit;
  if MessageDlg('SSTP Bottle ClientI܂', mtConfirmation,
                mbOkCancel, 0) = mrCancel then
    CanClose := false;
end;

procedure TfrmSender.UpdateIfGhostBox;
var
  Selected: String;
  i: integer;
  HiddenCount: integer;
begin
  cbxTargetGhost.DropDownCount := Pref.GhostDropDownCount;
  Selected := cbxTargetGhost.Text;
  HiddenCount := 0;
  with cbxTargetGhost do begin
    Items.BeginUpdate;
    Items.Clear;
    Items.Add(ChannelDefault);
    for i := 0 to SakuraSeeker.Count-1 do begin
      // jFMO΍BHWND̒fЂcĂ邪NameĂꍇ
      if Length(SakuraSeeker[i].Name) = 0 then Continue;
      if Pref.HideGhosts and not FTargetGhostExpand then
        if Pref.VisibleGhostsList.IndexOf(SakuraSeeker[i].Name) < 0 then
        begin
          Inc(HiddenCount);
          Continue;
        end;
      if cbxTargetGhost.Items.IndexOf(SakuraSeeker[i].Name) < 0 then
        cbxTargetGhost.Items.Add(SakuraSeeker[i].Name);
    end;
    cbxTargetGhost.ItemIndex := 0;
    if (Length(Selected) > 0) and (Selected <> ChannelDefault) then begin
      with cbxTargetGhost do begin
        for i := 1 to Items.Count-1 do begin
          if Items[i] = Selected then
            ItemIndex := i;
        end;
        //S[XgˑR݂ȂȂꍇ΍
        if ItemIndex = 0 then begin
          Items.Add(Selected);
          ItemIndex := Items.Count - 1;
        end;
      end;
    end;
    if Pref.HideGhosts and not FTargetGhostExpand then
      Items.Add(Format('ׂ(%d)...', [HiddenCount]));
    Items.EndUpdate;
  end;
end;

procedure TfrmSender.HTTPFailure(Sender: TObject);
begin
  SysUtils.Beep;
  Beep;
  ShowHintLabel('SSTP BottleT[oƂ̐ڑɎs܂', WarningColor);
  frmMessageBox.ShowMessage('SSTP BottleT[oƂ̐ڑɎs܂'#13#10 +
    (Sender as THTTPDownloadThread).LastErrorMessage);
  Connecting := false;
end;

procedure TfrmSender.actPrevGhostExecute(Sender: TObject);
var i: integer;
begin
  SakuraSeeker.BeginDetect;
  UpdateIfGhostBox;
  i := cbxTargetGhost.ItemIndex;
  Dec(i);
  if i <= -1 then
  begin
    i := cbxTargetGhost.Items.Count-1;
    if Pref.HideGhosts and not FTargetGhostExpand then
      i := i - 1;
  end;
  cbxTargetGhost.ItemIndex := i;
  cbxTargetGhostChange(self);
end;

procedure TfrmSender.actNextGhostExecute(Sender: TObject);
var i: integer;
begin
  SakuraSeeker.BeginDetect;
  UpdateIfGhostBox;
  i := cbxTargetGhost.ItemIndex;
  Inc(i);
  if Pref.HideGhosts and not FTargetGhostExpand then
  begin
    if  i > cbxTargetGhost.Items.Count-2 then i := 0;
  end else
  begin
    if  i > cbxTargetGhost.Items.Count-1 then i := 0;
  end;
  cbxTargetGhost.ItemIndex := i;
  cbxTargetGhostChange(self);
end;

procedure TfrmSender.actResetGhostExecute(Sender: TObject);
begin
  cbxTargetGhost.ItemIndex := 0; // (CH)ɖ߂
  FTargetGhostExpand := false;
  if Visible then memScript.SetFocus;
  cbxTargetGhostChange(self);
end;

procedure TfrmSender.timDisconnectCheckTimerTimer(Sender: TObject);
begin
  if (IdSlpp20.LastReadTimeInterval > Pref.ReconnectWait * 60000) then begin
    SysUtils.Beep;
    frmLog.AddCurrentSystemLog('SYSTEM', 'SSTP BottleT[oƂ̐ڑ^CAEg܂');
    if IdSlpp20.Connected then IdSlpp20.Disconnect;
  end;
  if not IdSlpp20.Connected then begin
    if Added then begin
      Slpp20Disconnect(self); //ȂDisconnectCxgN炸ɐؒfꍇ
    end else begin
      //ؒf܂܍ĐڑłuĂꍇ莞ԒuɍĐڑgC
      //񐔐
      RetryBeginConnect;
    end;
  end;
end;

procedure TfrmSender.RetryBeginConnect;
begin
  if FBeginConnectFailCount < 3 then begin
    // ؒfĂ΍Đڑ
    IdSlpp20.OnDisconnect := nil;
    if IdSlpp20.Connected then IdSlpp20.Disconnect;
    FAutoAddAfterGetChannel := true;
    BeginConnect;
    IdSlpp20.OnDisconnect := Slpp20Disconnect;
  end else if FBeginConnectFailCount = 3 then begin
    frmLog.AddCurrentSystemLog('SYSTEM', 'ĐڑgC𒆎~܂');
    frmMessageBox.ShowMessage(
      'SSTP BottleT[oɐڑł܂B'#13#10+
      'lbg[NɐڑĂ邱ƂmFŁA`lQ{^ĂB'#13#10+
      'SSTP BottleT[o_EĂꍇ́A΂炭ĂĐڑĂB'
    );
    Inc(FBeginConnectFailCount);
  end;
end;

procedure TfrmSender.actDownloadLogExecute(Sender: TObject);
var BottleLog: TBottleLogList;
    Title: String;
    Cond: TBottleLogDownloadCondition;
    NewIndex: integer;
  function TimeStr(Mins: integer): String;
  var day, hour, min: integer;
  begin
    day := Mins div (60 * 24);
    hour := (Mins div 60) mod 24;
    min := Mins mod 60;
    Result := '';
    if day  > 0 then Result := Result + Format('%d', [day]);
    if hour > 0 then Result := Result + Format('%d', [hour]);
    if (min  > 0) or (Result = '') then Result := Result + Format('%d', [min]);
  end;
begin
  Application.CreateForm(TfrmLogDownload, frmLogDownload);
  try
    if frmLogDownload.Execute then begin
      with frmLogDownload do begin
        if IsRange then begin
          if CompareDate(DateLo, DateHi) = 0 then
            Title := FormatDateTime('yy-mm-dd', DateLo)
          else
            Title := FormatDateTime('yy-mm-dd', DateLo) + ' - ' + FormatdateTime('yy-mm-dd', DateHi);
        end else begin
          Title := Format('ߋ%s', [TimeStr(RecentCount)]);
        end;
        if Channel <> '' then Title := Title + '(' + Channel + ')';
      end;
      BottleLog := TBottleLogList.Create(Title);
      try
        BottleLog.OnLoaded := frmLog.LogLoaded;
        BottleLog.OnLoadFailure := frmLog.LogLoadFailure;
        BottleLog.OnLoadWork := frmLog.LogLoadWork;
        with frmLogDownload do begin
          Cond.IsRange := IsRange;
          Cond.RecentCount := RecentCount;
          Cond.DateLo := DateLo;
          Cond.DateHi := DateHi;
          Cond.MinVote := MinVote;
          Cond.MinAgree := MinAgree;
          Cond.Channel := Channel;
        end;
        BottleLog.LoadFromWeb(Cond);
      except
        FreeAndNil(BottleLog);
      end;
      if BottleLog <> nil then begin
        NewIndex := frmLog.BottleLogList.Add(BottleLog);
        frmLog.UpdateTab;
        frmLog.tabBottleLog.TabIndex := NewIndex;
        frmLog.UpdateWindow;
      end;
    end;
  finally
    frmLogDownload.Release;
  end;
end;

function TfrmSender.BuildMenuConditionCheck(const IfGhost,
  Ghost: String): boolean;
var i: integer;
    Cond: String;
begin
  i := 0;
  Result := true;
  repeat
    Cond := Token(IfGhost, ',', i);
    if Cond <> '' then begin
      if Cond[1] = '!' then begin
        Cond := Copy(Cond, 2, High(integer));
        if Cond = Ghost then Result := false;
      end else begin
        if Cond <> Ghost then Result := false;
      end;
    end;
    Inc(i);
  until Cond = '';
end;

procedure TfrmSender.BuildMenu(Root: TMenuItem; Simple: boolean);
var i, j, k, count: integer;
    ConstData: TScriptConst;
    Menu1, Menu2: TMenuItem;
    Ghost: String;
begin
  // Simple = false ̏ꍇ̓j[Sɍč\zB
  // Simple = true ̏ꍇ̓S[Xg֌Ŵݍč\ẑōB
  if cbxTargetGhost.ItemIndex > 0 then Ghost := cbxTargetGhost.Text
  else if FNowChannel <> '' then Ghost := ChannelList.Channel[FNowChannel].Ghost;

  // ̃j[폜
  if Simple then begin
    // IfGhosttj[̂ݍ폜
    for i := Root.Count-1 downto 0 do begin
      if ScriptConstList.GetMenuByID(Root.Items[i].Tag).IfGhost <> '' then
        Root.Items[i].Free;
    end;
  end else
    // S폜
    Root.Clear;

  count := -1;
  for i := 0 to ScriptConstList.Count-1 do begin
    for j := 0 to ScriptConstList[i].Count-1 do begin
      // S[XgႢ̏ꍇ̓XLbv
      if not BuildMenuConditionCheck(ScriptConstList[i][j].IfGhost, Ghost) then Continue;
      Inc(count);
      // Simplȅꍇ͊ɊYj[݂邱Ƃ̂ŃXLbv
      if Simple and (count < Root.Count) then
        if (Root.Items[count].Tag = ScriptConstList[i][j].ID) then begin
          Continue;
        end;

      Menu1 := TMenuItem.Create(Root);
      with Menu1 do
      begin
        Caption := ScriptConstList[i][j].Caption;
        Hint    := ScriptConstList[i][j].Caption;
        AutoHotkeys := maManual;
        Tag := ScriptConstList[i][j].ID;
        OnClick := mnConstGroupClick;
      end;

      if not Simple then begin
        Root.Add(Menu1);
      end else begin
        if count < Root.Count-1 then
          Root.Insert(count, Menu1)
        else
          Root.Add(Menu1);
      end;

      Menu1.Enabled := ScriptConstList[i][j].Count > 0;
      for k := 0 to ScriptConstList[i][j].Count-1 do begin
        ConstData := ScriptConstList[i][j][k];
        Menu2 := TMenuItem.Create(Root);
        Menu2.Caption := ConstData.Caption;
        Menu2.Hint := ConstData.ConstText;
        // if ConstData.ShortCut <> 0 then Menu2.Hint := Menu2.Hint
        //   + ' (' + ShortCutToText(ConstData.ShortCut) + ')';
        // T[tBXvr[̂ߏ폜
        Menu2.ShortCut := ConstData.ShortCut;
        Menu2.OnClick := mnConstClick;
        Menu2.AutoHotkeys := maManual;
        Menu2.Tag := ConstData.ID;
        if (k mod 15 = 0) and (k > 0) then Menu2.Break := mbBarBreak;
        Menu1.Add(Menu2);
      end;
    end;
  end;
end;

procedure TfrmSender.cbxTargetGhostChange(Sender: TObject);
begin
  // uׂĕ\vIꂽꍇ̓S[XgI{bNXč\z
  if Pref.HideGhosts and not FTargetGhostExpand then
  begin
    with cbxTargetGhost do
    begin
      // ԉ̃ACeIꂽƂB
      // ItemIndex=0̏ꍇ(S[XgNĂȂꍇ)͗O
      if (ItemIndex = Items.Count-1) and (ItemIndex > 0) then
      begin
        FTargetGhostExpand := true;
        UpdateIfGhostBox;
        ItemIndex := 0;
        DroppedDown := true;
      end;
    end;
  end;
  // ^僁j[č\z
  ConstructMenu(true);
  // vr[ꍇ̓vr[
  EditorPreview;
end;

procedure TfrmSender.PlaySound(const FileName: String);
begin
  if Pref.SilentWhenHidden and not Application.ShowMainForm then Exit;
  try
    MediaPlayer.FileName := FileName;
    MediaPlayer.Open;
    MediaPlayer.Play;
  except
    on E: EMCIDeviceError do begin
      ShowMessage('TEhĐG[:'#13#10 + FileName + #13#10#13#10 + E.Message);
    end;
  end;
end;

procedure TfrmSender.actFMOExplorerExecute(Sender: TObject);
begin
  try
    if not Assigned(frmFMOExplorer) then
      Application.CreateForm(TfrmFMOExplorer, frmFMOExplorer);
  except
    on E: Exception do
      ShowMessage('FMOGNXv[\ł܂B'#13#10#13#10 +
        E.Message);
  end;
  frmFMOExplorer.Show;
end;

procedure TfrmSender.SaveChainRuleList;
var Str: TStringList;
begin
  Str := TStringList.Create;
  try
    Str.Text := ComponentToString(BottleChainRuleList);
    Str.SaveToFile(ExtractFileDir(Application.ExeName)+'\rule.txt');
  finally
    Str.Free;
  end;
end;

procedure TfrmSender.BottleSstpResendEnd(Sender: TObject; MID: String);
begin
  frmLog.SetBottleState(MID, lsOpened);
end;

procedure TfrmSender.BottleSstpResendTrying(Sender: TObject; MID: String);
begin
  frmLog.SetBottleState(MID, lsPlaying);
end;

procedure TfrmSender.actInsertCueExecute(Sender: TObject);
var InsertItem: TLogItem;
    i, errCount, Res: integer;
    Log: TBottleLogList;
    ErrorMes: String; // XNvg̃G[̓e
begin
  if FBottleSstp.CueCount > 0 then begin
    if MessageDlg(Format('ݍđL[ɓĂ%d̖z{gNAāA'+
      'OEBhEɂ{gAĐ܂B'#13#10+
      'VbZ[W͂̌ɍĐ܂B', [FBottleSstp.CueCount]),
      mtWarning, mbOkCancel, 0) = mrCancel then Exit;
  end;
  FBottleSstp.Clear;
  frmLog.AllBottleOpened;
  if frmLog.lvwLog.ItemIndex < 0 then Exit;
  Log := frmLog.SelectedBottleLog;
  if Log = nil then Exit;
  FBottleSSTP.OnResendCountChange := nil;
  errCount := 0;
  for i := frmLog.lvwLog.ItemIndex downto 0 do begin
    if (Log[i] as TLogItem).LogType <> ltBottle then Continue;
    InsertItem := TLogItem.Create(Log[i] as TLogItem);
    try
      InsertItem.Script := ScriptTransForSSTP(InsertItem.Script, ErrorMes);
      if ErrorMes <> '' then
      begin
        Res := MessageDlg('XNvgɖ肪\܂B' +
          'Đ܂?'#13#10 + ErrorMes, mtWarning,
          mbYesNoCancel, 0);
        if Res = mrNo then
          raise Exception.Create('Script Syntax Error')
        else if Res = mrCancel then
        begin
          InsertItem.Free;
          FBottleSstp.Clear;
          frmLog.AllBottleOpened;
          Break;
        end;
      end;
      if InsertItem.Ghost = '' then begin
        if ChannelList.Channel[InsertItem.Channel] <> nil then
        InsertItem.Ghost := ChannelList.Channel[InsertItem.Channel].Ghost;
      end;
      FBottleSSTP.Push(InsertItem);
      frmLog.SetBottleState(InsertItem.MID, lsUnopened);
    except
      InsertItem.Free;
      Inc(errCount);
    end;
  end;
  if errCount > 0 then
    ShowMessage(Format('%d̃{gɖ肪ߍĐł܂B', [errCount]));
  FBottleSSTP.OnResendCountChange := BottleSstpResendCountChange;
  BottleSstpResendCountChange(self);
  frmLog.lvwLog.Invalidate;
end;

function TfrmSender.ScriptTransForSSTP(const Script: String;
  out Error: String): String;
var TransOpt: TScriptTransOptions;
begin
  if Pref.NoTransURL then
    TransOpt := [toConvertURL, toNoChoice, toWaitScriptEnd]
  else
    TransOpt := [toConvertURL, toWaitScriptEnd];
  if Pref.IgnoreFrequentYenS then TransOpt := TransOpt + [toIgnoreFrequentYenS];
  if Pref.FixMessySurface then TransOpt := TransOpt + [toFixMessySurface];
  if Pref.HUTagTo01Tag then TransOpt := TransOpt + [toHUTagTo01Tag];
  Result := Script;
  Error := DoTrans(Result, TransOpt);
end;

procedure TfrmSender.FormResize(Sender: TObject);
var w, SelS, SelL: integer;
begin
  // GfB^[̃[hbv𒲐
  if memScript.ColWidth <> 0 then
  begin
    with memScript do
    begin
      SelS := SelStart;
      SelL := SelLength;
      w := Width - LeftMargin - ColWidth div 2;
      if ScrollBars in [ssVertical, ssBoth] then
        w := w - GetSystemMetrics(SM_CYVSCROLL);
      WrapOption.WrapByte := w div ColWidth;
      SelStart  := SelS;
      SelLength := SelL;
    end;
  end;
end;

procedure TfrmSender.actCopyExecute(Sender: TObject);
begin
  memScript.CopyToClipboard;
end;

procedure TfrmSender.actPasteExecute(Sender: TObject);
begin
  memScript.PasteFromClipboard;
end;

procedure TfrmSender.actCutExecute(Sender: TObject);
begin
  memScript.CutToClipboard;
end;

procedure TfrmSender.actSelectAllExecute(Sender: TObject);
begin
  memScript.SelectAll;
end;

procedure TfrmSender.actUndoExecute(Sender: TObject);
begin
  memScript.Undo;
end;

procedure TfrmSender.actRedoExecute(Sender: TObject);
begin
  memScript.Redo;
end;

function TfrmSender.IsSurfaceTag(const Script: String;
  var ID: integer): boolean;
begin
  Result := false;
  if SsParser.Match(Script, '\s%d') = 3 then
  begin
    Result := true;
    ID := Ord(Script[3]) - Ord('0')
  end
  else if (Length(Script) > 0) and (SsParser.Match(Script, '\s[%D]') = Length(Script)) then
  begin
    Result := true;
    ID := StrToIntDef(SsParser.GetParam(Script, 1), 0);
  end;
end;

procedure TfrmSender.memScriptMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var id: integer;
    token: String;
begin
  // ҏWEBhEŃ}EX|CgƃT[tBXvr[
  if not Pref.SurfacePreviewOnScriptPoint then
    Exit;
  token := memScript.TokenStringFromPos(Point(X, Y));
  if IsSurfaceTag(token, id) then
  begin
    DoSurfacePreview(id, spEditor);
  end else
  begin
    frmSurfacePreview.HideAway;
  end;
end;

procedure TfrmSender.DoSurfacePreview(Surface: integer;
  const Kind: TSurfacePreviewType);
var Ghost: String;
    Bmp: TBitmap;
    CPos: TPoint;
begin
  if cbxTargetGhost.ItemIndex > 0 then
    ghost := cbxTargetGhost.Text
  else if FNowChannel <> '' then
    ghost := ChannelList.Channel[FNowChannel].Ghost;

  // d\̗}
  if (FVisiblePreviewGhost = Ghost) and (FVisiblePreviewSurface = Surface) and
    not (frmSurfacePreview.IsHidden) then
  begin
    Exit;
  end;

  if ghost <> '' then
  begin
    Bmp := TBitmap.Create;
    try
      if Spps.TryGetImage(ghost, Surface, Bmp) then
      begin
        case Kind of
          spHint:
            CPos := GetSurfacePreviewPositionHint(Bmp.Width, Bmp.Height);
          spEditor:
            CPos := GetSurfacePreviewPositionScriptPoint(Bmp.Width, Bmp.Height);
          else
            CPos := Point(0, 0);
        end;
        frmSurfacePreview.ShowPreview(Bmp, CPos.X, CPos.Y);
        FVisiblePreviewGhost := Ghost;
        FVisiblePreviewSurface := Surface;
      end else
        frmSurfacePreview.HideAway;
    finally
      Bmp.Free;
    end;
  end;
end;

function TfrmSender.GetSurfacePreviewPositionHint(w, h: integer): TPoint;
{var MousePoint: TPoint;
    MenuRect: TRect;}
begin
  // T[tBXvr[EBhE̕\ʒu肷
  // MEBhËʒuɂĂ͖ȂƂɃj[\Ă̂
  // ĊO₱
  {GetCursorPos(MousePoint);
  OutputDebugString(PChar(IntToStr(FVisibleMenuItem.Count)));
  //if GetMenuItemRect(Self.Handle, FVisibleMenuItem.Items[0].Handle, 1, MenuRect) then ;
  Result := Point(MenuRect.Left-10, MenuRect.Top-10);}
  Result := GetSurfacePreviewPositionScriptPoint(w, h);
end;

function TfrmSender.GetSurfacePreviewPositionScriptPoint(w, h: integer): TPoint;
var MousePoint: TPoint;
begin
  GetCursorPos(MousePoint);
  case Pref.SurfacePreviewOnScriptPointPosition of
    spspMainWindowRight:
      Result := Point(Self.Left + Self.Width, MousePoint.Y);
  else
      Result := Point(Self.Left - w, MousePoint.Y);
  end;
end;

procedure TfrmSender.mnConstGroupClick(Sender: TObject);
begin
  if (Sender is TMenuItem) then
    FVisibleMenuItem := Sender as TMenuItem;
end;

procedure TfrmSender.actRecallScriptBufferExecute(Sender: TObject);
begin
  if FScriptBuffer.Count = 0 then
    Exit;
  memScript.Lines.Assign(FScriptBuffer[0] as TStringList);
  memScriptChange(Self);
  ShowHintLabel('XNvgĂяo܂');
end;

procedure TfrmSender.EditorPreview;
var Ghost, Script: String;
begin
  if frmEditorTalkShow <> nil then
    if frmEditorTalkShow.Visible then
    begin
      Script := StringReplace(GetScriptText, #13#10, '', [rfReplaceAll]);
      Ghost := '';
      if cbxTargetGhost.ItemIndex > 0 then
        Ghost := cbxTargetGhost.Text
      else if FNowChannel <> '' then
        Ghost := ChannelList.Channel[FNowChannel].Ghost;
      frmEditorTalkShow.TalkShowFrame.View(Script, Ghost);
    end;
end;

procedure TfrmSender.actEditorPreviewExecute(Sender: TObject);
begin
  if frmEditorTalkShow <> nil then
    frmEditorTalkShow.Show
  else
  begin
    Application.CreateForm(TfrmEditorTalkShow, frmEditorTalkShow);
    frmEditorTalkShow.TalkShowFrame.SetPreviewFont(memScript.Font);
    frmEditorTalkShow.Show;
  end;
  Pref.ShowEditorPreviewWindow := True;
  EditorPreview;
end;

// vOCZbg
procedure TfrmSender.actResetPluginsExecute(Sender: TObject);
begin
  Spps.ClearImagePool;
  Spps.LoadFromDirectory(FSppDir);
end;

procedure TfrmSender.IdSLPP20Connect(Sender: TObject);
begin
  ShowHintLabel('SSTP BottleT[o܂');
end;

// XNvg̃^Ou
// TCYς̔zp[^
function TfrmSender.TagReplace(Script: String; Before,
  After: array of String): String;
var BeforeList, AfterList: TStringList;
    i: integer;
begin
  BeforeList := TStringList.Create;
  AfterList  := TStringList.Create;
  try
    for i := Low(Before) to High(Before) do
      BeforeList.Add(Before[i]);
    for i := Low(After) to High(After) do
      AfterList.Add(After[i]);
    Result := TagReplace(Script, BeforeList, AfterList);
  finally
    BeforeList.Free;
    AfterList.Free;
  end;
end;

// XNvg̃^Ou
// StringReplaceƈĐmɃ^OɃ}b`A
// ܂p^[𕡐wł(ǔʂ܂uꂽ肵Ȃ)
function TfrmSender.TagReplace(Script: String; Before,
  After: TStrings): String;
var i, j: integer;
    Flag, OldLeaveEscape, OldEscapeInvalidMeta: boolean;
    OldStr: String;
begin
  Result := '';
  with SsParser do
  begin
    OldStr := InputString;
    OldLeaveEscape := LeaveEscape;
    OldEscapeInvalidMeta := EscapeInvalidMeta;
    LeaveEscape := true;
    EscapeInvalidMeta := false;
    InputString := Script;
  end;
  for i := 0 to SsParser.Count-1 do
  begin
    Flag := false;
    for j := 0 to Before.Count-1 do
    begin
      if (SsParser.MarkUpType[i] = mtTag) and (SsParser[i] = Before[j]) then
      begin
        Flag := true;
        Result := Result + After[j];
      end;
    end;
    if not Flag then
      Result := Result + SsParser[i];
  end;
  with SsParser do
  begin
    LeaveEscape := OldLeaveEscape;
    EscapeInvalidMeta := OldEscapeInvalidMeta;
    InputString := OldStr;
  end;
end;

// WndProcI[o[ChāAFWM_TaskBarCraeted
// Ή
procedure TfrmSender.WndProc(var Message: TMessage);
begin
  if (Message.Msg = FWM_TaskBarCreated) and (FWM_TaskBarCreated <> 0) then
  begin
    TaskTray.Registered := false; // TTaskTrayɃ^XNgCƂ
                                  // CÂ
    ChangeTaskIcon;
  end
  else
    inherited;
end;

// u
procedure TfrmSender.actReplaceExecute(Sender: TObject);
var
  Form: TfrmStrReplaceDialog;
  Lines: String;
  Options: TReplaceFlags;
begin
  Application.CreateForm(TfrmStrReplaceDialog, Form);
  try
    if Form.Execute then
    begin
      with Form.Pair do
      begin
        Lines := memScript.Lines.Text;
        Options := [rfReplaceAll];
        if IgnoreCase then
          Options := Options + [rfIgnoreCase];
        if UseRegExp then
          Lines := StringReplaceRegExp(Lines, BeforeStr, AfterStr, Options)
        else
          Lines := StringReplace(Lines, BeforeStr, AfterStr, Options);
      end;
      if Lines <> memScript.Lines.Text then
      begin
        memScript.SelectAll;
        memScript.SelText := Lines;
      end;
    end;
  finally
    Form.Release;
  end;
end;

procedure TfrmSender.actSendToEditorExecute(Sender: TObject);
var Log: TLogItem;
begin
  if frmLog.lvwLog.ItemIndex < 0 then Exit;
  Log := frmLog.SelectedBottleLog[frmLog.lvwLog.ItemIndex] as TLogItem;
  if Log = nil then Exit;
  CopyFromLogToEditor(Log);
end;

procedure TfrmSender.actSendToLogWindowExecute(Sender: TObject);
var Ghost, Script: String;
begin
  YenETrans;
  Script := StringReplace(GetScriptText, #13#10, '', [rfReplaceAll]);
  if cbxTargetGhost.ItemIndex > 0 then
    Ghost := cbxTargetGhost.Text
  else
    Ghost := '';
  frmLog.AddCurrentScriptLog('Nbv', Script, ClipChannel, '', Ghost);
  ClearEditor;
end;

procedure TfrmSender.memScriptDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  // OEBhẼOACe̒D&D
  if Source is TBottleLogDragObject then
    Accept := (Source as TBottleLogDragObject).LogItem.LogType = ltBottle
end;

procedure TfrmSender.memScriptDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var Src: TBottleLogDragObject;
    Log: TLogItem;
begin
  // OEBhE烍OACeD&DĂ
  if not (Source is TBottleLogDragObject) then
    Exit;
  if (Source as TBottleLogDragObject).LogItem.LogType <> ltBottle then
    Exit;
  Src := Source as TBottleLogDragObject;
  Log := Src.LogItem;
  CopyFromLogToEditor(Log);
end;

procedure TfrmSender.CopyFromLogToEditor(Log: TLogItem);
begin
  if Log.LogType <> ltBottle then Exit;
  frmSender.actClear.Execute; // ݂̃XNvgNbv(ݒɂ)
  memScript.Lines.Clear;
  memScript.Lines.Add(Log.Script);
  if Log.Ghost <> '' then
  begin
    // S[Xg{bNXɓ
    // S[XgǉĂč\z邱Ƃ
    // S[Xg{bNXɓ
    cbxTargetGhost.Items.Add(Log.Ghost);
    cbxTargetGhost.ItemIndex := cbxTargetGhost.Items.Count-1;
    UpdateIfGhostBox;
    cbxTargetGhost.Invalidate;
  end else
    cbxTargetGhost.ItemIndex := 0; // 'CH'ɂ
  memScript.SetFocus;
end;

procedure TfrmSender.actDeleteLogItemExecute(Sender: TObject);
begin
  // OEBhĚʃO폜
  if frmLog.SelectedBottleLog = nil then
    Exit;
  if frmLog.lvwLog.ItemIndex = -1 then
    Exit;
  frmLog.SelectedBottleLog.Delete(frmLog.lvwLog.ItemIndex);
  frmLog.UpdateWindow;
  frmLog.lvwLogClick(Self);
end;

procedure TfrmSender.ClearEditor;
var TmpScript: String;
    Position: Integer;
    DoSaveBuffer: boolean;
    SavedScript: TStringList;
begin
  // XNvg̃NA
  // ܂AXNvgNAobt@Ɍ݂̃XNvgۑ
  DoSaveBuffer := false;
  if FScriptBuffer.Count = 0 then
    DoSaveBuffer := true
  else if (FScriptBuffer[0] as TStringList).Text <> GetScriptText then
    DoSaveBuffer := true;
  if (GetScriptText = Pref.DefaultScript) or (GetScriptText = '') then
    DoSaveBuffer := false;
  if DoSaveBuffer then
  begin
    SavedScript := TStringList.Create;
    SavedScript.Text := GetScriptText;
    FScriptBuffer.Insert(0, SavedScript);
  end;
  if FScriptBuffer.Count >= 4 then
    FScriptBuffer.Delete(FScriptBuffer.Count-1);
  actRecallScriptBuffer.Enabled := FScriptBuffer.Count > 0;

  TmpScript := Pref.DefaultScript;
  Position := Pos('|', TmpScript);
  if Position < 1 then Position := 1;
  TmpScript := StringReplace(TmpScript, '|', '', []);
  memScript.Lines.Text := TmpScript;
  Sendmessage(memScript.Handle, WM_VSCROLL, SB_LINEUP, 0);
  memScript.SelStart := Position-1;

  if Visible then memScript.SetFocus;
  FScriptModified := false;
  memScriptChange(self);
end;

procedure TfrmSender.AppendTextLog(const FileName, Line: String);
var
  F: TextFile;
begin
  //MOۑ
  try
    ForceDirectories(ExtractFileDir(FileName));
    AssignFile(F, FileName);
    if FileExists(FileName) then
      Append(F)
    else
      Rewrite(F);
    WriteLn(F, Line);
    Flush(F);
    CloseFile(F);
  except
    on E: Exception do
      frmLog.AddCurrentSystemLog('SYSTEM', 'eLXgOۑɎsF'+E.Message);
  end;
end;

procedure TfrmSender.AppendXMLLog(const FileName: String; Args: THeadValue);
var
  F: TFileStream;
  Buf: String;
  P: integer;
  Impl: TDomImplementation;
  Parser: TXmlToDomParser;
  DOM: TdomDocument;
begin
  try // Long try block to handle all kinds of exception in this method
    if not FileExists(FileName) then
    begin
      // Create empty XML log file
      Impl := TDomImplementation.create(nil);
      try
        ForceDirectories(ExtractFileDir(FileName));
        Parser := TXmlToDomParser.create(nil);
        Parser.DOMImpl := Impl;
        try
          try
            DOM := Parser.fileToDom(ExtractFilePath(Application.ExeName)+'xbtl.dat');
            with DOM do
            begin
              documentElement.setAttribute('saved',
                FormatDateTime('yy/mm/dd hh:nn:ss', Now));
              documentElement.setAttribute('generator', VersionString);
              documentElement.setAttribute('version', '1.0');
            end;
            // ͖IFreeȂĂ悢
            F := TFileStream.Create(FileName, fmCreate or fmShareExclusive);
            try
              DOM.writeCodeAsShiftJIS(F);
            finally
              F.Free;
            end;
          except
            frmLog.AddCurrentSystemLog('SYSTEM', 'XMLOۑɎs܂');
          end;
        finally
          Parser.DOMImpl.freeDocument(DOM);
          Parser.Free;
        end;
      finally;
        Impl.Free;
      end;
    end;
    F := TFileStream.Create(FileName, fmOpenReadWrite or fmShareExclusive);
    try
      P := -11;
      SetLength(Buf, 12);
      while P > -100 do
      begin
        F.Seek(P, soFromEnd);
        F.Read(Buf[1], 12);
        if Buf = '</bottlelog>' then
          Break;
        Dec(P);
      end;
      if P = -100 then
        raise Exception.Create(FileName + ' is not a valid XML bottle log file')
      else
      begin
        F.Seek(P, soFromEnd);
        Buf := Format('<message mid="%s">', [Args['MID']]);
        Buf := Buf + Format('<date>%s</date>', [FormatDateTime('yy/mm/dd hh:nn:ss', Now)]);
        Buf := Buf + Format('<channel>%s</channel>', [XMLEntity(Args['Channel'])]);
        Buf := Buf + Format('<script>%s</script>', [XMLEntity(Args['Script'])]);
        Buf := Buf + '<votes>0</votes><agrees>0</agrees>';
        Buf := Buf + Format('<ghost>%s</ghost>', [XMLEntity(Args['IfGhost'])]);
        Buf := Buf + '</message>';
        Buf := Buf + '</bottlelog>';
        F.Write(Buf[1], Length(Buf));
      end;
    finally
      F.Free;
    end;
  except
    on E: Exception do
      frmLog.AddCurrentSystemLog('SYSTEM', 'XMLOۑɎs܂:'+E.Message);
  end;
end;

procedure TfrmSender.memScriptSelectionChange(Sender: TObject;
  Selected: Boolean);
var
  SelText: String;
begin
  SelText := memScript.SelText;
  if SelText <> '' then
  begin
    StatusBar.Panels[PanelBytes].Text := Format('(%doCg)', [Length(SelText)]);
  end else
  begin
    memScriptChange(Self);
  end; 
end;

function TfrmSender.ReplaceSurface(Script: String;
  Params: TCollection): String;
var
  Flag, OldLeaveEscape, OldEscapeInvalidMeta: boolean;
  OldStr, Tag: String;
  i, j, k, Cur: integer;
  Item: TSurfaceReplaceItem;
  Before: TSurfaceReplaceBeforeItem;
begin
  Result := '';
  Cur := 0;
  with SsParser do
  begin
    OldStr := InputString;
    OldLeaveEscape := LeaveEscape;
    OldEscapeInvalidMeta := EscapeInvalidMeta;
    LeaveEscape := true;
    EscapeInvalidMeta := false;
    InputString := Script;
  end;
  for i := 0 to SsParser.Count-1 do
  begin
    if SsParser.MarkUpType[i] <> mtTag then
    begin
      Result := Result + SsParser.Str[i];
      Continue;
    end;
    Tag := SsParser.Str[i];
    if SsParser.Match(Tag, '\s%d') = 2 then
      Cur := Ord(Tag[3]) - Ord('0')
    else if SsParser.Match(Tag, '\s[%D]') > 0 then
      Cur := StrToInt(SsParser.GetParam(Tag, 1))
    else
    begin
      Result := Result + Tag;
      Continue;
    end;
    Flag := false;
    for j := 0 to Params.Count-1 do
    begin
      Item := Params.Items[j] as TSurfaceReplaceItem;
      for k := 0 to Item.Before.Count-1 do
      begin
        Before := Item.Before.Items[k] as TSurfaceReplaceBeforeItem;
        if (Cur >= Before.FromNo) and (Cur <= Before.ToNo) then
        begin
          Flag := true;
          Result := Result + Format('\s[%d]', [Item.After]);
          Break;
        end;
      end;
      if Flag then
        Break;
    end;
    if not Flag then
      Result := Result + Tag;
  end;
  with SsParser do
  begin
    LeaveEscape := OldLeaveEscape;
    EscapeInvalidMeta := OldEscapeInvalidMeta;
    InputString := OldStr;
  end;
end;

procedure TfrmSender.WMQueryEndSession(var msg: TWMQueryEndSession);
begin
  // WindowsI悤ƂĂ̂m
  FEndSession := true;
  inherited;
end;

procedure TfrmSender.IdSLPP20ConnectFailed(Sender: TObject);
begin
  Added := false;
  if FBeginConnectFailCount = 0 then
  begin
    Beep;
    if Pref.UseHttpProxy then
      frmMessageBox.ShowMessage('HTTP ProxyʂSSTP BottleT[oɐڑł܂łB'#13#10 +
                  'lbg[N̏ԁEProxy̏ԂmFĂB'#13#10 +
                  '邢̓T[o_EĂ\܂B')
    else
      frmMessageBox.ShowMessage('SSTP BottleT[oɐڑł܂łB'#13#10 +
                  'lbg[NɌqĂ邩mFĂB'#13#10 +
                  '邢̓T[o_EĂ\܂B');
  end;
  ShowHintLabel('SSTP Bottle ServerڑɎs܂', WarningColor);
  Inc(FBeginConnectFailCount);
end;

procedure TfrmSender.BuildReplaceMenu(Root: TMenuItem);
var
  i: integer;
  Presets: TReplacePresetCollection;
  NewItem: TMenuItem;
begin
  Root.Clear;
  Presets := Pref.ReplacePresets.Presets;
  for i := 0 to Presets.Count-1 do
  begin
    NewItem := TMenuItem.Create(Root);
    with NewItem do
    begin
      Caption := Presets[i].Title;
      ShortCut := Presets[i].ShortCut;
      AutoHotkeys := maManual;
      Hint := Presets[i].Pairs.StringExpression;
      Tag := i;
      OnClick := mnPresetReplaceClick;
    end;
    Root.Add(NewItem);
  end;
  Root.Enabled := Presets.Count > 0;
end;

procedure TfrmSender.mnPresetReplaceClick(Sender: TObject);
var
  Preset: TReplacePreset;
  Lines, New: string;
begin
  // vZbgus
  Preset := Pref.ReplacePresets.Presets[(Sender as TMenuItem).Tag];
  Lines := memScript.Lines.Text;
  New := Preset.Pairs.ExecuteReplace(Lines);
  if New <> Lines then
  begin
    memScript.SelectAll;
    memScript.SelText := New;
  end;
  if Preset.ConfirmAfterReplace then
  begin
    btnConfirm.Click;
  end;
end;

end.
