unit MultipleChoiceEditor;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TfrmMultipleChoiceEditor = class(TForm)
    pnlChoices: TPanel;
    rgpChoices: TRadioGroup;
    btnOk: TButton;
    btnCancel: TButton;
    procedure btnOkClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  frmMultipleChoiceEditor: TfrmMultipleChoiceEditor;

function MultipleChoiceEdit(CaptionStr: String; const Items: array of String;
  var ItemIndex: integer): boolean;

implementation

{$R *.dfm}

function MultipleChoiceEdit(CaptionStr: String; const Items: array of String;
  var ItemIndex: integer): boolean;
var MyfrmMultipleChoiceEditor: TfrmMultipleChoiceEditor;
    i: integer;
begin
  Application.CreateForm(TfrmMultipleChoiceEditor, MyfrmMultipleChoiceEditor);
  with MyfrmMultipleChoiceEditor do begin
    try
      rgpChoices.Items.Clear;
      rgpChoices.Caption := CaptionStr;
      for i := 0 to High(Items) do begin
        rgpChoices.Items.Add(Items[i])
      end;
      rgpChoices.ItemIndex := ItemIndex;
      Result := ShowModal = mrOk;
      if Result then begin
        ItemIndex := rgpChoices.ItemIndex;
      end;
    finally
      Release;
    end;
  end;
end;

//

procedure TfrmMultipleChoiceEditor.btnOkClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;

procedure TfrmMultipleChoiceEditor.btnCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

end.
