unit OpenFileEditor;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TfrmOpenFileEditor = class(TForm)
    OpenDialog: TOpenDialog;
    edtFile: TEdit;
    btnBrowse: TButton;
    btnCancel: TButton;
    btnOk: TButton;
    lblCaption: TLabel;
    SaveDialog: TSaveDialog;
    procedure btnBrowseClick(Sender: TObject);
  private
    FOpenType: boolean; // behavior of the dialog (to open or to save)
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  frmOpenFileEditor: TfrmOpenFileEditor;

function OpenFileEdit(var FileName: String;  Filter, ACaption: String;
  Options: TOpenOptions): boolean;

function SaveFileEdit(var FileName: String;  Filter, ACaption: String;
  Options: TOpenOptions): boolean;


implementation

{$R *.dfm}

function ExecuteFileDialog(var FileName: String;  Filter, ACaption: String;
  Options: TOpenOptions; IsOpenType: boolean = true): boolean;
var AForm: TfrmOpenFileEditor;
begin
  Application.CreateForm(TfrmOpenFileEditor, AForm);
  try
    with AForm do begin
      FOpenType := IsOpenType;
      lblCaption.Caption := ACaption;
      OpenDialog.Options := Options;
      SaveDialog.Options := Options;
      OpenDialog.Filter := Filter;
      SaveDialog.Filter := Filter;
      edtFile.Text := FileName;
      Result := ShowModal = mrOk;
      if Result then FileName := edtFile.Text;
    end;
  finally
    AForm.Release;
  end;
end;

function OpenFileEdit(var FileName: String;  Filter, ACaption: String;
  Options: TOpenOptions): boolean;
begin
  Result := ExecuteFileDialog(FileName, Filter, ACaption, Options, true);
end;

function SaveFileEdit(var FileName: String;  Filter, ACaption: String;
  Options: TOpenOptions): boolean;
begin
  Result := ExecuteFileDialog(FileName, Filter, ACaption, Options, false);
end;


procedure TfrmOpenFileEditor.btnBrowseClick(Sender: TObject);
begin
  // Check FOpenType flag
  if FOpenType then
  begin
    if FileExists(edtFile.Text) then
      OpenDialog.FileName := edtFile.Text;
    if OpenDialog.Execute then
      edtFile.Text := OpenDialog.FileName;
  end else
  begin
    if FileExists(edtFile.Text) then
      SaveDialog.FileName := edtFile.Text;
    if SaveDialog.Execute then
      edtFile.Text := SaveDialog.FileName;
  end;
end;

end.
