{
SPPvOC߂̃NX
}

unit Plugins;

interface

uses Windows, SysUtils, Classes, Graphics;

type
  ESppException = class(Exception);

  TPluginFunction = (pfConfigure, pfSurfaceImage, pfSurfaceList);
  TPluginFunctions = set of TPluginFunction;

  TScope = 0..1; // S[XgXR[v
  TScopes = set of TScope;

  TSppGetVersionFunc = function(Name: PChar; NameLen: integer;
    var Version: integer; var CanConfigure: boolean): integer; cdecl;

  // LbVf[^ƂȂ1̃T[tBXvr[摜
  // ێNX
  // 摜̂̂ƁÃS[XgASurfaceKeyێ
  TSppImage = class(TObject)
  private
    FBitmap: TBitmap;
    FSurfaceKey: String;
    FGhost: String;
    procedure SetBitmap(const Value: TBitmap);
    procedure SetGhost(const Value: String);
    procedure SetSurfaceKey(const Value: String);
  protected
    function SurfaceKeyMatchTest(Surface: integer; AScope: TScope): boolean;
  public
    constructor Create;
    destructor Destroy; override;
    function KeyMatchTest(const Ghost: String;
      Surface: integer; Scope: TScope): boolean;
    property Ghost: String read FGhost write SetGhost;
    property SurfaceKey: String read FSurfaceKey write SetSurfaceKey;
    property Bitmap: TBitmap read FBitmap write SetBitmap;
  end;

  TSppImplementation = class;

  // vOC\NX
  // vOCLoadModuleAނo[W𔻕ʂ
  // K؂TSppImplementation(pꂩ̋ۃNX)
  // 
  TSppPlugin = class(TObject)
  private
    FPluginName: String; // vOC̖O(## Loader)
    FModuleName: String; // DLL̖O(*.dll)
    FImplementation: TSppImplementation; // vOC̎
    FHandle: THandle;
    FPluginFunctions: TPluginFunctions;
  protected
    procedure CreateImplementation;
  public
    constructor Create(const ModuleName: String);
    destructor Destroy; override;
    property ModuleName: String read FModuleName;
    property PluginName: String read FPluginName;
    function GetImage(const Ghost: String;
      Surface: integer; Scope: TScope): TSppImage;
    property Handle: THandle read FHandle;
    property PluginFunctions: TPluginFunctions read FPluginFunctions;
    procedure Configure;
  end;

  // vOC̃x[XNX(ۃNX)
  // ̕SPP1.0SPP2.0APÏႢ𒊏ۉ
  TSppImplementation = class(TObject)
  private
    FOwner: TSppPlugin;
    FLoaded: Boolean;
  public
    constructor Create(Owner: TSppPlugin); virtual;
    destructor Destroy; override;
    procedure Load; virtual;
    function GetImage(const Ghost: String;
      Surface: integer; Scope: TScope): TSppImage; virtual; abstract;
    procedure Unload; virtual;
    property Owner: TSppPlugin read FOwner;
    procedure Configure; virtual; abstract;
  end;

  { SPP Version1p̌^ }
  TSpp1LoadProc = procedure(Path: PChar); cdecl;
  TSpp1UnloadProc = procedure; cdecl;
  TSpp1GetImageFunc = function(Ghost: PChar; Surface: integer;
    H: HBITMAP): integer; cdecl;
  TSpp1GetImageSizeFunc = function(Ghost: PChar; Surface: integer;
    var w, h: integer): integer; cdecl;
  TSpp1ConfigureProc = procedure; cdecl;

  TSppImplementation1 = class(TSppImplementation)
  private
    // ֐E葱ϐ
    FSppLoad: TSpp1LoadProc;
    FSppUnload: TSpp1UnloadProc;
    FSppGetImage: TSpp1GetImageFunc;
    FSppGetImageSize: TSpp1GetImageSizeFunc;
    FSppConfigure: TSpp1ConfigureProc;
    procedure InitProcs;
    function DoGetImage(const Ghost: String;
      const Surface: integer; Bitmap: TBitmap): boolean;
  public
    constructor Create(Owner: TSppPlugin); override;
    procedure Load; override;
    function GetImage(const Ghost: String;
      Surface: integer; Scope: TScope): TSppImage; override;
    procedure Unload; override;
    procedure Configure; override;
  end;

implementation


{ TSppPlugin }

procedure TSppPlugin.Configure;
begin
  FImplementation.Configure;
end;

constructor TSppPlugin.Create(const ModuleName: String);
begin
  FModuleName := ModuleName;
  FHandle := LoadLibrary(PChar(FModuleName));
  if FHandle = 0 then
    raise ESppException.CreateFmt('Error loading %s', [FModuleName])
  else
  begin
    CreateImplementation;
    FImplementation.Load;
  end;
end;

procedure TSppPlugin.CreateImplementation;
var GetVersion: TSppGetVersionFunc;
    DLLName: array [0..255] of char;
    Version: integer;
    CanConfigure: boolean;
begin
  GetVersion := GetProcAddress(FHandle, 'GetVersion');
  if (@GetVersion = nil) then
    raise ESppException.CreateFmt('%s is not a valid SPP module', [FModuleName]);

  GetVersion(@DLLName, sizeof(DLLName), Version, CanConfigure);
  case Version of
    1: FImplementation := TSppImplementation1.Create(Self);
    // 2: FImplementation := TSppImplementation.Create(Self);
    else
      raise ESppException.CreateFmt('Module %s returned '+
        'unsupported version number(%d)', [FModuleName, Version]);
  end;
  FPluginName := DLLName;
  if CanConfigure then
    FPluginFunctions := [pfConfigure]
  else
    FPluginFunctions := [];
end;

destructor TSppPlugin.Destroy;
begin
  if FImplementation <> nil then
    FImplementation.UnLoad;
  FImplementation.Free;
  if not FreeLibrary(FHandle) then
    raise ESppException.CreateFmt('Error unloading module %s', [FModuleName]);
  inherited;
end;

function TSppPlugin.GetImage(const Ghost: String;
  Surface: integer; Scope: TScope): TSppImage;
begin
  Result := FImplementation.GetImage(Ghost, Surface, Scope);
end;

{ TSppImplementation }

constructor TSppImplementation.Create(Owner: TSppPlugin);
begin
  FOwner := Owner;
end;

destructor TSppImplementation.Destroy;
begin
  if FLoaded then
    Unload;
  inherited;
end;

procedure TSppImplementation.Load;
begin
  FLoaded := true;
end;

procedure TSppImplementation.Unload;
begin
  FLoaded := false;
end;

{ TSppImage }

constructor TSppImage.Create;
begin
  FBitmap := TBitmap.Create;
end;

destructor TSppImage.Destroy;
begin
  FBitmap.Free;
  inherited;
end;

function TSppImage.KeyMatchTest(const Ghost: String; Surface: integer;
  Scope: TScope): boolean;
begin
  // w肳ꂽS[XgET[tBXIDEXR[v
  // T[tBX̃vr[ɁẢ摜g邩?
  Result := (Self.Ghost = Ghost) and SurfaceKeyMatchTest(Surface, Scope);
end;

procedure TSppImage.SetBitmap(const Value: TBitmap);
begin
  FBitmap.Assign(Value);
end;

procedure TSppImage.SetGhost(const Value: String);
begin
  FGhost := Value;
end;

procedure TSppImage.SetSurfaceKey(const Value: String);
begin
  FSurfaceKey := Value;
end;

function TSppImage.SurfaceKeyMatchTest(Surface: integer;
  AScope: TScope): boolean;
var i, p: integer;
    Tokens: TStringList;
    Token, SurfaceIDList, ScopeKey: String;
    FromID, ToID: integer;
const SyntaxError = 'Syntax error found in SurfaceKey "%s"';
begin
  Result := false;
  p := Pos(',', SurfaceKey);
  if p <= 0 then
    raise ESppException.CreateFmt(SyntaxError, [SurfaceKey]);
  SurfaceIDList := Copy(SurfaceKey, 1, p-1);
  ScopeKey := Copy(SurfaceKey, p+1, High(integer));
  if (ScopeKey <> '*') and (ScopeKey <> IntToStr(AScope)) then
    Exit;
  if SurfaceIDList = '*' then
  begin
    Result := true;
    Exit;
  end;
  Tokens := TStringList.Create;
  try
    try
      Tokens.Delimiter := '&';
      Tokens.DelimitedText := SurfaceIDList;
      for i := 0 to Tokens.Count-1 do
      begin
        Token := Tokens[i];
        p := Pos('-', Token);
        if p > 0 then
        begin
          FromID := StrToInt(Copy(Token, 1, p));
          ToID := StrToInt(Copy(Token, p+1, High(integer)));
        end else
        begin
          FromID := StrToInt(Token);
          ToID := FromID;
        end;
        if (FromID <= Surface) and (Surface <= ToID) then
        begin
          Result := true;
          Exit;
        end;
      end;
    except
      on EConvertError do
        raise ESppException.CreateFmt(SyntaxError, [SurfaceKey]);
    end;
  finally
    Tokens.Free;
  end;
end;

{ TSppImplementation1 }

procedure TSppImplementation1.Configure;
begin
  inherited;
  FSppConfigure;
end;

constructor TSppImplementation1.Create(Owner: TSppPlugin);
begin
  inherited;
  InitProcs;
end;

function TSppImplementation1.DoGetImage(const Ghost: String;
  const Surface: integer; Bitmap: TBitmap): boolean;
var H: HBITMAP;
begin
  H := Bitmap.ReleaseHandle;
  Result := FSppGetImage(PChar(Ghost), Surface, H) = 0;
  Bitmap.Handle := H;
end;

function TSppImplementation1.GetImage(const Ghost: String;
  Surface: integer; Scope: TScope): TSppImage;
var Width, Height: integer;
    TmpBitmap: TBitmap;
begin
  Result := nil;
  Width  := 0;
  Height := 0;
  if Surface < 0 then Exit;
  if FSppGetImageSize(PChar(Ghost), Surface, Width, Height) <> 0 then
    Exit;
  TmpBitmap := TBitmap.Create;
  try
    TmpBitmap.Width  := Width;
    TmpBitmap.Height := Height;
    if DoGetImage(Ghost, Surface, TmpBitmap) then
    begin
      Result := TSppImage.Create;
      Result.Bitmap := TmpBitmap;
      Result.Ghost := Ghost;
      Result.SurfaceKey := Format('%d,*', [Surface]); // Any scope
    end;
  finally
    TmpBitmap.Free;
  end;
end;

procedure TSppImplementation1.InitProcs;
const
  SSppLoad = 'Load';
  SSppUnload = 'Unload';
  SSppGetVersion = 'GetVersion';
  SSppGetImage = 'GetImage';
  SSppGetImageSize = 'GetImageSize';
  SSppConfigure = 'Configure';
begin
  // Load DLL procedures
  FSppLoad := GetProcAddress(Owner.Handle, SSppLoad);
  FSppUnload := GetProcAddress(Owner.Handle, SSppUnload);
  FSppGetImage := GetProcAddress(Owner.Handle, SSppGetImage);
  FSppGetImageSize := GetProcAddress(Owner.Handle, SSppGetImageSize);
  FSppConfigure := GetProcAddress(Owner.Handle, SSppConfigure);

  if (@FSppLoad = nil) or (@FSppUnload = nil) or (@FSppGetImage = nil) or
     (@FSppGetImageSize = nil) or (@FSppConfigure = nil) then
  begin
    raise ESppException.Create('Error Getting Procedure Address');
  end;
end;

procedure TSppImplementation1.Load;
begin
  FSppLoad(PChar(ExtractFilePath(Owner.ModuleName)));
  inherited Load;
end;

procedure TSppImplementation1.Unload;
begin
  FSppUnload;
  inherited Unload;
end;

end.
