unit ReplacePresetListFrame;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, BottleDef, StrReplace, StdCtrls, ReplacePresetEditor, Menus;

type
  TfrmReplacePresetList = class(TFrame)
    lstPresets: TListBox;
    btnMoveUp: TButton;
    btnMoveDown: TButton;
    btnEdit: TButton;
    btnClone: TButton;
    btnDelete: TButton;
    btnAdd: TButton;
    procedure btnMoveUpClick(Sender: TObject);
    procedure btnMoveDownClick(Sender: TObject);
    procedure btnEditClick(Sender: TObject);
    procedure btnCloneClick(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure lstPresetsDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure lstPresetsDblClick(Sender: TObject);
  protected
    procedure MoveItem(const Delta: Integer);
  public
    procedure UpdateControls;
  end;

implementation

{$R *.dfm}

{ TfrmReplacePresetList }

procedure TfrmReplacePresetList.UpdateControls;
var
  i: Integer;
  Presets: TReplacePresetCollection;
begin
  Presets := Pref.ReplacePresets.Presets;
  with lstPresets.Items do
  begin
    BeginUpdate;
    try
      Clear;
      for i := 0 to Presets.Count-1 do
      begin
        Add(Presets[i].Title);
      end;
    finally
      EndUpdate;
    end;
  end;
end;

procedure TfrmReplacePresetList.btnMoveUpClick(Sender: TObject);
begin
  MoveItem(-1);
end;

procedure TfrmReplacePresetList.btnMoveDownClick(Sender: TObject);
begin
  MoveItem(1);
end;

procedure TfrmReplacePresetList.MoveItem(const Delta: Integer);
var
  TargetIndex: Integer;
  Presets: TReplacePresetCollection;
  Item: TReplacePreset;
begin
  TargetIndex := lstPresets.ItemIndex;
  if TargetIndex < 0 then
    Exit;
  if (TargetIndex + Delta < 0) or (TargetIndex + Delta >= lstPresets.Count) then
    Exit;
  Presets := Pref.ReplacePresets.Presets;
  // UACe𔲂o
  Item := Presets[TargetIndex];
  Item.Collection := nil; // ŃRNVO
  // VꏊɃACeđ
  Presets.Insert(TargetIndex + Delta).Assign(Item);
  lstPresets.Items.Move(TargetIndex, TargetIndex + Delta);
  lstPresets.ItemIndex := TargetIndex + Delta;
end;

procedure TfrmReplacePresetList.btnEditClick(Sender: TObject);
var
  Target: TReplacePreset;
  Index: Integer;
  Form: TfrmReplacePresetEditor;
begin
  Index := lstPresets.ItemIndex;
  if Index < 0 then
    Exit;
  Target := Pref.ReplacePresets.Presets[Index];
  Application.CreateForm(TfrmReplacePresetEditor, Form);
  try
    with Form do
    begin
      AskForTitle := true;
      Title    := Target.Title;
      ShortCut := Target.ShortCut;
      Pairs    := Target.Pairs;
      ConfirmAfterReplace := Target.ConfirmAfterReplace;
      if Execute then
      begin
        Target.Title    := Title;
        Target.ShortCut := ShortCut;
        Target.Pairs    := Pairs;
        Target.ConfirmAfterReplace := ConfirmAfterReplace;
        lstPresets.Invalidate;
      end;
    end;
  finally
    Form.Release;
  end;
end;

procedure TfrmReplacePresetList.btnCloneClick(Sender: TObject);
var
  Index: Integer;
  Target, New: TReplacePreset;
begin
  Index := lstPresets.ItemIndex;
  if Index < 0 then
    Exit;
  Target := Pref.ReplacePresets.Presets[Index];
  New := Pref.ReplacePresets.Presets.Add;
  New.Assign(Target);
  New.Title := Target.Title + '̃Rs[';
  lstPresets.Items.Add(New.Title);
  lstPresets.ItemIndex := lstPresets.Items.Count-1;
end;

procedure TfrmReplacePresetList.btnDeleteClick(Sender: TObject);
var
  Index: Integer;
  Target: TReplacePreset;
begin
  Index := lstPresets.ItemIndex;
  if Index < 0 then
    Exit;
  Target := Pref.ReplacePresets.Presets[Index];
  Target.Free; // ɃRNṼXgO
  lstPresets.Items.Delete(Index);
end;

procedure TfrmReplacePresetList.btnAddClick(Sender: TObject);
var
  New: TReplacePreset;
  Form: TfrmReplacePresetEditor;
begin
  New := TReplacePreset.Create(nil);
  try
    Application.CreateForm(TfrmReplacePresetEditor, Form);
    try
      with Form do
      begin
        AskForTitle := true;
        Title    := '̖ݒ';
        if Execute then
        begin
          New.Title    := Title;
          New.ShortCut := ShortCut;
          New.Pairs    := Pairs;
          New.ConfirmAfterReplace := ConfirmAfterReplace;
          Pref.ReplacePresets.Presets.Add.Assign(New);
          lstPresets.Items.Add(New.Title);
        end;
      end;
    finally
      Form.Release;
    end;
  finally
    New.Free;
  end;
end;

procedure TfrmReplacePresetList.lstPresetsDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  Str: string;
  y, w: Integer;
  Target: TReplacePreset;
begin
  lstPresets.Canvas.FillRect(Rect);

  // eLXg`̈̃}[W
  with Rect do
  begin
    Left := Left + 2;
    Top := Top + 2;
    Right := Right - 2;
    Bottom := Bottom - 2;
  end;

  Target := Pref.ReplacePresets.Presets[Index];
  with lstPresets.Canvas do
  begin
    // V[gJbg
    Font.Style := Font.Style + [fsBold];
    Str := ShortCutToText(Target.ShortCut);
    if Str <> '' then
    begin
      DrawText(Handle, PChar(Str), -1, Rect, DT_RIGHT);
      w := TextWidth(Str);
    end else
      w := 0;
    // ^Cg
    Str := Target.Title;
    Rect.Right := Rect.Right - w - 10;
    y := DrawText(Handle, PChar(Str), -1, Rect, DT_SINGLELINE or DT_END_ELLIPSIS);
    // ڍ
    Font.Style := Font.Style - [fsBold];
    Str := Target.Pairs.StringExpression;
    Rect.Top := Rect.Top + y;
    Rect.Left := Rect.Left + 5;
    Rect.Right := Rect.Right + w + 10;
    DrawText(Handle, PChar(Str), -1, Rect,
      DT_NOPREFIX or DT_WORDBREAK or DT_END_ELLIPSIS or DT_EDITCONTROL);
  end;
end;

procedure TfrmReplacePresetList.lstPresetsDblClick(Sender: TObject);
begin
  btnEdit.Click;
end;

end.
