unit SettingForm;

{
  ݒʁBꖢłȏłȂB
  PrefIuWFNgۂɑ삷B
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ExtCtrls, BottleDef, Spin,
  CPCConfigTreeView, ColorSettingFrame, BottleChainListFrame, SakuraSeekerInstance,
  ImgList, StrListEditor, SppList, Plugins, Clipbrd, SsPlayTime, StrUtils,
  SpecialCharEditor, ReplacePresetListFrame;

type
  TfrmSetting = class(TForm)
    PageControl: TPageControl;
    btnClose: TButton;
    tstGeneral: TTabSheet;
    tstDisplay: TTabSheet;
    tstKeys: TTabSheet;
    rgpWhenReturn: TRadioGroup;
    rgpWhenShiftReturn: TRadioGroup;
    rgpWhenCtrlReturn: TRadioGroup;
    memDefaultScript: TMemo;
    lblDefaultScript: TLabel;
    tstReceive: TTabSheet;
    OpenDialog: TOpenDialog;
    spnWaitScriptEnd: TSpinEdit;
    lblWaitScriptEnd: TLabel;
    cbxConfirmOnExit: TCheckBox;
    ctvBottle: TCPCConfigTreeView;
    gbxColor: TGroupBox;
    frmColorSetting: TfrmColorSetting;
    tstRule: TTabSheet;
    frmRuleList: TfrmBottleChainList;
    tstDetailed: TTabSheet;
    lblFMOName: TLabel;
    memFMOName: TMemo;
    tstChannel: TTabSheet;
    lblAutoJoinChannels: TLabel;
    memAutoJoinChannels: TMemo;
    cbxAutoStart: TCheckBox;
    btnUseCurrentJoinChannels: TButton;
    ImageList: TImageList;
    tstSurfacePreview: TTabSheet;
    lblSurfacePreview: TLabel;
    lvwPluginList: TListView;
    lblPluginList: TLabel;
    ctvSurfacePreview: TCPCConfigTreeView;
    btnVisibleGhosts: TButton;
    cbxHideGhosts: TCheckBox;
    cbxNoExtraSSTPHeaders: TCheckBox;
    lblLUID: TLabel;
    edtLUID: TEdit;
    cbxShowRuler: TCheckBox;
    rgpTabPosition: TRadioGroup;
    lblGhostDropDownCount: TLabel;
    spnGhostDropDownCount: TSpinEdit;
    cbxIgnoreTimeCritical: TCheckBox;
    cbxAutoClip: TCheckBox;
    btnCopyLUID: TButton;
    tvwCategory: TTreeView;
    Label1: TLabel;
    pnlHeading: TPanel;
    cbxConfirmOnTabClose: TCheckBox;
    tstConnection: TTabSheet;
    grpProxy: TGroupBox;
    lblProxyAddress: TLabel;
    lblProxyPort: TLabel;
    Label6: TLabel;
    edtProxyAddress: TEdit;
    edtProxyPort: TEdit;
    cbxUseHttpProxy: TCheckBox;
    spnReconnectWait: TSpinEdit;
    lblReconnectWait: TLabel;
    lblPartialConfirmFormat: TLabel;
    edtPartialConfirmFormat: TEdit;
    cbxAutoPartialConfirm: TCheckBox;
    tstPlayTime: TTabSheet;
    grpPlayTimeParams: TGroupBox;
    lblPlayTimeProfile: TLabel;
    cbxPlayTimeProfile: TComboBox;
    spnCostDBChar: TSpinEdit;
    spnCostWait: TSpinEdit;
    spnCostSurface: TSpinEdit;
    spnCostChar: TSpinEdit;
    spnCostQuickChar: TSpinEdit;
    lblCostWait: TLabel;
    lblCostSurface: TLabel;
    lblCostChar: TLabel;
    lblCostDBChar: TLabel;
    lblCostQuickChar: TLabel;
    btnSavePlayTimeProfile: TButton;
    lvwCostSpecials: TListView;
    lblCostSpecials: TLabel;
    btnPlaySpecialAdd: TButton;
    btnPlaySpecialDelete: TButton;
    gbxTabWidth: TGroupBox;
    cbxAutoTabWidth: TCheckBox;
    spnTabWidth: TSpinEdit;
    lblBrowser: TLabel;
    edtBrowserName: TEdit;
    BrowserLocateOpenDialog: TOpenDialog;
    btnBrowserLocate: TButton;
    tstPresetReplace: TTabSheet;
    ReplacePresetList: TfrmReplacePresetList;
    cbxAskUseHttpProxy: TCheckBox;
    cbxNoWarnOfEmptyFMO: TCheckBox;
    cbxProxyNeedAuthentication: TCheckBox;
    edtProxyUser: TEdit;
    edtProxyPass: TEdit;
    lblProxyUser: TLabel;
    lblProxyPass: TLabel;
    lblMinScriptLength: TLabel;
    spnMinScriptLength: TSpinEdit;
    cbxLogItemDragDrop: TCheckBox;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure edtProxyPortKeyPress(Sender: TObject; var Key: Char);
    procedure ctvBottleNodeChecked(Sender: TObject;
      Node: TCPCConfigItemNode);
    procedure ctvBottleNodeChecking(Sender: TObject;
      Node: TCPCConfigItemNode; var Allow: Boolean);
    procedure tstRuleShow(Sender: TObject);
    procedure btnUseCurrentJoinChannelsClick(Sender: TObject);
    procedure btnVisibleGhostsClick(Sender: TObject);
    procedure lvwPluginListDblClick(Sender: TObject);
    procedure edtLUIDEnter(Sender: TObject);
    procedure edtLUIDExit(Sender: TObject);
    procedure btnCopyLUIDClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure tvwCategoryChange(Sender: TObject; Node: TTreeNode);
    procedure tvwCategoryMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure cbxPlayTimeProfileChange(Sender: TObject);
    procedure btnSavePlayTimeProfileClick(Sender: TObject);
    procedure spnCostWaitChange(Sender: TObject);
    procedure btnPlaySpecialAddClick(Sender: TObject);
    procedure btnPlaySpecialDeleteClick(Sender: TObject);
    procedure lvwCostSpecialsDblClick(Sender: TObject);
    procedure spnTabWidthChange(Sender: TObject);
    procedure cbxAutoTabWidthClick(Sender: TObject);
    procedure btnBrowserLocateClick(Sender: TObject);
    procedure tstPresetReplaceShow(Sender: TObject);
    procedure cbxProxyNeedAuthenticationClick(Sender: TObject);
  private
    { Private 錾 }
    FOldLUID: String;
    FSpinUpdateFlag: boolean;
    procedure LoadPlayTimeProfiles;
    procedure PlayTimeParamsToSpinControl(Params: TSsPlayTimeParams);
    procedure SpinControlToPlayTimeParams(Params: TSsPlayTimeParams);
    procedure UpdateSpecialChars;
  public
    { Public 錾 }
    procedure Execute;
  end;

var
  frmSetting: TfrmSetting;

const
  DefaultNode = -1;
  ChannelDefaultGhost = '(`lS[Xg)';
  CheckedBottle = 22;
  UnCheckedBottle = 17;

implementation

{$R *.DFM}

const
  SettingIcon = 4;

procedure TfrmSetting.Execute;
var i: integer;
    Node: TCPCGroupNode;
begin
  PageControl.ActivePage := tstGeneral;
  memDefaultScript.Text := Pref.DefaultScript;
  cbxShowRuler.Checked := Pref.ShowRuler;
  cbxIgnoreTimeCritical.Checked := Pref.IgnoreTimeCritical;
  edtPartialConfirmFormat.Text := Pref.PartialConfirmFormat;
  cbxAutoPartialConfirm.Checked := Pref.AutoPartialConfirm;
  cbxConfirmOnExit.Checked := Pref.ConfirmOnExit;
  cbxConfirmOnTabClose.Checked := Pref.ConfirmOnTabClose;
  cbxAutoClip.Checked := Pref.AutoClip;
  //
  with frmColorSetting do begin
    Color['H'] := Pref.TalkColorH;
    Color['U'] := Pref.TalkColorU;
    Color['Synchro'] := Pref.TalkColorS;
    Color['Tag'] := Pref.MarkUpColor;
    Color['Meta'] := Pref.MetaWordColor;
    Color['Error'] := Pref.MarkErrorColor;
    Color['Text'] := Pref.TextColor;
    Color['Background'] := Pref.BgColor;
  end;
  //
  cbxPlayTimeProfile.Items.Clear;
  cbxPlayTimeProfile.Items.Add(Pref.PlayTimeParams.ProfileName);
  cbxPlayTimeProfile.ItemIndex := 0;
  LoadPlayTimeProfiles;
  PlayTimeParamsToSpinControl(Pref.PlayTimeParams);
  UpdateSpecialChars;
  //
  cbxAutoStart.Checked := Pref.AutoStart;
  rgpTabPosition.ItemIndex := Ord(Pref.TabPosition);
  spnTabWidth.Value := Pref.TabWidth;
  if Pref.TabWidth <= 0 then
    spnTabWidth.Value := 0;
  cbxAutoTabWidth.Checked := Pref.TabWidth <= 0;
  spnGhostDropDownCount.Value := Pref.GhostDropDownCount;
  try
    with ctvBottle do begin
      (GetNodeFromKeyPath('Arrive\NoTranslate') as TCPCCheckBoxNode).Checked := Pref.NoTranslate;
      (GetNodeFromKeyPath('Arrive\NoDescript') as TCPCCheckBoxNode).Checked := Pref.NoDescript;
      if Pref.NoTransUrl then
        (GetNodeFromKeyPath('Arrive\UrlTag\NoSelection') as TCPCRadioNode).Check
      else
        (GetNodeFromKeyPath('Arrive\UrlTag\WithSelection') as TCPCRadioNode).Check;
      (GetNodeFromKeyPath('Arrive\SilentWhenHidden') as TCPCCheckBoxNode).Checked := Pref.SilentWhenHidden;
      (GetNodeFromKeyPath('Arrive\FixMessySurface') as TCPCCheckBoxNode).Checked := Pref.FixMessySurface;
      (GetNodeFromKeyPath('Arrive\HUTagTo01Tag') as TCPCCheckBoxNode).Checked := Pref.HUTagTo01Tag;
      (GetNodeFromKeyPath('Out\ResetIfGhostAfterSend') as TCPCCheckBoxNode).Checked := Pref.ResetIfGhostAfterSend;
      (GetNodeFromKeyPath('Out\ClearAfterSend') as TCPCCheckBoxNode).Checked := Pref.ClearAfterSend;
      (GetNodeFromKeyPath('Out\NeedConfirmBeforeSend') as TCPCCheckBoxNode).Checked := Pref.NeedConfirmBeforeSend;
      (GetNodeFromKeyPath('Out\Confirm') as TCPCCheckBoxNode).Checked := not Pref.NoConfirm;
      (GetNodeFromKeyPath('Out\Warn\ScopeChangeInSynchronize') as TCPCCheckBoxNode).Checked := Pref.WarnScopeChangeInSynchronize;
      (GetNodeFromKeyPath('Out\Warn\YenTNotExist') as TCPCCheckBoxNode).Checked := Pref.WarnYenTNotExist;
    end;
  except
    on E: Exception do ShowMessage(E.Message);
  end;
  //cbxIgnoreFrequentYenS.Checked := Pref.IgnoreFrequentYenS;
  spnWaitScriptEnd.Value := Pref.WaitScriptEnd;
  spnMinScriptLength.Value := Pref.MinScriptLength;
  spnMinScriptLength.MinValue := DefaultMinScriptLength;
  //
  rgpWhenReturn.ItemIndex := Ord(Pref.WhenReturn);
  rgpWhenShiftReturn.ItemIndex := Ord(Pref.WhenShiftReturn);
  rgpWhenCtrlReturn.ItemIndex := Ord(Pref.WhenCtrlReturn);
  //
  cbxUseHttpProxy.Checked := Pref.UseHttpProxy;
  cbxAskUseHttpProxy.Checked := Pref.AskUseHttpProxy;
  cbxProxyNeedAuthentication.Checked := Pref.ProxyNeedAuthentication;
  cbxProxyNeedAuthenticationClick(Self);
  edtProxyAddress.Text := Pref.ProxyAddress;
  edtProxyPort.Text := IntToStr(Pref.ProxyPort);
  edtProxyUser.Text := Pref.ProxyUser;
  edtProxyPass.Text := Pref.ProxyPass;
  //
  spnReconnectWait.Value := Pref.ReconnectWait;
  //
  edtLUID.Text := Pref.LUID;
  //
  memFMOName.Lines := Pref.FMOName;
  cbxHideGhosts.Checked := Pref.HideGhosts;
  memAutoJoinChannels.Lines := Pref.AutoJoinChannels;
  cbxNoExtraSSTPHeaders.Checked := Pref.NoExtraSSTPHeaders;
  //
  with ctvSurfacePreview do
  begin
    (GetNodeFromKeyPath('OnHint\DoPreview') as TCPCCheckBoxNode).Checked := Pref.SurfacePreviewOnHint;
    (GetNodeFromKeyPath('OnScriptPoint\DoPreview') as TCPCCheckBoxNode).Checked := Pref.SurfacePreviewOnScriptPoint;
    Node := GetNodeFromKeyPath('OnScriptPoint\Position') as TCPCGroupNode;
    (Node.Item[Ord(Pref.SurfacePreviewOnScriptPointPosition)] as TCPCRadioNode).Check;
  end;
  for i := 0 to Spps.Count-1 do
  begin
    with lvwPluginList.Items.Add do
    begin
      Caption := ExtractFileName(Spps.SppItem[i].ModuleName);
      SubItems.Add(Spps.SppItem[i].PluginName);
    end;
  end;
  edtBrowserName.Text := Pref.BrowserExeName;
  cbxNoWarnOfEmptyFMO.Checked := Pref.NoWarnOfEmptyFMO;
  cbxLogItemDragDrop.Checked := Pref.LogItemDragDrop;

  //
  ShowModal;
end;

procedure TfrmSetting.FormClose(Sender: TObject; var Action: TCloseAction);
var i: integer;
    Node: TCPCGroupNode;
begin
  Pref.DefaultScript := memDefaultScript.Text;
  Pref.ShowRuler := cbxShowRuler.Checked;
  Pref.IgnoreTimeCritical := cbxIgnoreTimeCritical.Checked;
  Pref.PartialConfirmFormat := edtPartialConfirmFormat.Text;
  Pref.AutoPartialConfirm := cbxAutoPartialConfirm.Checked;
  Pref.ConfirmOnExit := cbxConfirmOnExit.Checked;
  Pref.ConfirmOnTabClose := cbxConfirmOnTabClose.Checked;
  Pref.AutoClip := cbxAutoClip.Checked;
  //
  with frmColorSetting do begin
    Pref.TalkColorH := Color['H'];
    Pref.TalkColorU := Color['U'];
    Pref.TalkColorS := Color['Synchro'];
    Pref.MarkUpColor := Color['Tag'];
    Pref.MetaWordColor := Color['Meta'];
    Pref.MarkErrorColor := Color['Error'];
    Pref.TextColor := Color['Text'];
    Pref.BgColor := Color['Background'];
  end;
  //
  Pref.PlayTimeParams.ProfileName := cbxPlayTimeProfile.Text;
  SpinControlToPlayTimeParams(Pref.PlayTimeParams);
  //
  Pref.AutoStart := cbxAutoStart.Checked;
  Pref.TabPosition := TTabPosition(rgpTabPosition.ItemIndex);
  Pref.TabWidth := spnTabWidth.Value;
  if cbxAutoTabWidth.Checked then
    Pref.TabWidth := 0;
  Pref.GhostDropDownCount := spnGhostDropDownCount.Value;
  try
    with ctvBottle do begin
      Pref.NoTranslate := (GetNodeFromKeyPath('Arrive\NoTranslate') as TCPCCheckBoxNode).Checked;
      Pref.NoDescript := (GetNodeFromKeyPath('Arrive\NoDescript') as TCPCCheckBoxNode).Checked;
      Pref.NoTransUrl := (GetNodeFromKeyPath('Arrive\UrlTag\NoSelection') as TCPCRadioNode).Checked;
      Pref.SilentWhenHidden := (GetNodeFromKeyPath('Arrive\SilentWhenHidden') as TCPCCheckBoxNode).Checked;
      Pref.FixMessySurface := (GetNodeFromKeyPath('Arrive\FixMessySurface') as TCPCCheckBoxNode).Checked;
      Pref.HUTagTo01Tag := (GetNodeFromKeyPath('Arrive\HUTagTo01Tag') as TCPCCheckBoxNode).Checked;
      Pref.ResetIfGhostAfterSend := (GetNodeFromKeyPath('Out\ResetIfGhostAfterSend') as TCPCCheckBoxNode).Checked;
      Pref.ClearAfterSend := (GetNodeFromKeyPath('Out\ClearAfterSend') as TCPCCheckBoxNode).Checked;
      Pref.NeedConfirmBeforeSend := (GetNodeFromKeyPath('Out\NeedConfirmBeforeSend') as TCPCCheckBoxNode).Checked;
      Pref.NoConfirm := not (GetNodeFromKeyPath('Out\Confirm') as TCPCCheckBoxNode).Checked;
      Pref.WarnYenTNotExist := (GetNodeFromKeyPath('Out\Warn\YenTNotExist') as TCPCCheckBoxNode).Checked;
      Pref.WarnScopeChangeInSynchronize := (GetNodeFromKeyPath('Out\Warn\ScopeChangeInSynchronize') as TCPCCheckBoxNode).Checked;
    end;
  except
    on E: Exception do ShowMessage(E.Message);
  end;
  //Pref.IgnoreFrequentYenS := cbxIgnoreFrequentYenS.Checked;
  Pref.WaitScriptEnd := spnWaitScriptEnd.Value;
  Pref.MinScriptLength := spnMinScriptLength.Value;
  //
  Pref.WhenReturn := TReturnKeyFunction(rgpWhenReturn.ItemIndex);
  Pref.WhenShiftReturn := TReturnKeyFunction(rgpWhenShiftReturn.ItemIndex);
  Pref.WhenCtrlReturn := TReturnKeyFunction(rgpWhenCtrlReturn.ItemIndex);
  //
  Pref.UseHttpProxy := cbxUseHttpProxy.Checked;
  Pref.AskUseHttpProxy := cbxAskUseHttpProxy.Checked;
  Pref.ProxyAddress := edtProxyAddress.Text;
  Pref.ProxyPort := StrToInt(edtProxyPort.Text);
  Pref.ProxyUser := edtProxyUser.Text;
  Pref.ProxyPass := edtProxyPass.Text;
  Pref.ProxyNeedAuthentication := cbxProxyNeedAuthentication.Checked;
  //
  Pref.ReconnectWait := spnReconnectWait.Value;
  //
  Pref.LUID := edtLUID.Text;
  //
  Pref.FMOName := memFMOName.Lines;
  SakuraSeeker.FileMappingTarget := Pref.FMOName;
  Pref.HideGhosts := cbxHideGhosts.Checked;
  Pref.NoExtraSSTPHeaders := cbxNoExtraSSTPHeaders.Checked;
  //
  Pref.AutoJoinChannels := memAutoJoinChannels.Lines;
  //
  with ctvSurfacePreview do
  begin
    Pref.SurfacePreviewOnHint := (GetNodeFromKeyPath('OnHint\DoPreview') as TCPCCheckBoxNode).Checked;
    Pref.SurfacePreviewOnScriptPoint := (GetNodeFromKeyPath('OnScriptPoint\DoPreview') as TCPCCheckBoxNode).Checked;
    Node := GetNodeFromKeyPath('OnScriptPoint\Position') as TCPCGroupNode;
    for i := 0 to Node.Count-1 do
      if (Node.Item[i] as TCPCRadioNode).Checked then
        Pref.SurfacePreviewOnScriptPointPosition := TSurfacePreviewOnScriptPointPosition(i);
  end;
  //
  Pref.BrowserExeName := edtBrowserName.Text;
  Pref.NoWarnOfEmptyFMO := cbxNoWarnOfEmptyFMO.Checked;
  Pref.LogItemDragDrop := cbxLogItemDragDrop.Checked;
end;

procedure TfrmSetting.edtProxyPortKeyPress(Sender: TObject; var Key: Char);
begin
  if not(Key in ['0'..'9']) then Key := Char(0);
end;

procedure TfrmSetting.ctvBottleNodeChecked(Sender: TObject;
  Node: TCPCConfigItemNode);
begin
  //ShowMessage(ctvBottle.GetFullKeyPath(Node));
end;

procedure TfrmSetting.ctvBottleNodeChecking(Sender: TObject;
  Node: TCPCConfigItemNode; var Allow: Boolean);
begin
  if Node.KeyName = 'IgnoreBottle' then begin
    MessageDlg('̋@\͎Ă܂', mtError, [mbOk], 0);
    Allow := false;
  end;
end;

procedure TfrmSetting.tstRuleShow(Sender: TObject);
begin
  frmRuleList.UpdateDisplay;
end;

procedure TfrmSetting.btnUseCurrentJoinChannelsClick(Sender: TObject);
begin
  memAutoJoinChannels.Lines := JoinChannels;
end;

procedure TfrmSetting.btnVisibleGhostsClick(Sender: TObject);
var i: integer;
    FullGhosts: TStringList;
begin
  FullGhosts := TStringList.Create;
  SakuraSeeker.BeginDetect;
  try
    for i := 0 to SakuraSeeker.Count-1 do
      FullGhosts.Add(SakuraSeeker[i].Name);
    StrListEdit(Pref.VisibleGhostsList, 'S[Xgw', true, FullGhosts);
  finally
    FullGhosts.Free;
  end;
end;

procedure TfrmSetting.lvwPluginListDblClick(Sender: TObject);
var Index: integer;
begin
  if lvwPluginList.Selected = nil then
    Exit;
  Index := lvwPluginList.Selected.Index;
  if pfConfigure in Spps.SppItem[Index].PluginFunctions then
    Spps.SppItem[Index].Configure
  else
    ShowMessage('ǉ̐ݒ荀ڂ͂܂B');
end;

procedure TfrmSetting.edtLUIDEnter(Sender: TObject);
begin
  FOldLUID := edtLUID.Text;
end;

procedure TfrmSetting.edtLUIDExit(Sender: TObject);
var TmpLUID: String;
    i: integer;
    Err: boolean;
begin
  TmpLUID := edtLUID.Text;
  i := 1;
  Err := false;
  if Length(TmpLUID) <> 82 then
    Err := true
  else
    while i <= Length(TmpLUID) do
    begin
      if not (TmpLUID[i] in ['0'..'9', 'a'..'z', 'A'..'Z', '.', ',']) then
      begin
        Err := true;
        Break;
      end;
      Inc(i);
    end;
  if Err then
  begin
    ShowMessage('LUID̓esł');
    edtLUID.Text := FOldLUID;
  end;
end;

procedure TfrmSetting.btnCopyLUIDClick(Sender: TObject);
begin
  Clipboard.SetTextBuf(PChar(edtLUID.Text));
end;

procedure TfrmSetting.FormCreate(Sender: TObject);
var
  i: integer;
  Cap: String;
  Node: TTreeNode;
begin
  for i := 0 to PageControl.PageCount-1 do
  begin
    Cap := PageControl.Pages[i].Caption;
    if Pos(':', Cap) > 0 then
      Cap := Copy(Cap, 1, Pos(':', Cap)-1);
    Node := tvwCategory.Items.Add(nil, Cap);
    Node.ImageIndex := -1;
    Node.SelectedIndex := SettingIcon;
  end;
  tvwCategoryChange(Self, tvwCategory.Items[0]);
  tvwCategory.Items[0].Selected := true;
end;

procedure TfrmSetting.tvwCategoryChange(Sender: TObject; Node: TTreeNode);
begin
  PageControl.ActivePageIndex := Node.Index;
  pnlHeading.Caption := PageControl.ActivePage.Caption;
end;

procedure TfrmSetting.tvwCategoryMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var
  Node: TTreeNode;
  NewHint: String;
  CPos: TPoint;
begin
  Node := tvwCategory.GetNodeAt(X, Y);
  if Node <> nil then
  begin
    NewHint := PageControl.Pages[Node.Index].Caption;
    if tvwCategory.Hint <> NewHint then
    begin
      tvwCategory.Hint := NewHint;
      GetCursorPos(CPos);
      Application.ActivateHint(CPos);
    end;
  end else
  begin
    tvwCategory.Hint := '';
    Application.HideHint;
  end;
end;

procedure TfrmSetting.PlayTimeParamsToSpinControl(Params: TSsPlayTimeParams);
begin
  FSpinUpdateFlag := true;
  with Params do
  begin
    spnCostWait.Value         := CostWait;
    spnCostSurface.Value      := CostSurface;
    spnCostChar.Value         := CostChar;
    spnCostDBChar.Value       := CostDBChar;
    spnCostQuickChar.Value    := CostQuickChar;
    lvwCostSpecials.Items.Clear;
  end;
  FSpinUpdateFlag := false;
end;

procedure TfrmSetting.SpinControlToPlayTimeParams(Params: TSsPlayTimeParams);
begin
  with Params do
  begin
    CostWait         := spnCostWait.Value;
    CostSurface      := spnCostSurface.Value;
    CostChar         := spnCostChar.Value;
    CostDBChar       := spnCostDBChar.Value;
    CostQuickChar    := spnCostQuickChar.Value;
  end;
end;


procedure TfrmSetting.LoadPlayTimeProfiles;
var i: integer;
    F: TSearchRec;
    Path, Item: String;
begin
  Path := ExtractFilePath(Application.ExeName);
  i := FindFirst(Path + 'playtime\*.txt', 0, F);
  if i = 0 then begin
    repeat
      Item := ChangeFileExt(F.Name, '');
      if cbxPlayTimeProfile.Items.IndexOf(Item) < 0 then
        cbxPlayTimeProfile.Items.Add(ChangeFileExt(F.Name, ''));
      i := FindNext(F);
    until i <> 0;
  end;
  FindClose(F);
end;

procedure TfrmSetting.cbxPlayTimeProfileChange(Sender: TObject);
var
  Params: TSsPlayTimeParams;
  Strs: TStringList;
  Path, ProName: String;
begin
  try
    Strs := TStringList.Create;
    ProName := cbxPlayTimeProfile.Text;
    try
      Path := ExtractFilePath(Application.ExeName) + 'playtime\';
      Strs.LoadFromFile(Path + ProName + '.txt');
      Params := StringToComponent(Strs.Text) as TSsPlayTimeParams;
      try
        PlayTimeParamsToSpinControl(Params);
        Pref.PlayTimeParams.Assign(Params);
        UpdateSpecialChars;
      finally
        Params.Free;
      end;
    finally
      Strs.Free;
    end;
    with cbxPlayTimeProfile do
    begin
      Items.Clear;
      LoadPlayTimeProfiles;
      ItemIndex := Items.IndexOf(ProName);
    end;
  except
    ; // Do nothing
  end;
end;

procedure TfrmSetting.btnSavePlayTimeProfileClick(Sender: TObject);
var
  ProfileName, Path, FileName: String;
  Strs: TStringList;
begin
  ProfileName := cbxPlayTimeProfile.Text;
  if InputQuery('vt@C', 'ۑvt@C', ProfileName) then
  begin
    try
      Path := ExtractFilePath(Application.ExeName) + 'playtime\';
      FileName := Path + ProfileName + '.txt';
      if FileExists(FileName) then
        if MessageDlg(Format('vt@C"%s"㏑܂', [ProfileName]),
          mtConfirmation, mbOkCancel, 0) = mrCancel then
          Exit;
      Strs := TStringList.Create;
      try
        SpinControlToPlayTimeParams(Pref.PlayTimeParams);
        Pref.PlayTimeParams.ProfileName := ProfileName;
        Strs.Text := ComponentToString(Pref.PlayTimeParams);
        Strs.SaveToFile(FileName);
      finally
        Strs.Free;
      end;
      with cbxPlayTimeProfile do
      begin
        Items.Clear;
        Items.Add(ProfileName);
        ItemIndex := 0;
        LoadPlayTimeProfiles;
      end;
    except
      on E: Exception do
        ShowMessage('ۑɎs܂B' + E.Message);
    end;
  end;
end;

procedure TfrmSetting.spnCostWaitChange(Sender: TObject);
var
  ProName: String;
const
  Modified = '(ύXς)';
begin
  if FSpinUpdateFlag then
    Exit;
  ProName := cbxPlayTimeProfile.Text;
  if Copy(ProName, Length(ProName)-Length(Modified)+1, Length(Modified)) <> Modified then
  begin
    ProName := Format('%s%s', [ProName, Modified]);
    with cbxPlayTimeProfile do
    begin
      Items.Clear;
      Items.Add(ProName);
      ItemIndex := 0;
      LoadPlayTimeProfiles;
    end;
  end;
end;

procedure TfrmSetting.btnPlaySpecialAddClick(Sender: TObject);
var
  Item: TListItem;
  SPChar: TSsPlayTimeSpecialChar;
begin
  Application.CreateForm(TfrmSpecialCharEditor, frmSpecialCharEditor);
  try
    with frmSpecialCharEditor do
    begin
      SpecialChar := '';
      Cost := 50;
      if Execute then
      begin
        SPChar := Pref.PlayTimeParams.SpecialChars.Add as TSsPlayTimeSpecialChar;
        SPChar.Char := SpecialChar;
        SPChar.Wait := Cost;
        Item := lvwCostSpecials.Items.Add;
        Item.Caption := SPChar.DisplayChar;
        Item.SubItems.Add(IntToStr(Cost));
        spnCostWaitChange(Self);
      end;
    end;
  finally
    frmSpecialCharEditor.Release;
  end;
end;

procedure TfrmSetting.btnPlaySpecialDeleteClick(Sender: TObject);
begin
  with lvwCostSpecials do
    if Selected <> nil then
    begin
      Pref.PlayTimeParams.SpecialChars.Delete(Selected.Index);
      Selected.Delete;
      spnCostWaitChange(Self);
    end;
end;

procedure TfrmSetting.lvwCostSpecialsDblClick(Sender: TObject);
var
  Item: TListItem;
  SPChar: TSsPlayTimeSpecialChar;
begin
  with lvwCostSpecials do
  begin
    Item := Selected;
    if Item <> nil then
    begin
      Application.CreateForm(TfrmSpecialCharEditor, frmSpecialCharEditor);
      try
        with frmSpecialCharEditor do
        begin
          SPChar := Pref.PlayTimeParams.SpecialChars.Items[Item.Index] as TSsPlayTimeSpecialChar;
          SpecialChar := SPChar.Char;
          Cost := SPChar.Wait;
          if Execute then
          begin
            SPChar.Char := SpecialChar;
            SPChar.Wait := Cost;
            Item.Caption := SPChar.DisplayChar;
            Item.SubItems[0] := IntToStr(Cost);
            spnCostWaitChange(Self);
          end;
        end;
      finally
        frmSpecialCharEditor.Release;
      end;
    end;
  end;
end;

procedure TfrmSetting.UpdateSpecialChars;
var
  i: integer;
  Item: TListItem;
  SPChar: TSsPlayTimeSpecialChar;
begin
  with lvwCostSpecials do
  begin
    Items.Clear;
    for i := 0 to Pref.PlayTimeParams.SpecialChars.Count-1 do
    begin
      SPChar := Pref.PlayTimeParams.SpecialChars.Items[i] as TSsPlayTimeSpecialChar;
      Item := Items.Add;
      Item.Caption := SPChar.DisplayChar;
      Item.SubItems.Add(IntToStr(SPChar.Wait));
    end;
  end;
end;

procedure TfrmSetting.spnTabWidthChange(Sender: TObject);
begin
  with cbxAutoTabWidth do
  begin
    OnClick := nil;
    cbxAutoTabWidth.Checked := false;
    OnClick := cbxAutoTabWidthClick;
  end;
end;

procedure TfrmSetting.cbxAutoTabWidthClick(Sender: TObject);
begin
  with spnTabWidth do
  begin
    OnChange := nil;
    try
      if not cbxAutoTabWidth.Checked then
        if Value = 0 then
          Value := 80;
    finally
      OnChange := spnTabWidthChange;
    end;
  end;
end;

procedure TfrmSetting.btnBrowserLocateClick(Sender: TObject);
begin
  with BrowserLocateOpenDialog do
  begin
    FileName := edtBrowserName.Text;
    if Execute then
      edtBrowserName.Text := FileName;
  end;
end;

procedure TfrmSetting.tstPresetReplaceShow(Sender: TObject);
begin
  ReplacePresetList.UpdateControls;
end;

procedure TfrmSetting.cbxProxyNeedAuthenticationClick(Sender: TObject);
begin
  with cbxProxyNeedAuthentication do
  begin
    edtProxyUser.Enabled := Checked;
    edtProxyPass.Enabled := Checked;
    lblProxyUser.Enabled := Checked;
    lblProxyPass.Enabled := Checked;
  end;
end;

end.
