{
 SppList - SPPvOCĕێ
}

unit SppList;

interface

uses Classes, Windows, SysUtils, Contnrs, Forms, Dialogs,
  Graphics, ProgressWindow, Plugins;

type
  TLoadPluginEventType = (lpPreLoad, lpPostLoad);
  TLoadPluginEvent = procedure(Sender: TObject;
    Status: TLoadPluginEventType; Plugin: String) of object;

  TSppList = class(TObjectList)
  private
    FImageCache: TObjectList;
    FOnLoadPlugin: TLoadPluginEvent;
    function GetSppItem(Index: integer): TSppPlugin;
    procedure SetOnLoadPlugin(const Value: TLoadPluginEvent);
  public
    procedure ClearImagePool;
    constructor Create(OwnsObject: boolean);
    destructor Destroy; override;
    procedure LoadFromDirectory(Dir: String);
    function TryGetImage(const Ghost: String; const Surface: integer;
      Bitmap: TBitmap): boolean;
    property SppItem[Index: integer]: TSppPlugin read GetSppItem;
    property OnLoadPlugin: TLoadPluginEvent read FOnLoadPlugin write SetOnLoadPlugin;
  end;

var
  Spps: TSppList;

const
  MaxPoolImage = 100;

implementation


{ TSppList }

procedure TSppList.ClearImagePool;
begin
  FImageCache.Clear;
end;

constructor TSppList.Create(OwnsObject: boolean);
begin
  inherited Create(true);
  if OwnsObject = false then
    raise Exception.Create('TSppList.OwnsObject must be set to true');
  FImageCache := TObjectList.Create;
end;

destructor TSppList.Destroy;
begin
  FImageCache.Free;
  inherited;
end;

function TSppList.GetSppItem(Index: integer): TSppPlugin;
begin
  Result := Items[Index] as TSppPlugin;
end;

procedure TSppList.LoadFromDirectory(Dir: String);
var F: TSearchRec;
    i: integer;
    Item: TSppPlugin;
    ProgressWindow: TfrmProgressWindow;
begin
  Clear; // Oɓǂݍ񂾂̂͑S
  ClearImagePool;
  ProgressWindow := TfrmProgressWindow.Create(nil);
  try
    ProgressWindow.Show;
    i := FindFirst(Dir + '\*.dll', 0, F);
    if i = 0 then begin
      repeat
        try
          if Assigned(FOnLoadPlugin) then
            FOnLoadPlugin(Self, lpPreLoad, F.Name);
          ProgressWindow.StatusText := Format('vOC%sǂݍݒ...', [F.Name]);
          Item := TSppPlugin.Create(Dir + '\' + F.Name);
          Self.Add(Item);
          if Assigned(FOnLoadPlugin) then
            FOnLoadPlugin(Self, lpPostLoad, F.Name);
        except
          on E: ESppException do
          begin
            ShowMessage('SPPvOC[hs:'#13#10 + E.Message);
          end;
        end;
        i := FindNext(F);
      until i <> 0;
    end;
    FindClose(F);
  finally
    ProgressWindow.Free;
  end;
end;

procedure TSppList.SetOnLoadPlugin(const Value: TLoadPluginEvent);
begin
  FOnLoadPlugin := Value;
end;

function TSppList.TryGetImage(const Ghost: String; const Surface: integer;
  Bitmap: TBitmap): boolean;
var i, j: integer;
    SppImage: TSppImage;
begin
  Result := false;

  // ɃLbVς݂̏ꍇ
  for i := 0 to FImageCache.Count-1 do
  begin
    if (FImageCache[i] as TSppImage).KeyMatchTest(Ghost, Surface, 0) then
    begin
      OutputDebugString(PChar('Cache Used: ' + Ghost + IntToStr(Surface)));
      Result := true;
      Bitmap.Assign((FImageCache[i] as TSppImage).Bitmap);
      FImageCache.Move(i, 0); // 擪ɎĂ
      Exit;
    end;
  end;
  SppImage := nil;
  // DLLۂɌĂяoČ
  for i := 0 to Self.Count-1 do
  begin
    SppImage :=  (Items[i] as TSppPlugin).GetImage(Ghost, Surface, 0);
    if SppImage <> nil then
    begin
      Result := true;
      Bitmap.Assign(SppImage.Bitmap);
      Break;
    end;
  end;
  // DLLĂяǒʂLbV
  if SppImage <> nil then
  begin
    FImageCache.Insert(0, SppImage);
  end else
  begin
    SppImage := TSppImage.Create;
    SppImage.Ghost := Ghost;
    SppImage.SurfaceKey := IntToStr(Surface) + ',*';
    FImageCache.Insert(0, SppImage);
  end;

  // ӂꂽLbṼNA
  if FImageCache.Count > MaxPoolImage then
    for j := FImageCache.Count-1 downto MaxPoolImage do
      FImageCache.Delete(j);
end;

initialization

Spps := TSppList.Create(true);

finalization

Spps.Free;

end.
