unit StrReplace;

{
  StrReplace.pas
  GUIƗAu֘AWbNNX̎
}

interface

uses Classes, SysUtils, Forms, Menus, RegexUtils, Contnrs;

type
  // ȉ5̃NX̒`́A灨傫ցA
  // LqĂ(܂܂܂ޕȀ)

  // ƒũyAƂ̃IvVL^\
  TReplacePairRec = record
    BeforeStr: string;
    AfterStr:  string;
    IgnoreCase: boolean;
    UseRegExp: boolean;
  end;

  // ƒũyAƂ̃IvVL^NX
  TReplacePair = class(TCollectionItem)
  private
    FPairRec: TReplacePairRec;
    procedure SetAfterStr(const Value: string);
    procedure SetBeforeStr(const Value: string);
    procedure SetIgnoreCase(const Value: boolean);
    procedure SetUseRegExp(const Value: boolean);
    function GetAfterStr: string;
    function GetBeforeStr: string;
    function GetIgnoreCase: boolean;
    function GetUseRegExp: boolean;
  public
    constructor Create(Collection: TCollection); override;
    function ExecuteReplace(TargetStr: string): string;
    procedure Assign(Source: TPersistent); override;
    procedure Clear;
    function IsValidPair: Boolean;
  published
    property BeforeStr: string read GetBeforeStr write SetBeforeStr;
    property AfterStr: string read GetAfterStr write SetAfterStr;
    property IgnoreCase: boolean read GetIgnoreCase write SetIgnoreCase default false;
    property UseRegExp: boolean read GetUseRegExp write SetUseRegExp default false;
  end;

  // TReplacePair̃RNVNXB
  TReplacePairCollection = class(TCollection)
  private
    function GetItem(Index: Integer): TReplacePair;
  public
    function Add: TReplacePair;
    property Items[Index: Integer]: TReplacePair read GetItem; default;
    function ExecuteReplace(TargetStr: string): string;
    function StringExpression: string;
  end;

  // TReplacePair̃RNVێA^CgȂǂ܂Ƃ߂
  // 1̃vZbgݒ荀ڂ\NX
  TReplacePreset = class(TCollectionItem)
  private
    FTitle: string;
    FPairs: TReplacePairCollection;
    FShortCut: TShortCut;
    FConfirmAfterReplace: Boolean;
    procedure SetPairs(const Value: TReplacePairCollection);
    procedure SetShortCut(const Value: TShortCut);
    procedure SetTitle(const Value: string);
    procedure SetConfirmAfterReplace(const Value: Boolean);
  public
    constructor Create(Collection: TCollection); override;
    destructor Destroy; override;
    procedure Assign(Source: TPersistent); override;
  published
    property Pairs: TReplacePairCollection read FPairs write SetPairs;
    property Title: string read FTitle write SetTitle;
    property ShortCut: TShortCut read FShortCut write SetShortCut;
    property ConfirmAfterReplace: Boolean read FConfirmAfterReplace write SetConfirmAfterReplace;
  end;

  TReplacePresetCollection = class(TCollection)
  private
    function GetItem(Index: Integer): TReplacePreset;
  public
    function Add: TReplacePreset;
    property Items[Index: Integer]: TReplacePreset read GetItem; default;
  end;

  // ŏIIɂVACY
  TReplacePresets = class(TComponent)
  private
    FPresets: TReplacePresetCollection;
    procedure SetPresets(const Value: TReplacePresetCollection);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Assign(Source: TPersistent); override;
  published
    property Presets: TReplacePresetCollection read FPresets write SetPresets;
  end;

implementation

{ TReplacePair }

procedure TReplacePair.Assign(Source: TPersistent);
begin
  if not (Source is TReplacePair) then
    inherited
  else
    FPairRec := (Source as TReplacePair).FPairRec;
end;

procedure TReplacePair.Clear;
begin
  with FPairRec do
  begin
    BeforeStr := '';
    AfterStr := '';
    UseRegExp := false;
    IgnoreCase := false;
  end;
end;

constructor TReplacePair.Create(Collection: TCollection);
begin
  inherited;
  IgnoreCase := true;
end;

function TReplacePair.ExecuteReplace(TargetStr: string): string;
var
  Options: TReplaceFlags;
begin
  // 1̒u
  Result := TargetStr;
  Options := [rfReplaceAll];
  if IgnoreCase then
    Options := Options + [rfIgnoreCase];
  if UseRegExp then
    Result := StringReplaceRegExp(Result, BeforeStr, AfterStr, Options)
  else
    Result := StringReplace(Result, BeforeStr, AfterStr, Options);
end;

function TReplacePair.GetAfterStr: string;
begin
  Result := FPairRec.AfterStr;
end;

function TReplacePair.GetBeforeStr: string;
begin
  Result := FPairRec.BeforeStr;
end;

function TReplacePair.GetIgnoreCase: boolean;
begin
  Result := FPairRec.IgnoreCase;
end;

function TReplacePair.GetUseRegExp: boolean;
begin
  Result := FPairRec.UseRegExp;
end;

function TReplacePair.IsValidPair: Boolean;
begin
  Result := true;
  if BeforeStr = '' then
    Result := false
  else
    try
      ExecuteReplace(' ')
    except
      Result := false;
    end;
end;

procedure TReplacePair.SetAfterStr(const Value: string);
begin
  FPairRec.AfterStr := Value;
end;

procedure TReplacePair.SetBeforeStr(const Value: string);
begin
  FPairRec.BeforeStr := Value;
end;

procedure TReplacePair.SetIgnoreCase(const Value: boolean);
begin
  FPairRec.IgnoreCase := Value;
end;

procedure TReplacePair.SetUseRegExp(const Value: boolean);
begin
  FPairRec.UseRegExp := Value;
end;

{ TReplacePreset }

procedure TReplacePreset.Assign(Source: TPersistent);
var
  Src: TReplacePreset;
begin
  if not (Source is TReplacePreset) then
    inherited
  else
  begin
    Src := Source as TReplacePreset;
    Pairs.Assign(Src.Pairs);
    Title := Src.Title;
    ShortCut := Src.ShortCut;
    ConfirmAfterReplace := Src.ConfirmAfterReplace;
  end;
end;

constructor TReplacePreset.Create(Collection: TCollection);
begin
  inherited;
  FPairs := TReplacePairCollection.Create(TReplacePair);
end;

destructor TReplacePreset.Destroy;
begin
  FPairs.Free;
  inherited;
end;

procedure TReplacePreset.SetPairs(const Value: TReplacePairCollection);
begin
  FPairs.Assign(Value);
end;

procedure TReplacePreset.SetShortCut(const Value: TShortCut);
begin
  FShortCut := Value;
end;

procedure TReplacePreset.SetTitle(const Value: string);
begin
  FTitle := Value;
end;

procedure TReplacePreset.SetConfirmAfterReplace(const Value: Boolean);
begin
  FConfirmAfterReplace := Value;
end;

{ TReplacePresets }

procedure TReplacePresets.Assign(Source: TPersistent);
begin
  if not (Source is TReplacePresets) then
    inherited
  else
  begin
    FPresets.Assign((Source as TReplacePresets).FPresets);
  end;
end;

constructor TReplacePresets.Create(AOwner: TComponent);
begin
  inherited;
  FPresets := TReplacePresetCollection.Create(TReplacePreset);
end;

destructor TReplacePresets.Destroy;
begin
  FPresets.Free;
  inherited;
end;

procedure TReplacePresets.SetPresets(
  const Value: TReplacePresetCollection);
begin
  FPresets.Assign(Value);
end;

{ TReplacePairCollection }

function TReplacePairCollection.Add: TReplacePair;
begin
  Result := inherited Add as TReplacePair;
end;

function TReplacePairCollection.ExecuteReplace(TargetStr: string): string;
var
  i: Integer;
begin
  Result := TargetStr;
  for i := 0 to Count-1 do
  begin
    Result := (Items[i] as TReplacePair).ExecuteReplace(Result);
  end;
end;

function TReplacePairCollection.GetItem(Index: Integer): TReplacePair;
begin
  Result := (inherited GetItem(Index)) as TReplacePair;
end;

function TReplacePairCollection.StringExpression: string;
var
  i: Integer;
begin
  Result := '';
  for i := 0 to Count-1 do
  begin
    if i > 0 then
      Result := Result + 'A';
    Result := Result + Format('u%svu%sv',
      [Items[i].BeforeStr, Items[i].AfterStr]);
  end;
end;

{ TReplacePresetCollection }

function TReplacePresetCollection.Add: TReplacePreset;
begin
  Result := inherited Add as TReplacePreset;
end;

function TReplacePresetCollection.GetItem(Index: Integer): TReplacePreset;
begin
  Result := inherited GetItem(Index) as TReplacePreset;
end;

initialization

Classes.RegisterClass(TReplacePresets);

end.
