unit StrReplaceDialog;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrReplaceFrame, StrReplace, RegexUtils;

type
  TfrmStrReplaceDialog = class(TForm)
    frmStrReplaceFrame: TfrmStrReplaceFrame;
    btnOk: TButton;
    btnCancel: TButton;
    procedure btnCancelClick(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
  private
    function GetPair: TReplacePair;
    procedure SetPair(const Value: TReplacePair);
    { Private 錾 }
  public
    property Pair: TReplacePair read GetPair write SetPair;
    function Execute: boolean;
  end;

var
  frmStrReplaceDialog: TfrmStrReplaceDialog;

implementation

{$R *.dfm}

procedure TfrmStrReplaceDialog.btnCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TfrmStrReplaceDialog.btnOkClick(Sender: TObject);
var
  Dummy: String;
begin
  with Pair do
  begin
    if UseRegExp and
      (SafeAndCheckRegExpSubst(BeforeStr, AfterStr, [rfReplaceAll], Dummy) <> '') then
    begin
      ShowMessage('K\Ɍ肪܂B');
      Exit;
    end;
    if BeforeStr = '' then
    begin
      ShowMessage('w肵ĂB');
      Exit;
    end;
  end;
  ModalResult := mrOk;
end;

function TfrmStrReplaceDialog.Execute: boolean;
begin
  Result := ShowModal = mrOk;
end;

function TfrmStrReplaceDialog.GetPair: TReplacePair;
begin
  Result := frmStrReplaceFrame.Pair;
end;

procedure TfrmStrReplaceDialog.SetPair(const Value: TReplacePair);
begin
  frmStrReplaceFrame.Pair := Value;
end;

end.
