{*******************************************************}
{       TSakuraScriptFountain - TEditor Fountain Parser }
{                                                       }
{       Copyright (c) 2003 naruto/CANO-Lab              }
{*******************************************************}

unit SakuraScriptFountain;

interface

uses
  SysUtils, Classes, heClasses, heFountain, heRaStrings, SsParser;

type
  TSakuraScriptFountainParser = class(TFountainParser)
  protected
    function GetTalkToken: char;
    procedure InitMethodTable; override;
    procedure TagProc;
    procedure MetaProc;
    procedure SymbolProc; override;
    function SsParser: TSsParser;
    function IsScope0ChangeTag(const Tag: String): boolean; virtual;
    function IsScope1ChangeTag(const Tag: String): boolean; virtual;
  public
    function NextToken: Char; override;
    function TokenToFountainColor: TFountainColor; override;
  end;

  TSakuraScriptFountain = class(TFountain)
  private
    FScope0Color: TFountainColor;
    FScope1Color: TFountainColor;
    FTagColor: TFountainColor;
    FMetaWordColor: TFountainColor;
    FTagErrorColor: TFountainColor;
    FSynchronizedColor: TFountainColor;
    FSakuraScriptParser: TSsParser;
    FProcessSync: boolean;
    FChangeScopeByHU: boolean;
    FChangeScopeBy01: boolean;
    procedure SetMetaWordColor(const Value: TFountainColor);
    procedure SetScope0Color(const Value: TFountainColor);
    procedure SetScope1Color(const Value: TFountainColor);
    procedure SetTagColor(const Value: TFountainColor);
    procedure SetTagErrorColor(const Value: TFountainColor);
    procedure SetSynchronizedColor(const Value: TFountainColor);
    procedure SetSakuraScriptParser(const Value: TSsParser);
    procedure SetChangeScopeBy01(const Value: boolean);
    procedure SetChangeScopeByHU(const Value: boolean);
    procedure SetProcessSync(const Value: boolean);
    { Private 錾 }
  protected
    { Protected 錾 }
    procedure CreateFountainColors; override;
    function GetParserClass: TFountainParserClass; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property Scope0Color: TFountainColor read FScope0Color write SetScope0Color;
    property Scope1Color: TFountainColor read FScope1Color write SetScope1Color;
    property TagColor: TFountainColor read FTagColor write SetTagColor;
    property TagErrorColor: TFountainColor read FTagErrorColor write SetTagErrorColor;
    property MetaWordColor: TFountainColor read FMetaWordColor write SetMetaWordColor;
    property SynchronizedColor: TFountainColor read FSynchronizedColor write SetSynchronizedColor;
    property SakuraScriptParser: TSsParser read FSakuraScriptParser write SetSakuraScriptParser;
    property ChangeScopeBy01: boolean read FChangeScopeBy01 write SetChangeScopeBy01 default true;
    property ChangeScopeByHU: boolean read FChangeScopeByHU write SetChangeScopeByHU default true;
    property ProcessSync: boolean read FProcessSync write SetProcessSync default true;
  published
    { Published 錾 }
  end;

procedure Register;

implementation

const
  { g[N̎ނ\萔(񋓌^Ƃđ₹Ȃ) }
  toScope0   = char(50); //XR[v0
  toScope1   = char(51); //XR[v1
  toTag      = char(52); //^O
  toTagError = char(53); //^O\LG[
  toMetaWord = char(54); //^
  toSynchronized = char(55); //VNiCYhZbV

  InScope1 = $1;
  InSynchronized = $2;

{ TSakuraScriptFountain }

constructor TSakuraScriptFountain.Create(AOwner: TComponent);
begin
  inherited;
  FChangeScopeByHU := true;
  FChangeScopeBy01 := true;
  FProcessSync := true;
end;

procedure TSakuraScriptFountain.CreateFountainColors;
begin
  inherited;
  FScope0Color       := CreateFountainColor;
  FScope1Color       := CreateFountainColor;
  FTagColor          := CreateFountainColor;
  FTagErrorColor     := CreateFountainColor;
  FMetaWordColor     := CreateFountainColor;
  FSynchronizedColor := CreateFountainColor;
end;

destructor TSakuraScriptFountain.Destroy;
begin
  FScope0Color.Free;
  FScope1Color.Free;
  FTagColor.Free;
  FTagErrorColor.Free;
  FMetaWordColor.Free;
  FSynchronizedColor.Free;
  inherited;
end;

function TSakuraScriptFountain.GetParserClass: TFountainParserClass;
begin
  Result := TSakuraScriptFountainParser;
end;

procedure TSakuraScriptFountain.SetChangeScopeBy01(const Value: boolean);
begin
  FChangeScopeBy01 := Value;
end;

procedure TSakuraScriptFountain.SetChangeScopeByHU(const Value: boolean);
begin
  FChangeScopeByHU := Value;
end;

procedure TSakuraScriptFountain.SetMetaWordColor(
  const Value: TFountainColor);
begin
  FMetaWordColor.Assign(Value);
end;

procedure TSakuraScriptFountain.SetProcessSync(const Value: boolean);
begin
  FProcessSync := Value;
end;

procedure TSakuraScriptFountain.SetSakuraScriptParser(
  const Value: TSsParser);
begin
  FSakuraScriptParser := Value;
end;

procedure TSakuraScriptFountain.SetScope0Color(
  const Value: TFountainColor);
begin
  FScope0Color.Assign(Value);
end;

procedure TSakuraScriptFountain.SetScope1Color(
  const Value: TFountainColor);
begin
  FScope1Color.Assign(Value);
end;

procedure TSakuraScriptFountain.SetSynchronizedColor(
  const Value: TFountainColor);
begin
  FSynchronizedColor.Assign(Value);
end;

procedure TSakuraScriptFountain.SetTagColor(const Value: TFountainColor);
begin
  FTagColor.Assign(Value);
end;

procedure TSakuraScriptFountain.SetTagErrorColor(
  const Value: TFountainColor);
begin
  FTagErrorColor.Assign(Value);
end;

{ TSakuraScriptFountainParser }

function TSakuraScriptFountainParser.GetTalkToken: char;
begin
  if (FElementIndex or InSynchronized) > 0 then
    Result := toSynchronized
  else if (FElementIndex or InScope1) > 0 then
    Result := toScope1
  else
    Result := toScope0;
end;

procedure TSakuraScriptFountainParser.InitMethodTable;
begin
  inherited;
  FMethodTable['\'] := TagProc;
  FMethodTable['%'] := MetaProc;
end;


function TSakuraScriptFountainParser.IsScope0ChangeTag(
  const Tag: String): boolean;
begin
  Result := false;
  if (Self.FFountain as TSakuraScriptFountain).ChangeScopeBy01 then
    if Tag = '\0' then
      Result := true;
  if (Self.FFountain as TSakuraScriptFountain).ChangeScopeByHU then
    if Tag = '\h' then
      Result := true;
end;

function TSakuraScriptFountainParser.IsScope1ChangeTag(
  const Tag: String): boolean;
begin
  Result := false;
  if (Self.FFountain as TSakuraScriptFountain).ChangeScopeBy01 then
    if Tag = '\1' then
      Result := true;
  if (Self.FFountain as TSakuraScriptFountain).ChangeScopeByHU then
    if Tag = '\u' then
      Result := true;
end;

procedure TSakuraScriptFountainParser.MetaProc;
var i, Le: integer;
begin
  Inc(FP);
  for i := 0 to SsParser.MetaPattern.Count-1 do
  begin
    Le := SsParser.MatchP(FP, PChar(SsParser.MetaPattern[i]));
    if Le > 0 then
    begin
      FToken := toMetaWord;
      Inc(FP, Le);
      Exit; // ߂ł^Ƃĉ͊
    end else
  end;
  SymbolProc; // PɕƂĈ
end;

function TSakuraScriptFountainParser.NextToken: Char;
begin
  // ̃NX̃LB
  // toIntegertoDBSymbol̃g[N͕svŁA
  // ɂ̃Ztǂ̃XR[vȂ̂KvȂ̂ŁA
  // g[N㏑
  inherited NextToken;
  if FToken = toTag then
  begin
    if IsScope1ChangeTag(TokenString) then
      FElementIndex := FElementIndex or InScope1
    else if IsScope0ChangeTag(TokenString) then
      FElementIndex := FElementIndex and not InScope1
    else if (FFountain as TSakuraScriptFountain).ProcessSync and
      (TokenString = '\_s') then
      FElementIndex := FElementIndex xor InSynchronized;
  end else
  begin
    if FToken in [toSymbol..toFloat, toAnk, toDBSymbol..toKana, toHex] then
    begin
      if (FElementIndex and InSynchronized) > 0 then
        FToken := toSynchronized
      else if (FElementIndex and InScope1) > 0 then
        FToken := toScope1
      else
        FToken := toScope0;
    end;
  end;
  Result := FToken;
end;

procedure TSakuraScriptFountainParser.SymbolProc;
// '\''%'ȊO͍ɓǂݔ΂BvȂB
// _uoCgVOoCgĒPȂV{ƂĈB
begin
  FToken := toSymbol;
  if not (FP^ in [#0, #9, #10, #13, '\', '%']) then
    if FP^ in LeadBytes then
      Inc(FP, 2)
    else
      Inc(FP);
end;

function TSakuraScriptFountainParser.SsParser: TSsParser;
begin
  Result := (FFountain as TSakuraScriptFountain).SakuraScriptParser;
  if Result = nil then raise Exception.Create('SakuraScriptParser property is nil');
end;

procedure TSakuraScriptFountainParser.TagProc;
var i, Le: integer;
    IsErr: boolean;
    Pat: String;
begin
  Inc(FP);
  if (FP^ in [#0, #13, #10]) then
  begin
    FToken := toTagError;
    Exit;
  end else if (FP^ = '\') or (FP^ = '%') then // '\\', '\%'`̃GXP[v
  begin
    Inc(FP);
    SymbolProc;
  end else
  begin
    for i := 0 to SsParser.TagPattern.Count-1 do
    begin
      Pat := SsParser.TagPattern[i];
      if Length(Pat) < 2 then Continue;
      IsErr := Pat[1] = '!';
      Le := SsParser.MatchP(FP, @Pat[2]);
      if Le > 0 then
      begin
        Inc(FP, Le);
        if IsErr then
          FToken := toTagError
        else
          FToken := toTag;
        Exit; // ߂łp^[}b`̏ꍇ
      end;
    end;
    // ȉ̓p^[擾s̏ꍇ
    FToken := toTagError;
    if FP^ in LeadBytes then
      Inc(FP, 2)
    else
      Inc(FP);
  end;
end;

function TSakuraScriptFountainParser.TokenToFountainColor: TFountainColor;
begin
  with TSakuraScriptFountain(FFountain) do
    case FToken of
      toScope0:
        Result := FScope0Color;
      toScope1:
        Result := FScope1Color;
      toTag:
        Result := FTagColor;
      toTagError:
        Result := FTagErrorColor;
      toMetaWord:
        Result := FMetaWordColor;
      toSynchronized:
        Result := FSynchronizedColor;
    else
        Result := nil;
    end;
end;

procedure Register;
begin
  RegisterComponents('TEditor', [TSakuraScriptFountain]);
end;

end.
