{********************************************************}
{ SakuraSeeker Component - Listups Existing SSTP Servers }
{                                                        }
{       Copyright (c) 2001-2003 naruto/CANO-Lab          }
{********************************************************}

unit SakuraSeeker;

interface

uses
  Windows, SysUtils, Classes, Contnrs;

type
  ESakuraSeekerError = class(Exception);

  TSakuraSeeker = class;

  TSakuraSeekerGetMutexNameEvent = procedure (Sender: TObject;
    var Name: String) of object;

  TSakuraProcess = class(TObject)
  private
    FHash: TStringList;
    FProcessID: String;
    FFMOName: String;
    FOwner: TSakuraSeeker;
    procedure SetProcessID(const Value: String);
    function GetHWnd: THandle;
    function GetName: String;
    function GetData(Key: String): String;
    function GetKeroName: String;
    function GetSetName: String;
    procedure SetFMOName(const Value: String);
    function GetDataAt(Index: integer): String;
    function GetCount: integer;
    function GetKeyAt(Index: integer): String;
  protected
    procedure AppendData(const Key, Value: String);
  public
    constructor Create(AOwner: TSakuraSeeker);
    destructor Destroy; override;
    property ProcessID: String read FProcessID write SetProcessID;
    property FMOName: String read FFMOName write SetFMOName;
    property HWnd: THandle read GetHWnd;
    property Name: String read GetName;
    property KeroName: String read GetKeroName;
    property SetName: String read GetSetName;
    property Data[Key: String]: String read GetData;
    property Count: integer read GetCount;
    property DataAt[Index: integer]: String read GetDataAt;
    property KeyAt[Index: integer]: String read GetKeyAt;
  end;

  TSakuraSeeker = class(TComponent)
  private
    { Private 錾 }
    FList: TObjectList;
    FAutoDetect: boolean;
    FOnAfterDetection: TNotifyEvent;
    FLastSeekResult: String; //O̎擾ʁBrp
    FSourceResult: String;   //̎擾ʁBrp
    FOnDetectResultChanged: TNotifyEvent;
    FFileMappingTarget: TStrings;
    FOnGetMutexName: TSakuraSeekerGetMutexNameEvent;
    FMutexPool: TStringList;
    function GetProcess(Index: integer): TSakuraProcess;
    procedure SetAutoDetect(const Value: boolean);
    function GetProcessByName(Name: String): TSakuraProcess;
    function GetProcessByID(ID: String): TSakuraProcess;
    function GetCount: integer;
    procedure SetOnAfterDetection(const Value: TNotifyEvent);
    procedure SetOnDetectResultChanged(const Value: TNotifyEvent);
    procedure SetFileMappingTarget(const Value: TStrings);
    function GetProcessBySetName(Name: String): TSakuraProcess;
    procedure SetOnGetMutexName(
      const Value: TSakuraSeekerGetMutexNameEvent);
  protected
    { Protected 錾 }
    procedure Loaded; override;
    procedure ClearList;
    procedure BeginDetectOne(const Target: String);
    function GetMutexName(const Target: String): String;
    function GetMutex(const Name: String): THandle;
  public
    { Public 錾 }
    procedure BeginDetect;
    property Count: integer read GetCount;
    property Process[Index: integer]: TSakuraProcess read GetProcess; default;
    property ProcessByName[Name: String]: TSakuraProcess read GetProcessByName;
    property ProcessBySetName[Name: String]: TSakuraProcess read GetProcessBySetName;
    property ProcessByID[ID: String]: TSakuraProcess read GetProcessByID;
    function KillFMO(const TargetFMOName, TargetID: String): boolean;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published 錾 }
    property AutoDetect: boolean read FAutoDetect write SetAutoDetect default true;
    property OnAfterDetection: TNotifyEvent read FOnAfterDetection write SetOnAfterDetection;
    property OnDetectResultChanged: TNotifyEvent read FOnDetectResultChanged write SetOnDetectResultChanged;
    property FileMappingTarget: TStrings read FFileMappingTarget write SetFileMappingTarget;
    property OnGetMutexName: TSakuraSeekerGetMutexNameEvent read FOnGetMutexName write SetOnGetMutexName;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TSakuraSeeker]);
end;

{ TSakuraProcess }

procedure TSakuraProcess.AppendData(const Key, Value: String);
begin
  FHash.Values[Key] := Value;
end;

constructor TSakuraProcess.Create(AOwner: TSakuraSeeker);
begin
  FHash := TStringList.Create;
  FOwner := AOwner;
end;

destructor TSakuraProcess.Destroy;
begin
  inherited;
  FHash.Free;
end;

function TSakuraProcess.GetCount: integer;
begin
  Result := FHash.Count;
end;

function TSakuraProcess.GetData(Key: String): String;
begin
  Result := FHash.Values[Key];
end;

function TSakuraProcess.GetDataAt(Index: integer): String;
begin
  if Index >= 0 then
    Result := Copy(FHash[Index], Length(FHash.Names[Index]) + 2, High(integer))
  else
    Result := '';
end;

function TSakuraProcess.GetHWnd: THandle;
begin
  Result := StrToIntDef(GetData('hwnd'), 0);
end;

function TSakuraProcess.GetKeroName: String;
begin
  Result := GetData('keroname');
end;

function TSakuraProcess.GetKeyAt(Index: integer): String;
begin
  Result := FHash.Names[Index];
end;

function TSakuraProcess.GetName: String;
begin
  Result := GetData('name');
end;


function TSakuraProcess.GetSetName: String;
begin
  Result := GetName + ',' + GetKeroName;
end;

procedure TSakuraProcess.SetFMOName(const Value: String);
begin
  FFMOName := Value;
end;

procedure TSakuraProcess.SetProcessID(const Value: String);
begin
  FProcessID := Value;
end;

{ TSakuraSeeker }

procedure TSakuraSeeker.BeginDetect;
var i: integer;
begin
  if [csDesigning, csLoading] * ComponentState <> [] then Exit;
  ClearList;

  FSourceResult := '';
  for i := 0 to FFileMappingTarget.Count-1 do begin
    BeginDetectOne(FFileMappingTarget[i]); //1File-mapping Object擾
  end;

  if Assigned(OnDetectResultChanged) and (FLastSeekResult <> FSourceResult) then begin
    FLastSeekResult := FSourceResult;
    OnDetectResultChanged(Self);
  end else begin
    FLastSeekResult := FSourceResult;
  end;

  if Assigned(OnAfterDetection) then OnAfterDetection(Self);
end;

procedure TSakuraSeeker.BeginDetectOne(const Target: String);
var MappingHandle, Mutex: THandle;
    P, PSaved: pointer;
    SourceStr, ID, Entry, Data: String;
    Size: integer;
    Strs: TStringList;
    Pro: TSakuraProcess;
    i, j: integer;
begin
  //t@C}bsOIuWFNg̎擾
  PSaved := nil;
  Strs := nil;
  MappingHandle := 0;
  
  Mutex := GetMutex(GetMutexName(Target));
  if Mutex = 0 then
    raise ESakuraSeekerError.Create('Mutexnh擾ł܂ł');
  if WaitForSingleObject(Mutex, 3000) = WAIT_TIMEOUT then
    raise ESakuraSeekerError.Create('Mutex^CAEg');
  try
    MappingHandle := OpenFileMapping(FILE_MAP_READ, false, PChar(Target));
    try
      if MappingHandle = 0 then begin
        SourceStr := '';
      end else begin
        PSaved := MapViewOfFile(MappingHandle, FILE_MAP_READ, 0, 0, 0);
        P := PSaved;
        if P <> nil then begin
          CopyMemory(@Size, P, SizeOf(integer));
          Inc(PChar(P), SizeOf(integer));
          SourceStr := PChar(P);
          if Length(SourceStr) > Size then
            raise ESakuraSeekerError.Create('FMO擾ł܂ł');
        end;
      end;
    finally
      //IuWFNg̔j
      if PSaved <> nil then UnmapViewOfFile(PSaved);
    end;
  finally
    if MappingHandle <> 0 then CloseHandle(MappingHandle);
    ReleaseMutex(Mutex);
  end;

  //f[^
  try
    try
      Strs := TStringList.Create;
      Strs.Text := SourceStr;
      for i := 0 to Strs.Count-1 do begin
        j := Pos('.', Strs[i]);
        ID := Copy(Strs[i], 1, j-1);
        Entry := Copy(Strs[i], j+1, Pos(#1, Strs[i])-j-1);
        Data := Copy(Strs[i], Pos(#1, Strs[i])+1, High(integer));
        Pro := GetProcessByID(ID);
        if Pro = nil then begin
          Pro := TSakuraProcess.Create(self);
          Pro.ProcessID := ID;
          Pro.FMOName := Target; // FMOʖ
          FList.Add(Pro);
        end;
        Pro.AppendData(Entry, Data);
      end;
    except
    end;
  finally
    Strs.Free;
  end;
  FSourceResult := FSourceResult + SourceStr;
end;

procedure TSakuraSeeker.ClearList;
begin
  FList.Clear;
end;

constructor TSakuraSeeker.Create(AOwner: TComponent);
begin
  inherited;
  FAutoDetect := true;
  FList := TObjectList.Create;
  FFileMappingTarget := TStringList.Create;
  FFileMappingTarget.Add('Sakura');
  FMutexPool := TStringList.Create;
end;

destructor TSakuraSeeker.Destroy;
var i: integer;
begin
  ClearList;
  FList.Free;
  FFileMappingTarget.Free;
  for i := 0 to FMutexPool.Count-1 do
  begin
    CloseHandle(StrToInt(Copy(FMutexPool[i], Pos('=', FMutexPool[i])+1, High(integer))));
  end;
  FreeAndNil(FMutexPool);
end;

function TSakuraSeeker.GetCount: integer;
begin
  Result := FList.Count;
end;

function TSakuraSeeker.GetMutex(const Name: String): THandle;
begin
  if FMutexPool.Values[Name] <> '' then
  begin
    Result := THandle(StrToInt(FMutexPool.Values[Name]));
  end else
  begin
    Result := CreateMutex(nil, false, PChar(Name));
    if Result <> 0 then
      FMutexPool.Values[Name] := IntToStr(Result);
  end;
end;

function TSakuraSeeker.GetMutexName(const Target: String): String;
begin
  if Assigned(FOnGetMutexName) then
  begin
    Result := Target;
    FOnGetMutexName(self, Result);
  end else
    Result := Target + 'FMO';
end;

function TSakuraSeeker.GetProcess(Index: integer): TSakuraProcess;
begin
  Result := FList[Index] as TSakuraProcess;
end;

function TSakuraSeeker.GetProcessByID(ID: String): TSakuraProcess;
var i: integer;
begin
  Result := nil;
  for i := 0 to FList.Count-1 do begin
    if TSakuraProcess(FList[i]).ProcessID = ID then begin
      Result := FList[i] as TSakuraProcess;
      Exit;
    end;
  end;
end;

function TSakuraSeeker.GetProcessByName(Name: String): TSakuraProcess;
var i: integer;
begin
  Result := nil;
  for i := 0 to FList.Count-1 do begin
    if (FList[i] as TSakuraProcess).Name = Name then begin
      Result := FList[i] as TSakuraProcess;
      Exit;
    end;
  end;
end;

function TSakuraSeeker.GetProcessBySetName(Name: String): TSakuraProcess;
var i: integer;
begin
  Result := nil;
  for i := 0 to FList.Count-1 do begin
    if (FList[i] as TSakuraProcess).SetName = Name then begin
      Result := FList[i] as TSakuraProcess;
      Exit;
    end;
  end;
end;

function TSakuraSeeker.KillFMO(const TargetFMOName, TargetID: String): boolean;
var MappingHandle, Mutex: THandle;
    P: pointer;
    SourceStr, ID: String;
    Size: integer;
    Strs: TStringList;
    i, j: integer;
begin
  //t@C}bsOIuWFNg̎擾
  Result := false;
  P := nil;
  Mutex := GetMutex(GetMutexName(TargetFMOName));
  if Mutex = 0 then
    raise ESakuraSeekerError.Create('Mutexnh擾ł܂ł');
  if WaitForSingleObject(Mutex, 3000) = WAIT_TIMEOUT then
    raise ESakuraSeekerError.Create('Mutex^CAEg');
  try
    MappingHandle := OpenFileMapping(FILE_MAP_WRITE, false, PChar(TargetFMOName));
    if MappingHandle = 0 then Exit;
    try
      SourceStr := '';
      P := MapViewOfFile(MappingHandle, FILE_MAP_WRITE, 0, 0, 0);
      if P <> nil then begin
        CopyMemory(@Size, P, SizeOf(integer));
        Inc(PChar(P), SizeOf(integer));
        SourceStr := PChar(P);
        if Length(SourceStr) > Size then
          raise ESakuraSeekerError.Create('FMO擾ł܂ł');
      end;

      //f[^
      Strs := TStringList.Create;
      try
        Strs.Text := SourceStr;
        for i := Strs.Count-1 downto 0 do begin
          j := Pos('.', Strs[i]);
          ID := Copy(Strs[i], 1, j-1);
          if ID = TargetID then begin
            Strs.Delete(i); // vȂGg폜
            Result := true;
          end;
        end;
        SourceStr := Strs.Text;
      finally
        Strs.Free;
      end;

      if Result then begin
        CopyMemory(P, PChar(SourceStr), Length(SourceStr)+1);
        Dec(PChar(P), SizeOf(integer));
      end;
    finally
      //IuWFNg̔j
      if P <> nil then UnmapViewOfFile(P);
      CloseHandle(MappingHandle);
    end;
  finally
    ReleaseMutex(Mutex);
  end;
end;

procedure TSakuraSeeker.Loaded;
begin
  inherited;
  if FAutoDetect and not (csDesigning in ComponentState) then BeginDetect;
end;

procedure TSakuraSeeker.SetAutoDetect(const Value: boolean);
begin
  FAutoDetect := Value;
end;

procedure TSakuraSeeker.SetFileMappingTarget(const Value: TStrings);
begin
  FFileMappingTarget.Assign(Value);
end;

procedure TSakuraSeeker.SetOnAfterDetection(const Value: TNotifyEvent);
begin
  FOnAfterDetection := Value;
end;

procedure TSakuraSeeker.SetOnDetectResultChanged(
  const Value: TNotifyEvent);
begin
  FOnDetectResultChanged := Value;
end;

procedure TSakuraSeeker.SetOnGetMutexName(
  const Value: TSakuraSeekerGetMutexNameEvent);
begin
  FOnGetMutexName := Value;
end;

end.
 