#include "debug.h"
#include "screen.h"
#include <stdio.h>
#include <stdarg.h>
#include <exception>
#include "MemMan.h"


extern "C" void debugprint(const char *format,...){
	int i;
	va_list ap;

	va_start(ap, format);
	Screen::Inst().vprintf(format, ap);
	va_end(ap);
}

extern "C" void hung(){
	for(;;){}
}

void *operator new (size_t size) {
	//debugprint("newed %d\n", size);
	return MemMan::Inst().sys_malloc(size);
}
void *operator new[] (size_t size){
	//debugprint("new[]ed %d\n", size);
	return MemMan::Inst().sys_malloc(size);
}

void operator delete(void *p) throw(){
	//debugprint("deleteed %p\n", p);
	MemMan::Inst().sys_free(p);
}

void operator delete[](void *p) throw(){
	//debugprint("delete[]ed %p\n", p);
	MemMan::Inst().sys_free(p);
}



extern "C" {
void __cxa_pure_virtual(){
}

void __cxa_end_catch(){
}

void __cxa_begin_catch(){
}

void __cxa_rethrow(){
}
void __cxa_call_unexpected(){}
};

namespace boost{
	void throw_exception(std::exception const&){}
};
