#pragma once
#include "typedefs.h"

#pragma pack(push, 1)
struct MBR_SECTOR{
	BYTE code[0x1BE];
	struct{
		BYTE bootflag;
		BYTE partition_begin_CHS[3];
		BYTE type;
		BYTE partition_end_CHS[3];
		DWORD begin_lba;
		DWORD size_lba;
	}pt[4];
	WORD magic;//0xAA55
};

struct FAT32_BOOTSECTOR
{
BYTE BS_jmpBoot[3]; // Jump Instruction to boot code
char BS_OEMName[8]; // "MSWIN4.1" is recommended setting
WORD BPB_BytsPerSec; // Count of bytes per Sector
BYTE BPB_SecPerClus; // Number of Sectors per Allocation Unit which must be a power of 2
WORD BPB_RsvdSecCnt; // Number of Reserved Sectors in the Reserved Region of the volume starting at the first sector of the volume
BYTE BPB_NumFATs; // Count of FAT data structures on the volume
WORD BPB_RootEntCnt; // Count of 32byte directory entries in the root directory for FAT12 and FAT16 volumes
WORD BPB_TotSec16; // Old 16-bit total count of sectors on the volume
BYTE BPB_Media; // 0xF8 for fixed media, 0xF0 for removable media
WORD BPB_FATSz16; //@ FAT12/FAT16 16bit-count of sectors occupied by ONE FAT

WORD BPB_SecPerTrk; // Sectors per Track for interrupt 0x13 (um... it is Wintel culture... x_x;)
WORD BPB_NumHeads; // Number of Heads for interrupt 0x13 (um... it is Wintel culture... x_x;)
DWORD BPB_HiddSec; // Count of Hidden Sectors preceding the partition that contains this FAT volume
DWORD BPB_TotSec32; // New 32-bit total count of sectors on the volume
// Following structure is prepared for FAT12 and FAT16 (not for FAT32)
DWORD BPB_FATSz32; //@ FAT32 32bit-count of sectors occupied by ONE FATǉ
WORD BPB_ExtFlags;
WORD BPB_FSVer;
DWORD BPB_RootClus;
WORD BPB_FSInfo;
WORD BPB_BkBootSec;
BYTE BPB_Reserved[12];
BYTE BS_DrvNum; // Int0x13 drive number (um... it is Wintel culture... x_x;)
BYTE BS_Reserved1; // Reserved for WindowsNT (um... it is MS culture... x_x;)
BYTE BS_BootSig; // Extended Boot Signature (0x29) which indicates following three fields in the boot sector are present
DWORD BS_VolID; // Volume Serial Number
BYTE BS_VolLab[11]; // Volume Label
BYTE BS_FilSysType[8]; // Type of File System (it is no more than a hint)
} ;



struct DIRENT{
	char DIR_Name[11];
	BYTE DIR_Attr;
	BYTE DIR_NTRes;
	BYTE DIR_CrtTimeTenth;
	WORD DIR_CrtTime;
	WORD DIR_CrtDate;
	WORD DIR_LstAccDate;
	WORD DIR_FstClusHI;
	WORD DIR_WrtTime;
	WORD DIR_WrtDate;
	WORD DIR_FstClusLO;
	DWORD DIR_FileSize;
	
	DWORD getfirstclus(){
		return DIR_FstClusHI << 16 | DIR_FstClusLO;
	}
	void setfirstclus(DWORD clus){
		DIR_FstClusHI = (clus & 0xffff0000) >> 16;
		DIR_FstClusLO = clus & 0x0000ffff;
	}
};

enum FAT_ATTR{
	ATTR_READ_ONLY = 0x01,
	ATTR_HIDDEN = 0x02,
	ATTR_SYSTEM = 0x04,
	ATTR_VOLUME_ID = 0x08,
	ATTR_DIRECTORY = 0x10,
	ATTR_ARCHIVE = 0x20,
	ATTR_LONG_NAME = ATTR_READ_ONLY | ATTR_HIDDEN | ATTR_SYSTEM | ATTR_VOLUME_ID
};

#pragma pack(pop)
