; haribote-ipl
; TAB=4

BASEADDR EQU 0x7c00
DISKREADSTRUCT EQU 0x0800
SYSADDR EQU 0xc200
SYSSECTOR EQU 0x0040
STACK EQU 0x7c00
HARDDISK_CACHE EQU 0x8000

PATNUM EQU 0
PAT0_STARTSEC EQU 0x3f
PAT0_SECNUM EQU 0x200

DRIVENO EQU 0x0820

MBR EQU 0x600
PATTABLE EQU MBR + 446

	ORG		BASEADDR			; このプログラムがどこに読み込まれるのか

	;FAT32 BPB
	jmp short entry
	nop
		db "MSDOS5.0" ; OEM Name
		dw 0x0200     ; bytes per sec
secperclus:
		db 2          ; sec per clus
reservedsec:
		dw 0x40       ; rsvdseccnt
fatnum:
		db 2          ; num fat data structures
		dw 0          ; root ent cnt (in fat32 must be zero)
		dw 0          ; total sec 16 (in fat32 must be zero)
media:
		db 0xf8       ; media (non-removable:0xf8 removable:0xf0)usbメモリに0xf8を使っても問題ない模様
		dw 0          ; fat sz 16 (in fat32 must be zero)
		dw 0x003f     ; sec per track
		dw 0x00ff     ; num heads
hiddensec:
		dd PAT0_STARTSEC ; hidden sec
		dd PAT0_SECNUM ; total sec 32

fatsize32:
		dd 0x100      ; fat sz 32
		dw 0          ; ext flags
		dw 0x0000     ; fs ver (must be 0x0000)
rootclus:
		dd 0x02       ; root clus
		dw 0x01       ; sector num of FSINFO
		dw 0x06       ; Backup boot sec
		resb 12       ; reserved
		db 0x80       ; drive num (used from int 0x13)
		db 0          ; reserved1
		db 0x29       ; ext boot sig
		dd 0xdebeefad ; Volume serial number (usually generated by date and time)
		db "NO NAME    " ; Volume label
		db "FAT32   " ; File Sys Type
entry:
	xor eax, eax
	mov ss, ax
	mov ds, ax
	mov es, ax
	mov sp, STACK
	
	mov [DRIVENO], dl

	mov ebx, [hiddensec]
	mov ax, [reservedsec]
	;movzx eax, ax ; この時点でeax上位16bitは0のはず
	add ebx, eax
	mov al, [fatnum]
	movzx eax, al
	mov ecx, [fatsize32]
	mul ecx
	add ebx, eax

	;fatのファイルデータの先頭からルートディレクトリの先頭クラスタへ
	mov ecx, [rootclus]
	dec ecx
	dec ecx
	mov eax, [secperclus]
	mul ecx
	add ebx, eax
	
	;まずはルートディレクトリの構造体からbootmgrのサイズを読む
	push HARDDISK_CACHE >> 4
	pop es
	xor di, di
	
	mov cl, [secperclus]
	movzx cx, cl
	
	call readhd
	
	mov eax, [es:di + 0x1c] ; bootmgrファイルサイズ
	add eax, 0x200 - 1
	mov ecx, 0x200
	xor edx, edx
	div ecx
	mov ecx, eax
	
	mov al, [secperclus]
	movzx eax, al
	add ebx, eax
	
	push SYSADDR >> 4
	pop es
	xor di,di
	
	call readhd

	
	jmp 0:SYSADDR

	 
readhd:
;ebx   : 読み込み開始セクタ
;es:di : 読み込み先アドレス
;cx    : 読み込むセクタ数
	;読み込みのための構造体を設定
	mov si, DISKREADSTRUCT
	mov ax, 0x0010
	mov [si], ax
	mov ax, cx ; 読み込むセクタ数
	mov [si+2], ax
	mov ax, di
	mov [si+4], ax
	mov ax, es
	mov [si+6], ax
;	mov ax, SYSSECTOR & 0xFFFF
;	mov [si+8], ax
;	mov ax, (SYSSECTOR >> 0x10) & 0xFFFF
;	mov [si+0x0a], ax
	mov [si + 8], ebx
	mov ax, 0
	mov [si+0x0c], ax
	mov [si+0x0e], ax
	
	; 拡張int 0x13を用いてHDDからブートセクションを読みこむ
	mov ah, 0x42
	mov dl, [DRIVENO]
	mov al, 0

	int 0x13
	ret

	


	RESB	0x1fe-($ - $$)		; 0x7dfeまでを0x00で埋める命令

	DB		0x55, 0xaa
