#pragma once
#include <new>
#include "ata/ataio.h"
#include "bootpack.h"
#include <stdarg.h>

class Screen{
public:
	static void Init(BOOTINFO *binfo);
	static Screen &Inst(){
		return *(Screen *)buf;
	}

	
	static const int fontw = 8, fonth = 16;
	
	void printf(const char *format, ...);
	void vprintf(const char *format, va_list ap);
	void puts(const char *s);
	
	struct RGB;
	void SetPixel(int x, int y, const RGB &rgb);
	
	void Scroll();
	
	class Pointer{
		int px, py;
		const int w, h;
	public:
		Pointer(BOOTINFO *binfo):px(0),py(0),w(binfo->screenx),h(binfo->screeny){
		}
		int getx(){return px;}
		int gety(){return py;}
		int NextChar(){
			int oldpy = py;
			px += Screen::fontw;
			if(px + Screen::fontw > w){
				px = 0;
				py += Screen::fonth;
				if(py + Screen::fonth > h){
					px = 0;
					py = oldpy;
					return 1;
				}
			}
			return 0;
		}
		int NewLine(){
			px = 0;
			py += Screen::fonth;
			if(py + Screen::fonth > h){
				px = 0;
				py -= Screen::fonth;
				return 1;
			}
			return 0;
		}
	}pt;
	
	struct RGB{
		BYTE r,g,b;
		RGB(BYTE r, BYTE g, BYTE b):r(r),g(g),b(b){}
		BYTE col8()const{
			return (r & 0xE0) | ((g >> 3) & 0x1C) | ((b >> 6) & 0x03);
		}
	};
private:
	static BYTE buf[];
	static void* operator new(size_t size, void* pbuf){ return pbuf; }
	Screen(BOOTINFO *binfo);

	BOOTINFO *binfo;
	char aa[5000];
	};