/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import jp.sf.orangesignal.csv.CsvReader;
import jp.sf.orangesignal.csv.CsvResultSetMetaData;

public class CsvResultSet
implements ResultSet {
    private CsvReader reader;
    private CsvResultSetMetaData meta;
    private List<String> row;
    private int rowNumber = 0;
    private boolean wasNull;

    public CsvResultSet(CsvReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException("CsvReader must not be null");
        }
        this.reader = reader;
        this.meta = new CsvResultSetMetaData(reader);
    }

    private void ensureOpen() throws SQLException {
        if (this.reader == null) {
            throw new SQLException("Stream closed");
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.ensureOpen();
        try {
            this.row = this.reader.readValues();
            if (this.row != null) {
                ++this.rowNumber;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reader = null;
        this.meta = null;
        this.row = null;
        this.rowNumber = 0;
        this.wasNull = false;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.ensureOpen();
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.ensureOpen();
        if (this.row == null) {
            throw new SQLException("No data is available");
        }
        if (columnIndex < 1 || columnIndex > this.row.size()) {
            throw new SQLException(String.format("Invalid column index %d", columnIndex));
        }
        String s = this.row.get(columnIndex - 1);
        this.wasNull = s == null;
        return s;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return false;
        }
        if ("1".equalsIgnoreCase(s)) {
            return true;
        }
        if ("0".equalsIgnoreCase(s)) {
            return false;
        }
        if ("true".equalsIgnoreCase(s)) {
            return true;
        }
        if ("false".equalsIgnoreCase(s)) {
            return false;
        }
        if ("on".equalsIgnoreCase(s)) {
            return true;
        }
        if ("off".equalsIgnoreCase(s)) {
            return false;
        }
        if ("yes".equalsIgnoreCase(s)) {
            return true;
        }
        if ("no".equalsIgnoreCase(s)) {
            return false;
        }
        throw new SQLException(String.format("Bad format for BOOLEAN '%s' in column %d.", s, columnIndex));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return 0;
        }
        return Byte.valueOf(s);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return 0;
        }
        return Short.valueOf(s);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return 0;
        }
        return Integer.valueOf(s);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return 0L;
        }
        return Long.valueOf(s);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return 0.0f;
        }
        return Float.valueOf(s).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return 0.0;
        }
        return Double.valueOf(s);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getBigDecimal(int, int) not supported");
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        return s.getBytes();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        try {
            return new Date(DateFormat.getDateInstance().parse(s).getTime());
        }
        catch (ParseException e) {
            throw new SQLException(String.format("Bad format for DATE '%s' in column %d.", s, columnIndex));
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        try {
            return new Time(DateFormat.getTimeInstance().parse(s).getTime());
        }
        catch (ParseException e) {
            throw new SQLException(String.format("Bad format for TIME '%s' in column %d.", s, columnIndex));
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        try {
            return new Timestamp(DateFormat.getDateTimeInstance().parse(s).getTime());
        }
        catch (ParseException e) {
            throw new SQLException(String.format("Bad format for TIMESTAMP '%s' in column %d.", s, columnIndex));
        }
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        Clob clob = this.getClob(columnIndex);
        if (clob == null) {
            return null;
        }
        return clob.getAsciiStream();
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getUnicodeStream(int) not supported");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        Blob blob = this.getBlob(columnIndex);
        if (blob == null) {
            return null;
        }
        return blob.getBinaryStream();
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public String getCursorName() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getCursorName() not supported");
    }

    @Override
    public CsvResultSetMetaData getMetaData() throws SQLException {
        this.ensureOpen();
        return this.meta;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.ensureOpen();
        if (columnLabel != null) {
            int max = this.meta.getColumnCount();
            for (int i = 1; i <= max; ++i) {
                if (!columnLabel.equalsIgnoreCase(this.meta.getColumnName(i))) continue;
                return i;
            }
        }
        throw new SQLException("invalid column label " + columnLabel);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        return new StringReader(s);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return new BigDecimal(this.getString(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("isBeforeFirst() not supported");
    }

    @Override
    public boolean isAfterLast() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("isAfterLast() not supported");
    }

    @Override
    public boolean isFirst() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("isFirst() not supported");
    }

    @Override
    public boolean isLast() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("isLast() not supported");
    }

    @Override
    public void beforeFirst() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("beforeFirst() not supported");
    }

    @Override
    public void afterLast() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("afterLast() not supported");
    }

    @Override
    public boolean first() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("first() not supported");
    }

    @Override
    public boolean last() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("last() not supported");
    }

    @Override
    public int getRow() throws SQLException {
        this.ensureOpen();
        return this.rowNumber;
    }

    @Override
    public boolean absolute(int row) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("absolute(int) not supported");
    }

    @Override
    public boolean relative(int rows) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("relative(int) not supported");
    }

    @Override
    public boolean previous() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("previous() not supported");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("setFetchDirection(int) not supported");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureOpen();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("setFetchSize(int) not supported");
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.ensureOpen();
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        this.ensureOpen();
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.ensureOpen();
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("rowUpdated() not supported");
    }

    @Override
    public boolean rowInserted() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("rowInserted() not supported");
    }

    @Override
    public boolean rowDeleted() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("rowDeleted() not supported");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateNull(int) not supported");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateBoolean(int, boolean) not supported");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateByte(int, byte) not supported");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateShort(int, short) not supported");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateInt(int, int) not supported");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateLong(int, long) not supported");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateFloat(int, float) not supported");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateDouble(int, double) not supported");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateBigDecimal(int, BigDecimal) not supported");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateString(int, String) not supported");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateBytes(int, byte[]) not supported");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateDate(int, Date) not supported");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateTime(int, Time) not supported");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateTimestamp(int, Timestamp) not supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream(int, InputStream, int) not supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream(int, InputStream, int) not supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream(int, Reader, int) not supported");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateObject(int, Object, int) not supported");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateObject(int, Object) not supported");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.updateNull(this.findColumn(columnLabel));
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.updateShort(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.updateInt(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.updateLong(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.updateString(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), x, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), x);
    }

    @Override
    public void insertRow() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("insertRow() not supported");
    }

    @Override
    public void updateRow() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateRow() not supported");
    }

    @Override
    public void deleteRow() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("deleteRow() not supported");
    }

    @Override
    public void refreshRow() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("refreshRow() not supported");
    }

    @Override
    public void cancelRowUpdates() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("cancelRowUpdates() not supported");
    }

    @Override
    public void moveToInsertRow() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("moveToInsertRow() not supported");
    }

    @Override
    public void moveToCurrentRow() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("moveToCurrentRow() not supported");
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.ensureOpen();
        return null;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getObject(int, Map) not supported");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getRef(int) not supported");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        return new SerialBlob(s.getBytes());
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        return new SerialClob(s.toCharArray());
    }

    @Override
    public Array getArray(int columnIndex) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getArray(int) not supported");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), map);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.getRef(this.findColumn(columnLabel));
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        try {
            DateFormat df = DateFormat.getDateInstance();
            df.setCalendar(cal);
            return new Date(df.parse(s).getTime());
        }
        catch (ParseException e) {
            throw new SQLException(String.format("Bad format for DATE '%s' in column %d.", s, columnIndex));
        }
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        try {
            DateFormat df = DateFormat.getTimeInstance();
            df.setCalendar(cal);
            return new Time(df.parse(s).getTime());
        }
        catch (ParseException e) {
            throw new SQLException(String.format("Bad format for TIME '%s' in column %d.", s, columnIndex));
        }
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        try {
            DateFormat df = DateFormat.getDateTimeInstance();
            df.setCalendar(cal);
            return new Timestamp(df.parse(s).getTime());
        }
        catch (ParseException e) {
            throw new SQLException(String.format("Bad format for TIMESTAMP '%s' in column %d.", s, columnIndex));
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        try {
            return new URL(s);
        }
        catch (MalformedURLException e) {
            throw new SQLException(String.format("Bad format for URL '%s' in column %d.", s, columnIndex));
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateRef(int, Ref) not supported");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.updateRef(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateBlob(int, Blob) not supported");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateBlob(int, Clob) not supported");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateArray(int, Array) not supported");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.updateArray(this.findColumn(columnLabel), x);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRowId(int) not supported");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(this.findColumn(columnLabel));
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateRowId(int, RowId) not supported");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.updateRowId(this.findColumn(columnLabel), x);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.ensureOpen();
        return 1;
    }

    @Override
    public boolean isClosed() {
        return this.reader == null;
    }

    @Override
    public void updateNString(int columnIndex, String string) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateNString(int, String) not supported");
    }

    @Override
    public void updateNString(String columnLabel, String string) throws SQLException {
        this.updateNString(this.findColumn(columnLabel), string);
    }

    @Override
    public void updateNClob(int columnIndex, NClob clob) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateNClob(int, NClob) not supported");
    }

    @Override
    public void updateNClob(String columnLabel, NClob clob) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), clob);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNClob(int) not supported");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getSQLXML(int) not supported");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateSQLXML(int, SQLXML) not supported");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.updateSQLXML(this.findColumn(columnLabel), xmlObject);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getNString(this.findColumn(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream(int, Reader, long) not supported");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream(int, InputStream, long) not supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream(int, InputStream, long) not supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream(int, Reader, long) not supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateBlob(int, InputStream, long) not supported");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), inputStream, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateClob(int, Reader, long) not supported");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateNClob(int, Reader, long) not supported");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream(int, Reader) not supported");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream(int, InputStream) not supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream(int, InputStream) not supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream(int, Reader) not supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateBlob(int, InputStream) not supported");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), inputStream);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateClob(int, Reader) not supported");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("updateNClob(int, Reader) not supported");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), reader);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("unwrap(Class) not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("isWrapperFor(Class) not supported");
    }
}

