/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.util.List;
import jp.sf.orangesignal.csv.CsvListHandler;
import jp.sf.orangesignal.csv.CsvReader;

public abstract class AbstractCsvListHandler<T, H extends AbstractCsvListHandler<T, H>>
implements CsvListHandler<T> {
    protected int offset;
    protected int limit;

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    public H offset(int offset) {
        this.setOffset(offset);
        return (H)this;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    public H limit(int limit) {
        this.setLimit(limit);
        return (H)this;
    }

    @Override
    public List<T> load(CsvReader reader) throws IOException {
        return this.load(reader, false);
    }

    @Override
    public List<T> processScalar(List<T> list) {
        int fromIndex = Math.max(this.offset, 0);
        int toIndex = this.limit <= 0 ? list.size() : Math.min(fromIndex + this.limit, list.size());
        return list.subList(fromIndex, toIndex);
    }
}

