package hiro.yoshioka.sdh;

import hiro.yoshioka.util.FileUtil;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SDHTester {

	public static void main(String[] args) {
		Display display = new Display();

		Shell shell = new Shell(display);
		shell.setLayout(new GridLayout(3, true));

		RDHTableViewer v = new RDHTableViewer(shell);
		v.getTable().setLayoutData(new GridData(GridData.FILL_BOTH));
		v.setInputAdjustDatum(createModel());

		final RDHTableViewer v2 = new RDHTableViewer(shell);

		Composite btnPanel = new Composite(shell, SWT.BOTTOM);
		btnPanel.setLayout(new FillLayout(SWT.VERTICAL));
		Button cpBtn = new Button(btnPanel, SWT.BORDER);
		cpBtn.setText("copy");
		cpBtn.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				System.out
						.println("pushed cpBtn-------------------------------");
				v2.doOperation(RDHTableViewer.COPY);
			}
		});
		Button pasteBtn = new Button(btnPanel, SWT.BORDER);
		pasteBtn.setText("paste");
		pasteBtn.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				System.out
						.println("pushed pasteBtn-------------------------------");
				v2.doOperation(RDHTableViewer.PASTE);
			}
		});
		Button htmlBtn = new Button(btnPanel, SWT.BORDER);
		htmlBtn.setText("generate Html");
		htmlBtn.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				System.out
						.println("pushed pasteBtn-------------------------------");
				List<Integer> percentList = new ArrayList<Integer>();
				percentList.add(3);
				percentList.add(5);
				String html = v2.getCDH().toHtmlString(Integer.MAX_VALUE,
						percentList);
				FileUtil.writeFile(new File("c:/tmp/h.html"), html, "UTF-8");
			}
		});

		v2.setSupportChart(true);
		v2.setSupportHyperLink(new DefaultHyperLinkAction(new int[] { 2 }));
		v2.getTable().setLayoutData(new GridData(GridData.FILL_BOTH));
		v2.setMaxMultiLine(4);
		// v2.setInputAdjustDatum(createModel());
		v2.setInputAdjustHeader(createModel());

		System.out.println("aaaaaaaa");
		shell.open();
		System.out.println("aaaaaaaabbbbbbbbbbb");

		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		System.out.println("aaaaaaaabbbbbbbbbbbddddddddddd");

		display.dispose();

	}

	private static ResultSetDataHolder createModel() {
		ResultSetDataHolder rdh = new ResultSetDataHolder(new String[] {
				"name", "job", "use0(%)", "email", "use(%)" });
		for (int i = 0; i < 20; i++) {
			rdh.addRow(new String[] { i + "", "Bokowski",
					((i + 34) % 100) + "", "Boris_Bokowski@ca.ibm.com", i + "" });
			rdh.addRow(new String[] { i + "", "Creasey", ((i + 34) % 100) + "",
					"Tod_Creasey@ca.ibm.com", i % 42 + "" });
			rdh.addRow(new String[] { i + "", "Beaton", ((i + 34) % 100) + "",
					"wayne@eclipse.org", i % 23 + "" });
			rdh.addRow(new String[] {
					"i     am \n a\n one\n of \n pen\n this is a pen too.",
					"Schi\r\nn\r\nsdl", ((i + 34) % 100) + "",
					"tom.schindl@bestsolution.at", "100" });
		}
		// rdh.addRow(new String[] { "Boris", "Bokowski",
		// "Boris_Bokowski@ca.ibm.com" });
		// rdh.addRow(new String[] { "Tod", "Creasey", "Tod_Creasey@ca.ibm.com"
		// });

		return rdh;
	}
}
