package hiro.yoshioka.util;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public enum ColorNameEnum {
	/** DELETE */
	DELETE("susu", 0x88, 0x7f, 0x7a),
	/** CHANGE */
	CHANGE("momo", 0xf0, 0x91, 0x99),
	/** ADD */
	ADD("ame", 0xde, 0xb0, 0x68),
	/** NULL */
	NULL("chigusa", 0x92, 0xb5, 0xa9),
	/** SIMA */
	SIMA("wakana", 0xd8, 0xe6, 0x98),
	/** TAG */
	TAG("haizakura", 0xe8, 0xd3, 0xd1),
	/** NULL */
	SELECTION("wasurenagusa", 0xeb, 0x6e, 0xef),
	/** ASAGI(BLUE) */
	ASAGI("asagi", 0x00, 0xa3, 0xaf),
	/** SHIRAFUJI(LIGHT_GRAY) */
	SHIRAFUJI("shirafuji", 0xdb, 0xd0, 0xe6),
	/** GLAY */
	GLAY("glay", 0x88, 0x88, 0x88),
	/** BLACK */
	BLACK("black", 0x00, 0x00, 0x00);

	private String colorName;
	private int r, g, b;

	private ColorNameEnum(String text, int r, int g, int b) {
		this.colorName = text;
		this.r = r;
		this.g = g;
		this.b = b;
	}

	public String getColorName() {
		return colorName;
	}

	public Color getColor(Display device) {
		return new Color(device, r, g, b);
	}
}
