package hiro.yoshioka.util;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class FontUtil {
	static FontRegistry registry;

	public synchronized static Font getFont(FontNameEnum fne) {
		return getRegistry().get(fne.name());
	}

	public synchronized static final FontRegistry getRegistry() {
		if (registry == null) {
			registry = new FontRegistry();

			Display device = Display.getCurrent();
			for (FontNameEnum fne : FontNameEnum.values()) {
				Font f = fne.getFont(device);
				registry.put(fne.name(), f.getFontData());
			}
		}
		return registry;
	}
}
