/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.sqlite.Conn;

public class JDBC
implements Driver {
    private static final String PREFIX = "jdbc:sqlite:";

    static {
        try {
            DriverManager.registerDriver(new JDBC());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 1;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public boolean acceptsURL(String url) {
        return url != null && url.toLowerCase().startsWith(PREFIX);
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        DriverPropertyInfo sharedCache = new DriverPropertyInfo("shared_cache", "false");
        sharedCache.choices = new String[]{"true", "false"};
        sharedCache.description = "Enable SQLite Shared-Cache mode, native driver only.";
        sharedCache.required = false;
        return new DriverPropertyInfo[]{sharedCache};
    }

    public Connection connect(String url, Properties info) throws SQLException {
        String file;
        if (!this.acceptsURL(url)) {
            return null;
        }
        String string = file = PREFIX.equalsIgnoreCase(url = url.trim()) ? ":memory:" : url.substring(PREFIX.length());
        if (info.getProperty("shared_cache") == null) {
            return new Conn(url, file);
        }
        return new Conn(url, file, Boolean.parseBoolean(info.getProperty("shared_cache")));
    }
}

