#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QFileDialog>
#include <QMessageBox>

#include <QDebug>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    image = NULL;
    ui->imgView->setScene(&scene);

    ui->lineEdit->setText("");
    ui->lineEdit->setFocus();
    ui->btnStart->setDisabled(true);
}

MainWindow::~MainWindow()
{
    delete ui;
}

QRcode *MainWindow::encode(const unsigned char *intext)
{
    QRcode *code;

    int casesensitive = 1;
    int version = 0;
    QRecLevel level = QR_ECLEVEL_L;
    QRencodeMode hint = QR_MODE_8;

//    if(micro) {
//        if(eightbit) {
//            code = QRcode_encodeDataMQR(length, intext, version, level);
//        } else {
//            code = QRcode_encodeStringMQR((char *)intext, version, level, hint, casesensitive);
//        }
//    } else {
//        if(eightbit) {
//            code = QRcode_encodeData(length, intext, version, level);
//        } else {
            code = QRcode_encodeString((char *)intext, version, level, hint, casesensitive);
//        }
//    }

    return code;
}

QPixmap MainWindow::encodeTextToPixmap( QString text )
{
    int margin = 3;
    int size = 3;

#if 0
    QByteArray a = text.toUtf8();
    if ( m_useBom )
    {
        // insert BOM
        a.insert( 0, BOM );
    }
#else
    QByteArray a = text.toAscii();
#endif
    QRcode* qrcode = encode( (unsigned char*)a.constData() ); // Generate QRCode from string.
    if ( qrcode == NULL )
    {
        return NULL;
    }

    int realwidth = (qrcode->width + margin * 2) * size;
    if (image != NULL) {
        delete(image);
    }
    image = new QImage( realwidth, realwidth, QImage::Format_Mono );
    QPainter painter(image);

    painter.fillRect( QRect( 0, 0, realwidth, realwidth ), QColor( Qt::white ) );

    QColor black( Qt::black );

    int i = 0;
    int x = 0;
    int y = 0;
    QRect rect( 0, 0, size, size );
    while ( y < qrcode->width )
    {
        x = 0;
        while ( x < qrcode->width )
        {
            // only if a block is present (black)
            if ( qrcode->data[i] & 1 )
            {
                rect.moveTo(size * (margin + x),
                       size * (margin + y));
                painter.fillRect( rect, black );
            }
            i++;
            x++;
        }
        y++;
    }

    painter.end();

    QPixmap pixmap = QPixmap::fromImage(*image);

    QRcode_free(qrcode);

    return pixmap;
}

void MainWindow::on_btnStart_clicked()
{

    scene.clear();
    QPixmap pixmap = encodeTextToPixmap(ui->lineEdit->text());
    scene.addPixmap( pixmap );

}

void MainWindow::on_lineEdit_textChanged(const QString &arg1)
{
    if (arg1.isEmpty()) {
        ui->btnStart->setDisabled(true);;
     } else {
        ui->btnStart->setDisabled(false);
    }
}

void MainWindow::on_actionExit_triggered()
{
    close();
}

void MainWindow::on_actionSave_triggered()
{
    if (image == NULL || image->isNull()) {
        ; // empty imagedata
    } else {
        QString fileName = QFileDialog::getSaveFileName( this, "Save Image", "./", "Image Files (*.png)" );
        if ( fileName.isEmpty() )	return;
        image->save( fileName, "PNG");
    }
}

void MainWindow::on_actionAbout_triggered()
{
    QMessageBox::about(this, "About", tr("QtQREncode v0.1, uses libqrencode library."));
}

void MainWindow::on_actionAbout_Qt_triggered()
{
    QApplication::aboutQt();
}
