/*
 *  TOPPERS/SSP Kernel
 *      Smallest Set Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2009 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2010 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2011 by Meika Sugimoto
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEEρE
 *  ĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒쌠
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[X
 *      R[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎgp
 *      ł`ōĔzzꍇɂ́CĔzzɔhLgip҃}
 *      jAȂǁjɁCL̒쌠\C̗pщL̖
 *      ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎgp
 *      łȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNgɕ
 *        邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹Q
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD܂C
 *      {\tgEFÃ[U܂̓Gh[ÛȂ闝RɊ
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړIɑ΂
 *  K܂߂āCȂۏ؂sȂD܂C{\tgEFA̗p
 *  ɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC
 *  ȂD
 * 
 */

#ifndef TOPPERS_TASK_H
#define TOPPERS_TASK_H

#include "kernel_impl.h"


/*
 *  ^XNDx̓\EO\ϊ}N
 */
#define INT_PRIORITY(x)		((uint_t)((x) - TMIN_TPRI))

/*
 *  ^XNID̍őlikernel_cfg.cj
 */
extern const ID	tmax_tskid;

/*
 *  ^XN̐
 */
#define tnum_tsk	((uint_t)(tmax_tskid - TMIN_TSKID + 1))

/*
 *  s\Ԃ̃^XNȂ̎s^XN̋NDx
 */
#define IPRI_NULL	(UINT_MAX)


extern uint_t get_ipri_self(ID tskid);
extern uint_t get_ipri(ID tskid);

/*
 *  fBXpb`^^XNO[`NvtO
 *
 *  ݃nh^CPUOnh̏oɁCfBXpb`܂
 *  ^XNO[`̋Nv邱ƂtOD
 */
extern bool_t	reqflg;

/*
 *  fBXpb`֎~
 *
 *  fBXpb`֎~Ԃł邱ƂtOD
 */
extern bool_t	disdsp;

/*
 *  ^XN̏
 */
extern void initialize_task(void);
/*
 *  sԃ^XN̋NDx
 */
extern uint_t runtsk_ipri;

/*
 *  ^XN̋N
 */
extern bool_t make_active(uint_t ipri);

/*
 *  ^XN̋x~
 */
extern bool_t test_dormant(uint_t tskid);

/*
 *  ōD揇ʃ^XÑT[`
 */
extern uint_t search_schedtsk(void);

/*
 *  ^XN̎s
 */
extern void run_task(uint_t ipri);

/*
 *  ^XNfBXpb`
 */
extern void dispatcher(void);

#endif /* TOPPERS_TASK_H */
