/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: eventflag.h 748 2008-03-07 17:18:06Z hiro $
 */

/*
 *		CxgtO@\
 */

#ifndef TOPPERS_EVENTFLAG_H
#define TOPPERS_EVENTFLAG_H

#include <queue.h>

/*
 *  CxgtOubN
 *
 *  ̍\̂́CEʐMIuWFNg̏ubN̋ʕ
 *  iWOBJINIBjgiIuWFNgw̌pɑĵŁC
 *  ŏ̃tB[hʂɂȂĂD
 */
typedef struct eventflag_initialization_block {
	ATR			flgatr;			/* CxgtO */
	FLGPTN		iflgptn;		/* CxgtÕrbgp^[̏l */
} FLGINIB;

/*
 *  CxgtOǗubN
 *
 *  ̍\̂́CEʐMIuWFNg̊ǗubN̋ʕiWOBJCBj
 *  giIuWFNgw̌pɑĵŁCŏ2
 *  tB[hʂɂȂĂD
 */
typedef struct eventflag_control_block {
	QUEUE		wait_queue;		/* CxgtO҂L[ */
	const FLGINIB *p_flginib;	/* ubNւ̃|C^ */
	FLGPTN		flgptn;			/* CxgtO݃p^[ */
} FLGCB;

/*
 *  CxgtO҂ubN̒`
 *
 *  ̍\̂́CEʐMIuWFNg̑҂ubN̋ʕ
 *  iWINFO_WOBJjgiIuWFNgw̌pɑĵŁC
 *  ŏ2̃tB[hʂɂȂĂD
 *
 *  flgptńCwaiptnwfmodeƓɎgƂ͂Ȃ߁Cp̂g
 *  ΃ߖ񂷂邱Ƃ\łD
 */
typedef struct eventflag_waiting_information {
	WINFO		winfo;			/* W̑҂ubN */
	FLGCB		*p_flgcb;		/* ҂ĂCxgtO̊ǗubN */
	FLGPTN		waiptn;			/* ҂p^[ */
	MODE		wfmode;			/* ҂[h */
	FLGPTN		flgptn;			/* ҂̃p^[ */
} WINFO_FLG;

/*
 *  CxgtOID̍őlikernel_cfg.cj
 */
extern const ID	tmax_flgid;

/*
 *  CxgtOubÑGAikernel_cfg.cj
 */
extern const FLGINIB	flginib_table[];

/*
 *  CxgtOǗubÑGAikernel_cfg.cj
 */
extern FLGCB	flgcb_table[];

/*
 *  CxgtOǗubNCxgtOIDo߂̃}N
 */
#define	FLGID(p_flgcb)	((ID)(((p_flgcb) - flgcb_table) + TMIN_FLGID))

/*
 *  CxgtO@\̏
 */
extern void	initialize_eventflag(void);

/*
 *  CxgtO҂̃`FbN
 */
extern bool_t	check_flg_cond(FLGCB *p_flgcb, FLGPTN waiptn,
								MODE wfmode, FLGPTN *p_flgptn);

#endif /* TOPPERS_EVENTFLAG_H */
