/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2008 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́CFree Software Foundation ɂČ\Ă 
 *  GNU General Public License  Version 2 ɋLqĂC
 *  (1)`(4)̏𖞂ꍇɌC{\tgEFAi{\tgEF
 *  Aς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFAėp\ȃoCiR[hiP[^uIu
 *      WFNgt@C⃉CuȂǁǰ`ŗpꍇɂ́Cp
 *      ɔhLgip҃}jAȂǁjɁCL̒쌠\C
 *      ̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAėps\ȃoCiR[ȟ`܂͋@ɑg
 *      ݍ񂾌`ŗpꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) pɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) p̌`ԂCʂɒ߂@ɂāCL쌠҂ɕ񍐂
 *        ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂́C
 *  {\tgEFAɊւāC̓Kp\܂߂āCȂۏ؂s
 *  ȂD܂C{\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ
 *  Ȃ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	RSK-M16C-62P UARTpVAI/OW[
 */

#include <kernel.h>
#include <sil.h>
#include <t_syslog.h>
#include "RSK-M16C-62P.h"
#include "target_serial.h"

/*
 *  SIOhCȍ
 */
void
sio_initialize(intptr_t exinf)
{
#ifndef	USE_KD3083
	m16c_uart_initialize();
#endif
}

/*
 *  VAI/O|[g̃I[v
 */
SIOPCB *
sio_opn_por(ID siopid, intptr_t exinf)
{
	SIOPCB  *p_siopcb;
	ER      ercd;
	
	/*
	 *  VAI/O݂}XND
	 */
	ercd = dis_int(INTNO_SIO_TX);
	assert(ercd == E_OK);
	ercd = dis_int(INTNO_SIO_RX);
	assert(ercd == E_OK);
	
#ifndef	USE_KD3083
	/*
	 *  foCXˑ̃I[vD
	 */
	p_siopcb = 
		m16c_uart_opn_por(siopid , exinf , UART_BAUDRATE , UART_CLKSRC);
	
	/*
	 *  VAI/Õ݂}XND
	 */
	ercd = ena_int(INTNO_SIO_TX);
	assert(ercd == E_OK);
	ercd = ena_int(INTNO_SIO_RX);
	assert(ercd == E_OK);
#endif
	return(p_siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
sio_cls_por(SIOPCB *p_siopcb)
{
	ER        ercd;
	
#ifndef	USE_KD3083
	/*
	 *  foCXˑ̃N[YD
	 */
	m16c_uart_cls_por(p_siopcb);
#endif
	
	/*
	 *  VAI/O݂}XND
	 */
	ercd = dis_int(INTNO_SIO_TX);
	assert(ercd == E_OK);
	ercd = dis_int(INTNO_SIO_RX);
	assert(ercd == E_OK);
}

/*
 *  SIO̊݃nh
 */
void
sio_tx_isr(intptr_t exinf)
{
#ifndef	USE_KD3083
	m16c_uart_tx_isr(exinf);
#endif
}


/*
 *  SIO̊݃nh
 */
void
sio_rx_isr(intptr_t exinf)
{
#ifndef	USE_KD3083
	m16c_uart_rx_isr(exinf);
#endif
}

/*
 *  VAI/O|[gւ̕M
 */
bool_t
sio_snd_chr(SIOPCB *siopcb, char_t c)
{
#ifndef	USE_KD3083
	return(m16c_uart_snd_chr(siopcb, c));
#else
	return true;
#endif
}

/*
 *  VAI/O|[g̕M
 */
int_t
sio_rcv_chr(SIOPCB *siopcb)
{
#ifndef	USE_KD3083
	return(m16c_uart_rcv_chr(siopcb));
#else
	return 0;
#endif
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void
sio_ena_cbr(SIOPCB *siopcb, uint_t cbrtn)
{
#ifndef	USE_KD3083
	m16c_uart_ena_cbr(siopcb, cbrtn);
#endif
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
sio_dis_cbr(SIOPCB *siopcb, uint_t cbrtn)
{
#ifndef	USE_KD3083
	m16c_uart_dis_cbr(siopcb, cbrtn);
#endif
}

/*
 *  VAI/O|[g̑M\R[obN
 */
void
m16c_uart_irdy_snd(intptr_t exinf)
{
#ifndef	USE_KD3083
	sio_irdy_snd(exinf);
#endif
}

/*
 *  VAI/O|[g̎MʒmR[obN
 */
void
m16c_uart_irdy_rcv(intptr_t exinf)
{
#ifndef	USE_KD3083
	sio_irdy_rcv(exinf);
#endif
}

