/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2007,2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: test_cpuexc1.c 818 2008-03-18 12:56:15Z hiro $
 */

/* 
 *		CPUÕeXg(1)
 *
 * yeXg̖ړIz
 *
 *  ^XNReLXgCbNԂŔCPUOɂVXe
 *  Ԃ̃eXgDݗDx}XNTIPM_ENAALLCfBXpb`֎~
 *  ԁC^XNOԂŃeXgD
 *
 * yeXgځz
 *
 *  C^XNReLXgCbNԂŔCPUOɂ
 *  āC
 *
 *	(A) CPUOnhsJnCPUbNtOωȂ
 *		I݃bNԂŔCPUOł́CVXeԂ𐳂
 *		߂邱Ƃۏ؂Ȃ߁CeXgłȂD
 *	(B) CPUOnhsJnɊݗDx}XNωȂ
 *		I݃bNԂŔCPUOł́CVXeԂ𐳂
 *		߂邱Ƃۏ؂Ȃ߁CeXgłȂD
 *	(C) CPUOnhsJnɃfBXpb`֎~tOωȂ
 *		I݃bNԂŔCPUOł́CVXeԂ𐳂
 *		߂邱Ƃۏ؂Ȃ߁CeXgłȂD
 *	(D) CPUOnhsJnɃ^XNO֎~tOωȂ
 *		I݃bNԂŔCPUOł́CVXeԂ𐳂
 *		߂邱Ƃۏ؂Ȃ߁CeXgłȂD
 *	(E) CPUOnh^[CPUbNtOɖ߂邱
 *		ICPUOnh烊^[łꍇ̂݃eXgD
 *	(F) CPUOnh^[ɊݗDx}XNɖ߂邱
 *		ICPUOnh烊^[łꍇ̂݃eXgD
 *	(G) CPUOnh^[ɃfBXpb`֎~tOωȂ
 *		ICPUOnh烊^[łꍇ̂݃eXgD
 *	(H) CPUOnh^[Ƀ^XNO֎~tOωȂ
 *		ICPUOnh烊^[łꍇ̂݃eXgD
 *	(I) xsns_xpntrueԂ
 *	(J) xsns_dpntrueԂ
 *
 * ygp\[Xz
 *
 *	TASK1: TA_ACTCDxC^XNO[`o^
 *	CPUEXC1: TA_NULL
 *	ALM1: TA_NULL
 *
 * yeXgV[PXz
 *
 *	== TASK1iDxj==
 *	1:	Ԃ̃`FbN
 *		dis_dsp()
 *		ena_tex()
 *	2:	Ԃ̃`FbN
 *		sta_alm(ALM1, 1U)
 *		A[nh1̎s҂
 *	== ALM1 ==
 *	3:	Ԃ̃`FbN
 *		SIL_LOC_INT()
 *		RAISE_CPU_EXCEPTION
 *	== CPUEXC1 ==
 *	4:	xsns_xpn() == true			... (I)
 *		xsns_dpn() == true			... (J)
 *	5:	CPUOnh烊^[łȂꍇ́CŏI
 *	5:	^[
 *	== ALM1ij==
 *	6:	SIL_UNL_LOC()
 *	7:	Ԃ̃`FbN				... (E)(G)(H)
 *		^[
 *	== TASK1ij==
 *	8:	Ԃ̃`FbN				... (F)
 *	9:	eXgI
 */

#include <sil.h>
#include <kernel.h>
#include <t_syslog.h>
#include "kernel_cfg.h"
#include "test_lib.h"
#include "test_cpuexc.h"

volatile bool_t	alm1_flag = false;

void
task1(intptr_t exinf)
{
	ER		ercd;

	check_point(1);
	check_state(false, false, TIPM_ENAALL, false, false, true);
	ercd = dis_dsp();
	check_ercd(ercd, E_OK);
	ercd = ena_tex();
	check_ercd(ercd, E_OK);

	check_point(2);
	check_state(false, false, TIPM_ENAALL, true, true, false);
	ercd = sta_alm(ALM1, 1U);
	check_ercd(ercd, E_OK);

	while (!(alm1_flag));

	check_point(8);
	check_state(false, false, TIPM_ENAALL, true, true, false);

	check_finish(9);
}

void
tex_task1(TEXPTN texptn, intptr_t exinf)
{
	check_point(0);
}

void
task2(intptr_t exinf)
{
	check_point(0);
}

void
alarm1_handler(intptr_t exinf)
{
	SIL_PRE_LOC;

	check_point(3);
	check_state_i(true, false, true, true, false);
	SIL_LOC_INT();
	RAISE_CPU_EXCEPTION;

	check_point(6);
	SIL_UNL_INT();

	check_point(7);
	check_state_i(true, false, true, true, false);
	alm1_flag = true;
}

void
cpuexc_handler(void *p_excinf)
{
	check_point(4);
	check_assert(xsns_xpn(p_excinf) == true);
	check_assert(xsns_dpn(p_excinf) == true);

#ifdef CANNOT_RETURN_CPUEXC
	check_finish(5);
#endif /* CANNOT_RETURN_CPUEXC */

	check_point(5);
}
