/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2009 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: prc_config.h 1430 2009-01-14 17:37:56Z ertl-hiro $
 */

/*
 *		vZbTˑW[iM68040pj
 *
 *  ̃CN[ht@ĆCtarget_config.hi܂́CCN
 *  [ht@Cĵ݂CN[hD̃t@C
 *  ڃCN[hĂ͂ȂȂD
 */

#ifndef TOPPERS_PRC_CONFIG_H
#define TOPPERS_PRC_CONFIG_H

#ifndef TOPPERS_MACRO_ONLY

/*
 *  vZbT̓ꖽ߂̃CC֐`
 */
#include "prc_insn.h"

/*
 *  ^XNReLXgubN̒`
 */
typedef struct task_context_block {
	void	*msp;		/* X^bN|C^ */
	FP		pc;			/* vOJE^ */
} CTXB;

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  ݗDx}XN색Cu
 *
 *  M68040ł́CXe[^XWX^iSRj̉8`10rbg߂3rbg
 *  ɊݗDx}XNin[hEFÅݗDx}XNCIPMju
 *  ĂDIPMۑĂ߂ɁCݗDx̊O\i-1A
 *  ̒ljgƂ\ł邪C]vȍErbgVtgƕ
 *  ]KvɂȂD邽߂ɁCIPMۑꍇɂ́CSR
 *  8`10rbg߂olgƂɂD̒lݗDx}
 *  XN̓\ƌĂсCIIPMƏƂɂD
 */

/*
 *  ݗDx}XN̊O\Ɠ\̕ϊ
 */
#define EXT_IPM(iipm)	(-CAST(PRI, (iipm) >> 8))		/* O\ɕϊ */
#define INT_IPM(ipm)	(CAST(uint16_t, -(ipm)) << 8)	/* \ɕϊ */

#ifndef TOPPERS_MACRO_ONLY

/*
 *  IPMin[hEFÅݗDx}XNC\ǰݒl̓Ǐo
 */
Inline uint16_t
current_iipm(void)
{
	return(current_sr() & 0x0700U);
}

/*
 *  IPMin[hEFÅݗDx}XNC\ǰݒl̐ݒ
 */
Inline void
set_iipm(uint16_t iipm)
{
	set_sr((current_sr() & ~0x0700U) | iipm);
}

/*
 *  TOPPERSWݏf̎
 *
 *  M68040́CXe[^XWX^iSRjɊݗDx}XNin[hEF
 *  ÅݗDx}XNCIPMjĂ邪CCPUbNtOɑ
 *  @\ȂD̂߁CCPUbNtŐ@\CIPMɂ
 *  D
 *
 *  ܂CPUbNtO̒liȂ킿CCPUbNԂCPUbN
 *  j́Ĉ߂̕ϐilock_flagjpӂĕێD
 *
 *  CPUbNtONAĂԁiȂ킿CCPUbNԂ
 *  ԁj́CIPMin[hEFÅݗDx}XNjCf̊
 *  Dx}XN̒lɐݒ肷D̊Ԃ́Cf̊ݗDx}XN
 *  ́CIPMpĕێD
 *
 *  ɑ΂CPUbNtOZbgĂԁiȂ킿CCPUb
 *  NԂ̊ԁj́CIPMin[hEFÅݗDx}XNjCJ[l
 *  Ǘׂ݂̊ă}XNliTIPM_LOCKjƁCf̊ݗD
 *  x}XNƂ̍ɐݒ肷D̊Ԃ̃f̊ݗDx}X
 *  ŃĈ߂̕ϐisaved_iipmC\ŕێjpӂĕێ
 *  D
 */

/*
 *  ReLXg̎Q
 *
 *  M68040ł́C^XNReLXg}X^[hŁC^XNReLX
 *  g݃[hŎsD}X^[h݃[h́CXe[
 *  ^XWX^iSRj̊݃[hrbgɂ蔻ʂłD
 */
Inline bool_t
sense_context(void)
{
	return((current_sr() & 0x1000U) == 0U);
}

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  CPUbNԂł̊ݗDx}XN
 *
 *  TIPM_LOCḰCJ[lǗׂ݂̊ă}XNlɒ`D
 *  ̓Iɂ́CTMIN_INTPRI-6̎TIPM_LOCK-7ɁCłȂꍇɂ
 *  TIPM_LOCKTMIN_INTPRIɈvD
 */
#if TMIN_INTPRI == -6		/* NMIȊOɃJ[lǗO݂݂̊Ȃ */
#define TIPM_LOCK		(-7)
#else /* TMIN_INTPRI == -6 */
#if (-1 >= TMIN_INTPRI) && (TMIN_INTPRI > -6)
#define TIPM_LOCK		TMIN_INTPRI
#else /* (-1 >= TMIN_INTPRI) && (TMIN_INTPRI > -6) */
#error TMIN_INTPRI out of range.
#endif /* (-1 >= TMIN_INTPRI) && (TMIN_INTPRI > -6) */
#endif /* TMIN_INTPRI == -6 */

/*
 *  CPUbNԂł̊ݗDx}XN̓\
 */
#define IIPM_LOCK		INT_IPM(TIPM_LOCK)

/*
 *  TIPM_ENAALLiݗDx}XNSj̓\
 */
#define IIPM_ENAALL		INT_IPM(TIPM_ENAALL)

#ifndef TOPPERS_MACRO_ONLY

/*
 *  CPUbNtÔ߂̕ϐ
 *
 *  ̕ϐ́CCPUbNԂ̎̂ݏĂ悢̂ƂD
 */
extern volatile bool_t		lock_flag;	/* CPUbNtO̒lێϐ */
extern volatile uint16_t	saved_iipm;	/* ݗDx}XNۑϐ */

/*
 *  CPUbNԂւ̈ڍs
 *
 *  IPMin[hEFÅݗDx}XNjCsaved_iipmɕۑCJ[
 *  lǗׂ݂̊ă}XNliTIPM_LOCKjɐݒ肷D܂C
 *  lock_flagtrueɂD
 *
 *  IPMCŏTIPM_LOCKƓ荂ꍇɂ́C
 *  saved_iipmɕۑ݂̂ŁCTIPM_LOCKɂ͐ݒ肵ȂD́Cf
 *  ̊ݗDx}XNCTIPM_LOCKƓ荂xɐݒ
 *  ĂԂɂD
 *
 *  ̊֐́CCPUbNԁilock_flagtruȅԁjŌĂ΂邱Ƃ
 *  Ȃ̂Ƒz肵ĂD
 */
Inline void
x_lock_cpu(void)
{
	uint16_t	iipm;

	/*
	 *  current_iipm()̕Ԃl𒼐saved_iipmɕۑCꎞϐiipm
	 *  pĂ̂́Ccurrent_iipm()Ă񂾒Ɋ݂C
	 *  Nꂽݏsaved_iipmύX\邽߂
	 *  D
	 */
	iipm = current_iipm();
#if TIPM_LOCK == -7
	disint();
#else /* TIPM_LOCK == -7 */
	if (IIPM_LOCK > iipm) {
		set_iipm(IIPM_LOCK);
	}
#endif /* TIPM_LOCK == -7 */
	saved_iipm = iipm;
	lock_flag = true;
	Asm("":::"memory");
}

#define t_lock_cpu()	x_lock_cpu()
#define i_lock_cpu()	x_lock_cpu()

/*
 *  CPUbNԂ̉
 *
 *  lock_flagfalseɂCIPMin[hEFÅݗDx}XNjC
 *  saved_iipmɕۑlɖ߂D
 *
 *  ̊֐́CCPUbNԁilock_flagtruȅԁjł̂݌Ă΂
 *  ̂Ƒz肵ĂD
 */
Inline void
x_unlock_cpu(void)
{
	Asm("":::"memory");
	lock_flag = false;
	set_iipm(saved_iipm);
}

#define t_unlock_cpu()	x_unlock_cpu()
#define i_unlock_cpu()	x_unlock_cpu()

/*
 *  CPUbNԂ̎Q
 */
Inline bool_t
x_sense_lock(void)
{
	return(lock_flag);
}

#define t_sense_lock()	x_sense_lock()
#define i_sense_lock()	x_sense_lock()

/*
 *  chg_ipmŗLȊݗDx͈̔͂̔
 *
 *  TMIN_INTPRI̒lɂ炸Cchg_ipmł́C-6`TIPM_ENAALLi0j͈̔
 *  ɐݒł邱ƂƂi^[Qbg`̊gjD
 */
#define VALID_INTPRI_CHGIPM(intpri) \
				(-6 <= (intpri) && (intpri) <= TIPM_ENAALL)

/*
 * if́jݗDx}XN̐ݒ
 *
 *  CPUbNtONAĂ鎞́Cn[hEFÅݗDx}
 *  XNݒ肷DCPUbNtOZbgĂ鎞́Csaved_iipm
 *  ݒ肵CɁCn[hEFÅݗDx}XNCݒ肵悤
 *  if́jݗDx}XNTIPM_LOCK̍ɐݒ肷D
 */
Inline void
x_set_ipm(PRI intpri)
{
	uint16_t	iipm = INT_IPM(intpri);

	if (!lock_flag) {
		set_iipm(iipm);
	}
	else {
		saved_iipm = iipm;
#if TIPM_LOCK == -7
		/*
		 *  TIPM_LOCK-7̏ꍇɂ́C̎_Ńn[hEFÅݗD
		 *  x}XNK7ɐݒ肳Ă邽߁Cݒ肵ȂKvȂD
		 */
#else /* TIPM_LOCK == -7 */
		set_iipm(iipm > IIPM_LOCK ? iipm : IIPM_LOCK);
#endif /* TIPM_LOCK == -7 */
	}
}

#define t_set_ipm(intpri)	x_set_ipm(intpri)
#define i_set_ipm(intpri)	x_set_ipm(intpri)

/*
 * if́jݗDx}XN̎Q
 *
 *  CPUbNtONAĂ鎞̓n[hEFÅݗDx}
 *  XNCZbgĂ鎞saved_iipmQƂD
 */
Inline PRI
x_get_ipm(void)
{
	uint16_t	iipm;

	if (!lock_flag) {
		iipm = current_iipm();
	}
	else {
		iipm = saved_iipm;
	}
	return(EXT_IPM(iipm));
}

#define t_get_ipm()		x_get_ipm()
#define i_get_ipm()		x_get_ipm()

/*
 *  ōD揇ʃ^XNւ̃fBXpb`iprc_support.Sj
 *
 *  dispatch́C^XNReLXgĂяoꂽT[rXR[
 *  ĂяôׂŁC^XNReLXgECPUbNԁEfBXpb
 *  `ԁEif́jݗDx}XNSԂŌĂяo
 *  ΂ȂȂD
 */
extern void	dispatch(void);

/*
 *  fBXpb`̓Jniprc_support.Sj
 *
 *  start_dispatch́CJ[lNɌĂяôׂŁCׂĂ̊
 *  ݂֎~ԁi݃bNԂƓ̏ԁjŌĂяoȂ
 *  ȂȂD
 */
extern void	start_dispatch(void) NoReturn;

/*
 *  ݂̃ReLXĝĂăfBXpb`iprc_support.Sj
 *
 *  exit_and_dispatch́Cext_tskĂяôׂŁC^XNReL
 *  XgECPUbNԁEfBXpb`ԁEif́jݗD
 *  x}XNSԂŌĂяoȂ΂ȂȂD
 */
extern void	exit_and_dispatch(void) NoReturn;

/*
 *  J[l̏Ǐďoiprc_support.Sj
 *
 *  call_exit_kerneĺCJ[l̏IɌĂяôׂŁC^XN
 *  ReLXgɐ؂芷āCJ[l̏Iiexit_kerneljĂяo
 *  D
 */
extern void call_exit_kernel(void) NoReturn;

/*
 *  ^XNReLXg̏
 *
 *  ^XNx~ԂsłԂɈڍs鎞ɌĂ΂D̎_
 *  ŃX^bN̈gĂ͂ȂȂD
 *
 *  activate_contextCCC֐ł͂Ȃ}N`ƂĂ̂́C
 *  ̎_łTCB`ĂȂ߂łD
 */
extern void	start_r(void);

#define activate_context(p_tcb)											\
{																		\
	(p_tcb)->tskctxb.msp = (void *)((char *)((p_tcb)->p_tinib->stk)		\
										+ (p_tcb)->p_tinib->stksz);		\
	(p_tcb)->tskctxb.pc = (void *) start_r;								\
}

/*
 *  calltex͎gpȂ
 */
#define OMIT_CALLTEX

/*
 *  OxN^e[u̍\̒`
 */
typedef struct exc_vector_entry {
	FP		exc_handler;		/* Onh̋NԒn */
} EXCVE;

/*
 *  ݃nhԍCPUOnhԍ͈̔͂̔
 */
#define VALID_INHNO_DEFINH(inhno)	((0x10U <= (inhno) && (inhno) <= 0x1fU) \
									|| (0x40U <= (inhno) && (inhno) <= 0xffU))
#define VALID_EXCNO_DEFEXC(excno)	((0x02U <= (excno) && (excno) <= 0x0fU) \
									|| (0x20U <= (excno) && (excno) <= 0x3fU))

/*
 *  ݃nh̐ݒ
 *
 *  xNgԍinhno̊݃nh̏o̔Ԓnint_entryɐ
 *  肷D
 */
Inline void
x_define_inh(INHNO inhno, FP int_entry)
{
	EXCVE	*excvt;

	assert(VALID_INHNO_DEFINH(inhno));

#ifdef EXCVT_KERNEL
	/*
	 *  EXCVT_KERNEL`Ă鎞́C̒VBR
	 *  EXCVT_KERNELɐݒ肷̂ŁCEXCVT_KERNELgD
	 */
	excvt = (EXCVE *) EXCVT_KERNEL;
#else /* EXCVT_KERNEL */
	excvt = (EXCVE *) current_vbr();
#endif /* EXCVT_KERNEL */
	excvt[inhno].exc_handler = int_entry;
}

/*
 *  CPUOnh̐ݒ
 *
 *  xNgԍexcnoCPUOnh̏o̔Ԓnexc_entryɐ
 *  肷D
 */
Inline void
x_define_exc(EXCNO excno, FP exc_entry)
{
	EXCVE	*excvt;

	assert(VALID_EXCNO_DEFEXC(excno));

#ifdef EXCVT_KERNEL
	/*
	 *  EXCVT_KERNEL`Ă鎞́C̒VBR
	 *  EXCVT_KERNELɐݒ肷̂ŁCEXCVT_KERNELgD
	 */
	excvt = (EXCVE *) EXCVT_KERNEL;
#else /* EXCVT_KERNEL */
	excvt = (EXCVE *) current_vbr();
#endif /* EXCVT_KERNEL */
	excvt[excno].exc_handler = exc_entry;
}

/*
 *  ݃nh̏o̐
 */

/*
 *  ݃nh̏õx}N
 */
#define INT_ENTRY(inhno, inthdr)	_kernel_##inthdr##_##inhno

/*
 *  LOG_INH_ENTER}N`ĂꍇɁCCALL_LOG_INH_ENTERC
 *  inhno_nump[^Ƃlog_inh_enterĂяoAZuR[
 *  hɃ}N`D
 */
#ifdef LOG_INH_ENTER

#define CALL_LOG_INH_ENTER(inhno_num) \
"	move.l #" #inhno_num ", -(%sp)	\n"  /* inhno_nump[^ */ \
"	jsr _kernel_log_inh_enter		\n"  /* log_inh_enterĂяo */ \
"	addq.l #4, %sp					\n"

#else /* LOG_INH_ENTER */
#define CALL_LOG_INH_ENTER(inhno_num)
#endif /* LOG_INH_ENTER */

#ifdef LOG_INH_LEAVE

/*
 *  CALL_LOG_INH_LEAVECinhno_nump[^Ƃlog_inh_leave
 *  яoAZuR[hɃ}N`D
 */
#define CALL_LOG_INH_LEAVE(inhno_num) \
"	move.l #" #inhno_num ", -(%sp)	\n"  /* inhno_nump[^ */ \
"	jsr _kernel_log_inh_leave		\n"  /* log_inh_leaveĂяo */ \
"	addq.l #4, %sp					\n"

/*
 *  LOG_INH_LEAVE}N`Ăꍇ̊݃nh̏oD
 *  ݃nhTu[`R[C߂ĂCg[XO
 *  擾Cret_intɕ򂷂D
 */
#define INTHDR_ENTRY(inhno, inhno_num, inthdr) \
extern void _kernel_##inthdr##_##inhno(void); \
asm(".text							\n" \
"_kernel_" #inthdr "_" #inhno ":	\n" \
"	movem.l %d0-%d1/%a0-%a1, -(%sp)	\n"  /* XNb`WX^ۑ */ \
	CALL_LOG_INH_ENTER(inhno_num) \
"	jsr " #inthdr "					\n"  /* ݃nhĂяo */ \
	CALL_LOG_INH_LEAVE(inhno_num) \
"	jmp _kernel_ret_int				\n");/* ret_int֕ */

#else /* LOG_INH_LEAVE */

/*
 *  LOG_INH_LEAVE}N`ĂȂꍇ̊݃nh̏o
 *  D߂ԒnƂret_intX^bNɐς񂾌C݃nh̋N
 *  Ԓnɕ򂷂D݃nh̃^[ɂCret_int֕
 *  D
 */
#define INTHDR_ENTRY(inhno, inhno_num, inthdr) \
extern void _kernel_##inthdr##_##inhno(void); \
asm(".text							\n" \
"_kernel_" #inthdr "_" #inhno ":	\n" \
"	movem.l %d0-%d1/%a0-%a1, -(%sp)	\n"  /* XNb`WX^ۑ */ \
	CALL_LOG_INH_ENTER(inhno_num) \
"	move.l #_kernel_ret_int, -(%sp)	\n"  /* ߂ԒnX^bNɐς */ \
"	jmp " #inthdr "					\n");/* ݃nh֕ */

#endif /* LOG_INH_LEAVE */

/*
 *  CPUOnh̏o̐
 *
 *  CPUOnh́C^XNReLXgŎsD̂߁CCPU
 *  OnhĂяoOɊ݃[hɈڍsC^[Ă
 *  ̃[hɖ߂D̃[hɖ߂߂ɁC݃[hɈڍsO
 *  SR݃X^bNɕۑi^[SRQƂ
 *  C^XNX^bNɕۑꍇCQƂ̂ʓ|jD
 */

/*
 *  CPUOnh̏õx}N
 */
#define EXC_ENTRY(excno, exchdr)	_kernel_##exchdr##_##excno

/*
 *  LOG_EXC_ENTER}N`ĂꍇɁCCALL_LOG_EXC_ENTERC
 *  excno_nump[^Ƃlog_exc_enterĂяoAZuR[
 *  hɃ}N`D
 */
#ifdef LOG_EXC_ENTER

#define CALL_LOG_EXC_ENTER(excno_num) \
"	move.l #" #excno_num ", -(%sp)	\n"  /* excno_nump[^ */ \
"	jsr _kernel_log_exc_enter		\n"  /* log_exc_enterĂяo */ \
"	addq.l #4, %sp					\n"

#else /* LOG_EXC_ENTER */
#define CALL_LOG_EXC_ENTER(excno_num)
#endif /* LOG_EXC_ENTER */

#ifdef LOG_EXC_LEAVE

/*
 *  CALL_LOG_EXC_LEAVECexcno_nump[^Ƃlog_exc_leave
 *  яoAZuR[hɃ}N`D
 */
#define CALL_LOG_EXC_LEAVE(excno_num) \
"	move.l #" #excno_num ", -(%sp)	\n"  /* excno_nump[^ */ \
"	jsr _kernel_log_exc_leave		\n"  /* log_exc_leaveĂяo */ \
"	addq.l #4, %sp					\n"

/*
 *  LOG_EXC_LEAVE}N`ĂꍇCPUOnh̏o
 *  DCPUOnhTu[`R[C߂ĂCg[X
 *  O̎擾Cret_excɕ򂷂D
 */
#define EXCHDR_ENTRY(excno, excno_num, exchdr) \
extern void _kernel_##exchdr##_##excno(void *sp); \
asm(".text							\n" \
"_kernel_" #exchdr "_" #excno ":	\n" \
"	movem.l %d0-%d1/%a0-%a1, -(%sp)	\n"  /* XNb`WX^ۑ */ \
"	lea.l 16(%sp), %a0				\n"  /* Ot[̐擪A0 */ \
"	move.w %sr, %d0					\n"  /* SRD0 */ \
"	and.w #~0x1000, %sr				\n"  /* ݃[hiX^bN؊j*/ \
"	move.l %d0, -(%sp)				\n"  /* SRX^bNɕۑ */ \
"	move.l _kernel_lock_flag, %d0	\n"  /* lock_flagX^bNɕۑ */ \
"	move.l %d0, -(%sp)				\n" \
"	move.l %a0, -(%sp)				\n"  /* A0p[^Ƃēn */ \
	CALL_LOG_EXC_ENTER(excno_num) \
"	jsr " #exchdr "					\n"  /* CPUOnh֕ */ \
	CALL_LOG_EXC_LEAVE(excno_num) \
"	jmp _kernel_ret_exc				\n");/* ߂ԒnX^bNɐς */

#else /* LOG_EXC_LEAVE */

/*
 *  LOG_EXC_LEAVE}N`ĂȂꍇCPUOnh̏o
 *  D߂ԒnƂret_excX^bNɐς񂾌CCPUOnh
 *  NԒnɕ򂷂DCPUOnh̃^[ɂCret_exc
 *  򂷂D
 */
#define EXCHDR_ENTRY(excno, excno_num, exchdr) \
extern void _kernel_##exchdr##_##excno(void *sp); \
asm(".text							\n" \
"_kernel_" #exchdr "_" #excno ":	\n" \
"	movem.l %d0-%d1/%a0-%a1, -(%sp)	\n"  /* XNb`WX^ۑ */ \
"	lea.l 16(%sp), %a0				\n"  /* Ot[̐擪A0 */ \
"	move.w %sr, %d0					\n"  /* SRD0 */ \
"	and.w #~0x1000, %sr				\n"  /* ݃[hiX^bN؊j*/ \
"	move.l %d0, -(%sp)				\n"  /* SRX^bNɕۑ */ \
"	move.l _kernel_lock_flag, %d0	\n"  /* lock_flagX^bNɕۑ */ \
"	move.l %d0, -(%sp)				\n" \
"	move.l %a0, -(%sp)				\n"  /* A0p[^Ƃēn */ \
	CALL_LOG_EXC_ENTER(excno_num) \
"	move.l #_kernel_ret_exc, -(%sp)	\n"  /* ߂ԒnX^bNɐς */ \
"	jmp " #exchdr "					\n");/* CPUOnh֕ */

#endif /* LOG_EXC_LEAVE */

/*
 *  CPUO̔̃ReLXg̎Q
 *
 *  CPUO̔̃ReLXgC^XNReLXg̎falseC
 *  łȂtrueԂD
 */
Inline bool_t
exc_sense_context(void *p_excinf)
{
	return((*((uint16_t *) p_excinf) & 0x1000U) == 0U);
}

/*
 *  CPUO̔IPMin[hEFÅݗDx}XNC\
 *  j̎Q
 */
Inline uint16_t
exc_get_iipm(void *p_excinf)
{
	return(*((uint16_t *) p_excinf) & 0x0700U);
}

/*
 *  CPUO̔̃ReLXgƊ݂̃}XNԂ̎Q
 *
 *  CPUO̔̃VXeԂCJ[lsłȂC^XNR
 *  eLXgłC݃bNԂłȂCCPUbNԂłȂCi
 *  f́jݗDx}XNSԂł鎞trueCłȂ
 *  falseԂiCPUOJ[lǗO̊ݏŔꍇ
 *  ɂfalseԂjD
 *
 *  M68040ł́CCPUO̔IPMin[hEFÅݗDx}
 *  XNjׂĂ݂̊Ԃł邱Ƃ`FbN邱ƂŁC
 *  J[lsłȂƁC݃bNԂłȂƁCCPUbN
 *  łȂƁCif́jݗDx}XNSԂł邱Ƃ
 *  4̏`FbN邱ƂłiCPUO
 *  lock_flagQƂKv͂ȂjD
 */
Inline bool_t
exc_sense_intmask(void *p_excinf)
{
	return(!exc_sense_context(p_excinf)
					&& exc_get_iipm(p_excinf) == IIPM_ENAALL);
}

/*
 *  CPUO̔̃ReLXgƊ݁^CPUbNԂ̎Q
 *
 *  CPUO̔̃VXeԂCJ[lsłȂC^XNR
 *  eLXgłC݃bNԂłȂCCPUbNԂłȂ
 *  trueCłȂfalseԂiCPUOJ[lǗO̊ݏ
 *  ŔꍇɂfalseԂjD
 *
 *  M68040ł́CCPUO̔IPMin[hEFÅݗDx}
 *  XNjTIPM_LOCKႢƂ`FbN邱ƂŁCJ[ls
 *  ȂƁC݃bNԂłȂƁCCPUbNԂłȂƂ3
 *  ̏`FbNĂiCPUOlock_flag͎QƂ
 *  ȂjDɂCif́jݗDx}XNTIPM_LOCK
 *  ͂荂lɐݒ肵ă^XNsĂ鎞ɂfalse Ԃ
 *  Ă܂Cf𐳊mɂ邽߂̃I[owbh傫ƂC
 *  e邱ƂɂD
 */
Inline bool_t
exc_sense_unlock(void *p_excinf)
{
	return(!exc_sense_context(p_excinf)
					&& exc_get_iipm(p_excinf) < IIPM_LOCK);
}

/*
 *  vZbTˑ̏
 */
extern void	prc_initialize(void);

/*
 *  vZbTˑ̏I
 */
extern void	prc_terminate(void);

#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_PRC_CONFIG_H */
