/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: mempfix.h 264 2007-07-12 08:23:10Z hiro $
 */

/*
 *		Œ蒷v[@\
 */

#ifndef TOPPERS_MEMPFIX_H
#define TOPPERS_MEMPFIX_H

#include <queue.h>

/*
 *  Œ蒷ubNǗubN
 *
 *  nexttB[hɂ́CubNčς݂̏ꍇINDEX_ALLOCC
 *  Ă̏ꍇ͎̖ăubÑCfbNXԍi[D
 *  Ō̖ăubN̏ꍇɂ́CINDEX_NULLi[D
 */
typedef struct fixed_memoryblock_management_block {
	uint_t		next;			/* ̖ăubN */
} MPFMB;

/*
 *  Œ蒷v[ubN
 *
 *  ̍\̂́CEʐMIuWFNg̏ubN̋ʕ
 *  iWOBJINIBjgiIuWFNgw̌pɑĵŁC
 *  ŏ̃tB[hʂɂȂĂD
 */
typedef struct fixed_memorypool_initialization_block {
	ATR			mpfatr;			/* Œ蒷v[ */
	uint_t		blkcnt;			/* ubN */
	uint_t		blksz;			/* ubÑTCYiۂ߂lj */
	void		*mpf;			/* Œ蒷v[̈̐擪Ԓn */
	MPFMB		*p_mpfmb;		/* Œ蒷v[Ǘ̈̐擪Ԓn */
} MPFINIB;

/*
 *  Œ蒷v[ǗubN
 *
 *  ̍\̂́CEʐMIuWFNg̊ǗubN̋ʕiWOBJCBj
 *  giIuWFNgw̌pɑĵŁCŏ2
 *  tB[hʂɂȂĂD
 */
typedef struct fixed_memorypool_control_block {
	QUEUE		wait_queue;		/* Œ蒷v[҂L[ */
	const MPFINIB *p_mpfinib;	/* ubNւ̃|C^ */
	uint_t		fblkcnt;		/* ăubN */
	uint_t		unused;			/* gpubN̐擪 */
	uint_t		freelist;		/* ăubÑXg */
} MPFCB;

/*
 *  Œ蒷v[҂ubN̒`
 *
 *  ̍\̂́CEʐMIuWFNg̑҂ubN̋ʕ
 *  iWINFO_WOBJjgiIuWFNgw̌pɑĵŁC
 *  ŏ2̃tB[hʂɂȂĂD
 */
typedef struct fixed_memorypool_waiting_information {
	WINFO		winfo;			/* W̑҂ubN */
	MPFCB		*p_mpfcb;		/* ҂ĂŒ蒷v[̊ǗubN*/
	void		*blk;			/* lubN */
} WINFO_MPF;

/*
 *  Œ蒷v[ID̍őlikernel_cfg.cj
 */
extern const ID	tmax_mpfid;

/*
 *  Œ蒷v[ubÑGAikernel_cfg.cj
 */
extern const MPFINIB	mpfinib_table[];

/*
 *  Œ蒷v[ǗubÑGAikernel_cfg.cj
 */
extern MPFCB	mpfcb_table[];

/*
 *  Œ蒷v[ǗubNŒ蒷v[IDo
 *  ߂̃}N
 */
#define	MPFID(p_mpfcb)	((ID)(((p_mpfcb) - mpfcb_table) + TMIN_MPFID))

/*
 *  Œ蒷v[@\̏
 */
extern void	initialize_mempfix(void);

/*
 *  Œ蒷v[ubNl
 */
extern void	get_mpf_block(MPFCB *p_mpfcb, void **p_blk);

#endif /* TOPPERS_MEMPFIX_H */
