﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Bis5Products.InstCreater {
    public partial class Setup : Form {
        /// <summary>
        /// インストールするソフトウェアが動作するのに必要な.net Frameworkのバージョン
        /// </summary>
        public enum FrameworkVersion {
            /// <summary>
            /// 設定ファイル内に指定がありません。インストーラは正常に動作しません。
            /// </summary>
            Undefined,
            /// <summary>
            /// ソフトウェアの動作に.net Frameworkを必要としません。
            /// </summary>
            None,
            /// <summary>
            /// ソフトウェアの動作に.net Framework2.0が必要です。
            /// </summary>
            FW2,
            /// <summary>
            /// ソフトウェアの動作に.net Framework3.0が必要です。
            /// </summary>
            FW3,
            /// <summary>
            /// ソフトウェアの動作に.net Framework3.5が必要です。
            /// </summary>
            FW35,
            /// <summary>
            /// ソフトウェアの動作に.net Framework4.0 Cloent Profileが必要です。
            /// </summary>
            FW4C,
            /// <summary>
            /// ソフトウェアの動作に.net Framework4.0 Extendedが必要です。
            /// </summary>
            FW4E
        }

        private Setup() {
            InitializeComponent();
        }
        /// <param name="cfg">インストールスクリプトファイルから読み込まれた設定値を格納したDictionary&lt;string, string&gt;</param>
        /// <param name="fwver">インストールするソフトウェアに必要なランタイムバージョン</param>
        public Setup(Dictionary<string, string> cfg = null, FrameworkVersion fwver = FrameworkVersion.Undefined)
            : this() {

                if (cfg == null || fwver == FrameworkVersion.Undefined)
                    Application.Exit();

        }

    }
}