/**
 *
 */
package common;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author 無糖ブラック
 *
 */
public class Environment {

	/**
	 *
	 */
	static Environment m_env = null;

	/**
	 *
	 */
	private Logger m_logger = null;

	/**
	 *
	 */
	private ArrayList<String> m_pathList = null;

	/**
	 *
	 */
	private Properties m_properties;

	/**
	 *
	 */
	private Environment() {
		setLogger(Logger.getLogger("HttpServlet"));
		m_pathList = new ArrayList<String>();
		m_properties = new Properties();
	}

	/**
	 *
	 * @return
	 */
	public static Environment getEnvironment() {
		if ( m_env == null ) {
			m_env = new Environment();
		}
		return m_env;
	}

	/**
	 *
	 * @param path
	 * @return
	 */
	public int init(String path) {

		FileInputStream fis = null;
		InputStreamReader isr = null;

		try {

			if ( m_pathList.indexOf(path) < 0 ) {
				fis = new FileInputStream(path);
				isr = new InputStreamReader(fis, Charset.defaultCharset());
				m_properties.load(isr);

				String logLevel = getParam("loglevel");
				logLevel = logLevel.toUpperCase();
				if (logLevel.equals("ALL")) {
					m_logger.setLevel(Level.ALL);
				}
				else if (logLevel.equals("FINEST")) {
					m_logger.setLevel(Level.FINEST);
				}
				else if (logLevel.equals("FINER")) {
					m_logger.setLevel(Level.FINER);
				}
				else if (logLevel.equals("FINE")) {
					m_logger.setLevel(Level.FINE);
				}
				else if (logLevel.equals("CONFIG")) {
					m_logger.setLevel(Level.CONFIG);
				}
				else if (logLevel.equals("INFO")) {
					m_logger.setLevel(Level.INFO);
				}
				else if (logLevel.equals("WARNING")) {
					m_logger.setLevel(Level.WARNING);
				}
				else if (logLevel.equals("SEVERE")) {
					m_logger.setLevel(Level.SEVERE);
				}
				else if (logLevel.equals("OFF")) {
					m_logger.setLevel(Level.OFF);
				}

				m_pathList.add(path);
			}

		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return -1;
		} catch (IOException e) {
			e.printStackTrace();
			return -1;
		} finally {
			try {
				if (isr != null) {
					isr.close();
				}
				if (fis != null) {
					fis.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
				return -1;
			}
		}

		return 0;
	}

	/**
	 *
	 * @param key
	 * @return
	 */
	public String getParam(String key) {
		return m_properties.getProperty(key);
	}

	/**
	 *
	 * @param key
	 * @return
	 */
	public void setParam(String key, String value) {
		m_properties.setProperty(key, value);
	}

	/**
	 * @return logger
	 */
	public Logger getLogger() {
		return m_logger;
	}

	/**
	 * @param logger セットする logger
	 */
	private void setLogger(Logger logger) {
		m_logger = logger;
	}
}
