/**
 *
 */
package control;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import objectModel.Account;
import objectModel.ClassAccount;
import systemModel.ClassColumnMaster;
import systemModel.ClassColumnSetting;
import systemModel.ClassDepartment;
import systemModel.ClassDepartmentPerson;
import systemModel.ClassPerson;
import systemModel.ColumnMaster;
import systemModel.Department;
import systemModel.Person;

import common.DBAccessWrapper;
import common.Environment;
import common.XSVReader;

/**
 *
 * @author 無糖ブラック
 *
 */
public class Maintenance extends ChokomaroHttpServlet {

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		super.doPost(request, response);

		Environment env = Environment.getEnvironment();
		String setup = env.getParam("setup");
		if ( !setup.equals("on")) {
			return;
		}

		HttpSession session = request.getSession(true);

		String in_userid = (String)session.getAttribute("userid");
		if ( in_userid.equals("") ) {
			return;
		}

		String in_option = request.getParameter("option");
		if ( in_option.equals("") ) {
			return;
		}

		//ユーザー情報初期化
		if ( in_option.equals("setupPerson") ) {
			String messageString = setupPerson(in_userid);

			//登録結果出力
			response.getWriter().write(messageString);
		}
		else if ( in_option.equals("setupColumns") ) {
			String messageString = setupColumns(in_userid);

			//登録結果出力
			response.getWriter().write(messageString);
		}
		else if ( in_option.equals("setupAccount") ) {
			String messageString = setupAccount(in_userid);

			//登録結果出力
			response.getWriter().write(messageString);
		}
	}

	/**
	 * ユーザー情報初期化
	 * @return
	 */
	private String setupPerson(String in_userid) {

		String messageString = "";
		int result = 0;
		Environment env = Environment.getEnvironment();
		DBAccessWrapper db = new DBAccessWrapper(env, in_userid);

		ClassDepartmentPerson clsDepartmentPerson = new ClassDepartmentPerson(db);
		ClassDepartment clsDepartment = new ClassDepartment(db);
		ClassPerson clsPerson = new ClassPerson(db);

		try {
			db.startTransaction();

			//部門ユーザー関連テーブル初期化
			result = clsDepartmentPerson.truncate();
			if ( result < 0 ) {
				db.rollback();
				return "部門ユーザー関連情報の初期化に失敗しました。";
			}

			//部門テーブル初期化
			result = clsDepartment.truncate();
			if ( result < 0 ) {
				db.rollback();
				return "部門情報の初期化に失敗しました。";
			}

			//ユーザーテーブル初期化
			result = clsPerson.truncate();
			if ( result < 0 ) {
				db.rollback();
				return "ユーザー情報の初期化に失敗しました。";
			}

			ArrayList<String> insertParams = new ArrayList<String>();
			ArrayList<Object> insertValues  = new ArrayList<Object>();

			insertParams.clear();
			insertParams.add("DEPARTMENT_NUMBER");
			insertParams.add("NAME");
			insertParams.add("PERSON");
			insertParams.add("CREATE_PERSON");
			insertParams.add("MODIFY_PERSON");

			insertValues.clear();
			insertValues.add(in_userid);
			insertValues.add("管理者");
			insertValues.add(in_userid);
			insertValues.add(in_userid);
			insertValues.add(in_userid);

			Department department = clsDepartment.create(insertParams, insertValues);

			insertParams.clear();
			insertParams.add("PERSON_NUMBER");
			insertParams.add("PASSWORD");
			insertParams.add("NAME");
			insertParams.add("CREATE_PERSON");
			insertParams.add("MODIFY_PERSON");

			insertValues.clear();
			insertValues.add(in_userid);
			insertValues.add(in_userid);
			insertValues.add(in_userid);
			insertValues.add(in_userid);
			insertValues.add(in_userid);

			Person person = clsPerson.create(insertParams, insertValues);

			department.assignPerson(person, in_userid);

			db.commit();

			messageString = "ユーザー情報を初期化しました。";
		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();
			messageString = "ユーザー情報の初期化に失敗しました。";
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();
			messageString = "ユーザー情報の初期化に失敗しました。";
		} catch (IOException e) {
			e.printStackTrace();
			db.rollback();
			messageString = "ユーザー情報の初期化に失敗しました。";
		}

		return messageString;
	}

	/**
	 * 列情報初期化
	 * @return
	 */
	private String setupColumns(String in_userid) {

		//列情報初期設定ファイル読み込み
		String path = getServletContext().getRealPath("/conf/columns.ini");
		XSVReader xsvReader = new XSVReader(path, "\t");
		ArrayList<String[]> lines;
		try {
			lines = xsvReader.readLines();
		} catch (IOException e) {
			e.printStackTrace();
			return "列情報初期設定ファイル読み込みに失敗しました。";
		}

		String messageString = "";
		int result = 0;
		Environment env = Environment.getEnvironment();
		DBAccessWrapper db = new DBAccessWrapper(env, in_userid);

		ClassColumnMaster clsColumnMaster = new ClassColumnMaster(db);
		ClassColumnSetting clsColumnSetting = new ClassColumnSetting(db);

		try {
			db.startTransaction();

			//列情報テーブル初期化
			result = clsColumnMaster.truncate();
			if ( result < 0 ) {
				db.rollback();
				return "列情報の初期化に失敗しました。";
			}

			ArrayList<String> insertParams1 = new ArrayList<String>();
			ArrayList<Object> insertValues1  = new ArrayList<Object>();

			insertParams1.clear();
			insertParams1.add("TABLE_VIEW_NAME");
			insertParams1.add("TABLE_ID");
			insertParams1.add("COLUMN_VIEW_NAME");
			insertParams1.add("COLUMN_ID");
			insertParams1.add("COLUMN_TYPE");
			insertParams1.add("COLUMN_LENGTH");
			insertParams1.add("COLUMN_DISPLAY");
			insertParams1.add("COLUMN_EDITABLE");
			insertParams1.add("CREATE_PERSON");
			insertParams1.add("MODIFY_PERSON");

			ArrayList<String> insertParams2 = new ArrayList<String>();
			ArrayList<Object> insertValues2  = new ArrayList<Object>();

			insertParams2.clear();
			insertParams2.add("SUPER_IDENTIFICATION");
			insertParams2.add("PERSON_NUMBER");
			insertParams2.add("DISPLAY");
			insertParams2.add("STRUCT_ORDER");
			insertParams2.add("WITDH");
			insertParams2.add("CREATE_PERSON");
			insertParams2.add("MODIFY_PERSON");

			String lastTableName = "";
			int structOrder = 1;
			for( int ii = 1; ii < lines.size(); ++ii ) {

				String[] attrs = lines.get(ii);

				String tableViewName = "";
				String tableName = "";
				String columnViewName = "";
				String columnName = "";
				String columnType = "";
				String columnLength = "";
				String columnOption = "";
				String[] columnOptions = null;

				for (int jj = 0; jj < attrs.length; ++jj ) {
					switch (jj) {
					case 0:
						tableViewName = attrs[jj];
						break;
					case 1:
						tableName = attrs[jj].toUpperCase();
						break;
					case 2:
						columnViewName = attrs[jj];
						break;
					case 3:
						columnName = attrs[jj].toUpperCase();
						break;
					case 4:
						columnType = attrs[jj].toUpperCase();
						break;
					case 5:
						columnLength = attrs[jj];
						break;
					case 13:
						columnOption = attrs[jj].toUpperCase();
						columnOptions = columnOption.split(",");
						break;
					default:
						break;
					}
				}

				if ( columnLength.isEmpty() ) {
					columnLength = "0";
				}

				//列情報登録
				insertValues1.clear();
				insertValues1.add(tableViewName);
				insertValues1.add(tableName);
				insertValues1.add(columnViewName);
				insertValues1.add(columnName);
				insertValues1.add(columnType);
				insertValues1.add(columnLength);
				String columnDisplay = "TRUE";
				String columnEditable = "FALSE";
				if ( columnOptions != null ) {
					for (int jj = 0; jj < columnOptions.length; ++jj ) {
						if ( columnOptions[jj].equals("HIDDEN") ) {
							columnDisplay = "FALSE";
						}
						else if ( columnOptions[jj].equals("EDITABLE") ) {
							columnEditable = "TRUE";
						}
					}
				}
				insertValues1.add(columnDisplay);
				insertValues1.add(columnEditable);
				insertValues1.add(in_userid);
				insertValues1.add(in_userid);

				ColumnMaster columnMaster = clsColumnMaster.create(insertParams1, insertValues1);

				//列情報登録
				if ( lastTableName.isEmpty() || !lastTableName.equals(tableName) ) {
					lastTableName = tableName;
					structOrder = 1;
				}
				else {
					++structOrder;
				}

				insertValues2.clear();
				insertValues2.add(columnMaster.identification());
				insertValues2.add(in_userid);
				insertValues2.add("TRUE");
				insertValues2.add(structOrder);
				insertValues2.add("100");
				insertValues2.add(in_userid);
				insertValues2.add(in_userid);

				clsColumnSetting.create(insertParams2, insertValues2);
			}

			db.commit();

			messageString = "列情報を初期化しました。";
		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();
			messageString =  "列情報の初期化に失敗しました。";
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();
			messageString =  "列情報の初期化に失敗しました。";
		} catch (IOException e) {
			e.printStackTrace();
			db.rollback();
			messageString =  "列情報の初期化に失敗しました。";
		}

		return messageString;
	}

	/**
	 * 勘定科目初期化
	 * @param in_userid
	 * @return
	 * @throws IOException
	 */
	private String setupAccount(String in_userid) {

		//勘定科目初期設定ファイル読み込み
		String path = getServletContext().getRealPath("/conf/account.ini");
		XSVReader xsvReader = new XSVReader(path, "\t");
		ArrayList<String[]> lines;
		try {
			lines = xsvReader.readLines();
		} catch (IOException e) {
			e.printStackTrace();
			return "勘定科目初期設定ファイル読み込みに失敗しました。";
		}

		String messageString = "";
		int result = 0;
		Environment env = Environment.getEnvironment();
		DBAccessWrapper db = new DBAccessWrapper(env, in_userid);
		ClassAccount clsAccount = new ClassAccount(db);

		try {
			db.startTransaction();

			//勘定科目テーブル初期化
			result = clsAccount.truncate();
			if ( result < 0 ) {
				db.rollback();
				return "勘定科目の初期化に失敗しました。";
			}

			ArrayList<String> insertParams = new ArrayList<String>();
			ArrayList<Object> insertValues  = new ArrayList<Object>();

			insertParams.clear();
			insertParams.add("ACCOUNT_NUMBER");
			insertParams.add("NAME");
			insertParams.add("AMOUNT");
			insertParams.add("CONSUMPTION_TAX_RATE");
			insertParams.add("ACCOUNT_TYPE");
			insertParams.add("DEBIT_CREDIT_TYPE");
			insertParams.add("BP_TYPE");

			insertParams.add("TOP_ACCOUNT");
			insertParams.add("HAS_ACCOUNT");

			insertParams.add("DEPARTMENT_NUMBER");
			insertParams.add("DISPLAY");
			insertParams.add("SYSTEM_FLAG");
			insertParams.add("CREATE_PERSON");
			insertParams.add("MODIFY_PERSON");

			for( int ii = 0; ii < lines.size(); ++ii ) {

				//勘定科目登録
				String[] attrs = lines.get(ii);

				//勘定科目登録
				insertValues .clear();
				insertValues .add(attrs[0]);
				insertValues .add(attrs[1]);
				insertValues .add(attrs[2]);
				insertValues .add(attrs[3]);
				insertValues .add(attrs[4]);
				insertValues .add(attrs[5]);
				insertValues .add(attrs[6]);
				if ( attrs.length > 9 ) {
					insertValues .add("false");
				}
				else {
					insertValues .add("true");
				}
				insertValues .add("false");
				insertValues .add(in_userid);
				insertValues .add(attrs[7]);
				insertValues .add(attrs[8]);
				insertValues .add(in_userid);
				insertValues .add(in_userid);

				Account account;
				account = clsAccount.create(insertParams, insertValues);

				String accountIdentification;
				accountIdentification = account.identification();
				if ( accountIdentification.equals("") ) {
					db.rollback();
					return "勘定科目の登録に失敗しました。";
				}

				if ( attrs.length > 9 ) {
					//上位勘定科目検索
					String condition = "ACCOUNT_NUMBER = ?";
					ArrayList<Object> conditionValues = new ArrayList<Object>();
					conditionValues.add(attrs[9]);

					//勘定科目構成登録
					ArrayList<Account> results;
					results = clsAccount.select(condition, conditionValues);
					if ( results.size() == 0 ) {
						db.rollback();
						messageString = "上位勘定科目の検索に失敗しました。(" + attrs[10] + ")";
						return messageString;
					}
					Account parentAccount = results.get(0);
					parentAccount.appendChild(account);
				}
			}

			db.commit();

			messageString = "勘定科目を初期化しました。";
		} catch (SQLException e) {
			e.printStackTrace();
			db.rollback();
			messageString = "勘定科目の初期化に失敗しました。";
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
			db.rollback();
			messageString = "勘定科目の初期化に失敗しました。";
		} catch (IOException e) {
			e.printStackTrace();
			db.rollback();
			messageString = "勘定科目の初期化に失敗しました。";
		}

		return messageString;
	}
}
