/**
 *
 */
package meta;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import common.XSVReader;


/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassMetaColumn extends ClassMetaObject {

	private Map<String, ArrayList<MetaColumn>> m_metaColumnsMap;

	private String m_columnTypesMetaPath;
	private Properties m_columnTypes = new Properties();

	/**
	 *
	 * @param delimiter
	 */
	public ClassMetaColumn(String path, String path2, String delimiter, ArrayList<String> columnNames) {
		super(path, delimiter, columnNames);

		m_metaColumnsMap = new HashMap<String, ArrayList<MetaColumn>>();
		m_columnTypesMetaPath = path2;
	}

	/**
	 *
	 * @param path
	 * @return
	 * @throws IOException
	 */
	public void init() throws IOException {

		if ( m_metaColumnsMap.isEmpty() ) {

			FileInputStream fis = new FileInputStream(m_columnTypesMetaPath);
			InputStreamReader isr = new InputStreamReader(fis, Charset.defaultCharset());
			m_columnTypes.load(isr);
			Enumeration<Object> keys = m_columnTypes.keys();
			while (keys.hasMoreElements()) {
				String key = keys.nextElement().toString();
				String value = m_columnTypes.getProperty(key);
				m_columnTypes.setProperty(key.toUpperCase(), value.toUpperCase());
			}
			isr.close();
			fis.close();

			int	columnTypeIndex = 0;
			for (int ii = 0; ii < m_columnNames.size(); ++ii ) {
				String columnName = m_columnNames.get(ii);
				if ( columnName.equals("COLUMN_TYPE") ){
					columnTypeIndex = ii;
					break;
				}
			}

			XSVReader xsvReader = new XSVReader(m_path, m_delimiter);
			ArrayList<String[]> lines = xsvReader.readLines();
			for( int ii = 1; ii < lines.size(); ++ii ) {
				String[] attrs = lines.get(ii);
				String value = "";
				ArrayList<String> values = new ArrayList<String>();
				for (int jj = 0; jj < m_columnNames.size(); ++jj ) {
					if ( jj < attrs.length ) {
						value = attrs[jj];
						value = value.toUpperCase();
					}
					else {
						value = "";
					}

					//型情報置換
					if ( jj == columnTypeIndex ) {
						if (value.contains(" ")) {
							value = value.replaceAll(" ", "_");
						}
						if ( m_columnTypes.containsKey(value) ) {
							value = m_columnTypes.getProperty(value);
						}
					}

					values.add(value);
				}

				MetaColumn object = new MetaColumn(m_columnNames, values);
				String tableId = object.getProperty("TABLE_ID");
				ArrayList<MetaColumn> metaColumns = m_metaColumnsMap.get(tableId);
				if ( metaColumns == null ) {
					metaColumns = new ArrayList<MetaColumn>();
				}
				metaColumns.add(object);
				m_metaColumnsMap.put(tableId, metaColumns);
			}
		}
	}

	/**
	 *
	 * @param path
	 * @return
	 * @throws IOException
	 */
	public ArrayList<MetaColumn> getMetaObjects(String targetTableId) {
		return m_metaColumnsMap.get(targetTableId.toUpperCase());
	}

	/**
	 *
	 * @param path
	 * @return
	 * @throws IOException
	 */
	public MetaColumn getMetaObjects(String targetTableId, String targetColumnId) {
		MetaColumn metaColumn = null;
		ArrayList<MetaColumn> metaColumns = m_metaColumnsMap.get(targetTableId);
		for (int ii = 0; ii < metaColumns.size(); ++ii) {
			metaColumn = metaColumns.get(ii);
			String columnId = metaColumn.getProperty("COLUMN_ID");
			if (columnId.equals(targetColumnId)) {
				break;
			}
		}
		return metaColumn;
	}

}
