package model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import meta.ClassMetaColumn;
import meta.ClassMetaObject;
import meta.MetaColumn;
import meta.MetaFactory;

import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassModelObject {

	/**
	 *
	 */
	protected DBAccessWrapper m_db;

	/**
	 *
	 */
	protected String m_tableName;

	/**
	 *
	 */
	protected Map<String, String> m_propTypes = new HashMap<String, String>();

	/**
	 *
	 */
	public ClassModelObject() {
		this.m_db = null;
		this.m_tableName = "";
	}

	/**
	 *
	 * @param db
	 */
	public ClassModelObject(DBAccessWrapper db, String tableName) {
		this.m_db = db;
		this.m_tableName = tableName;

		MetaFactory metaFactory = MetaFactory.getMetaFactory();
		ClassMetaObject classMetaObject = metaFactory.getClassMetaObject("MetaColumn");
		ClassMetaColumn classMetaColumn = (ClassMetaColumn)classMetaObject;
		ArrayList<MetaColumn> metaColumns = classMetaColumn.getMetaObjects(tableName);
		for (int ii = 0; ii < metaColumns.size(); ++ii) {
			MetaColumn metaColumn = metaColumns.get(ii);
			String columnId = metaColumn.getProperty("COLUMN_ID");
			String columnType = metaColumn.getProperty("COLUMN_TYPE");
			m_propTypes.put(columnId, columnType);
		}
	}

	/**
	 *
	 * @param selectParams
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public ArrayList<ArrayList<String>> select(ArrayList<String> selectParams, String selectCondition, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException {

		String selectConditions[] = selectCondition.split(" ");
		ArrayList<String> conditionTypes = new ArrayList<String>();
		for (int ii = 0; ii < selectConditions.length; ++ii){
			String key = selectConditions[ii].toUpperCase();
			if ( m_propTypes.containsKey(key) ) {
				String type = m_propTypes.get(key);
				conditionTypes.add(type);
			}
		}

		return m_db.select(selectParams, m_tableName, selectCondition, conditionTypes, conditionValues);
	}

	/**
	 *
	 * @param insertParams
	 * @param insertTypes
	 * @param insertValues
	 * @param selectParams
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	protected ArrayList<ArrayList<String>> insert(ArrayList<String> insertParams, ArrayList<Object> insertValues, ArrayList<String> selectParams) throws SQLException, ClassNotFoundException {

		ArrayList<String> allParams = new ArrayList<String>();
		ArrayList<Object> allValues = new ArrayList<Object>();

		allParams.addAll(insertParams);
		allValues.addAll(insertValues);

		if ( !allParams.contains("CREATE_PERSON") ) {
			allParams.add("CREATE_PERSON");
			allValues.add(m_db.getActor());
		}
		if ( !allParams.contains("MODIFY_PERSON") ) {
			allParams.add("MODIFY_PERSON");
			allValues.add(m_db.getActor());
		}

		ArrayList<String> allTypes = new ArrayList<String>();
		for (int ii = 0; ii < allParams.size(); ++ii){
			String key = allParams.get(ii);
			String type = m_propTypes.get(key);
			allTypes.add(type);
		}

		return m_db.insert(m_tableName, allParams, allTypes, allValues, selectParams);
	}

	/**
	 *
	 * @param updateParams
	 * @param updateTypes
	 * @param updateValues
	 * @param updateCondition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public int update(ArrayList<String> updateParams, ArrayList<Object> updateValues, String updateCondition, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException {

		ArrayList<String> updateTypes = new ArrayList<String>();
		for (int ii = 0; ii < updateParams.size(); ++ii){
			String key = updateParams.get(ii);
			String type = m_propTypes.get(key);
			updateTypes.add(type);
		}

		String updateConditions[] = updateCondition.split(" ");
		ArrayList<String> conditionTypes = new ArrayList<String>();
		for (int ii = 0; ii < updateConditions.length; ++ii){
			String key = updateConditions[ii];
			if ( m_propTypes.containsKey(key) ) {
				String type = m_propTypes.get(key);
				conditionTypes.add(type);
			}
		}

		ArrayList<String> allParams = new ArrayList<String>();
		allParams.addAll(updateParams);
		if ( !allParams.contains("MODIFY_PERSON") ) {
			allParams.add("MODIFY_PERSON");
		}

		ArrayList<String> updateAllTypes = new ArrayList<String>();
		updateAllTypes.addAll(updateTypes);
		updateAllTypes.add("string");

		ArrayList<Object> allValues = new ArrayList<Object>();
		allValues.addAll(updateValues);
		allValues.add(m_db.getActor());

		return m_db.update(allParams, updateAllTypes, allValues, m_tableName, updateCondition, conditionTypes, conditionValues);
	}

	/**
	 *
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public int truncate() throws SQLException, ClassNotFoundException {
		int result;
		result = m_db.truncate(m_tableName);
		return result;
	}
}
