package objectModel;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

import meta.ClassMetaColumn;
import meta.ClassMetaObject;
import meta.MetaColumn;
import meta.MetaFactory;
import model.ClassEntity;

import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassAccount extends ClassEntity {

	/**
	 *
	 */
	public ClassAccount() {
		this.m_tableName = "ACCOUNT";
	}

	/**
	 *
	 * @param db
	 */
	public ClassAccount(DBAccessWrapper db) {
		super(db, "ACCOUNT");
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public ArrayList<Account> select(String condition, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException, IOException {

		MetaFactory metaFactory = MetaFactory.getMetaFactory();
		ClassMetaObject classMetaObject = metaFactory.getClassMetaObject("MetaColumn");
		ClassMetaColumn classMetaColumn = (ClassMetaColumn)classMetaObject;

		ArrayList<MetaColumn> metaColumns = classMetaColumn.getMetaObjects(m_tableName);
		ArrayList<String> selectParams = new ArrayList<String>();
		for (int ii = 0; ii < metaColumns.size(); ++ii) {
			MetaColumn metaColumn = metaColumns.get(ii);
			String columnId = metaColumn.getProperty("COLUMN_ID");
			selectParams.add(columnId);
		}

		ArrayList<ArrayList<String>> rows = super.select(selectParams, condition, conditionValues);
		ArrayList<Account> objects = new ArrayList<Account>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			Account object = new Account(m_db, selectParams, row);
			objects.add(object);
		}

		return objects;
	}

	/**
	 *
	 * @param insertParams
	 * @param insertTypes
	 * @param insertValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public Account create(ArrayList<String> insertParams, ArrayList<Object> insertValues) throws SQLException, ClassNotFoundException, IOException {
		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.add("IDENTIFICATION");

		ArrayList<ArrayList<String>> rows = super.insert(insertParams, insertValues, selectParams);

		String identificaton = rows.get(0).get(0);
		String condition = "identification = ?";
		ArrayList<Object> conditionValues = new ArrayList<Object>();
		conditionValues.add(identificaton);

		ArrayList<Account> accounts;
		accounts = select(condition, conditionValues);

		return accounts.get(0);
	}

	/**
	 *
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public int truncate() throws SQLException, ClassNotFoundException {
		int result = 0;

		//勘定科目構成テーブル初期化
		ClassAccountStructure clsAccountStructure = new ClassAccountStructure(m_db);
		result = clsAccountStructure.truncate();
		if ( result < 0 ) {
			return result;
		}

		//勘定科目品目関連テーブル初期化
		ClassAccountPart clsAccountPart = new ClassAccountPart(m_db);
		result = clsAccountPart.truncate();
		if ( result < 0 ) {
			return result;
		}

		result = super.truncate();
		return result;
	}
}
