package objectModel;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

import meta.ClassMetaColumn;
import meta.ClassMetaObject;
import meta.MetaColumn;
import meta.MetaFactory;
import model.ClassEntity;

import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassJournal extends ClassEntity {

	/**
	 *
	 */
	public ClassJournal() {
		this.m_tableName = "JOURNAL";
	}

	/**
	 *
	 * @param db
	 */
	public ClassJournal(DBAccessWrapper db) {
		super(db, "JOURNAL");
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public ArrayList<Journal> select(String condition, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException, IOException {

		MetaFactory metaFactory = MetaFactory.getMetaFactory();
		ClassMetaObject classMetaObject = metaFactory.getClassMetaObject("MetaColumn");
		ClassMetaColumn classMetaColumn = (ClassMetaColumn)classMetaObject;

		ArrayList<MetaColumn> metaColumns = classMetaColumn.getMetaObjects(m_tableName);
		ArrayList<String> selectParams = new ArrayList<String>();
		for (int ii = 0; ii < metaColumns.size(); ++ii) {
			MetaColumn metaColumn = metaColumns.get(ii);
			String columnId = metaColumn.getProperty("COLUMN_ID");
			selectParams.add(columnId);
		}

		ArrayList<ArrayList<String>> rows = super.select(selectParams, condition, conditionValues);
		ArrayList<Journal> objects = new ArrayList<Journal>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			Journal object = new Journal(m_db, selectParams, row);
			objects.add(object);
		}

		return objects;
	}
}
