package objectModel;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

import meta.ClassMetaColumn;
import meta.ClassMetaObject;
import meta.MetaColumn;
import meta.MetaFactory;
import model.ClassEntity;

import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassPartner extends ClassEntity {

	/**
	 *
	 */
	public ClassPartner() {
		this.m_tableName = "PARTNER";
	}

	/**
	 *
	 * @param db
	 */
	public ClassPartner(DBAccessWrapper db) {
		super(db, "PARTNER");
		this.m_tableName = "PARTNER";
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public ArrayList<Partner> select(String condition, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException, IOException {

		MetaFactory metaFactory = MetaFactory.getMetaFactory();
		ClassMetaObject classMetaObject = metaFactory.getClassMetaObject("MetaColumn");
		ClassMetaColumn classMetaColumn = (ClassMetaColumn)classMetaObject;

		ArrayList<MetaColumn> metaColumns = classMetaColumn.getMetaObjects(m_tableName);
		ArrayList<String> selectParams = new ArrayList<String>();
		for (int ii = 0; ii < metaColumns.size(); ++ii) {
			MetaColumn metaColumn = metaColumns.get(ii);
			String columnId = metaColumn.getProperty("COLUMN_ID");
			selectParams.add(columnId);
		}

		ArrayList<ArrayList<String>> rows = super.select(selectParams, condition, conditionValues);
		ArrayList<Partner> objects = new ArrayList<Partner>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			Partner object = new Partner(m_db, selectParams, row);
			objects.add(object);
		}

		return objects;
	}

	/**
	 *
	 * @param insertParams
	 * @param insertTypes
	 * @param insertValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public Partner create(ArrayList<String> insertParams, ArrayList<Object> insertValues) throws SQLException, ClassNotFoundException, IOException {
		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.add("IDENTIFICATION");

		ArrayList<ArrayList<String>> rows = super.insert(insertParams, insertValues, selectParams);

		String identificaton = rows.get(0).get(0);
		String condition = "identification = ?";
		ArrayList<Object> conditionValues = new ArrayList<Object>();
		conditionValues.add(identificaton);

		ArrayList<Partner> accounts;
		accounts = select(condition, conditionValues);

		return accounts.get(0);
	}
}
