package systemModel;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

import model.Entity;
import model.NavigationItem;

import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class Person extends Entity {

	/**
	 *
	 * @param db
	 * @param keys
	 * @param values
	 */
	public Person(DBAccessWrapper db, ArrayList<String> keys, ArrayList<String> values) {
		super(db, keys,values, "PERSON");
	}

	/**
	 *
	 * @return
	 */
	public String number() {
		return m_properties.get("PERSON_NUMBER");
	}

	/**
	 *
	 * @param number
	 */
	public void number(String number) {
		m_properties.put("PERSON_NUMBER", number);
	}

	/**
	 *
	 * @param inSortParams
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public ArrayList<NavigationItem> navigateDepartment(ArrayList<String> inSortParams) throws SQLException, ClassNotFoundException, IOException {

		String strbTableNames[] = {"DEPARTMENT_PERSON", "DEPARTMENT"};

		StringBuilder condition = new StringBuilder();
		condition.append("T1.RIGHT_IDENTIFICATION = ? AND T1.LEFT_IDENTIFICATION = T2.IDENTIFICATION");

		ArrayList<NavigationItem> objects = navigate("", strbTableNames, condition.toString(), inSortParams);
		return objects;
	}

}
